/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.content;

import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.actions.ShowContentAction;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ToolWindowContentUiType;
import com.intellij.openapi.wm.impl.ToolWindowImpl;
import com.intellij.openapi.wm.impl.content.BaseLabel;
import com.intellij.openapi.wm.impl.content.ComboContentLayout;
import com.intellij.openapi.wm.impl.content.ContentLayout;
import com.intellij.openapi.wm.impl.content.TabContentLayout;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.content.ContentUI;
import com.intellij.ui.content.tabs.PinToolwindowTabAction;
import com.intellij.ui.content.tabs.TabbedContentAction;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToolWindowContentUi
extends JPanel
implements ContentUI,
PropertyChangeListener,
DataProvider {
    public static final String POPUP_PLACE = "ToolwindowPopup";
    ContentManager myManager;
    final JPanel myContent = new JPanel(new BorderLayout());
    ToolWindowImpl myWindow;
    TabbedContentAction.CloseAllAction myCloseAllAction;
    TabbedContentAction.MyNextTabAction myNextTabAction;
    TabbedContentAction.MyPreviousTabAction myPreviousTabAction;
    ShowContentAction myShowContent;
    ContentLayout myTabsLayout = new TabContentLayout(this);
    ContentLayout myComboLayout = new ComboContentLayout(this);
    private ToolWindowContentUiType myType = ToolWindowContentUiType.TABBED;

    public ToolWindowContentUi(ToolWindowImpl window) {
        this.myWindow = window;
        this.myContent.setOpaque(false);
        this.myContent.setFocusable(false);
        this.setOpaque(false);
        this.myShowContent = new ShowContentAction(this.myWindow, this.myContent);
        this.setBorder(new EmptyBorder(0, 0, 0, 2));
    }

    public void setType(@NotNull ToolWindowContentUiType type) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/wm/impl/content/ToolWindowContentUi.setType must not be null");
        }
        if (this.myType != type) {
            if (this.myType != null) {
                this.getCurrentLayout().reset();
            }
            this.myType = type;
            this.getCurrentLayout().init();
            this.rebuild();
        }
    }

    private ContentLayout getCurrentLayout() {
        assert (this.myManager != null);
        return this.myType == ToolWindowContentUiType.TABBED ? this.myTabsLayout : this.myComboLayout;
    }

    public JComponent getComponent() {
        return this.myContent;
    }

    public JComponent getTabComponent() {
        return this;
    }

    public void setManager(ContentManager manager) {
        if (this.myManager != null) {
            this.getCurrentLayout().reset();
        }
        this.myManager = manager;
        this.getCurrentLayout().init();
        this.myManager.addContentManagerListener(new ContentManagerListener(){

            public void contentAdded(ContentManagerEvent event) {
                ToolWindowContentUi.this.getCurrentLayout().contentAdded(event);
                event.getContent().addPropertyChangeListener((PropertyChangeListener)ToolWindowContentUi.this);
                ToolWindowContentUi.this.rebuild();
            }

            public void contentRemoved(ContentManagerEvent event) {
                event.getContent().removePropertyChangeListener((PropertyChangeListener)ToolWindowContentUi.this);
                ToolWindowContentUi.this.getCurrentLayout().contentRemoved(event);
                ToolWindowContentUi.this.ensureSelectedContentVisible();
                ToolWindowContentUi.this.rebuild();
            }

            public void contentRemoveQuery(ContentManagerEvent event) {
            }

            public void selectionChanged(ContentManagerEvent event) {
                ToolWindowContentUi.this.ensureSelectedContentVisible();
                ToolWindowContentUi.this.update();
                ToolWindowContentUi.this.myContent.revalidate();
                ToolWindowContentUi.this.myContent.repaint();
            }
        });
        ToolWindowContentUi.initMouseListeners(this, this);
        this.rebuild();
        this.myCloseAllAction = new TabbedContentAction.CloseAllAction(this.myManager);
        this.myNextTabAction = new TabbedContentAction.MyNextTabAction(this.myManager);
        this.myPreviousTabAction = new TabbedContentAction.MyPreviousTabAction(this.myManager);
    }

    private void ensureSelectedContentVisible() {
        Component visible;
        Content selected = this.myManager.getSelectedContent();
        if (selected == null) {
            this.myContent.removeAll();
            return;
        }
        if (this.myContent.getComponentCount() == 1 && (visible = this.myContent.getComponent(0)) == selected.getComponent()) {
            return;
        }
        this.myContent.removeAll();
        this.myContent.add((Component)selected.getComponent(), "Center");
        this.myContent.revalidate();
        this.myContent.repaint();
    }

    private void rebuild() {
        this.getCurrentLayout().rebuild();
        this.getCurrentLayout().update();
        this.revalidate();
        this.repaint();
        if (this.myManager.getContentCount() == 0 && this.myWindow.isToHideOnEmptyContent()) {
            this.myWindow.hide(null);
        }
    }

    @Override
    public void doLayout() {
        this.getCurrentLayout().layout();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.getCurrentLayout().paintComponent(g);
    }

    @Override
    protected void paintChildren(Graphics g) {
        super.paintChildren(g);
        this.getCurrentLayout().paintChildren(g);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        size.height = 0;
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component each = this.getComponent(i);
            size.height = Math.max(each.getPreferredSize().height, size.height);
        }
        return size;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.update();
    }

    private void update() {
        this.getCurrentLayout().update();
        this.revalidate();
        this.repaint();
    }

    public boolean isSingleSelection() {
        return true;
    }

    public boolean isToSelectAddedContent() {
        return false;
    }

    public boolean canBeEmptySelection() {
        return false;
    }

    public void beforeDispose() {
    }

    public boolean canChangeSelectionTo(Content content, boolean implicit) {
        return true;
    }

    static void initMouseListeners(final JComponent c, final ToolWindowContentUi ui) {
        Content content;
        if (c.getClientProperty(ui) != null) {
            return;
        }
        final Point[] myLastPoint = new Point[1];
        c.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (myLastPoint[0] == null) {
                    return;
                }
                Window window = SwingUtilities.windowForComponent(c);
                if (window instanceof IdeFrame) {
                    return;
                }
                Rectangle oldBounds = window.getBounds();
                Point newPoint = e.getPoint();
                SwingUtilities.convertPointToScreen(newPoint, c);
                Point offset = new Point(newPoint.x - myLastPoint[0].x, newPoint.y - myLastPoint[0].y);
                window.setLocation(oldBounds.x + offset.x, oldBounds.y + offset.y);
                myLastPoint[0] = newPoint;
            }
        });
        c.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                myLastPoint[0] = e.getPoint();
                SwingUtilities.convertPointToScreen(myLastPoint[0], c);
                if (!e.isPopupTrigger()) {
                    if (UIUtil.isCloseClick((MouseEvent)e)) {
                        ui.processHide(e);
                    } else {
                        ui.myWindow.fireActivated();
                    }
                }
            }
        });
        final DefaultActionGroup contentGroup = new DefaultActionGroup();
        if (c instanceof BaseLabel && (content = ((BaseLabel)c).getContent()) != null) {
            contentGroup.add((AnAction)ui.myShowContent);
            contentGroup.addSeparator();
            contentGroup.add((AnAction)new TabbedContentAction.CloseAction(content));
            contentGroup.add((AnAction)ui.myCloseAllAction);
            contentGroup.add((AnAction)new TabbedContentAction.CloseAllButThisAction(content));
            contentGroup.addSeparator();
            if (content.isPinnable()) {
                contentGroup.add(PinToolwindowTabAction.getPinAction());
                contentGroup.addSeparator();
            }
            contentGroup.add((AnAction)ui.myNextTabAction);
            contentGroup.add((AnAction)ui.myPreviousTabAction);
            contentGroup.addSeparator();
        }
        c.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                DefaultActionGroup group = new DefaultActionGroup();
                group.addAll((ActionGroup)contentGroup);
                ActionGroup windowPopup = ui.myWindow.getPopupGroup();
                if (windowPopup != null) {
                    group.addAll(windowPopup);
                }
                ActionPopupMenu popupMenu = ActionManager.getInstance().createActionPopupMenu(ToolWindowContentUi.POPUP_PLACE, (ActionGroup)group);
                popupMenu.getComponent().show(comp, x, y);
            }
        });
        c.putClientProperty(ui, Boolean.TRUE);
    }

    private void processHide(MouseEvent e) {
        IdeEventQueue.getInstance().blockNextEvents(e);
        Component c = e.getComponent();
        if (c instanceof BaseLabel) {
            BaseLabel tab = (BaseLabel)c;
            if (tab.getContent() != null) {
                if (this.myManager.canCloseContents() && tab.getContent().isCloseable()) {
                    this.myManager.removeContent(tab.getContent(), true);
                } else if (this.myManager.getContentCount() == 1) {
                    this.hideWindow(e);
                }
            }
        } else {
            this.hideWindow(e);
        }
    }

    private void hideWindow(MouseEvent e) {
        if (e.isControlDown()) {
            this.myWindow.fireHiddenSide();
        } else {
            this.myWindow.fireHidden();
        }
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        if (PlatformDataKeys.TOOL_WINDOW.is(dataId)) {
            return this.myWindow;
        }
        return null;
    }

    public void dispose() {
    }

    boolean isCurrent(ContentLayout layout) {
        return this.getCurrentLayout() == layout;
    }

    public void showContentPopup(InputEvent inputEvent) {
        BaseListPopupStep<Content> step = new BaseListPopupStep<Content>(null, this.myManager.getContents()){

            public PopupStep onChosen(Content selectedValue, boolean finalChoice) {
                ToolWindowContentUi.this.myManager.setSelectedContent(selectedValue, true, true);
                return FINAL_CHOICE;
            }

            @NotNull
            public String getTextFor(Content value) {
                String string = value.getDisplayName();
                if (string == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/openapi/wm/impl/content/ToolWindowContentUi$5.getTextFor must not return null");
                }
                return string;
            }

            public Icon getIconFor(Content aValue) {
                return aValue.getIcon();
            }

            public boolean isMnemonicsNavigationEnabled() {
                return true;
            }
        };
        step.setDefaultOptionIndex(Arrays.asList(this.myManager.getContents()).indexOf(this.myManager.getSelectedContent()));
        this.getCurrentLayout().showContentPopup(JBPopupFactory.getInstance().createListPopup((ListPopupStep)step));
    }
}

