/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.compiler;

import com.intellij.compiler.CompilerManagerImpl;
import com.intellij.compiler.impl.CompilerCacheManager;
import com.intellij.compiler.impl.CompilerUtil;
import com.intellij.compiler.impl.FileProcessingCompilerStateCache;
import com.intellij.compiler.impl.packagingCompiler.DestinationInfo;
import com.intellij.compiler.impl.packagingCompiler.ExplodedDestinationInfo;
import com.intellij.compiler.impl.packagingCompiler.IgnoredFileFilter;
import com.intellij.compiler.impl.packagingCompiler.JarDestinationInfo;
import com.intellij.compiler.impl.packagingCompiler.JarInfo;
import com.intellij.compiler.impl.packagingCompiler.JarsBuilder;
import com.intellij.compiler.impl.packagingCompiler.PackagingCompilerCache;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.CompilerPaths;
import com.intellij.openapi.compiler.FileProcessingCompiler;
import com.intellij.openapi.compiler.PackagingCompiler;
import com.intellij.openapi.compiler.ValidityState;
import com.intellij.openapi.compiler.make.BuildParticipant;
import com.intellij.openapi.compiler.make.BuildParticipantProvider;
import com.intellij.openapi.deployment.DeploymentUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.artifacts.ArtifactProperties;
import com.intellij.packaging.artifacts.ArtifactPropertiesProvider;
import com.intellij.packaging.elements.ArtifactIncrementalCompilerContext;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.IncrementalCompilerInstructionCreator;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.artifacts.ArtifactValidationUtil;
import com.intellij.packaging.impl.compiler.ArtifactCompileScope;
import com.intellij.packaging.impl.compiler.ArtifactPackagingItemValidityState;
import com.intellij.packaging.impl.compiler.ArtifactPackagingProcessingItem;
import com.intellij.packaging.impl.compiler.ArtifactsProcessingItemsBuilderContext;
import com.intellij.packaging.impl.compiler.CopyToDirectoryInstructionCreator;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.io.DataInput;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IncrementalArtifactsCompiler
implements PackagingCompiler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.packaging.impl.compiler.IncrementalArtifactsCompiler");
    private static final Key<Set<String>> WRITTEN_PATHS_KEY = Key.create((String)"artifacts_written_paths");
    private static final Key<List<String>> FILES_TO_DELETE_KEY = Key.create((String)"artifacts_files_to_delete");
    private static final Key<Set<Artifact>> AFFECTED_ARTIFACTS = Key.create((String)"affected_artifacts");
    private static final Key<ArtifactsProcessingItemsBuilderContext> BUILDER_CONTEXT_KEY = Key.create((String)"artifacts_builder_context");
    @Nullable
    private PackagingCompilerCache myOutputItemsCache;

    @Nullable
    public static IncrementalArtifactsCompiler getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/compiler/IncrementalArtifactsCompiler.getInstance must not be null");
        }
        IncrementalArtifactsCompiler[] compilers = (IncrementalArtifactsCompiler[])CompilerManager.getInstance((Project)project).getCompilers(IncrementalArtifactsCompiler.class);
        return compilers.length == 1 ? compilers[0] : null;
    }

    private static ArtifactPackagingProcessingItem[] collectItems(ArtifactsProcessingItemsBuilderContext builderContext, Project project) {
        CompileContext context = builderContext.getCompileContext();
        Set<Artifact> artifactsToBuild = ArtifactCompileScope.getArtifactsToBuild(project, context.getCompileScope());
        if (LOG.isDebugEnabled()) {
            LOG.debug("artifacts to build: " + artifactsToBuild);
        }
        ArrayList additionalArtifacts = new ArrayList();
        for (BuildParticipantProvider provider : (BuildParticipantProvider[])BuildParticipantProvider.EXTENSION_POINT_NAME.getExtensions()) {
            for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                Collection participants = provider.getParticipants(module);
                for (BuildParticipant participant : participants) {
                    ContainerUtil.addIfNotNull((Object)participant.createArtifact(context), additionalArtifacts);
                }
            }
        }
        if (LOG.isDebugEnabled() && !additionalArtifacts.isEmpty()) {
            LOG.debug("additional artifacts to build: " + additionalArtifacts);
        }
        artifactsToBuild.addAll(additionalArtifacts);
        ArrayList<Artifact> allArtifacts = new ArrayList<Artifact>(Arrays.asList(ArtifactManager.getInstance((Project)project).getArtifacts()));
        allArtifacts.addAll(additionalArtifacts);
        for (Artifact artifact : allArtifacts) {
            String outputPath = artifact.getOutputPath();
            if (outputPath != null && outputPath.length() != 0) {
                IncrementalArtifactsCompiler.collectItems(builderContext, artifact, outputPath, project, artifactsToBuild.contains(artifact));
                continue;
            }
            if (!artifactsToBuild.contains(artifact)) continue;
            context.addMessage(CompilerMessageCategory.ERROR, "Cannot build '" + artifact.getName() + "' artifact: output path is not specified", null, -1, -1);
        }
        context.putUserData(AFFECTED_ARTIFACTS, artifactsToBuild);
        return builderContext.getProcessingItems();
    }

    @NotNull
    public FileProcessingCompiler.ProcessingItem[] getProcessingItems(final CompileContext context) {
        FileProcessingCompiler.ProcessingItem[] processingItemArray = (FileProcessingCompiler.ProcessingItem[])new ReadAction<FileProcessingCompiler.ProcessingItem[]>(){

            protected void run(Result<FileProcessingCompiler.ProcessingItem[]> result) {
                Project project = context.getProject();
                Set<Artifact> selfIncludingArtifacts = ArtifactValidationUtil.getInstance(project).getSelfIncludingArtifacts();
                if (!selfIncludingArtifacts.isEmpty()) {
                    LOG.info("Self including artifacts: " + selfIncludingArtifacts);
                    if (!ArtifactCompileScope.getArtifactsToBuild(project, context.getCompileScope()).isEmpty()) {
                        for (Artifact artifact : selfIncludingArtifacts) {
                            context.addMessage(CompilerMessageCategory.ERROR, "Artifact '" + artifact.getName() + "' includes itself in the output layout", null, -1, -1);
                        }
                    }
                    result.setResult((Object)FileProcessingCompiler.ProcessingItem.EMPTY_ARRAY);
                    return;
                }
                ArtifactsProcessingItemsBuilderContext builderContext = new ArtifactsProcessingItemsBuilderContext(context);
                context.putUserData(BUILDER_CONTEXT_KEY, (Object)builderContext);
                Object[] allProcessingItems = IncrementalArtifactsCompiler.collectItems(builderContext, project);
                if (LOG.isDebugEnabled()) {
                    int num = Math.min(5000, allProcessingItems.length);
                    LOG.debug("All files (" + num + " of " + allProcessingItems.length + "):");
                    for (int i = 0; i < num; ++i) {
                        LOG.debug(allProcessingItems[i].getFile().getPath());
                    }
                }
                try {
                    FileProcessingCompilerStateCache cache = CompilerCacheManager.getInstance(project).getFileProcessingCompilerCache((FileProcessingCompiler)IncrementalArtifactsCompiler.this);
                    for (ArtifactPackagingProcessingItem artifactPackagingProcessingItem : allProcessingItems) {
                        artifactPackagingProcessingItem.init(cache);
                    }
                }
                catch (IOException e) {
                    context.requestRebuildNextTime(e.getMessage());
                    context.addMessage(CompilerMessageCategory.ERROR, e.getMessage(), null, -1, -1);
                    result.setResult((Object)FileProcessingCompiler.ProcessingItem.EMPTY_ARRAY);
                    LOG.info((Throwable)e);
                    return;
                }
                boolean hasFilesToDelete = IncrementalArtifactsCompiler.this.collectFilesToDelete(context, builderContext.getProcessingItems());
                if (hasFilesToDelete) {
                    MockProcessingItem mockItem = new MockProcessingItem((VirtualFile)new LightVirtualFile("239239293"));
                    result.setResult((Object)ArrayUtil.append((Object[])allProcessingItems, (Object)mockItem, FileProcessingCompiler.ProcessingItem.class));
                } else {
                    result.setResult((Object)allProcessingItems);
                }
            }
        }.execute().getResultObject();
        if (processingItemArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/packaging/impl/compiler/IncrementalArtifactsCompiler.getProcessingItems must not return null");
        }
        return processingItemArray;
    }

    private static void collectItems(@NotNull ArtifactsProcessingItemsBuilderContext builderContext, @NotNull Artifact artifact, @NotNull String outputPath, Project project, boolean enable) {
        if (builderContext == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/compiler/IncrementalArtifactsCompiler.collectItems must not be null");
        }
        if (artifact == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/packaging/impl/compiler/IncrementalArtifactsCompiler.collectItems must not be null");
        }
        if (outputPath == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/packaging/impl/compiler/IncrementalArtifactsCompiler.collectItems must not be null");
        }
        CompositePackagingElement rootElement = artifact.getRootElement();
        VirtualFile outputFile = LocalFileSystem.getInstance().findFileByPath(outputPath);
        CopyToDirectoryInstructionCreator instructionCreator = new CopyToDirectoryInstructionCreator(builderContext, outputPath, outputFile);
        PackagingElementResolvingContext resolvingContext = ArtifactManager.getInstance((Project)project).getResolvingContext();
        builderContext.setCollectingEnabledItems(enable);
        rootElement.computeIncrementalCompilerInstructions((IncrementalCompilerInstructionCreator)instructionCreator, resolvingContext, (ArtifactIncrementalCompilerContext)builderContext, artifact.getArtifactType());
    }

    public FileProcessingCompiler.ProcessingItem[] process(final CompileContext context, final FileProcessingCompiler.ProcessingItem[] items) {
        final Set<String> deletedJars = this.deleteOutdatedFiles(context);
        final ArrayList<ArtifactPackagingProcessingItem> processedItems = new ArrayList<ArtifactPackagingProcessingItem>();
        final THashSet<String> writtenPaths = IncrementalArtifactsCompiler.createPathsHashSet();
        final Ref built = Ref.create((Object)false);
        CompilerUtil.runInContext(context, "Copying files", new ThrowableRunnable<RuntimeException>(){

            public void run() throws RuntimeException {
                built.set((Object)IncrementalArtifactsCompiler.doBuild(context, items, processedItems, writtenPaths, deletedJars));
            }
        });
        if (!((Boolean)built.get()).booleanValue()) {
            return FileProcessingCompiler.ProcessingItem.EMPTY_ARRAY;
        }
        context.getProgressIndicator().setText(CompilerBundle.message((String)"packaging.compiler.message.updating.caches", (Object[])new Object[0]));
        context.getProgressIndicator().setText2("");
        IncrementalArtifactsCompiler.refreshOutputFiles(writtenPaths);
        new ReadAction(){

            protected void run(Result result) {
                IncrementalArtifactsCompiler.processDestinations(processedItems);
            }
        }.execute();
        IncrementalArtifactsCompiler.removeInvalidItems(processedItems);
        this.updateOutputCache(context.getProject(), processedItems);
        context.putUserData(WRITTEN_PATHS_KEY, writtenPaths);
        return processedItems.toArray(new FileProcessingCompiler.ProcessingItem[processedItems.size()]);
    }

    private static boolean doBuild(final CompileContext context, FileProcessingCompiler.ProcessingItem[] items, List<ArtifactPackagingProcessingItem> processedItems, final Set<String> writtenPaths, Set<String> deletedJars) {
        boolean testMode = ApplicationManager.getApplication().isUnitTestMode();
        if (LOG.isDebugEnabled()) {
            int num = Math.min(200, items.length);
            LOG.debug("Files to process (" + num + " of " + items.length + "):");
            for (int i = 0; i < num; ++i) {
                LOG.debug(items[i].getFile().getPath());
            }
        }
        final DeploymentUtil deploymentUtil = DeploymentUtil.getInstance();
        final IgnoredFileFilter fileFilter = new IgnoredFileFilter();
        ArtifactsProcessingItemsBuilderContext builderContext = (ArtifactsProcessingItemsBuilderContext)context.getUserData(BUILDER_CONTEXT_KEY);
        THashSet changedJars = new THashSet();
        for (String deletedJar : deletedJars) {
            ContainerUtil.addIfNotNull((Object)builderContext.getJarInfo(deletedJar), (Collection)changedJars);
        }
        try {
            IncrementalArtifactsCompiler.onBuildStartedOrFinished(builderContext, false);
            if (context.getMessageCount(CompilerMessageCategory.ERROR) > 0) {
                return false;
            }
            int i = 0;
            for (FileProcessingCompiler.ProcessingItem item0 : items) {
                if (item0 instanceof MockProcessingItem) continue;
                final ArtifactPackagingProcessingItem artifactPackagingProcessingItem = (ArtifactPackagingProcessingItem)item0;
                context.getProgressIndicator().checkCanceled();
                final Ref exception = Ref.create(null);
                new ReadAction((Set)changedJars){
                    final /* synthetic */ Set val$changedJars;
                    {
                        this.val$changedJars = set2;
                    }

                    protected void run(Result result) {
                        File fromFile = VfsUtil.virtualToIoFile((VirtualFile)artifactPackagingProcessingItem.getFile());
                        for (DestinationInfo destination : artifactPackagingProcessingItem.getEnabledDestinations()) {
                            if (destination instanceof ExplodedDestinationInfo) {
                                ExplodedDestinationInfo explodedDestination = (ExplodedDestinationInfo)destination;
                                File toFile = new File(FileUtil.toSystemDependentName((String)explodedDestination.getOutputPath()));
                                if (!fromFile.exists()) continue;
                                try {
                                    deploymentUtil.copyFile(fromFile, toFile, context, writtenPaths, fileFilter);
                                    continue;
                                }
                                catch (IOException e) {
                                    exception.set((Object)e);
                                    return;
                                }
                            }
                            this.val$changedJars.add(((JarDestinationInfo)destination).getJarInfo());
                        }
                    }
                }.execute();
                if (exception.get() != null) {
                    throw (IOException)exception.get();
                }
                context.getProgressIndicator().setFraction((double)(++i) * 1.0 / (double)items.length);
                processedItems.add(artifactPackagingProcessingItem);
                if (!testMode) continue;
                CompilerManagerImpl.addRecompiledPath(FileUtil.toSystemDependentName((String)artifactPackagingProcessingItem.getFile().getPath()));
            }
            JarsBuilder builder = new JarsBuilder((Set<JarInfo>)changedJars, fileFilter, context);
            boolean processed = builder.buildJars(writtenPaths);
            if (!processed) {
                return false;
            }
            HashSet<Object> recompiledSources = new HashSet<Object>();
            for (JarInfo jarInfo : builder.getJarsToBuild()) {
                for (Pair<String, VirtualFile> pair : jarInfo.getPackedFiles()) {
                    recompiledSources.add(pair.getSecond());
                }
            }
            for (ArtifactPackagingProcessingItem artifactPackagingProcessingItem : processedItems) {
                recompiledSources.remove(artifactPackagingProcessingItem.getFile());
            }
            for (VirtualFile virtualFile : recompiledSources) {
                ArtifactPackagingProcessingItem item = builderContext.getItemBySource(virtualFile);
                LOG.assertTrue(item != null, (Object)virtualFile);
                processedItems.add(item);
                if (!testMode) continue;
                CompilerManagerImpl.addRecompiledPath(FileUtil.toSystemDependentName((String)item.getFile().getPath()));
            }
            IncrementalArtifactsCompiler.onBuildStartedOrFinished(builderContext, true);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
            context.addMessage(CompilerMessageCategory.ERROR, e.getLocalizedMessage(), null, -1, -1);
            return false;
        }
        return true;
    }

    public static Set<Artifact> getAffectedArtifacts(CompileContext compileContext) {
        return (Set)compileContext.getUserData(AFFECTED_ARTIFACTS);
    }

    @Nullable
    public static Set<String> getWrittenPaths(@NotNull CompileContext context) {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/compiler/IncrementalArtifactsCompiler.getWrittenPaths must not be null");
        }
        return (Set)context.getUserData(WRITTEN_PATHS_KEY);
    }

    @NotNull
    public String getDescription() {
        if ("Artifacts Packaging Compiler" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/packaging/impl/compiler/IncrementalArtifactsCompiler.getDescription must not return null");
        }
        return "Artifacts Packaging Compiler";
    }

    @NotNull
    private PackagingCompilerCache getOutputItemsCache(Project project) {
        if (this.myOutputItemsCache == null) {
            this.myOutputItemsCache = new PackagingCompilerCache(CompilerPaths.getCompilerSystemDirectory((Project)project).getPath() + File.separator + "incremental_artifacts_timestamp.dat");
        }
        PackagingCompilerCache packagingCompilerCache = this.myOutputItemsCache;
        if (packagingCompilerCache == null) {
            throw new IllegalStateException("@NotNull method com/intellij/packaging/impl/compiler/IncrementalArtifactsCompiler.getOutputItemsCache must not return null");
        }
        return packagingCompilerCache;
    }

    public void processOutdatedItem(CompileContext context, String url, @Nullable ValidityState state) {
    }

    private boolean collectFilesToDelete(CompileContext context, ArtifactPackagingProcessingItem[] allProcessingItems) {
        ArrayList<String> filesToDelete = new ArrayList<String>();
        THashSet<String> outputPaths = IncrementalArtifactsCompiler.createPathsHashSet();
        for (ArtifactPackagingProcessingItem item : allProcessingItems) {
            for (Pair<DestinationInfo, Boolean> destinationInfo : item.getDestinations()) {
                String outputPath = IncrementalArtifactsCompiler.getOutputPathWithJarSeparator((DestinationInfo)destinationInfo.getFirst());
                outputPaths.add(outputPath);
            }
        }
        Iterator<String> pathIterator = this.getOutputItemsCache(context.getProject()).getUrlsIterator();
        while (pathIterator.hasNext()) {
            String path = pathIterator.next();
            if (outputPaths.contains(path)) continue;
            filesToDelete.add(path);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Files to delete (" + filesToDelete.size() + "):");
            for (String path : filesToDelete) {
                LOG.debug(path);
            }
        }
        if (filesToDelete.isEmpty()) {
            return false;
        }
        context.putUserData(FILES_TO_DELETE_KEY, filesToDelete);
        return true;
    }

    private static String getOutputPathWithJarSeparator(DestinationInfo destinationInfo) {
        String fileOutputPath;
        String fullOutputPath;
        String outputPath = destinationInfo.getOutputFilePath();
        if (destinationInfo instanceof JarDestinationInfo && (fullOutputPath = destinationInfo.getOutputPath()).startsWith(fileOutputPath = destinationInfo.getOutputFilePath())) {
            outputPath = outputPath + "!/" + DeploymentUtil.trimForwardSlashes((String)fullOutputPath.substring(fileOutputPath.length()));
        }
        return outputPath;
    }

    private static void onBuildStartedOrFinished(ArtifactsProcessingItemsBuilderContext context, boolean finished) throws Exception {
        CompileContext compileContext = context.getCompileContext();
        Set<Artifact> artifacts = IncrementalArtifactsCompiler.getAffectedArtifacts(compileContext);
        for (Artifact artifact : artifacts) {
            for (ArtifactPropertiesProvider provider : artifact.getPropertiesProviders()) {
                ArtifactProperties properties = artifact.getProperties(provider);
                if (finished) {
                    properties.onBuildFinished(artifact, compileContext);
                    continue;
                }
                properties.onBuildStarted(artifact, compileContext);
            }
        }
    }

    private static THashSet<String> createPathsHashSet() {
        return SystemInfo.isFileSystemCaseSensitive ? new THashSet() : new THashSet((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
    }

    private static void removeInvalidItems(List<ArtifactPackagingProcessingItem> processedItems) {
        THashSet files = new THashSet(processedItems.size());
        for (ArtifactPackagingProcessingItem item : processedItems) {
            files.add(item.getFile());
        }
        RefreshQueue.getInstance().refresh(false, false, null, VfsUtil.toVirtualFileArray((Collection)files));
        Iterator<ArtifactPackagingProcessingItem> iterator = processedItems.iterator();
        while (iterator.hasNext()) {
            ArtifactPackagingProcessingItem item;
            item = iterator.next();
            VirtualFile file = item.getFile();
            if (file.isValid()) continue;
            iterator.remove();
        }
    }

    private static void processDestinations(List<ArtifactPackagingProcessingItem> items) {
        for (ArtifactPackagingProcessingItem item : items) {
            item.setProcessed();
        }
    }

    private Set<String> deleteOutdatedFiles(CompileContext context) {
        context.getProgressIndicator().setText(CompilerBundle.message((String)"packaging.compiler.message.deleting.outdated.files", (Object[])new Object[0]));
        List filesToDelete = (List)context.getUserData(FILES_TO_DELETE_KEY);
        Set<String> deletedJars = filesToDelete != null ? this.deleteFiles(filesToDelete, context) : Collections.emptySet();
        context.getProgressIndicator().checkCanceled();
        return deletedJars;
    }

    private Set<String> deleteFiles(List<String> paths, CompileContext context) {
        Set<Artifact> artifactsToBuild = IncrementalArtifactsCompiler.getAffectedArtifacts(context);
        boolean testMode = ApplicationManager.getApplication().isUnitTestMode();
        THashSet deletedJars = new THashSet();
        THashSet notDeletedJars = new THashSet();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Deleting outdated files...");
        }
        int notDeletedFilesCount = 0;
        Artifact[] allArtifacts = ArtifactManager.getInstance((Project)context.getProject()).getArtifacts();
        ArrayList<File> filesToRefresh = new ArrayList<File>();
        for (String fullPath : paths) {
            boolean isUnderOutput = false;
            boolean isInArtifactsToBuild = false;
            for (Artifact artifact : allArtifacts) {
                String path = artifact.getOutputPath();
                if (StringUtil.isEmpty((String)path) || !FileUtil.startsWith((String)fullPath, (String)path)) continue;
                isUnderOutput = true;
                if (!artifactsToBuild.contains(artifact)) continue;
                isInArtifactsToBuild = true;
                break;
            }
            if (isUnderOutput && !isInArtifactsToBuild) continue;
            int end = fullPath.indexOf("!/");
            boolean isJar = end != -1;
            String filePath = isJar ? fullPath.substring(0, end) : fullPath;
            boolean deleted = false;
            if (isJar) {
                if (notDeletedJars.contains((Object)filePath)) continue;
                deleted = deletedJars.contains((Object)filePath);
            }
            File file = new File(FileUtil.toSystemDependentName((String)filePath));
            if (!deleted) {
                filesToRefresh.add(file);
                deleted = FileUtil.delete((File)file);
            }
            if (deleted) {
                if (isJar) {
                    deletedJars.add((Object)filePath);
                }
                if (testMode) {
                    CompilerManagerImpl.addDeletedPath(file.getAbsolutePath());
                }
                this.getOutputItemsCache(context.getProject()).remove(fullPath);
                continue;
            }
            if (isJar) {
                notDeletedJars.add((Object)filePath);
            }
            if (notDeletedFilesCount++ > 50) {
                context.addMessage(CompilerMessageCategory.WARNING, "Deletion of outdated files stopped because too many files cannot be deleted", null, -1, -1);
                break;
            }
            context.addMessage(CompilerMessageCategory.WARNING, "Cannot delete file '" + filePath + "'", null, -1, -1);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Cannot delete file " + file);
        }
        CompilerUtil.refreshIOFiles(filesToRefresh);
        return deletedJars;
    }

    private void updateOutputCache(Project project, List<ArtifactPackagingProcessingItem> processedItems) {
        for (ArtifactPackagingProcessingItem processedItem : processedItems) {
            for (DestinationInfo destinationInfo : processedItem.getEnabledDestinations()) {
                VirtualFile virtualFile = destinationInfo.getOutputFile();
                if (virtualFile == null) continue;
                String path = IncrementalArtifactsCompiler.getOutputPathWithJarSeparator(destinationInfo);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("update output cache: file " + path);
                }
                this.getOutputItemsCache(project).update(path, virtualFile.getTimeStamp());
            }
        }
        this.saveCacheIfDirty(project);
    }

    private static void refreshOutputFiles(Set<String> writtenPaths) {
        ArrayList<File> filesToRefresh = new ArrayList<File>();
        for (String path : writtenPaths) {
            filesToRefresh.add(new File(path));
        }
        CompilerUtil.refreshIOFiles(filesToRefresh);
    }

    private void saveCacheIfDirty(Project project) {
        if (this.getOutputItemsCache(project).isDirty()) {
            this.getOutputItemsCache(project).save();
        }
    }

    public ValidityState createValidityState(DataInput is) throws IOException {
        return new ArtifactPackagingItemValidityState(is);
    }

    public boolean validateConfiguration(CompileScope scope) {
        return true;
    }

    private static class MockProcessingItem
    implements FileProcessingCompiler.ProcessingItem {
        private final VirtualFile myFile;

        public MockProcessingItem(VirtualFile file) {
            this.myFile = file;
        }

        @NotNull
        public VirtualFile getFile() {
            VirtualFile virtualFile = this.myFile;
            if (virtualFile == null) {
                throw new IllegalStateException("@NotNull method com/intellij/packaging/impl/compiler/IncrementalArtifactsCompiler$MockProcessingItem.getFile must not return null");
            }
            return virtualFile;
        }

        @Nullable
        public ValidityState getValidityState() {
            return null;
        }
    }
}

