/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.ide.IconProvider;
import com.intellij.openapi.project.Project;
import com.intellij.pom.PomIconProvider;
import com.intellij.pom.PomNamedTarget;
import com.intellij.pom.PomRenameableTarget;
import com.intellij.pom.PomTarget;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiTarget;
import com.intellij.psi.impl.RenameableFakePsiElement;
import com.intellij.util.IncorrectOperationException;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PomTargetPsiElementImpl
extends RenameableFakePsiElement
implements PomTargetPsiElement {
    private final PomTarget myTarget;
    private final Project myProject;

    public PomTargetPsiElementImpl(@NotNull PsiTarget target) {
        if (target == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PomTargetPsiElementImpl.<init> must not be null");
        }
        this(target.getNavigationElement().getProject(), (PomTarget)target);
    }

    public PomTargetPsiElementImpl(@NotNull Project project, @NotNull PomTarget target) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PomTargetPsiElementImpl.<init> must not be null");
        }
        if (target == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PomTargetPsiElementImpl.<init> must not be null");
        }
        super(null);
        this.myProject = project;
        this.myTarget = target;
    }

    @NotNull
    public PomTarget getTarget() {
        PomTarget pomTarget = this.myTarget;
        if (pomTarget == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PomTargetPsiElementImpl.getTarget must not return null");
        }
        return pomTarget;
    }

    @Override
    public String getName() {
        if (this.myTarget instanceof PomNamedTarget) {
            return ((PomNamedTarget)this.myTarget).getName();
        }
        return null;
    }

    @Override
    public boolean isWritable() {
        if (this.myTarget instanceof PomRenameableTarget) {
            return ((PomRenameableTarget)this.myTarget).isWritable();
        }
        return false;
    }

    public String getTypeName() {
        throw new UnsupportedOperationException("Method getTypeName is not yet implemented for " + this.myTarget.getClass().getName() + "; see PomDescriptionProvider");
    }

    public Icon getIcon() {
        for (IconProvider iconProvider : (IconProvider[])IconProvider.EXTENSION_POINT_NAME.getExtensions()) {
            Icon icon;
            if (!(iconProvider instanceof PomIconProvider) || (icon = ((PomIconProvider)iconProvider).getIcon(this.myTarget, 0)) == null) continue;
            return icon;
        }
        if (this.myTarget instanceof PsiTarget) {
            return ((PsiTarget)this.myTarget).getNavigationElement().getIcon(0);
        }
        return null;
    }

    @Override
    public boolean isValid() {
        if (this.myTarget instanceof PsiTarget) {
            return ((PsiTarget)this.myTarget).getNavigationElement().isValid();
        }
        return this.myTarget.isValid();
    }

    @Override
    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PomTargetPsiElementImpl.setName must not be null");
        }
        if (this.myTarget instanceof PomRenameableTarget) {
            ((PomRenameableTarget)this.myTarget).setName(name);
            return this;
        }
        throw new UnsupportedOperationException("Cannot rename " + this.myTarget);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        PomTargetPsiElementImpl that = (PomTargetPsiElementImpl)((Object)o);
        return this.myTarget.equals(that.myTarget);
    }

    public int hashCode() {
        return this.myTarget.hashCode();
    }

    @Override
    public boolean isEquivalentTo(PsiElement another) {
        return this.equals(another) || another != null && this.myTarget instanceof PsiTarget && another.isEquivalentTo(((PsiTarget)this.myTarget).getNavigationElement());
    }

    @Override
    public PsiElement getContext() {
        if (this.myTarget instanceof PsiTarget) {
            return ((PsiTarget)this.myTarget).getNavigationElement();
        }
        return null;
    }

    @Nullable
    public PsiElement getParent() {
        return null;
    }

    @Override
    public void navigate(boolean requestFocus) {
        this.myTarget.navigate(requestFocus);
    }

    @Override
    public boolean canNavigate() {
        return this.myTarget.canNavigate();
    }

    @Override
    public boolean canNavigateToSource() {
        return this.myTarget.canNavigateToSource();
    }

    @Override
    @Nullable
    public PsiFile getContainingFile() {
        if (this.myTarget instanceof PsiTarget) {
            return ((PsiTarget)this.myTarget).getNavigationElement().getContainingFile();
        }
        return null;
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PomTargetPsiElementImpl.getProject must not return null");
        }
        return project;
    }
}

