/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.file;

import com.intellij.codeInsight.completion.scope.JavaCompletionProcessor;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.ide.projectView.impl.nodes.PackageElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadActionProcessor;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.PackageIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiQualifiedNamedElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.JavaPsiFacadeImpl;
import com.intellij.psi.impl.PsiElementBase;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.migration.PsiMigrationImpl;
import com.intellij.psi.impl.source.tree.java.PsiCompositeModifierList;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.ui.RowIcon;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Icons;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.QueryExecutor;
import com.intellij.util.QueryFactory;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiPackageImpl
extends PsiElementBase
implements PsiPackage,
Queryable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.file.PsiPackageImpl");
    private final PsiManagerEx myManager;
    private final String myQualifiedName;
    private volatile CachedValue<PsiModifierList> myAnnotationList;
    private volatile CachedValue<Collection<PsiDirectory>> myDirectories;
    private volatile Set<String> myPublicClassNamesCache;
    private final Object myPublicClassNamesCacheLock = new String("package classnames cache lock");

    public PsiPackageImpl(PsiManagerEx manager, String qualifiedName) {
        this.myManager = manager;
        this.myQualifiedName = qualifiedName;
    }

    public boolean equals(Object o) {
        return o instanceof PsiPackageImpl && this.myManager == ((PsiPackageImpl)((Object)o)).myManager && this.myQualifiedName.equals(((PsiPackageImpl)((Object)o)).myQualifiedName);
    }

    public int hashCode() {
        return this.myQualifiedName.hashCode();
    }

    @NotNull
    public String getQualifiedName() {
        String string = this.myQualifiedName;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/file/PsiPackageImpl.getQualifiedName must not return null");
        }
        return string;
    }

    @NotNull
    public PsiDirectory[] getDirectories() {
        Collection<PsiDirectory> collection = this.getAllDirectories();
        PsiDirectory[] psiDirectoryArray = (PsiDirectory[])ContainerUtil.toArray(collection, (Object[])new PsiDirectory[collection.size()]);
        if (psiDirectoryArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/file/PsiPackageImpl.getDirectories must not return null");
        }
        return psiDirectoryArray;
    }

    private Collection<PsiDirectory> getAllDirectories() {
        if (this.myDirectories == null) {
            this.myDirectories = CachedValuesManager.getManager((Project)this.myManager.getProject()).createCachedValue((CachedValueProvider)new CachedValueProvider<Collection<PsiDirectory>>(){

                public CachedValueProvider.Result<Collection<PsiDirectory>> compute() {
                    return CachedValueProvider.Result.create((Object)new DirectoriesSearch().search(GlobalSearchScope.allScope((Project)PsiPackageImpl.this.myManager.getProject())).findAll(), (Object[])new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT, ProjectRootManager.getInstance((Project)PsiPackageImpl.this.getProject())});
                }
            }, false);
        }
        return (Collection)this.myDirectories.getValue();
    }

    @NotNull
    public PsiDirectory[] getDirectories(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/PsiPackageImpl.getDirectories must not be null");
        }
        ArrayList<PsiDirectory> result = null;
        Collection<PsiDirectory> directories = this.getAllDirectories();
        for (PsiDirectory directory : directories) {
            if (!scope.contains(directory.getVirtualFile())) continue;
            if (result == null) {
                result = new ArrayList<PsiDirectory>();
            }
            result.add(directory);
        }
        PsiDirectory[] psiDirectoryArray = result == null ? PsiDirectory.EMPTY_ARRAY : result.toArray(new PsiDirectory[result.size()]);
        if (psiDirectoryArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/file/PsiPackageImpl.getDirectories must not return null");
        }
        return psiDirectoryArray;
    }

    public RowIcon getElementIcon(int elementFlags) {
        return PsiPackageImpl.createLayeredIcon((Icon)Icons.PACKAGE_ICON, (int)elementFlags);
    }

    public String getName() {
        if (this.myQualifiedName.length() == 0) {
            return null;
        }
        int index = this.myQualifiedName.lastIndexOf(46);
        if (index < 0) {
            return this.myQualifiedName;
        }
        return this.myQualifiedName.substring(index + 1);
    }

    @Nullable
    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        PsiDirectory[] dirs;
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/PsiPackageImpl.setName must not be null");
        }
        this.checkSetName(name);
        for (PsiDirectory dir : dirs = this.getDirectories()) {
            dir.setName(name);
        }
        String nameAfterRename = RenameUtil.getQualifiedNameAfterRename(this.getQualifiedName(), name);
        return this.getFacade().findPackage(nameAfterRename);
    }

    public void checkSetName(@NotNull String name) throws IncorrectOperationException {
        PsiDirectory[] dirs;
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/PsiPackageImpl.checkSetName must not be null");
        }
        for (PsiDirectory dir : dirs = this.getDirectories()) {
            dir.checkSetName(name);
        }
    }

    public void handleQualifiedNameChange(final @NotNull String newQualifiedName) {
        if (newQualifiedName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/PsiPackageImpl.handleQualifiedNameChange must not be null");
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        final String oldQualifedName = this.myQualifiedName;
        boolean anyChanged = this.changePackagePrefixes(oldQualifedName, newQualifiedName);
        if (anyChanged) {
            UndoManager.getInstance((Project)this.myManager.getProject()).undoableActionPerformed(new UndoableAction(){

                public void undo() {
                    PsiPackageImpl.this.changePackagePrefixes(newQualifiedName, oldQualifedName);
                }

                public void redo() {
                    PsiPackageImpl.this.changePackagePrefixes(oldQualifedName, newQualifiedName);
                }

                public DocumentReference[] getAffectedDocuments() {
                    return DocumentReference.EMPTY_ARRAY;
                }

                public boolean isGlobal() {
                    return true;
                }
            });
        }
    }

    private boolean changePackagePrefixes(String oldQualifiedName, String newQualifiedName) {
        Module[] modules = ModuleManager.getInstance((Project)this.myManager.getProject()).getModules();
        ArrayList<ModifiableRootModel> modelsToCommit = new ArrayList<ModifiableRootModel>();
        for (Module module : modules) {
            ContentEntry[] contentEntries;
            boolean anyChange = false;
            ModifiableRootModel rootModel = ModuleRootManager.getInstance((Module)module).getModifiableModel();
            for (ContentEntry contentEntry : contentEntries = rootModel.getContentEntries()) {
                SourceFolder[] sourceFolders;
                for (SourceFolder sourceFolder : sourceFolders = contentEntry.getSourceFolders()) {
                    String packagePrefix = sourceFolder.getPackagePrefix();
                    if (!packagePrefix.startsWith(oldQualifiedName)) continue;
                    sourceFolder.setPackagePrefix(newQualifiedName + packagePrefix.substring(oldQualifiedName.length()));
                    anyChange = true;
                }
            }
            if (anyChange) {
                modelsToCommit.add(rootModel);
                continue;
            }
            rootModel.dispose();
        }
        if (!modelsToCommit.isEmpty()) {
            ProjectRootManager.getInstance((Project)this.myManager.getProject()).multiCommit(modelsToCommit.toArray(new ModifiableRootModel[modelsToCommit.size()]));
            return true;
        }
        return false;
    }

    public VirtualFile[] occursInPackagePrefixes() {
        Module[] modules;
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (Module module : modules = ModuleManager.getInstance((Project)this.myManager.getProject()).getModules()) {
            ContentEntry[] contentEntries;
            for (ContentEntry contentEntry : contentEntries = ModuleRootManager.getInstance((Module)module).getContentEntries()) {
                SourceFolder[] sourceFolders;
                for (SourceFolder sourceFolder : sourceFolders = contentEntry.getSourceFolders()) {
                    VirtualFile file;
                    String packagePrefix = sourceFolder.getPackagePrefix();
                    if (!packagePrefix.startsWith(this.myQualifiedName) || (file = sourceFolder.getFile()) == null) continue;
                    result.add(file);
                }
            }
        }
        return VfsUtil.toVirtualFileArray(result);
    }

    public PsiPackage getParentPackage() {
        if (this.myQualifiedName.length() == 0) {
            return null;
        }
        int lastDot = this.myQualifiedName.lastIndexOf(46);
        if (lastDot < 0) {
            return new PsiPackageImpl(this.myManager, "");
        }
        return new PsiPackageImpl(this.myManager, this.myQualifiedName.substring(0, lastDot));
    }

    @NotNull
    public Language getLanguage() {
        Language language = StdFileTypes.JAVA.getLanguage();
        if (language == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/file/PsiPackageImpl.getLanguage must not return null");
        }
        return language;
    }

    public PsiManager getManager() {
        return this.myManager;
    }

    @NotNull
    public PsiElement[] getChildren() {
        LOG.error("method not implemented");
        if (PsiElement.EMPTY_ARRAY == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/file/PsiPackageImpl.getChildren must not return null");
        }
        return PsiElement.EMPTY_ARRAY;
    }

    @Nullable
    public PsiElement getParent() {
        return this.getParentPackage();
    }

    @Nullable
    public PsiFile getContainingFile() {
        return null;
    }

    @Nullable
    public TextRange getTextRange() {
        return null;
    }

    public int getStartOffsetInParent() {
        return -1;
    }

    public int getTextLength() {
        return -1;
    }

    public PsiElement findElementAt(int offset) {
        return null;
    }

    public int getTextOffset() {
        return -1;
    }

    @Nullable
    public String getText() {
        return null;
    }

    @NotNull
    public char[] textToCharArray() {
        if (ArrayUtil.EMPTY_CHAR_ARRAY == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/file/PsiPackageImpl.textToCharArray must not return null");
        }
        return ArrayUtil.EMPTY_CHAR_ARRAY;
    }

    public boolean textMatches(@NotNull CharSequence text) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/PsiPackageImpl.textMatches must not be null");
        }
        return false;
    }

    public boolean textMatches(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/PsiPackageImpl.textMatches must not be null");
        }
        return false;
    }

    public PsiElement copy() {
        LOG.error("method not implemented");
        return null;
    }

    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/PsiPackageImpl.add must not be null");
        }
        throw new IncorrectOperationException();
    }

    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/PsiPackageImpl.addBefore must not be null");
        }
        throw new IncorrectOperationException();
    }

    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/PsiPackageImpl.addAfter must not be null");
        }
        throw new IncorrectOperationException();
    }

    public void checkAdd(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/PsiPackageImpl.checkAdd must not be null");
        }
        throw new IncorrectOperationException();
    }

    public void delete() throws IncorrectOperationException {
        PsiDirectory[] dirs;
        this.checkDelete();
        for (PsiDirectory dir : dirs = this.getDirectories()) {
            dir.delete();
        }
    }

    public void checkDelete() throws IncorrectOperationException {
        for (PsiDirectory dir : this.getDirectories()) {
            dir.checkDelete();
        }
    }

    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        if (newElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/PsiPackageImpl.replace must not be null");
        }
        throw new IncorrectOperationException();
    }

    public boolean isValid() {
        if (new DirectoriesSearch().search(GlobalSearchScope.allScope((Project)this.getProject())).findFirst() != null) {
            return true;
        }
        return this.getFacade().packagePrefixExists(this.myQualifiedName);
    }

    public boolean isWritable() {
        PsiDirectory[] dirs;
        for (PsiDirectory dir : dirs = this.getDirectories()) {
            if (dir.isWritable()) continue;
            return false;
        }
        return true;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/PsiPackageImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitPackage((PsiPackage)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public String toString() {
        return "PsiPackage:" + this.getQualifiedName();
    }

    @NotNull
    public PsiClass[] getClasses() {
        PsiClass[] psiClassArray = this.getClasses(GlobalSearchScope.allScope((Project)this.myManager.getProject()));
        if (psiClassArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/file/PsiPackageImpl.getClasses must not return null");
        }
        return psiClassArray;
    }

    @NotNull
    public PsiClass[] getClasses(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/PsiPackageImpl.getClasses must not be null");
        }
        PsiClass[] psiClassArray = this.getFacade().getClasses(this, scope);
        if (psiClassArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/file/PsiPackageImpl.getClasses must not return null");
        }
        return psiClassArray;
    }

    @Nullable
    public PsiModifierList getAnnotationList() {
        if (this.myAnnotationList == null) {
            this.myAnnotationList = CachedValuesManager.getManager((Project)this.myManager.getProject()).createCachedValue((CachedValueProvider)new PackageAnnotationValueProvider());
        }
        return (PsiModifierList)this.myAnnotationList.getValue();
    }

    @NotNull
    public PsiPackage[] getSubPackages() {
        PsiPackage[] psiPackageArray = this.getSubPackages(GlobalSearchScope.allScope((Project)this.myManager.getProject()));
        if (psiPackageArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/file/PsiPackageImpl.getSubPackages must not return null");
        }
        return psiPackageArray;
    }

    @NotNull
    public PsiPackage[] getSubPackages(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/PsiPackageImpl.getSubPackages must not be null");
        }
        PsiPackage[] psiPackageArray = this.getFacade().getSubPackages(this, scope);
        if (psiPackageArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/file/PsiPackageImpl.getSubPackages must not return null");
        }
        return psiPackageArray;
    }

    private JavaPsiFacadeImpl getFacade() {
        return (JavaPsiFacadeImpl)JavaPsiFacade.getInstance((Project)this.myManager.getProject());
    }

    private Set<String> buildClassnamesCache() {
        THashSet classNames = new THashSet();
        for (PsiClass aClass : this.getClasses()) {
            classNames.add(aClass.getName());
        }
        return classNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getClassNamesCache() {
        if (this.myPublicClassNamesCache == null) {
            Object object = this.myPublicClassNamesCacheLock;
            synchronized (object) {
                if (this.myPublicClassNamesCache == null) {
                    this.myPublicClassNamesCache = this.buildClassnamesCache();
                }
            }
        }
        return this.myPublicClassNamesCache;
    }

    @NotNull
    private PsiClass[] findClassesByName(String name, GlobalSearchScope scope) {
        String qName = this.getQualifiedName();
        String classQName = qName.length() > 0 ? qName + "." + name : name;
        PsiClass[] psiClassArray = this.getFacade().findClasses(classQName, scope);
        if (psiClassArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/file/PsiPackageImpl.findClassesByName must not return null");
        }
        return psiClassArray;
    }

    public boolean containsClassNamed(String name) {
        return this.getClassNamesCache().contains(name);
    }

    @Nullable
    private PsiPackage findSubPackageByName(String name) {
        String qName = this.getQualifiedName();
        String subpackageQName = qName.length() > 0 ? qName + "." + name : name;
        PsiPackage aPackage = this.getFacade().findPackage(subpackageQName);
        if (aPackage == null) {
            return null;
        }
        return aPackage;
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        NameHint nameHint;
        if (processor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/PsiPackageImpl.processDeclarations must not be null");
        }
        if (state == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/file/PsiPackageImpl.processDeclarations must not be null");
        }
        if (place == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/psi/impl/file/PsiPackageImpl.processDeclarations must not be null");
        }
        GlobalSearchScope scope = place.getResolveScope();
        processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, (Object)this);
        ElementClassHint classHint = (ElementClassHint)processor.getHint(ElementClassHint.KEY);
        JavaPsiFacadeImpl facade = this.getFacade();
        PsiMigrationImpl migration = facade.getCurrentMigration();
        Condition prefixMatcher = (Condition)processor.getHint(JavaCompletionProcessor.NAME_FILTER);
        if (classHint == null || classHint.shouldProcess(ElementClassHint.DeclaractionKind.CLASS)) {
            nameHint = (NameHint)processor.getHint(NameHint.KEY);
            if (nameHint != null) {
                if (this.processClassesByName(processor, state, place, scope, nameHint.getName(state))) {
                    return false;
                }
            } else if (prefixMatcher != null && migration == null) {
                for (String className : this.getClassNamesCache()) {
                    if (!prefixMatcher.value((Object)className) || !this.processClassesByName(processor, state, place, scope, className)) continue;
                    return false;
                }
            } else {
                PsiClass[] classes = this.getClasses(scope);
                if (!PsiPackageImpl.processClasses(processor, state, classes)) {
                    return false;
                }
                if (migration != null) {
                    for (PsiClass psiClass : migration.getMigrationClasses(this.getQualifiedName())) {
                        if (processor.execute((PsiElement)psiClass, state)) continue;
                        return false;
                    }
                }
            }
        }
        if (classHint == null || classHint.shouldProcess(ElementClassHint.DeclaractionKind.PACKAGE)) {
            nameHint = (NameHint)processor.getHint(NameHint.KEY);
            if (nameHint != null) {
                PsiPackage aPackage = this.findSubPackageByName(nameHint.getName(state));
                if (aPackage != null && !processor.execute((PsiElement)aPackage, state)) {
                    return false;
                }
            } else {
                PsiPackage[] packs;
                for (PsiPackage pack : packs = this.getSubPackages(scope)) {
                    String packageName = pack.getName();
                    if (packageName == null || !facade.getNameHelper().isIdentifier(packageName, PsiUtil.getLanguageLevel((PsiElement)this)) || processor.execute((PsiElement)pack, state)) continue;
                    return false;
                }
                if (migration != null) {
                    for (PsiPackage aPackage : migration.getMigrationPackages(this.getQualifiedName())) {
                        if (processor.execute((PsiElement)aPackage, state)) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    private boolean processClassesByName(PsiScopeProcessor processor, ResolveState state, PsiElement place, GlobalSearchScope scope, String className) {
        PsiClass[] classes = this.findClassesByName(className, scope);
        return !PsiPackageImpl.processClasses(processor, state, classes);
    }

    private static boolean processClasses(PsiScopeProcessor processor, ResolveState state, PsiClass[] classes) {
        for (PsiClass aClass : classes) {
            if (processor.execute((PsiElement)aClass, state)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean canNavigate() {
        return this.isValid();
    }

    @Override
    public boolean canNavigateToSource() {
        return false;
    }

    @Override
    public void navigate(final boolean requestFocus) {
        ToolWindow window = ToolWindowManager.getInstance((Project)this.getProject()).getToolWindow(ToolWindowId.PROJECT_VIEW);
        window.activate(null);
        window.getActivation().doWhenDone(new Runnable(){

            @Override
            public void run() {
                ProjectView projectView = ProjectView.getInstance(PsiPackageImpl.this.getProject());
                projectView.changeView("PackagesPane");
                PsiDirectory[] directories = PsiPackageImpl.this.getDirectories();
                VirtualFile firstDir = directories[0].getVirtualFile();
                boolean isLibraryRoot = ProjectRootsUtil.isLibraryRoot(firstDir, PsiPackageImpl.this.getProject());
                Module module = ProjectRootManager.getInstance((Project)PsiPackageImpl.this.getProject()).getFileIndex().getModuleForFile(firstDir);
                PackageElement packageElement = new PackageElement(module, PsiPackageImpl.this, isLibraryRoot);
                projectView.getProjectViewPaneById("PackagesPane").select(packageElement, firstDir, requestFocus);
            }
        });
    }

    public boolean isPhysical() {
        return true;
    }

    public ASTNode getNode() {
        return null;
    }

    @Nullable
    public PsiModifierList getModifierList() {
        return this.getAnnotationList();
    }

    public boolean hasModifierProperty(@NonNls @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/PsiPackageImpl.hasModifierProperty must not be null");
        }
        return false;
    }

    public PsiQualifiedNamedElement getContainer() {
        return this.getParentPackage();
    }

    public void putInfo(Map<String, String> info) {
        info.put("packageName", this.getName());
        info.put("packageQualifiedName", this.getQualifiedName());
    }

    private class PackageAnnotationValueProvider
    implements CachedValueProvider<PsiModifierList> {
        @NonNls
        private static final String PACKAGE_INFO_FILE = "package-info.java";
        private final Object[] OOCB_DEPENDENCY = new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT};

        private PackageAnnotationValueProvider() {
        }

        public CachedValueProvider.Result<PsiModifierList> compute() {
            ArrayList<PsiModifierList> list = new ArrayList<PsiModifierList>();
            for (PsiDirectory directory : PsiPackageImpl.this.getDirectories()) {
                PsiModifierList modifierList;
                PsiPackageStatement stmt;
                PsiFile file = directory.findFile(PACKAGE_INFO_FILE);
                if (file == null || (stmt = (PsiPackageStatement)PsiTreeUtil.getChildOfType((PsiElement)file, PsiPackageStatement.class)) == null || (modifierList = stmt.getAnnotationList()) == null) continue;
                list.add(modifierList);
            }
            JavaPsiFacadeImpl facade = PsiPackageImpl.this.getFacade();
            for (PsiClass aClass : facade.findClasses(PsiPackageImpl.this.getQualifiedName() + ".package-info", ProjectScope.getAllScope((Project)PsiPackageImpl.this.getProject()))) {
                ContainerUtil.addIfNotNull((Object)aClass.getModifierList(), list);
            }
            return new CachedValueProvider.Result((Object)(list.isEmpty() ? null : new PsiCompositeModifierList(PsiPackageImpl.this.getManager(), list)), this.OOCB_DEPENDENCY);
        }
    }

    private class DirectoriesSearch
    extends QueryFactory<PsiDirectory, GlobalSearchScope> {
        public DirectoriesSearch() {
            this.registerExecutor((QueryExecutor)new QueryExecutor<PsiDirectory, GlobalSearchScope>(){

                public boolean execute(final GlobalSearchScope scope, final Processor<PsiDirectory> consumer) {
                    PackageIndex.getInstance((Project)PsiPackageImpl.this.getProject()).getDirsByPackageName(PsiPackageImpl.this.myQualifiedName, false).forEach((Processor)new ReadActionProcessor<VirtualFile>(){

                        public boolean processInReadAction(VirtualFile dir) {
                            if (!scope.contains(dir)) {
                                return true;
                            }
                            PsiDirectory psiDir = PsiPackageImpl.this.myManager.findDirectory(dir);
                            assert (psiDir != null);
                            return consumer.process((Object)psiDir);
                        }
                    });
                    return true;
                }
            });
        }

        public Query<PsiDirectory> search(GlobalSearchScope scope) {
            return this.createQuery(scope);
        }
    }
}

