/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.concurrency.JobUtil;
import com.intellij.ide.todo.TodoConfiguration;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLock;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.search.IndexPatternSearchImpl;
import com.intellij.psi.impl.search.LowLevelSearchUtil;
import com.intellij.psi.impl.search.TodoItemImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.IndexPattern;
import com.intellij.psi.search.IndexPatternOccurrence;
import com.intellij.psi.search.IndexPatternProvider;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiNonJavaFileReferenceProcessor;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.TextOccurenceProcessor;
import com.intellij.psi.search.TodoItem;
import com.intellij.psi.search.TodoPattern;
import com.intellij.psi.search.searches.IndexPatternSearch;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.text.StringSearcher;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiSearchHelperImpl
implements PsiSearchHelper {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.search.PsiSearchHelperImpl");
    private final PsiManagerEx myManager;
    private static final TodoItem[] EMPTY_TODO_ITEMS = new TodoItem[0];

    @NotNull
    public SearchScope getUseScope(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/search/PsiSearchHelperImpl.getUseScope must not be null");
        }
        SearchScope searchScope = element.getUseScope();
        if (searchScope == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/search/PsiSearchHelperImpl.getUseScope must not return null");
        }
        return searchScope;
    }

    public PsiSearchHelperImpl(PsiManagerEx manager) {
        this.myManager = manager;
    }

    @NotNull
    public PsiFile[] findFilesWithTodoItems() {
        PsiFile[] psiFileArray = this.myManager.getCacheManager().getFilesWithTodoItems();
        if (psiFileArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/search/PsiSearchHelperImpl.findFilesWithTodoItems must not return null");
        }
        return psiFileArray;
    }

    @NotNull
    public TodoItem[] findTodoItems(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/search/PsiSearchHelperImpl.findTodoItems must not be null");
        }
        TodoItem[] todoItemArray = PsiSearchHelperImpl.doFindTodoItems(file, new TextRange(0, file.getTextLength()));
        if (todoItemArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/search/PsiSearchHelperImpl.findTodoItems must not return null");
        }
        return todoItemArray;
    }

    @NotNull
    public TodoItem[] findTodoItems(@NotNull PsiFile file, int startOffset, int endOffset) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/search/PsiSearchHelperImpl.findTodoItems must not be null");
        }
        TodoItem[] todoItemArray = PsiSearchHelperImpl.doFindTodoItems(file, new TextRange(startOffset, endOffset));
        if (todoItemArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/search/PsiSearchHelperImpl.findTodoItems must not return null");
        }
        return todoItemArray;
    }

    private static TodoItem[] doFindTodoItems(PsiFile file, TextRange textRange) {
        Collection occurrences = IndexPatternSearch.search((PsiFile)file, (IndexPatternProvider)TodoConfiguration.getInstance()).findAll();
        if (occurrences.isEmpty()) {
            return EMPTY_TODO_ITEMS;
        }
        ArrayList<TodoItemImpl> items = new ArrayList<TodoItemImpl>(occurrences.size());
        for (IndexPatternOccurrence occurrence : occurrences) {
            TextRange occurrenceRange = occurrence.getTextRange();
            if (!textRange.contains(occurrenceRange)) continue;
            items.add(new TodoItemImpl(occurrence.getFile(), occurrenceRange.getStartOffset(), occurrenceRange.getEndOffset(), PsiSearchHelperImpl.mapPattern(occurrence.getPattern())));
        }
        return items.toArray(new TodoItem[items.size()]);
    }

    private static TodoPattern mapPattern(IndexPattern pattern) {
        for (TodoPattern todoPattern : TodoConfiguration.getInstance().getTodoPatterns()) {
            if (todoPattern.getIndexPattern() != pattern) continue;
            return todoPattern;
        }
        LOG.error("Could not find matching TODO pattern for index pattern " + pattern.getPatternString());
        return null;
    }

    public int getTodoItemsCount(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/search/PsiSearchHelperImpl.getTodoItemsCount must not be null");
        }
        int count = this.myManager.getCacheManager().getTodoCount(file.getVirtualFile(), TodoConfiguration.getInstance());
        if (count != -1) {
            return count;
        }
        return this.findTodoItems(file).length;
    }

    public int getTodoItemsCount(@NotNull PsiFile file, @NotNull TodoPattern pattern) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/search/PsiSearchHelperImpl.getTodoItemsCount must not be null");
        }
        if (pattern == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/search/PsiSearchHelperImpl.getTodoItemsCount must not be null");
        }
        int count = this.myManager.getCacheManager().getTodoCount(file.getVirtualFile(), pattern.getIndexPattern());
        if (count != -1) {
            return count;
        }
        TodoItem[] items = this.findTodoItems(file);
        count = 0;
        for (TodoItem item : items) {
            if (!item.getPattern().equals((Object)pattern)) continue;
            ++count;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public PsiElement[] findCommentsContainingIdentifier(@NotNull String identifier, @NotNull SearchScope searchScope) {
        if (identifier == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/search/PsiSearchHelperImpl.findCommentsContainingIdentifier must not be null");
        }
        if (searchScope == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/search/PsiSearchHelperImpl.findCommentsContainingIdentifier must not be null");
        }
        final ArrayList results = new ArrayList();
        this.processCommentsContainingIdentifier(identifier, searchScope, new Processor<PsiElement>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean process(PsiElement element) {
                ArrayList arrayList = results;
                synchronized (arrayList) {
                    results.add(element);
                }
                return true;
            }
        });
        ArrayList arrayList = results;
        // MONITORENTER : arrayList
        PsiElement[] psiElementArray = results.toArray(new PsiElement[results.size()]);
        // MONITOREXIT : arrayList
        if (psiElementArray != null) return psiElementArray;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/search/PsiSearchHelperImpl.findCommentsContainingIdentifier must not return null");
    }

    public boolean processCommentsContainingIdentifier(@NotNull String identifier, @NotNull SearchScope searchScope, final @NotNull Processor<PsiElement> processor) {
        if (identifier == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/search/PsiSearchHelperImpl.processCommentsContainingIdentifier must not be null");
        }
        if (searchScope == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/search/PsiSearchHelperImpl.processCommentsContainingIdentifier must not be null");
        }
        if (processor == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/search/PsiSearchHelperImpl.processCommentsContainingIdentifier must not be null");
        }
        TextOccurenceProcessor occurenceProcessor = new TextOccurenceProcessor(){

            public boolean execute(PsiElement element, int offsetInElement) {
                ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(element.getLanguage());
                if (parserDefinition == null) {
                    return true;
                }
                if (element.getNode() != null && !parserDefinition.getCommentTokens().contains(element.getNode().getElementType())) {
                    return true;
                }
                if (element.findReferenceAt(offsetInElement) == null) {
                    return processor.process((Object)element);
                }
                return true;
            }
        };
        return this.processElementsWithWord(occurenceProcessor, searchScope, identifier, (short)2, true);
    }

    public boolean processElementsWithWord(final @NotNull TextOccurenceProcessor processor, @NotNull SearchScope searchScope, final @NotNull String text, short searchContext, final boolean caseSensitively) {
        if (processor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/search/PsiSearchHelperImpl.processElementsWithWord must not be null");
        }
        if (searchScope == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/search/PsiSearchHelperImpl.processElementsWithWord must not be null");
        }
        if (text == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/search/PsiSearchHelperImpl.processElementsWithWord must not be null");
        }
        if (text.length() == 0) {
            throw new IllegalArgumentException("Cannot search for elements with empty text");
        }
        final ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
        if (searchScope instanceof GlobalSearchScope) {
            StringSearcher searcher = new StringSearcher(text, caseSensitively, true);
            return this.processElementsWithTextInGlobalScope(processor, (GlobalSearchScope)searchScope, searcher, searchContext, caseSensitively);
        }
        LocalSearchScope scope = (LocalSearchScope)searchScope;
        PsiElement[] scopeElements = scope.getScope();
        final boolean ignoreInjectedPsi = scope.isIgnoreInjectedPsi();
        return JobUtil.invokeConcurrentlyUnderMyProgress(Arrays.asList(scopeElements), new Processor<PsiElement>(){

            public boolean process(PsiElement scopeElement) {
                return PsiSearchHelperImpl.processElementsWithWordInScopeElement(scopeElement, processor, text, caseSensitively, ignoreInjectedPsi, progress);
            }
        }, "textsearch");
    }

    private static boolean processElementsWithWordInScopeElement(final PsiElement scopeElement, final TextOccurenceProcessor processor, final String word, final boolean caseSensitive, final boolean ignoreInjectedPsi, final ProgressIndicator progress) {
        return (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                StringSearcher searcher = new StringSearcher(word, caseSensitive, true);
                return LowLevelSearchUtil.processElementsContainingWordInElement(processor, scopeElement, searcher, ignoreInjectedPsi, progress);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processElementsWithTextInGlobalScope(final @NotNull TextOccurenceProcessor processor, @NotNull GlobalSearchScope scope, final @NotNull StringSearcher searcher, short searchContext, boolean caseSensitively) {
        if (processor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/search/PsiSearchHelperImpl.processElementsWithTextInGlobalScope must not be null");
        }
        if (scope == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/search/PsiSearchHelperImpl.processElementsWithTextInGlobalScope must not be null");
        }
        if (searcher == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/search/PsiSearchHelperImpl.processElementsWithTextInGlobalScope must not be null");
        }
        LOG.assertTrue(!Thread.holdsLock(PsiLock.LOCK), (Object)"You must not run search from within updating PSI activity. Please consider invokeLatering it instead.");
        final ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
        if (progress != null) {
            progress.pushState();
            progress.setText(PsiBundle.message((String)"psi.scanning.files.progress", (Object[])new Object[0]));
        }
        this.myManager.startBatchFilesProcessingMode();
        try {
            String text = searcher.getPattern();
            List<PsiFile> fileSet = this.getFilesWithText(scope, searchContext, caseSensitively, text, progress);
            if (progress != null) {
                progress.setText(PsiBundle.message((String)"psi.search.for.word.progress", (Object[])new Object[]{text}));
            }
            final AtomicInteger counter = new AtomicInteger(0);
            final AtomicBoolean canceled = new AtomicBoolean(false);
            final AtomicBoolean pceThrown = new AtomicBoolean(false);
            final int size = fileSet.size();
            boolean completed = JobUtil.invokeConcurrentlyUnderMyProgress(fileSet, new Processor<PsiFile>(){

                public boolean process(final PsiFile file) {
                    if (!(file instanceof PsiBinaryFile)) {
                        file.getViewProvider().getContents();
                        ApplicationManager.getApplication().runReadAction(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    PsiFile[] psiRoots = file.getPsiRoots();
                                    HashSet<PsiFile> processed = new HashSet<PsiFile>(psiRoots.length * 2, 0.5f);
                                    for (PsiFile psiRoot : psiRoots) {
                                        if (progress != null) {
                                            progress.checkCanceled();
                                        }
                                        if (!processed.add(psiRoot) || LowLevelSearchUtil.processElementsContainingWordInElement(processor, (PsiElement)psiRoot, searcher, false, progress)) continue;
                                        canceled.set(true);
                                        return;
                                    }
                                    PsiSearchHelperImpl.this.myManager.dropResolveCaches();
                                }
                                catch (ProcessCanceledException e) {
                                    canceled.set(true);
                                    pceThrown.set(true);
                                }
                            }
                        });
                    }
                    if (progress != null) {
                        double fraction = (double)counter.incrementAndGet() / (double)size;
                        progress.setFraction(fraction);
                    }
                    return !canceled.get();
                }
            }, "Process usages in files");
            if (pceThrown.get()) {
                throw new ProcessCanceledException();
            }
            boolean bl = completed;
            return bl;
        }
        finally {
            if (progress != null) {
                progress.popState();
            }
            this.myManager.finishBatchFilesProcessingMode();
        }
    }

    private List<PsiFile> getFilesWithText(@NotNull GlobalSearchScope scope, short searchContext, boolean caseSensitively, @NotNull String text, ProgressIndicator progress) {
        if (scope == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/search/PsiSearchHelperImpl.getFilesWithText must not be null");
        }
        if (text == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/psi/impl/search/PsiSearchHelperImpl.getFilesWithText must not be null");
        }
        ArrayList<PsiFile> result = new ArrayList<PsiFile>();
        if (!this.processFilesWithText(scope, searchContext, caseSensitively, text, (Processor<PsiFile>)new CommonProcessors.CollectProcessor(result), progress)) {
            return Collections.emptyList();
        }
        return result;
    }

    private boolean processFilesWithText(@NotNull GlobalSearchScope scope, short searchContext, boolean caseSensitively, @NotNull String text, @NotNull Processor<PsiFile> processor, ProgressIndicator progress) {
        THashSet fileSet;
        if (scope == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/search/PsiSearchHelperImpl.processFilesWithText must not be null");
        }
        if (text == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/psi/impl/search/PsiSearchHelperImpl.processFilesWithText must not be null");
        }
        if (processor == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of com/intellij/psi/impl/search/PsiSearchHelperImpl.processFilesWithText must not be null");
        }
        List words = StringUtil.getWordsIn((String)text);
        if (words.isEmpty()) {
            return true;
        }
        Collections.sort(words, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o2.length() - o1.length();
            }
        });
        if (words.size() > 1) {
            fileSet = new THashSet();
            THashSet copy = new THashSet();
            for (int i = 0; i < words.size() - 1; ++i) {
                if (progress != null) {
                    progress.checkCanceled();
                } else {
                    ProgressManager.checkCanceled();
                }
                String word = (String)words.get(i);
                this.myManager.getCacheManager().processFilesWithWord((Processor<PsiFile>)new CommonProcessors.CollectProcessor((Collection)copy), word, searchContext, scope, caseSensitively);
                if (i == 0) {
                    fileSet.addAll(copy);
                } else {
                    fileSet.retainAll((Collection<?>)copy);
                }
                copy.clear();
                if (fileSet.isEmpty()) break;
            }
            if (fileSet.isEmpty()) {
                return true;
            }
        } else {
            fileSet = null;
        }
        return this.myManager.getCacheManager().processFilesWithWord(new Processor<PsiFile>((Set)fileSet, processor){
            final /* synthetic */ Set val$fileSet;
            final /* synthetic */ Processor val$processor;
            {
                this.val$fileSet = set;
                this.val$processor = processor;
            }

            public boolean process(PsiFile psiFile) {
                if (this.val$fileSet != null && !this.val$fileSet.contains(psiFile)) {
                    return true;
                }
                return this.val$processor.process((Object)psiFile);
            }
        }, (String)words.get(words.size() - 1), searchContext, scope, caseSensitively);
    }

    @NotNull
    public PsiFile[] findFilesWithPlainTextWords(@NotNull String word) {
        if (word == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/search/PsiSearchHelperImpl.findFilesWithPlainTextWords must not be null");
        }
        PsiFile[] psiFileArray = this.myManager.getCacheManager().getFilesWithWord(word, (short)16, GlobalSearchScope.projectScope((Project)this.myManager.getProject()), true);
        if (psiFileArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/search/PsiSearchHelperImpl.findFilesWithPlainTextWords must not return null");
        }
        return psiFileArray;
    }

    public void processUsagesInNonJavaFiles(@NotNull String qName, @NotNull PsiNonJavaFileReferenceProcessor processor, @NotNull GlobalSearchScope searchScope) {
        if (qName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/search/PsiSearchHelperImpl.processUsagesInNonJavaFiles must not be null");
        }
        if (processor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/search/PsiSearchHelperImpl.processUsagesInNonJavaFiles must not be null");
        }
        if (searchScope == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/search/PsiSearchHelperImpl.processUsagesInNonJavaFiles must not be null");
        }
        this.processUsagesInNonJavaFiles(null, qName, processor, searchScope);
    }

    public void processUsagesInNonJavaFiles(final @Nullable PsiElement originalElement, @NotNull String qName, final @NotNull PsiNonJavaFileReferenceProcessor processor, @NotNull GlobalSearchScope searchScope) {
        String wordToSearch;
        int dollarIndex;
        if (qName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/search/PsiSearchHelperImpl.processUsagesInNonJavaFiles must not be null");
        }
        if (processor == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/search/PsiSearchHelperImpl.processUsagesInNonJavaFiles must not be null");
        }
        if (searchScope == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/psi/impl/search/PsiSearchHelperImpl.processUsagesInNonJavaFiles must not be null");
        }
        if (qName.length() == 0) {
            throw new IllegalArgumentException("Cannot search for elements with empty text");
        }
        ProgressManager progressManager = ProgressManager.getInstance();
        final ProgressIndicator progress = progressManager.getProgressIndicator();
        int dotIndex = qName.lastIndexOf(46);
        int maxIndex = Math.max(dotIndex, dollarIndex = qName.lastIndexOf(36));
        String string = wordToSearch = maxIndex >= 0 ? qName.substring(maxIndex + 1) : qName;
        if (originalElement != null && this.myManager.isInProject(originalElement) && searchScope.isSearchInLibraries()) {
            searchScope = searchScope.intersectWith(GlobalSearchScope.projectScope((Project)this.myManager.getProject()));
        }
        final GlobalSearchScope theSearchScope = searchScope;
        PsiFile[] files = (PsiFile[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiFile[]>(){

            public PsiFile[] compute() {
                return PsiSearchHelperImpl.this.myManager.getCacheManager().getFilesWithWord(wordToSearch, (short)16, theSearchScope, true);
            }
        });
        final StringSearcher searcher = new StringSearcher(qName, true, true);
        if (progress != null) {
            progress.pushState();
            progress.setText(PsiBundle.message((String)"psi.search.in.non.java.files.progress", (Object[])new Object[0]));
        }
        final Ref cancelled = new Ref((Object)Boolean.FALSE);
        final GlobalSearchScope finalScope = searchScope;
        for (int i = 0; i < files.length; ++i) {
            if (progress != null) {
                progress.checkCanceled();
            }
            final PsiFile psiFile = files[i];
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    CharSequence text = psiFile.getViewProvider().getContents();
                    int index = LowLevelSearchUtil.searchWord(text, 0, text.length(), searcher, progress);
                    while (index >= 0) {
                        PsiReference referenceAt = psiFile.findReferenceAt(index);
                        if (!(referenceAt != null && originalElement != null && PsiSearchScopeUtil.isInScope((SearchScope)PsiSearchHelperImpl.this.getUseScope(originalElement).intersectWith((SearchScope)finalScope), (PsiElement)psiFile) || processor.process(psiFile, index, index + searcher.getPattern().length()))) {
                            cancelled.set((Object)Boolean.TRUE);
                            return;
                        }
                        index = LowLevelSearchUtil.searchWord(text, index + searcher.getPattern().length(), text.length(), searcher, progress);
                    }
                }
            });
            if (((Boolean)cancelled.get()).booleanValue()) break;
            if (progress == null) continue;
            progress.setFraction((double)(i + 1) / (double)files.length);
        }
        if (progress != null) {
            progress.popState();
        }
    }

    public void processAllFilesWithWord(@NotNull String word, @NotNull GlobalSearchScope scope, @NotNull Processor<PsiFile> processor, boolean caseSensitively) {
        if (word == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/search/PsiSearchHelperImpl.processAllFilesWithWord must not be null");
        }
        if (scope == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/search/PsiSearchHelperImpl.processAllFilesWithWord must not be null");
        }
        if (processor == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/search/PsiSearchHelperImpl.processAllFilesWithWord must not be null");
        }
        this.myManager.getCacheManager().processFilesWithWord(processor, word, (short)1, scope, caseSensitively);
    }

    public void processAllFilesWithWordInText(@NotNull String word, @NotNull GlobalSearchScope scope, @NotNull Processor<PsiFile> processor, boolean caseSensitively) {
        if (word == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/search/PsiSearchHelperImpl.processAllFilesWithWordInText must not be null");
        }
        if (scope == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/search/PsiSearchHelperImpl.processAllFilesWithWordInText must not be null");
        }
        if (processor == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/search/PsiSearchHelperImpl.processAllFilesWithWordInText must not be null");
        }
        this.myManager.getCacheManager().processFilesWithWord(processor, word, (short)16, scope, caseSensitively);
    }

    public void processAllFilesWithWordInComments(@NotNull String word, @NotNull GlobalSearchScope scope, @NotNull Processor<PsiFile> processor) {
        if (word == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/search/PsiSearchHelperImpl.processAllFilesWithWordInComments must not be null");
        }
        if (scope == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/search/PsiSearchHelperImpl.processAllFilesWithWordInComments must not be null");
        }
        if (processor == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/search/PsiSearchHelperImpl.processAllFilesWithWordInComments must not be null");
        }
        this.myManager.getCacheManager().processFilesWithWord(processor, word, (short)2, scope, true);
    }

    public void processAllFilesWithWordInLiterals(@NotNull String word, @NotNull GlobalSearchScope scope, @NotNull Processor<PsiFile> processor) {
        if (word == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/search/PsiSearchHelperImpl.processAllFilesWithWordInLiterals must not be null");
        }
        if (scope == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/search/PsiSearchHelperImpl.processAllFilesWithWordInLiterals must not be null");
        }
        if (processor == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/search/PsiSearchHelperImpl.processAllFilesWithWordInLiterals must not be null");
        }
        this.myManager.getCacheManager().processFilesWithWord(processor, word, (short)4, scope, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PsiSearchHelper.SearchCostResult isCheapEnoughToSearch(@NotNull String name, @NotNull GlobalSearchScope scope, final @Nullable PsiFile fileToIgnoreOccurencesIn, ProgressIndicator progress) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/search/PsiSearchHelperImpl.isCheapEnoughToSearch must not be null");
        }
        if (scope == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/search/PsiSearchHelperImpl.isCheapEnoughToSearch must not be null");
        }
        final int[] count = new int[]{0};
        if (!this.processFilesWithText(scope, (short)255, true, name, new Processor<PsiFile>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean process(PsiFile file) {
                if (file == fileToIgnoreOccurencesIn) {
                    return true;
                }
                int[] nArray = count;
                synchronized (count) {
                    count[0] = count[0] + 1;
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return count[0] <= 10;
                }
            }
        }, progress)) {
            return PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES;
        }
        int[] nArray = count;
        synchronized (count) {
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return count[0] == 0 ? PsiSearchHelper.SearchCostResult.ZERO_OCCURRENCES : PsiSearchHelper.SearchCostResult.FEW_OCCURRENCES;
        }
    }

    static {
        IndexPatternSearch.INDEX_PATTERN_SEARCH_INSTANCE = new IndexPatternSearchImpl();
    }
}

