/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.PsiImplUtil;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class ClassInnerStuffCache {
    private volatile Map<String, PsiField> myCachedFieldsMap = null;
    private volatile Map<String, PsiMethod[]> myCachedMethodsMap = null;
    private volatile Map<String, PsiClass> myCachedInnersMap = null;
    private volatile PsiMethod[] myCachedConstructors = null;
    private final PsiClass myClass;

    public ClassInnerStuffCache(PsiClass aClass) {
        this.myClass = aClass;
    }

    public void dropCaches() {
        this.myCachedConstructors = null;
        this.myCachedFieldsMap = null;
        this.myCachedMethodsMap = null;
        this.myCachedInnersMap = null;
    }

    @NotNull
    public PsiMethod[] getConstructors() {
        PsiMethod[] constructors = this.myCachedConstructors;
        if (constructors == null) {
            this.myCachedConstructors = constructors = PsiImplUtil.getConstructors(this.myClass);
        }
        if (constructors == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/ClassInnerStuffCache.getConstructors must not return null");
        }
        return constructors;
    }

    public PsiField findFieldByName(String name, boolean checkBases) {
        if (!checkBases) {
            THashMap cachedFields = this.myCachedFieldsMap;
            if (cachedFields == null) {
                PsiField[] fields = this.myClass.getFields();
                if (fields.length > 0) {
                    cachedFields = new THashMap();
                    for (PsiField field : fields) {
                        cachedFields.put(field.getName(), field);
                    }
                    this.myCachedFieldsMap = cachedFields;
                } else {
                    this.myCachedFieldsMap = Collections.emptyMap();
                    return null;
                }
            }
            return cachedFields.get(name);
        }
        return PsiClassImplUtil.findFieldByName(this.myClass, name, checkBases);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public PsiMethod[] findMethodsByName(String name, boolean checkBases) {
        PsiMethod[] psiMethodArray;
        if (!checkBases) {
            PsiMethod[] psiMethods;
            THashMap cachedMethods = this.myCachedMethodsMap;
            if (cachedMethods == null) {
                PsiMethod[] methods;
                cachedMethods = new THashMap();
                THashMap cachedMethodsMap = new THashMap();
                for (PsiMethod method : methods = this.myClass.getMethods()) {
                    ArrayList<PsiMethod> list = (ArrayList<PsiMethod>)cachedMethodsMap.get(method.getName());
                    if (list == null) {
                        list = new ArrayList<PsiMethod>(1);
                        cachedMethodsMap.put(method.getName(), list);
                    }
                    list.add(method);
                }
                for (Map.Entry entry : cachedMethodsMap.entrySet()) {
                    List cached = (List)entry.getValue();
                    String methodName = (String)entry.getKey();
                    cachedMethods.put(methodName, cached.toArray(new PsiMethod[cached.size()]));
                }
                this.myCachedMethodsMap = cachedMethods;
            }
            if ((psiMethodArray = (psiMethods = cachedMethods.get(name)) != null ? psiMethods : PsiMethod.EMPTY_ARRAY) == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/ClassInnerStuffCache.findMethodsByName must not return null");
            return psiMethodArray;
        }
        psiMethodArray = PsiClassImplUtil.findMethodsByName(this.myClass, name, checkBases);
        if (psiMethodArray != null) return psiMethodArray;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/ClassInnerStuffCache.findMethodsByName must not return null");
    }

    public PsiClass findInnerClassByName(String name, boolean checkBases) {
        if (!checkBases) {
            THashMap inners = this.myCachedInnersMap;
            if (inners == null) {
                PsiClass[] classes = this.myClass.getInnerClasses();
                if (classes.length > 0) {
                    inners = new THashMap();
                    for (PsiClass psiClass : classes) {
                        inners.put(psiClass.getName(), psiClass);
                    }
                    this.myCachedInnersMap = inners;
                } else {
                    this.myCachedInnersMap = Collections.emptyMap();
                    return null;
                }
            }
            return inners.get(name);
        }
        return PsiClassImplUtil.findInnerByName(this.myClass, name, checkBases);
    }
}

