/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.lang.ASTNode;
import com.intellij.lang.StdLanguages;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.impl.java.stubs.JavaStubElementType;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.PreFormatProcessor;
import com.intellij.psi.impl.source.codeStyle.javadoc.CommentFormatter;
import com.intellij.psi.javadoc.PsiDocComment;

public class FormatCommentsProcessor
implements PreFormatProcessor {
    @Override
    public TextRange process(ASTNode element, TextRange range) {
        Project project = SourceTreeToPsiMap.treeElementToPsi(element).getProject();
        if (!CodeStyleSettingsManager.getSettings((Project)project).ENABLE_JAVADOC_FORMATTING || element.getPsi().getContainingFile().getLanguage() != StdLanguages.JAVA) {
            return range;
        }
        return FormatCommentsProcessor.formatCommentsInner(project, element, range);
    }

    private static TextRange formatCommentsInner(Project project, ASTNode element, TextRange range) {
        TextRange result = range;
        if (FormatCommentsProcessor.shouldProcess(element)) {
            TextRange elementRange = element.getTextRange();
            if (range.contains(elementRange)) {
                new CommentFormatter(project).process(element);
                TextRange newRange = element.getTextRange();
                result = new TextRange(range.getStartOffset(), range.getEndOffset() + newRange.getLength() - elementRange.getLength());
            }
            if (element.getPsi() instanceof PsiField || element.getPsi() instanceof PsiMethod || element instanceof PsiDocComment || range.getEndOffset() < elementRange.getStartOffset()) {
                return result;
            }
        }
        for (ASTNode current = element.getFirstChildNode(); current != null; current = current.getTreeNext()) {
            current.getFirstChildNode();
            result = FormatCommentsProcessor.formatCommentsInner(project, current, result);
        }
        return result;
    }

    private static boolean shouldProcess(ASTNode element) {
        if (element instanceof PsiDocComment) {
            return true;
        }
        return element.getElementType() instanceof JavaStubElementType && element.getPsi() instanceof PsiDocCommentOwner;
    }
}

