/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle.javadoc;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.javadoc.JDClassComment;
import com.intellij.psi.impl.source.codeStyle.javadoc.JDComment;
import com.intellij.psi.impl.source.codeStyle.javadoc.JDMethodComment;
import com.intellij.psi.impl.source.codeStyle.javadoc.JDParser;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nullable;

public class CommentFormatter {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.codeStyle.javadoc.CommentFormatter");
    private final CodeStyleSettings mySettings;
    private final JDParser myParser;
    private final Project myProject;

    public CommentFormatter(Project project) {
        this.mySettings = CodeStyleSettingsManager.getSettings((Project)project);
        this.myParser = new JDParser(this.mySettings);
        this.myProject = project;
    }

    public CodeStyleSettings getSettings() {
        return this.mySettings;
    }

    public JDParser getParser() {
        return this.myParser;
    }

    public void process(ASTNode element) {
        if (!this.getSettings().ENABLE_JAVADOC_FORMATTING) {
            return;
        }
        PsiElement psiElement = SourceTreeToPsiMap.treeElementToPsi(element);
        this.processElementComment(psiElement);
    }

    private void processElementComment(PsiElement psiElement) {
        if (psiElement instanceof PsiClass) {
            String newCommentText = this.formatClassComment((PsiClass)psiElement);
            this.replaceDocComment(newCommentText, (PsiDocCommentOwner)psiElement);
        } else if (psiElement instanceof PsiMethod) {
            String newCommentText = this.formatMethodComment((PsiMethod)psiElement);
            this.replaceDocComment(newCommentText, (PsiDocCommentOwner)psiElement);
        } else if (psiElement instanceof PsiField) {
            String newCommentText = this.formatFieldComment((PsiField)psiElement);
            this.replaceDocComment(newCommentText, (PsiDocCommentOwner)psiElement);
        } else if (psiElement instanceof PsiDocComment) {
            this.processElementComment(psiElement.getParent());
        }
    }

    private void replaceDocComment(String newCommentText, PsiDocCommentOwner psiDocCommentOwner) {
        PsiDocComment oldComment = psiDocCommentOwner.getDocComment();
        if (newCommentText != null) {
            newCommentText = CommentFormatter.stripSpaces(newCommentText);
        }
        if (newCommentText == null || oldComment == null || newCommentText.equals(oldComment.getText())) {
            return;
        }
        try {
            PsiComment newComment = JavaPsiFacade.getInstance((Project)this.myProject).getElementFactory().createCommentFromText(newCommentText, null);
            ASTNode oldNode = oldComment.getNode();
            ASTNode newNode = newComment.getNode();
            assert (oldNode != null && newNode != null);
            ASTNode parent = oldNode.getTreeParent();
            parent.replaceChild(oldNode, newNode);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private static String stripSpaces(String text) {
        String[] lines = LineTokenizer.tokenize((char[])text.toCharArray(), (boolean)false);
        StringBuffer buf = new StringBuffer(text.length());
        for (int i = 0; i < lines.length; ++i) {
            if (i > 0) {
                buf.append('\n');
            }
            buf.append(CommentFormatter.rTrim(lines[i]));
        }
        return buf.toString();
    }

    private static String rTrim(String text) {
        int idx;
        for (idx = text.length(); idx > 0 && Character.isWhitespace(text.charAt(idx - 1)); --idx) {
        }
        return text.substring(0, idx);
    }

    @Nullable
    private String formatClassComment(PsiClass psiClass) {
        String info = CommentFormatter.getOrigCommentInfo((PsiDocCommentOwner)psiClass);
        if (info == null) {
            return null;
        }
        JDComment comment = this.getParser().parse(info, new JDClassComment(this));
        return comment.generate(CommentFormatter.getIndent((PsiElement)psiClass));
    }

    @Nullable
    private String formatMethodComment(PsiMethod psiMethod) {
        String info = CommentFormatter.getOrigCommentInfo((PsiDocCommentOwner)psiMethod);
        if (info == null) {
            return null;
        }
        JDComment comment = this.getParser().parse(info, new JDMethodComment(this));
        return comment.generate(CommentFormatter.getIndent((PsiElement)psiMethod));
    }

    @Nullable
    private String formatFieldComment(PsiField psiField) {
        String info = CommentFormatter.getOrigCommentInfo((PsiDocCommentOwner)psiField);
        if (info == null) {
            return null;
        }
        JDComment comment = this.getParser().parse(info, new JDComment(this));
        return comment.generate(CommentFormatter.getIndent((PsiElement)psiField));
    }

    private static String getOrigCommentInfo(PsiDocCommentOwner element) {
        StringBuffer sb = new StringBuffer();
        PsiElement e = element.getFirstChild();
        if (!(e instanceof PsiComment)) {
            return null;
        }
        boolean first = true;
        while (true) {
            if (e instanceof PsiDocComment) {
                PsiComment cm = (PsiComment)e;
                String text = cm.getText();
                if (text.startsWith("//")) {
                    if (!first) {
                        sb.append('\n');
                    }
                    sb.append(text.substring(2).trim());
                } else if (text.startsWith("/*")) {
                    text = text.charAt(2) == '*' ? text.substring(3, Math.max(3, text.length() - 2)) : text.substring(2, Math.max(2, text.length() - 2));
                    sb.append(text);
                }
            } else if (!(e instanceof PsiWhiteSpace) && !(e instanceof PsiComment)) break;
            first = false;
            e = e.getNextSibling();
        }
        return sb.toString();
    }

    private static String getIndent(PsiElement element) {
        char ch;
        int l;
        PsiElement e = element.getFirstChild();
        PsiWhiteSpace lastWS = null;
        while (true) {
            if (e instanceof PsiWhiteSpace) {
                lastWS = (PsiWhiteSpace)e;
            } else {
                if (!(e instanceof PsiComment)) break;
                lastWS = null;
            }
            e = e.getNextSibling();
        }
        Object object = e = lastWS == null ? element.getPrevSibling() : lastWS;
        if (!(e instanceof PsiWhiteSpace)) {
            return "";
        }
        PsiWhiteSpace ws = (PsiWhiteSpace)e;
        String t = ws.getText();
        int i = l = t.length();
        while (--i >= 0 && (ch = t.charAt(i)) != '\n' && ch != '\r') {
        }
        if (i < 0) {
            return t;
        }
        if (++i == l) {
            return "";
        }
        return t.substring(i);
    }
}

