/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.javadoc;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaDocTokenType;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaReference;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveState;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.psi.scope.ElementClassFilter;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.processor.FilterScopeProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CharTable;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiDocMethodOrFieldRef
extends CompositePsiElement
implements PsiDocTagValue,
Constants {
    public PsiDocMethodOrFieldRef() {
        super(DOC_METHOD_OR_FIELD_REF);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/javadoc/PsiDocMethodOrFieldRef.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitDocTagValue((PsiDocTagValue)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @Override
    public PsiReference getReference() {
        PsiElement scope = this.getScope();
        PsiElement element = this.getNameElement();
        if (scope == null || element == null) {
            return new MyReference(null);
        }
        PsiReference psiReference = this.getReferenceInScope(scope, element);
        if (psiReference != null) {
            return psiReference;
        }
        if (scope instanceof PsiClass) {
            PsiClass classScope = (PsiClass)scope;
            PsiClass containingClass = classScope.getContainingClass();
            while (containingClass != null) {
                classScope = containingClass;
                psiReference = this.getReferenceInScope((PsiElement)classScope, element);
                if (psiReference != null) {
                    return psiReference;
                }
                containingClass = classScope.getContainingClass();
            }
        }
        return new MyReference(null);
    }

    @Nullable
    private PsiReference getReferenceInScope(PsiElement scope, PsiElement element) {
        final String name = element.getText();
        String[] signature = this.getSignature();
        if (signature == null) {
            PsiVariable[] vars;
            for (PsiVariable psiVariable : vars = PsiDocMethodOrFieldRef.getAllVariables(scope, this)) {
                if (!psiVariable.getName().equals(name)) continue;
                return new MyReference((PsiElement)psiVariable);
            }
        }
        final PsiMethod[] methods = PsiDocMethodOrFieldRef.getAllMethods(scope, this);
        block1: for (PsiVariable psiVariable : methods) {
            if (!psiVariable.getName().equals(name)) continue;
            if (signature == null) {
                return new MyReference((PsiElement)psiVariable);
            }
            PsiParameter[] parameters = psiVariable.getParameterList().getParameters();
            if (parameters.length != signature.length) continue;
            for (int j = 0; j < parameters.length; ++j) {
                PsiParameter parameter = parameters[j];
                PsiType type1 = TypeConversionUtil.erasure((PsiType)parameter.getType());
                String type2 = signature[j];
                if (!Comparing.strEqual((String)type1.getPresentableText(), (String)type2) && !Comparing.strEqual((String)type1.getCanonicalText(), (String)type2)) continue block1;
            }
            return new MyReference((PsiElement)psiVariable){

                @Override
                @NotNull
                public PsiElement[] getVariants() {
                    ArrayList<PsiMethod> lst = new ArrayList<PsiMethod>();
                    for (PsiMethod method : methods) {
                        if (!name.equals(method.getName())) continue;
                        lst.add(method);
                    }
                    PsiElement[] psiElementArray = (PsiElement[])lst.toArray(new PsiMethod[lst.size()]);
                    if (psiElementArray == null) {
                        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/javadoc/PsiDocMethodOrFieldRef$1.getVariants must not return null");
                    }
                    return psiElementArray;
                }
            };
        }
        return null;
    }

    public static PsiVariable[] getAllVariables(PsiElement scope, PsiElement place) {
        SmartList result = new SmartList();
        scope.processDeclarations(new FilterScopeProcessor((ElementFilter)ElementClassFilter.VARIABLE, result), ResolveState.initial(), null, place);
        return (PsiVariable[])result.toArray((Object[])new PsiVariable[result.size()]);
    }

    public static PsiMethod[] getAllMethods(PsiElement scope, PsiElement place) {
        SmartList result = new SmartList();
        scope.processDeclarations(new FilterScopeProcessor((ElementFilter)ElementClassFilter.METHOD, result), ResolveState.initial(), null, place);
        return (PsiMethod[])result.toArray((Object[])new PsiMethod[result.size()]);
    }

    @Override
    public int getTextOffset() {
        PsiElement element = this.getNameElement();
        if (element != null) {
            return element.getTextRange().getStartOffset();
        }
        return this.getTextRange().getEndOffset();
    }

    public PsiElement getNameElement() {
        ASTNode sharp = this.findChildByType(DOC_TAG_VALUE_SHARP_TOKEN);
        if (sharp == null) {
            return null;
        }
        return SourceTreeToPsiMap.treeElementToPsi(sharp).getNextSibling();
    }

    private String[] getSignature() {
        PsiElement element;
        for (element = this.getNameElement().getNextSibling(); element != null && !(element instanceof PsiDocTagValue); element = element.getNextSibling()) {
        }
        if (element == null) {
            return null;
        }
        ArrayList<String> types = new ArrayList<String>();
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            String[] typeStrings;
            if (child.getNode().getElementType() != DOC_TYPE_HOLDER || (typeStrings = child.getText().split("[, ]")) == null) continue;
            for (String type : typeStrings) {
                if (type.length() <= 0) continue;
                types.add(type);
            }
        }
        return ArrayUtil.toStringArray(types);
    }

    @Nullable
    private PsiElement getScope() {
        if (this.getFirstChildNode().getElementType() == ElementType.DOC_REFERENCE_HOLDER) {
            PsiElement firstChildPsi = SourceTreeToPsiMap.treeElementToPsi(this.getFirstChildNode().getFirstChildNode());
            if (firstChildPsi instanceof PsiJavaCodeReferenceElement) {
                PsiJavaCodeReferenceElement referenceElement = (PsiJavaCodeReferenceElement)firstChildPsi;
                PsiElement referencedElement = referenceElement.resolve();
                if (referencedElement instanceof PsiClass) {
                    return referencedElement;
                }
                return null;
            }
            if (firstChildPsi instanceof PsiKeyword) {
                PsiKeyword keyword = (PsiKeyword)firstChildPsi;
                if (keyword.getTokenType().equals(THIS_KEYWORD)) {
                    return JavaResolveUtil.getContextClass(this);
                }
                if (keyword.getTokenType().equals(SUPER_KEYWORD)) {
                    PsiClass contextClass = JavaResolveUtil.getContextClass(this);
                    if (contextClass != null) {
                        return contextClass.getSuperClass();
                    }
                    return null;
                }
            }
        }
        return JavaResolveUtil.getContextClass(this);
    }

    private class MyReference
    implements PsiJavaReference {
        private final PsiElement myReferencee;

        public MyReference(PsiElement referencee) {
            this.myReferencee = referencee;
        }

        public PsiElement resolve() {
            return this.myReferencee;
        }

        public void processVariants(PsiScopeProcessor processor) {
            for (PsiElement element : this.getVariants()) {
                if (processor.execute(element, ResolveState.initial())) continue;
                return;
            }
        }

        @NotNull
        public JavaResolveResult advancedResolve(boolean incompleteCode) {
            Object object = this.myReferencee == null ? JavaResolveResult.EMPTY : new CandidateInfo(this.myReferencee, PsiSubstitutor.EMPTY);
            if (object == null) {
                throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/javadoc/PsiDocMethodOrFieldRef$MyReference.advancedResolve must not return null");
            }
            return object;
        }

        @NotNull
        public JavaResolveResult[] multiResolve(boolean incompleteCode) {
            JavaResolveResult[] javaResolveResultArray;
            if (this.myReferencee == null) {
                javaResolveResultArray = JavaResolveResult.EMPTY_ARRAY;
            } else {
                JavaResolveResult[] javaResolveResultArray2 = new JavaResolveResult[1];
                javaResolveResultArray = javaResolveResultArray2;
                javaResolveResultArray2[0] = new CandidateInfo(this.myReferencee, PsiSubstitutor.EMPTY);
            }
            if (javaResolveResultArray == null) {
                throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/javadoc/PsiDocMethodOrFieldRef$MyReference.multiResolve must not return null");
            }
            return javaResolveResultArray;
        }

        @NotNull
        public PsiElement[] getVariants() {
            ArrayList<Object> vars = new ArrayList<Object>();
            PsiElement scope = PsiDocMethodOrFieldRef.this.getScope();
            if (scope != null) {
                vars.addAll(Arrays.asList(PsiDocMethodOrFieldRef.getAllMethods(scope, PsiDocMethodOrFieldRef.this)));
                vars.addAll(Arrays.asList(PsiDocMethodOrFieldRef.getAllVariables(scope, PsiDocMethodOrFieldRef.this)));
            }
            PsiElement[] psiElementArray = (PsiElement[])vars.toArray(new PsiModifierListOwner[vars.size()]);
            if (psiElementArray == null) {
                throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/javadoc/PsiDocMethodOrFieldRef$MyReference.getVariants must not return null");
            }
            return psiElementArray;
        }

        public boolean isSoft() {
            return false;
        }

        public String getCanonicalText() {
            return PsiDocMethodOrFieldRef.this.getNameElement().getText();
        }

        public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
            PsiElement element = PsiDocMethodOrFieldRef.this.getNameElement();
            ASTNode treeElement = SourceTreeToPsiMap.psiElementToTree(element);
            CharTable charTableByTree = SharedImplUtil.findCharTableByTree(treeElement);
            LeafElement newToken = Factory.createSingleLeafElement(JavaDocTokenType.DOC_TAG_VALUE_TOKEN, newElementName, charTableByTree, PsiDocMethodOrFieldRef.this.getManager());
            ((CompositeElement)treeElement.getTreeParent()).replaceChildInternal(SourceTreeToPsiMap.psiElementToTree(element), newToken);
            return SourceTreeToPsiMap.treeElementToPsi(newToken);
        }

        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            String newName;
            PsiClass containingClass;
            boolean hasSignature;
            PsiMethod method;
            if (element == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/javadoc/PsiDocMethodOrFieldRef$MyReference.bindToElement must not be null");
            }
            if (this.isReferenceTo(element)) {
                return PsiDocMethodOrFieldRef.this;
            }
            String name = PsiDocMethodOrFieldRef.this.getNameElement().getText();
            if (element instanceof PsiMethod) {
                method = (PsiMethod)element;
                hasSignature = PsiDocMethodOrFieldRef.this.getSignature() != null;
                containingClass = method.getContainingClass();
                newName = method.getName();
            } else if (element instanceof PsiField) {
                PsiField field = (PsiField)element;
                hasSignature = false;
                containingClass = field.getContainingClass();
                method = null;
                newName = field.getName();
            } else {
                throw new IncorrectOperationException();
            }
            if (PsiDocMethodOrFieldRef.this.getFirstChild().getNode().getElementType() == ElementType.DOC_REFERENCE_HOLDER) {
                PsiJavaCodeReferenceElement referenceElement = (PsiJavaCodeReferenceElement)PsiDocMethodOrFieldRef.this.getFirstChild().getFirstChild();
                referenceElement.bindToElement((PsiElement)containingClass);
            } else if (!PsiTreeUtil.isAncestor((PsiElement)containingClass, (PsiElement)PsiDocMethodOrFieldRef.this, (boolean)true)) {
                PsiReferenceExpression ref = JavaPsiFacade.getInstance((Project)containingClass.getProject()).getElementFactory().createReferenceExpression(containingClass);
                PsiDocMethodOrFieldRef.this.addAfter((PsiElement)ref, null);
            }
            if (hasSignature || !name.equals(newName)) {
                String text = PsiDocMethodOrFieldRef.this.getText();
                StringBuffer newText = new StringBuffer();
                newText.append("/** @see ");
                if (name.equals(newName)) {
                    newText.append(text.substring(0, text.indexOf(40)));
                } else {
                    int sharpIndex = text.indexOf(35);
                    if (sharpIndex >= 0) {
                        newText.append(text.substring(0, sharpIndex + 1));
                    }
                    newText.append(newName);
                }
                if (hasSignature) {
                    newText.append('(');
                    PsiParameter[] parameters = method.getParameterList().getParameters();
                    for (int i = 0; i < parameters.length; ++i) {
                        PsiParameter parameter = parameters[i];
                        if (i > 0) {
                            newText.append(",");
                        }
                        newText.append(parameter.getType().getCanonicalText());
                    }
                    newText.append(')');
                }
                newText.append("*/");
                PsiComment comment = JavaPsiFacade.getInstance((Project)containingClass.getProject()).getElementFactory().createCommentFromText(newText.toString(), null);
                PsiElement tag = PsiTreeUtil.getChildOfType((PsiElement)comment, PsiDocTag.class);
                PsiElement ref = PsiTreeUtil.getChildOfType((PsiElement)tag, PsiDocMethodOrFieldRef.class);
                return PsiDocMethodOrFieldRef.this.replace(ref);
            }
            return PsiDocMethodOrFieldRef.this;
        }

        public boolean isReferenceTo(PsiElement element) {
            return PsiDocMethodOrFieldRef.this.getManager().areElementsEquivalent(this.resolve(), element);
        }

        public TextRange getRangeInElement() {
            ASTNode sharp = PsiDocMethodOrFieldRef.this.findChildByType(JavaDocTokenType.DOC_TAG_VALUE_SHARP_TOKEN);
            if (sharp == null) {
                return new TextRange(0, PsiDocMethodOrFieldRef.this.getTextLength());
            }
            PsiElement nextSibling = SourceTreeToPsiMap.treeElementToPsi(sharp).getNextSibling();
            if (nextSibling != null) {
                int startOffset = nextSibling.getTextRange().getStartOffset() - PsiDocMethodOrFieldRef.this.getTextRange().getStartOffset();
                int endOffset = nextSibling.getTextRange().getEndOffset() - PsiDocMethodOrFieldRef.this.getTextRange().getStartOffset();
                PsiElement nextParSibling = nextSibling.getNextSibling();
                if (nextParSibling != null && "(".equals(nextParSibling.getText())) {
                    ++endOffset;
                    PsiElement nextElement = nextParSibling.getNextSibling();
                    if (nextElement != null && SourceTreeToPsiMap.psiElementToTree(nextElement).getElementType() == JavaDocTokenType.DOC_TAG_VALUE_TOKEN) {
                        endOffset += nextElement.getTextLength();
                        nextElement = nextElement.getNextSibling();
                    }
                    if (nextElement != null && ")".equals(nextElement.getText())) {
                        ++endOffset;
                    }
                }
                return new TextRange(startOffset, endOffset);
            }
            return new TextRange(PsiDocMethodOrFieldRef.this.getTextLength(), PsiDocMethodOrFieldRef.this.getTextLength());
        }

        public PsiElement getElement() {
            return PsiDocMethodOrFieldRef.this;
        }
    }
}

