/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.parsing;

import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.lexer.FilterLexer;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.LexerPosition;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.parsing.DeclarationParsing;
import com.intellij.psi.impl.source.parsing.JavaParsingContext;
import com.intellij.psi.impl.source.parsing.ParseUtil;
import com.intellij.psi.impl.source.parsing.Parsing;
import com.intellij.psi.impl.source.parsing.WhiteSpaceAndCommentsProcessor;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.StdTokenSets;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.util.CharTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileTextParsing
extends Parsing {
    public FileTextParsing(JavaParsingContext context) {
        super(context);
    }

    public static TreeElement parseFileText(PsiManager manager, Lexer lexer, CharSequence buffer, int startOffset, int endOffset, CharTable table) {
        return FileTextParsing.parseFileText(manager, lexer, buffer, startOffset, endOffset, false, table);
    }

    public static TreeElement parseFileText(PsiManager manager, @NotNull Lexer lexer, CharSequence buffer, int startOffset, int endOffset, boolean skipHeader, CharTable table) {
        if (lexer == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/parsing/FileTextParsing.parseFileText must not be null");
        }
        FilterLexer filterLexer = new FilterLexer(lexer, (FilterLexer.Filter)new FilterLexer.SetFilter(StdTokenSets.WHITE_SPACE_OR_COMMENT_BIT_SET));
        filterLexer.start(buffer, startOffset, endOffset);
        FileElement dummyRoot = DummyHolderFactory.createHolder(manager, null, table).getTreeElement();
        JavaParsingContext context = new JavaParsingContext(dummyRoot.getCharTable(), LanguageLevelProjectExtension.getInstance((Project)manager.getProject()).getLanguageLevel());
        if (!skipHeader) {
            TreeElement packageStatement = (TreeElement)context.getFileTextParsing().parsePackageStatement((Lexer)filterLexer);
            if (packageStatement != null) {
                dummyRoot.rawAddChildren(packageStatement);
            }
            TreeElement importList = (TreeElement)FileTextParsing.parseImportList((Lexer)filterLexer, context);
            dummyRoot.rawAddChildren(importList);
        }
        CompositeElement invalidElementsGroup = null;
        while (filterLexer.getTokenType() != null) {
            if (filterLexer.getTokenType() == JavaTokenType.SEMICOLON) {
                dummyRoot.rawAddChildren(ParseUtil.createTokenElement((Lexer)filterLexer, dummyRoot.getCharTable()));
                filterLexer.advance();
                invalidElementsGroup = null;
                continue;
            }
            TreeElement first = context.getDeclarationParsing().parseDeclaration((Lexer)filterLexer, DeclarationParsing.Context.FILE_CONTEXT);
            if (first != null) {
                dummyRoot.rawAddChildren(first);
                invalidElementsGroup = null;
                continue;
            }
            if (invalidElementsGroup == null) {
                invalidElementsGroup = Factory.createErrorElement(JavaErrorMessages.message("expected.class.or.interface", new Object[0]));
                dummyRoot.rawAddChildren(invalidElementsGroup);
            }
            invalidElementsGroup.rawAddChildren(ParseUtil.createTokenElement((Lexer)filterLexer, context.getCharTable()));
            filterLexer.advance();
        }
        ParseUtil.insertMissingTokens(dummyRoot, lexer, startOffset, endOffset, -1, WhiteSpaceAndCommentsProcessor.INSTANCE, context);
        return dummyRoot.getFirstChildNode();
    }

    public static ASTNode parseImportList(Lexer lexer, JavaParsingContext context) {
        CompositeElement importList = ASTFactory.composite(JavaElementType.IMPORT_LIST);
        if (lexer.getTokenType() == JavaTokenType.IMPORT_KEYWORD) {
            context.getImportsTextParsing().parseImportStatements(lexer, importList);
        }
        return importList;
    }

    @Nullable
    private ASTNode parsePackageStatement(Lexer lexer) {
        LexerPosition startPos = lexer.getCurrentPosition();
        CompositeElement packageStatement = ASTFactory.composite(JavaElementType.PACKAGE_STATEMENT);
        if (lexer.getTokenType() != JavaTokenType.PACKAGE_KEYWORD) {
            FilterLexer filterLexer = new FilterLexer(lexer, (FilterLexer.Filter)new FilterLexer.SetFilter(StdTokenSets.WHITE_SPACE_OR_COMMENT_BIT_SET));
            CompositeElement list = this.myContext.getDeclarationParsing().parseAnnotationList((Lexer)filterLexer, ASTFactory.composite(JavaElementType.MODIFIER_LIST));
            packageStatement.rawAddChildren(list);
            if (lexer.getTokenType() != JavaTokenType.PACKAGE_KEYWORD) {
                lexer.restore(startPos);
                return null;
            }
        }
        packageStatement.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
        lexer.advance();
        CompositeElement packageReference = this.parseJavaCodeReference(lexer, true, false, false);
        if (packageReference == null) {
            lexer.restore(startPos);
            return null;
        }
        packageStatement.rawAddChildren(packageReference);
        if (lexer.getTokenType() == JavaTokenType.SEMICOLON) {
            packageStatement.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
            lexer.advance();
        } else {
            packageStatement.rawAddChildren(Factory.createErrorElement(JavaErrorMessages.message("expected.semicolon", new Object[0])));
        }
        return packageStatement;
    }
}

