/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.scope.processor;

import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.scope.PsiConflictResolver;
import com.intellij.psi.scope.conflictResolvers.DuplicateConflictResolver;
import com.intellij.psi.scope.processor.MethodsProcessor;
import com.intellij.util.SmartList;

public class MethodCandidatesProcessor
extends MethodsProcessor {
    protected boolean myHasAccessibleStaticCorrectCandidate = false;

    public MethodCandidatesProcessor(PsiElement place, PsiConflictResolver[] resolvers, SmartList<CandidateInfo> container) {
        super(resolvers, container, place);
    }

    public MethodCandidatesProcessor(PsiElement place) {
        super(new PsiConflictResolver[]{DuplicateConflictResolver.INSTANCE}, (SmartList<CandidateInfo>)new SmartList(), place);
    }

    @Override
    public void add(PsiElement element, PsiSubstitutor substitutor) {
        if (element instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)element;
            this.addMethod(method, substitutor, this.isInStaticScope() && !method.hasModifierProperty("static"));
        }
    }

    public void addMethod(PsiMethod method, PsiSubstitutor substitutor, boolean staticProblem) {
        boolean isAccessible = JavaResolveUtil.isAccessible((PsiMember)method, method.getContainingClass(), method.getModifierList(), this.myPlace, this.myAccessClass, this.myCurrentFileContext);
        this.myHasAccessibleStaticCorrectCandidate |= isAccessible && !staticProblem;
        if (this.isAccepted(method)) {
            this.add((CandidateInfo)this.createCandidateInfo(method, substitutor, staticProblem, isAccessible));
        }
    }

    protected MethodCandidateInfo createCandidateInfo(PsiMethod method, PsiSubstitutor substitutor, boolean staticProblem, boolean accessible) {
        return new MethodCandidateInfo((PsiElement)method, substitutor, !accessible, staticProblem, (PsiElement)this.getArgumentList(), this.myCurrentFileContext, this.getArgumentList().getExpressionTypes(), this.getTypeArguments());
    }

    protected boolean isAccepted(PsiMethod candidate) {
        if (!this.isConstructor()) {
            return !candidate.isConstructor() && this.getName(ResolveState.initial()).equals(candidate.getName());
        }
        if (!candidate.isConstructor()) {
            return false;
        }
        if (this.myAccessClass == null) {
            return true;
        }
        if (this.myAccessClass instanceof PsiAnonymousClass) {
            return candidate.getContainingClass().equals(this.myAccessClass.getSuperClass());
        }
        return this.myAccessClass.equals(candidate.getContainingClass());
    }

    public CandidateInfo[] getCandidates() {
        JavaResolveResult[] resolveResult = this.getResult();
        CandidateInfo[] infos = new CandidateInfo[resolveResult.length];
        System.arraycopy(resolveResult, 0, infos, 0, resolveResult.length);
        return infos;
    }
}

