/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util.occurences;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.refactoring.util.occurences.OccurenceFilter;
import org.jetbrains.annotations.NonNls;

public abstract class NotInSuperOrThisCallFilterBase
implements OccurenceFilter {
    @Override
    public boolean isOK(PsiExpression occurence) {
        PsiElement parent = occurence.getParent();
        while (parent instanceof PsiExpression) {
            parent = parent.getParent();
        }
        if (!(parent instanceof PsiExpressionList)) {
            return true;
        }
        if (!((parent = parent.getParent()) instanceof PsiMethodCallExpression)) {
            return true;
        }
        String text = ((PsiMethodCallExpression)parent).getMethodExpression().getText();
        return !this.getKeywordText().equals(text);
    }

    @NonNls
    protected abstract String getKeywordText();
}

