/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.jetbrains.annotations.NonNls;

public class PendingEventDispatcher<T extends EventListener> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.PendingEventDispatcher");
    private final T myMulticaster;
    private final List<T> myListeners = new ArrayList<T>();
    private final Map<T, Boolean> myListenersState = new HashMap<T, Boolean>();
    private List<T> myCachedListeners = null;
    private final Stack<T> myDispatchingListeners = new Stack();
    private Method myCurrentDispatchMethod = null;
    private Object[] myCurrentDispatchArgs = null;
    private static int ourDispatchingEventsCounter = 0;
    private final boolean myAssertDispatchThread;

    public static <T extends EventListener> PendingEventDispatcher<T> create(Class<T> listenerClass) {
        return PendingEventDispatcher.create(listenerClass, true);
    }

    public static <T extends EventListener> PendingEventDispatcher<T> create(Class<T> listenerClass, boolean assertDispatchThread) {
        return new PendingEventDispatcher<T>(listenerClass, assertDispatchThread);
    }

    public static boolean isDispatchingAnyEvent() {
        return ourDispatchingEventsCounter > 0;
    }

    public boolean isDispatching() {
        return this.myCurrentDispatchMethod != null;
    }

    private PendingEventDispatcher(Class<T> listenerClass, boolean assertDispatchThread) {
        this.myAssertDispatchThread = assertDispatchThread;
        InvocationHandler handler = new InvocationHandler(){

            @Override
            @NonNls
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.getDeclaringClass().getName().equals("java.lang.Object")) {
                    String methodName = method.getName();
                    if (methodName.equals("toString")) {
                        return "Multicaster";
                    }
                    if (methodName.equals("hashCode")) {
                        return System.identityHashCode(proxy);
                    }
                    if (methodName.equals("equals")) {
                        return proxy == args[0] ? Boolean.TRUE : Boolean.FALSE;
                    }
                    LOG.error("Incorrect Object's method invoked for proxy:" + methodName);
                    return null;
                }
                PendingEventDispatcher.this.dispatch(method, args);
                return null;
            }
        };
        this.myMulticaster = (EventListener)Proxy.newProxyInstance(listenerClass.getClassLoader(), new Class[]{listenerClass}, handler);
    }

    public boolean hasListeners() {
        return !this.myListeners.isEmpty();
    }

    public T getMulticaster() {
        return this.myMulticaster;
    }

    public synchronized void addListener(T listener) {
        this.myListeners.add(listener);
        this.myListenersState.put(listener, Boolean.TRUE);
        this.myCachedListeners = null;
    }

    public synchronized void addListener(T listener, Disposable parentDisposable) {
        this.addListener(listener);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable((EventListener)listener){
            final /* synthetic */ EventListener val$listener;
            {
                this.val$listener = eventListener;
            }

            public void dispose() {
                PendingEventDispatcher.this.removeListener(this.val$listener);
            }
        });
    }

    public synchronized void removeListener(T listener) {
        this.myListeners.remove(listener);
        this.myListenersState.remove(listener);
        this.myCachedListeners = null;
    }

    public void dispatchPendingEvent(T listener) {
        Boolean dispatched = this.myListenersState.get(listener);
        if (dispatched == null) {
            return;
        }
        if (!dispatched.booleanValue()) {
            Application application = ApplicationManager.getApplication();
            if (application.isDispatchThread()) {
                this.invoke(listener);
            } else {
                return;
            }
        }
    }

    private void assertDispatchThread() {
        Application application = ApplicationManager.getApplication();
        if (this.myAssertDispatchThread && !application.isUnitTestMode()) {
            application.assertIsDispatchThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatch(Method method, Object[] args) {
        this.assertDispatchThread();
        if (this.myCurrentDispatchMethod != null) {
            LOG.error("Event cannot be raised when dispatching another event is in progress. Dispatching " + this.myCurrentDispatchMethod.getName());
        }
        method.setAccessible(true);
        ++ourDispatchingEventsCounter;
        this.myCurrentDispatchMethod = method;
        this.myCurrentDispatchArgs = args;
        try {
            int i;
            List<T> listeners = this.getListeners();
            for (i = 0; i < listeners.size(); ++i) {
                this.myListenersState.put(listeners.get(i), Boolean.FALSE);
            }
            for (i = 0; i < listeners.size(); ++i) {
                this.invoke((EventListener)listeners.get(i));
            }
        }
        finally {
            --ourDispatchingEventsCounter;
            this.myCurrentDispatchMethod = null;
            this.myCurrentDispatchArgs = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invoke(T listener) {
        Boolean state = this.myListenersState.get(listener);
        if (state == null || state.booleanValue()) {
            return;
        }
        this.myListenersState.put(listener, Boolean.TRUE);
        try {
            this.myDispatchingListeners.push(listener);
            this.myCurrentDispatchMethod.invoke(listener, this.myCurrentDispatchArgs);
        }
        catch (AbstractMethodError e) {
        }
        catch (InvocationTargetException e) {
            LOG.error(e.getCause());
        }
        catch (IllegalAccessException e) {
            LOG.error(e.getCause());
        }
        finally {
            this.myDispatchingListeners.pop();
        }
    }

    private void updateCachedListeners() {
        if (this.myCachedListeners == null) {
            this.myCachedListeners = new ArrayList<T>(this.myListeners);
        }
    }

    public List<T> getListeners() {
        this.updateCachedListeners();
        return this.myCachedListeners;
    }
}

