/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupValueFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.PomTarget;
import com.intellij.pom.references.PomService;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiTarget;
import com.intellij.psi.impl.PomTargetPsiElementImpl;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomTarget;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.ElementPresentationManager;
import com.intellij.util.xml.EnumConverter;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.MergedObject;
import com.intellij.util.xml.ResolvingConverter;
import com.intellij.util.xml.WrappingConverter;
import com.intellij.util.xml.impl.ConvertContextImpl;
import com.intellij.util.xml.impl.DomCompletionContributor;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.xml.util.XmlTagUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenericDomValueReference<T>
extends PsiReferenceBase<XmlElement>
implements EmptyResolveMessageProvider {
    private final GenericDomValue<T> myGenericValue;

    public GenericDomValueReference(GenericDomValue<T> domValue) {
        super((PsiElement)DomUtil.getValueElement(domValue));
        this.myGenericValue = domValue;
        assert (DomUtil.hasXml(domValue));
        this.setRangeInElement(this.createTextRange());
    }

    protected final PsiManager getPsiManager() {
        return PsiManager.getInstance((Project)this.myGenericValue.getManager().getProject());
    }

    protected TextRange createTextRange() {
        if (this.myGenericValue instanceof GenericAttributeValue) {
            GenericAttributeValue genericAttributeValue = (GenericAttributeValue)this.myGenericValue;
            XmlAttributeValue attributeValue = genericAttributeValue.getXmlAttributeValue();
            if (attributeValue == null) {
                return TextRange.from((int)0, (int)genericAttributeValue.getXmlAttribute().getTextLength());
            }
            int length = attributeValue.getTextLength();
            return length < 2 ? TextRange.from((int)0, (int)length) : new TextRange(1, length - 1);
        }
        XmlTag tag = this.myGenericValue.getXmlTag();
        assert (tag != null);
        return XmlTagUtil.getTrimmedValueRange((XmlTag)tag);
    }

    protected final GenericDomValue<T> getGenericValue() {
        return this.myGenericValue;
    }

    public boolean isSoft() {
        return true;
    }

    @Nullable
    protected PsiElement resolveInner(T o) {
        Converter<T> converter = this.getConverter();
        if (converter instanceof ResolvingConverter) {
            return ((ResolvingConverter)converter).resolve(o, (ConvertContext)this.getConvertContext());
        }
        if (o instanceof PsiElement) {
            return (PsiElement)o;
        }
        if (o instanceof DomElement) {
            DomTarget target = DomTarget.getTarget((DomElement)((DomElement)o));
            return target == null ? null : PomService.convertToPsi((PsiTarget)target);
        }
        if (o instanceof MergedObject) {
            List list = ((MergedObject)o).getImplementations();
            for (Object o1 : list) {
                PsiElement psiElement = this.resolveInner(o1);
                if (psiElement == null) continue;
                return psiElement;
            }
        }
        return o != null ? (XmlElement)this.getElement() : null;
    }

    public boolean isReferenceTo(PsiElement element) {
        Converter<T> converter = this.getConverter();
        if (converter instanceof ResolvingConverter) {
            PomTarget target;
            Object value = this.myGenericValue.getValue();
            if (value instanceof DomElement && element instanceof PomTargetPsiElementImpl && (target = ((PomTargetPsiElementImpl)element).getTarget()) instanceof DomTarget && value.equals(((DomTarget)target).getDomElement())) {
                return true;
            }
            return ((ResolvingConverter)converter).isReferenceTo(element, this.getStringValue(), value, (ConvertContext)this.getConvertContext());
        }
        return super.isReferenceTo(element);
    }

    private String getStringValue() {
        return this.myGenericValue.getStringValue();
    }

    public Converter<T> getConverter() {
        return WrappingConverter.getDeepestConverter((Converter)this.myGenericValue.getConverter(), this.myGenericValue);
    }

    @Nullable
    public PsiElement resolve() {
        Object value = this.myGenericValue.getValue();
        return value == null ? null : this.resolveInner(value);
    }

    public String getCanonicalText() {
        return this.getStringValue();
    }

    public String getUnresolvedMessagePattern() {
        ConvertContextImpl context = this.getConvertContext();
        return this.getConverter().getErrorMessage(this.getStringValue(), (ConvertContext)context);
    }

    public final ConvertContextImpl getConvertContext() {
        return new ConvertContextImpl(DomManagerImpl.getDomInvocationHandler(this.myGenericValue));
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        Converter<T> converter = this.getConverter();
        if (converter instanceof ResolvingConverter) {
            ((ResolvingConverter)converter).handleElementRename(this.myGenericValue, (ConvertContext)this.getConvertContext(), newElementName);
            return this.myGenericValue.getXmlTag();
        }
        return super.handleElementRename(newElementName);
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/impl/GenericDomValueReference.bindToElement must not be null");
        }
        Converter<T> converter = this.getConverter();
        if (converter instanceof ResolvingConverter) {
            ((ResolvingConverter)converter).bindReference(this.myGenericValue, (ConvertContext)this.getConvertContext(), element);
            return this.myGenericValue.getXmlTag();
        }
        if (element instanceof XmlTag) {
            DomElement domElement = this.myGenericValue.getManager().getDomElement((XmlTag)element);
            if (domElement != null) {
                this.myGenericValue.setValue((Object)domElement);
            } else {
                this.myGenericValue.setStringValue(((XmlTag)element).getName());
            }
            return this.myGenericValue.getXmlTag();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Object[] getVariants() {
        Object[] objectArray;
        Converter<T> converter = this.getConverter();
        if ((converter instanceof EnumConverter || converter == ResolvingConverter.BOOLEAN_CONVERTER) && DomCompletionContributor.isSchemaEnumerated(this.getElement())) {
            objectArray = ArrayUtil.EMPTY_OBJECT_ARRAY;
            if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/util/xml/impl/GenericDomValueReference.getVariants must not return null");
            return objectArray;
        } else if (!(converter instanceof ResolvingConverter)) {
            objectArray = ArrayUtil.EMPTY_OBJECT_ARRAY;
            if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/util/xml/impl/GenericDomValueReference.getVariants must not return null");
            return objectArray;
        } else {
            ResolvingConverter resolvingConverter = (ResolvingConverter)converter;
            ArrayList<Object> result = new ArrayList<Object>();
            ConvertContextImpl convertContext = this.getConvertContext();
            for (Object variant : resolvingConverter.getVariants((ConvertContext)convertContext)) {
                LookupElement lookupElement = resolvingConverter.createLookupElement(variant);
                if (lookupElement != null) {
                    result.add(lookupElement);
                    continue;
                }
                String name = converter.toString(variant, (ConvertContext)convertContext);
                if (name == null) continue;
                result.add(ElementPresentationManager.getInstance().createVariant(variant, name, ((ResolvingConverter)converter).getPsiElement(variant)));
            }
            for (String string : resolvingConverter.getAdditionalVariants((ConvertContext)convertContext)) {
                result.add(LookupValueFactory.createLookupValue(string, null));
            }
            objectArray = result.toArray();
            if (objectArray == null) throw new IllegalStateException("@NotNull method com/intellij/util/xml/impl/GenericDomValueReference.getVariants must not return null");
            return objectArray;
        }
    }
}

