/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.indices;

import com.intellij.openapi.util.text.StringUtil;
import org.apache.maven.archetype.catalog.Archetype;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArchetypeInfo {
    public final String groupId;
    public final String artifactId;
    public final String version;
    public final String repository;
    public final String description;

    public ArchetypeInfo(Archetype archetype) {
        this(archetype.getGroupId(), archetype.getArtifactId(), archetype.getVersion(), archetype.getRepository(), archetype.getDescription());
    }

    public ArchetypeInfo(@NotNull String groupId, @NotNull String artifactId, @NotNull String version, @Nullable String repository, @Nullable String description) {
        if (groupId == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/maven/indices/ArchetypeInfo.<init> must not be null");
        }
        if (artifactId == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/idea/maven/indices/ArchetypeInfo.<init> must not be null");
        }
        if (version == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/jetbrains/idea/maven/indices/ArchetypeInfo.<init> must not be null");
        }
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.repository = StringUtil.isEmptyOrSpaces((String)repository) ? null : repository;
        this.description = StringUtil.isEmptyOrSpaces((String)description) ? null : description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArchetypeInfo that = (ArchetypeInfo)o;
        if (this.groupId != null ? !this.groupId.equals(that.groupId) : that.groupId != null) {
            return false;
        }
        if (this.artifactId != null ? !this.artifactId.equals(that.artifactId) : that.artifactId != null) {
            return false;
        }
        return !(this.version != null ? !this.version.equals(that.version) : that.version != null);
    }

    public int hashCode() {
        int result = this.groupId != null ? this.groupId.hashCode() : 0;
        result = 31 * result + (this.artifactId != null ? this.artifactId.hashCode() : 0);
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        return result;
    }
}

