/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import java.io.Serializable;
import java.util.List;
import org.jetbrains.idea.maven.project.MavenArtifact;

public class MavenArtifactNode
implements Serializable {
    private MavenArtifact myArtifact;
    private List<MavenArtifactNode> myDependencies;

    protected MavenArtifactNode() {
    }

    public MavenArtifactNode(MavenArtifact artifact, List<MavenArtifactNode> dependencies) {
        this.myArtifact = artifact;
        this.myDependencies = dependencies;
    }

    public MavenArtifact getArtifact() {
        return this.myArtifact;
    }

    public List<MavenArtifactNode> getDependencies() {
        return this.myDependencies;
    }

    public String toString() {
        return this.myArtifact.getDisplayStringWithTypeAndClassifier() + "->(" + MavenArtifactNode.formatNodesList(this.myDependencies) + ")";
    }

    public static String formatNodesList(List<MavenArtifactNode> nodes) {
        return StringUtil.join(nodes, (Function)new Function<MavenArtifactNode, String>(){

            public String fun(MavenArtifactNode each) {
                return each.toString();
            }
        }, (String)",");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MavenArtifactNode that = (MavenArtifactNode)o;
        if (!this.myArtifact.equals(that.myArtifact)) {
            return false;
        }
        return ((Object)this.myDependencies).equals(that.myDependencies);
    }

    public int hashCode() {
        int result = this.myArtifact.hashCode();
        result = 31 * result + ((Object)this.myDependencies).hashCode();
        return result;
    }
}

