/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.execution.Location;
import com.intellij.execution.RunConfigurationExtension;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.junit.JUnitConfigurationProducer;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import java.util.Iterator;

public class TestMethodConfigurationProducer
extends JUnitConfigurationProducer {
    private Location<PsiMethod> myMethodLocation;

    protected RunnerAndConfigurationSettingsImpl createConfigurationByElement(Location location, ConfigurationContext context) {
        Project project = location.getProject();
        this.myMethodLocation = TestMethodConfigurationProducer.getTestMethod(location);
        if (this.myMethodLocation == null) {
            return null;
        }
        RunnerAndConfigurationSettingsImpl settings = this.cloneTemplateConfiguration(project, context);
        JUnitConfiguration configuration = (JUnitConfiguration)settings.getConfiguration();
        this.setupConfigurationModule(context, configuration);
        Module originalModule = ((JavaRunConfigurationModule)configuration.getConfigurationModule()).getModule();
        configuration.beMethodConfiguration(this.myMethodLocation);
        configuration.restoreOriginalModule(originalModule);
        RunConfigurationExtension.patchCreatedConfiguration((ModuleBasedConfiguration)configuration);
        this.copyStepsBeforeRun(project, (RunConfiguration)configuration);
        return settings;
    }

    public PsiElement getSourceElement() {
        return this.myMethodLocation.getPsiElement();
    }

    private static Location<PsiMethod> getTestMethod(Location<?> location) {
        Iterator iterator = location.getAncestors(PsiMethod.class, false);
        while (iterator.hasNext()) {
            Location methodLocation = (Location)iterator.next();
            if (!JUnitUtil.isTestMethod((Location)methodLocation)) continue;
            return methodLocation;
        }
        return null;
    }
}

