/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.DiffContentUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class FileContent
extends DiffContent {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.diff.FileContent");
    private final VirtualFile myFile;
    private Document myDocument;
    private final Project myProject;

    public FileContent(Project project, @NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/diff/FileContent.<init> must not be null");
        }
        this.myProject = project;
        this.myFile = file;
    }

    @Override
    public Document getDocument() {
        if (this.myDocument == null && DiffContentUtil.isTextFile(this.myFile)) {
            this.myDocument = FileDocumentManager.getInstance().getDocument(this.myFile);
        }
        return this.myDocument;
    }

    @Override
    public OpenFileDescriptor getOpenFileDescriptor(int offset) {
        return new OpenFileDescriptor(this.myProject, this.myFile, offset);
    }

    @Override
    public VirtualFile getFile() {
        return this.myFile;
    }

    @Override
    public FileType getContentType() {
        return DiffContentUtil.getContentType(this.myFile);
    }

    @Override
    public byte[] getBytes() throws IOException {
        if (this.myFile.isDirectory()) {
            return null;
        }
        return this.myFile.contentsToByteArray();
    }

    @Override
    public boolean isBinary() {
        if (this.myFile.isDirectory()) {
            return false;
        }
        return FileTypeManager.getInstance().getFileTypeByFile(this.myFile).isBinary();
    }
}

