/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VirtualFileWrapper {
    private final File myFile;

    public VirtualFileWrapper(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/VirtualFileWrapper.<init> must not be null");
        }
        this.myFile = file;
    }

    public boolean exists() {
        return this.myFile.exists();
    }

    @Nullable
    public VirtualFile getVirtualFile() {
        return LocalFileSystem.getInstance().refreshAndFindFileByIoFile(this.myFile);
    }

    @Nullable
    public VirtualFile getVirtualFile(boolean createIfNotExist) {
        if (createIfNotExist && !this.myFile.exists()) {
            try {
                if (!this.myFile.createNewFile()) {
                    return null;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.getVirtualFile();
    }

    @NotNull
    public File getFile() {
        File file = this.myFile;
        if (file == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/VirtualFileWrapper.getFile must not return null");
        }
        return file;
    }
}

