/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.stubs.SerializationManager;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubElementTypeHolderEP;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.stubs.StubSerializer;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.PersistentStringEnumerator;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public class SerializationManagerImpl
extends SerializationManager
implements ApplicationComponent {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.stubs.SerializationManagerImpl");
    private PersistentStringEnumerator myNameStorage;
    private final Map<Integer, StubSerializer<? extends StubElement>> myIdToSerializer = new HashMap<Integer, StubSerializer<? extends StubElement>>();
    private final Map<StubSerializer<? extends StubElement>, Integer> mySerializerToId = new HashMap<StubSerializer<? extends StubElement>, Integer>();
    private final List<StubSerializer<? extends StubElement>> myAllSerializers = new ArrayList<StubSerializer<? extends StubElement>>();
    private final AtomicBoolean myNameStorageCrashed = new AtomicBoolean(false);
    private final File myFile = new File(PathManager.getSystemPath() + "/index/rep.names");
    private boolean mySerializersLoaded = false;

    public SerializationManagerImpl() {
        this.myFile.getParentFile().mkdirs();
        try {
            this.myNameStorage = new PersistentStringEnumerator(this.myFile);
        }
        catch (IOException e) {
            this.myNameStorageCrashed.set(true);
            LOG.info((Throwable)e);
            this.repairNameStorage();
            this.myNameStorageCrashed.set(true);
        }
        this.registerSerializer(PsiFileStubImpl.TYPE);
    }

    @Override
    public boolean isNameStorageCorrupted() {
        return this.myNameStorageCrashed.get();
    }

    @Override
    public void repairNameStorage() {
        if (this.myNameStorageCrashed.getAndSet(false)) {
            try {
                File[] files;
                if (this.myNameStorage != null) {
                    this.myNameStorage.close();
                }
                if ((files = this.myFile.getParentFile().listFiles()) != null) {
                    for (File file : files) {
                        if (!file.getName().startsWith(this.myFile.getName())) continue;
                        FileUtil.delete((File)file);
                    }
                }
                this.myNameStorage = new PersistentStringEnumerator(this.myFile);
                this.mySerializerToId.clear();
                this.myIdToSerializer.clear();
                for (StubSerializer<? extends StubElement> serializer : this.myAllSerializers) {
                    this.assignId(serializer);
                }
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
                this.myNameStorageCrashed.set(true);
            }
        }
    }

    @Override
    public void registerSerializer(@NotNull StubSerializer<? extends StubElement> serializer) {
        if (serializer == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/stubs/SerializationManagerImpl.registerSerializer must not be null");
        }
        this.myAllSerializers.add(serializer);
        try {
            this.assignId(serializer);
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            this.myNameStorageCrashed.set(true);
        }
    }

    private void assignId(@NotNull StubSerializer<? extends StubElement> serializer) throws IOException {
        if (serializer == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/stubs/SerializationManagerImpl.assignId must not be null");
        }
        int id = this.persistentId(serializer);
        StubSerializer<? extends StubElement> old = this.myIdToSerializer.put(id, serializer);
        assert (old == null) : "ID: " + serializer.getExternalId() + " is not unique; Already registered serializer with this ID: " + old.getClass().getName();
        Integer oldId = this.mySerializerToId.put(serializer, id);
        assert (oldId == null) : "Serializer " + serializer + " is already registered; Old ID:" + oldId;
    }

    private int persistentId(@NotNull StubSerializer<? extends StubElement> serializer) throws IOException {
        if (serializer == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/stubs/SerializationManagerImpl.persistentId must not be null");
        }
        return this.myNameStorage.enumerate((Object)serializer.getExternalId());
    }

    private synchronized void initSerializers() {
        IElementType[] stubElementTypes;
        if (this.mySerializersLoaded) {
            return;
        }
        this.mySerializersLoaded = true;
        for (StubElementTypeHolderEP holderEP : (StubElementTypeHolderEP[])Extensions.getExtensions(StubElementTypeHolderEP.EP_NAME)) {
            holderEP.initialize();
        }
        for (IElementType type : stubElementTypes = IElementType.enumerate(new IElementType.Predicate(){

            @Override
            public boolean matches(IElementType type) {
                return type instanceof StubSerializer;
            }
        })) {
            StubSerializer stubSerializer;
            if (type instanceof IStubFileElementType && ((IStubFileElementType)type).getExternalId().equals(PsiFileStubImpl.TYPE.getExternalId()) || this.myAllSerializers.contains(stubSerializer = (StubSerializer)((Object)type))) continue;
            this.registerSerializer(stubSerializer);
        }
    }

    @Override
    public void serialize(StubElement rootStub, OutputStream stream) {
        StubOutputStream stubOutputStream = new StubOutputStream(stream, this.myNameStorage);
        this.doSerialize(rootStub, stubOutputStream);
    }

    private void doSerialize(StubElement rootStub, StubOutputStream stream) {
        this.initSerializers();
        try {
            StubSerializer serializer = this.getSerializer(rootStub);
            DataInputOutputUtil.writeINT((DataOutput)stream, (int)this.getClassId(serializer));
            serializer.serialize(rootStub, stream);
            List<StubElement> children = rootStub.getChildrenStubs();
            DataInputOutputUtil.writeINT((DataOutput)stream, (int)children.size());
            for (StubElement child : children) {
                this.doSerialize(child, stream);
            }
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            this.myNameStorageCrashed.set(true);
        }
    }

    @Override
    public StubSerializer getSerializer(StubElement rootStub) {
        if (rootStub instanceof PsiFileStub) {
            PsiFileStub fileStub = (PsiFileStub)rootStub;
            return fileStub.getType();
        }
        return rootStub.getStubType();
    }

    @Override
    public StubElement deserialize(InputStream stream) {
        StubInputStream inputStream = new StubInputStream(stream, this.myNameStorage);
        this.initSerializers();
        try {
            return this.deserialize(inputStream, null);
        }
        catch (IOException e) {
            this.myNameStorageCrashed.set(true);
            LOG.info((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private StubElement deserialize(StubInputStream stream, StubElement parentStub) throws IOException {
        int id = DataInputOutputUtil.readINT((DataInput)stream);
        StubSerializer serializer = this.getClassById(id);
        assert (serializer != null) : "No serializer registered for stub: ID=" + id + "; parent stub class=" + (parentStub != null ? parentStub.getClass().getName() : "null");
        Object stub = serializer.deserialize(stream, parentStub);
        int childCount = DataInputOutputUtil.readINT((DataInput)stream);
        for (int i = 0; i < childCount; ++i) {
            this.deserialize(stream, (StubElement)stub);
        }
        return stub;
    }

    private int getClassId(StubSerializer serializer) {
        Integer idValue = this.mySerializerToId.get(serializer);
        assert (idValue != null) : "No ID found for serializer " + serializer;
        return idValue;
    }

    private StubSerializer getClassById(int id) {
        return this.myIdToSerializer.get(id);
    }

    @Override
    @NotNull
    public String getComponentName() {
        if ("PSI.SerializationManager" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/stubs/SerializationManagerImpl.getComponentName must not return null");
        }
        return "PSI.SerializationManager";
    }

    @Override
    public void initComponent() {
    }

    @Override
    public void disposeComponent() {
        try {
            this.myNameStorage.close();
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }
}

