/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.fixtures.LightCodeInsightFixtureTestCase;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;

public abstract class InjectedLanguageFixtureTestCase
extends LightCodeInsightFixtureTestCase {
    protected void checkCompletionVariants(FileType fileType, String text, String ... strings) throws Throwable {
        this.myFixture.configureByText(fileType, text.replaceAll("\\|", "<caret>"));
        this.tuneCompletionFile(this.myFixture.getFile());
        LookupElement[] elements = this.myFixture.completeBasic();
        InjectedLanguageFixtureTestCase.assertNotNull((Object)elements);
        this.myFixture.checkResult(text.replaceAll("\\|", "<caret>"));
        InjectedLanguageFixtureTestCase.assertSameElements((Collection)ContainerUtil.map((Object[])elements, (Function)new Function<LookupElement, String>(){

            public String fun(LookupElement lookupItem) {
                return lookupItem.getLookupString();
            }
        }), (Object[])strings);
    }

    protected void assertNoVariants(FileType fileType, String text) throws Throwable {
        this.checkCompleted(fileType, text, text);
    }

    protected void checkCompleted(FileType fileType, String text, String resultText) throws Throwable {
        this.myFixture.configureByText(fileType, text.replaceAll("\\|", "<caret>"));
        this.tuneCompletionFile(this.myFixture.getFile());
        LookupElement[] elements = this.myFixture.completeBasic();
        if (elements != null && elements.length == 1) {
            new WriteCommandAction(this.getProject(), new PsiFile[0]){

                @Override
                protected void run(Result result) throws Throwable {
                    ((LookupImpl)LookupManager.getInstance((Project)this.getProject()).getActiveLookup()).finishLookup('\n');
                }
            }.execute();
        } else if (elements != null && elements.length > 0) {
            InjectedLanguageFixtureTestCase.fail((String)Arrays.toString((Object[])elements));
        }
        this.myFixture.checkResult(resultText.replaceAll("\\|", "<caret>"));
        FileDocumentManager.getInstance().saveDocument(this.myFixture.getDocument(this.myFixture.getFile()));
    }

    protected void tuneCompletionFile(PsiFile file) {
    }
}

