/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RandomDoubleForRandomIntegerInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("UsingRandomNextDoubleForRandomInteger" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/performance/RandomDoubleForRandomIntegerInspection.getID must not return null");
        }
        return "UsingRandomNextDoubleForRandomInteger";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("random.double.for.random.integer.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/performance/RandomDoubleForRandomIntegerInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("random.double.for.random.integer.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/performance/RandomDoubleForRandomIntegerInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new RandomDoubleForRandomIntegerFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new StringEqualsEmptyStringVisitor();
    }

    @Nullable
    static PsiExpression getContainingExpression(PsiExpression expression) {
        PsiElement ancestor = expression.getParent();
        while (ancestor != null) {
            if (!(ancestor instanceof PsiExpression)) {
                return null;
            }
            if (!(ancestor instanceof PsiParenthesizedExpression)) {
                return (PsiExpression)ancestor;
            }
            ancestor = ancestor.getParent();
        }
        return null;
    }

    private static class StringEqualsEmptyStringVisitor
    extends BaseInspectionVisitor {
        private StringEqualsEmptyStringVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
            if (call == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/performance/RandomDoubleForRandomIntegerInspection$StringEqualsEmptyStringVisitor.visitMethodCallExpression must not be null");
            }
            super.visitMethodCallExpression(call);
            PsiReferenceExpression methodExpression = call.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            String nextDouble = "nextDouble";
            if (!"nextDouble".equals(methodName)) {
                return;
            }
            PsiMethod method = call.resolveMethod();
            if (method == null) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            String className = containingClass.getQualifiedName();
            if (!"java.util.Random".equals(className)) {
                return;
            }
            PsiExpression possibleMultiplierExpression = RandomDoubleForRandomIntegerInspection.getContainingExpression((PsiExpression)call);
            if (!StringEqualsEmptyStringVisitor.isMultiplier(possibleMultiplierExpression)) {
                return;
            }
            PsiExpression possibleIntCastExpression = RandomDoubleForRandomIntegerInspection.getContainingExpression(possibleMultiplierExpression);
            if (!StringEqualsEmptyStringVisitor.isIntCast(possibleIntCastExpression)) {
                return;
            }
            this.registerMethodCallError(call, new Object[0]);
        }

        private static boolean isMultiplier(PsiExpression expression) {
            if (expression == null) {
                return false;
            }
            if (!(expression instanceof PsiBinaryExpression)) {
                return false;
            }
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression;
            PsiJavaToken sign = binaryExpression.getOperationSign();
            IElementType tokenType = sign.getTokenType();
            return JavaTokenType.ASTERISK.equals(tokenType);
        }

        private static boolean isIntCast(PsiExpression expression) {
            if (expression == null) {
                return false;
            }
            if (!(expression instanceof PsiTypeCastExpression)) {
                return false;
            }
            PsiTypeCastExpression castExpression = (PsiTypeCastExpression)expression;
            PsiType type = castExpression.getType();
            return PsiType.INT.equals(type);
        }
    }

    private static class RandomDoubleForRandomIntegerFix
    extends InspectionGadgetsFix {
        private RandomDoubleForRandomIntegerFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("random.double.for.random.integer.replace.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/performance/RandomDoubleForRandomIntegerInspection$RandomDoubleForRandomIntegerFix.getName must not return null");
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiIdentifier name = (PsiIdentifier)descriptor.getPsiElement();
            PsiReferenceExpression expression = (PsiReferenceExpression)name.getParent();
            if (expression == null) {
                return;
            }
            PsiExpression call = (PsiExpression)expression.getParent();
            PsiExpression qualifier = expression.getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            String qualifierText = qualifier.getText();
            PsiBinaryExpression multiplication = (PsiBinaryExpression)RandomDoubleForRandomIntegerInspection.getContainingExpression(call);
            if (multiplication == null) {
                return;
            }
            PsiExpression cast = RandomDoubleForRandomIntegerInspection.getContainingExpression((PsiExpression)multiplication);
            if (cast == null) {
                return;
            }
            PsiExpression lhs = multiplication.getLOperand();
            PsiExpression strippedLhs = ParenthesesUtils.stripParentheses(lhs);
            PsiExpression multiplierExpression = call.equals(strippedLhs) ? multiplication.getROperand() : lhs;
            assert (multiplierExpression != null);
            String multiplierText = multiplierExpression.getText();
            String nextInt = ".nextInt((int) ";
            RandomDoubleForRandomIntegerFix.replaceExpression(cast, qualifierText + ".nextInt((int) " + multiplierText + ')');
        }
    }
}

