/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class StringConcatenationInsideStringBufferAppendInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("string.concatenation.inside.string.buffer.append.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/performance/StringConcatenationInsideStringBufferAppendInspection.getDisplayName must not return null");
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiClass aClass = (PsiClass)infos[0];
        String className = aClass.getName();
        String string = InspectionGadgetsBundle.message("string.concatenation.inside.string.buffer.append.problem.descriptor", className);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/performance/StringConcatenationInsideStringBufferAppendInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new StringConcatenationInsideStringBufferAppendVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new ReplaceWithChainedAppendFix();
    }

    private static class StringConcatenationInsideStringBufferAppendVisitor
    extends BaseInspectionVisitor {
        private StringConcatenationInsideStringBufferAppendVisitor() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"append".equals(methodName)) {
                return;
            }
            PsiExpressionList argumentList = expression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return;
            }
            PsiExpression argument = arguments[0];
            if (!StringConcatenationInsideStringBufferAppendVisitor.isConcatenation(argument)) {
                return;
            }
            PsiMethod method = expression.resolveMethod();
            if (method == null) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            String className = containingClass.getQualifiedName();
            if ("java.lang.StringBuffer".equals(className) || "java.lang.StringBuilder".equals(className)) {
                this.registerMethodCallError(expression, containingClass);
                return;
            }
            PsiManager manager = containingClass.getManager();
            Project project = containingClass.getProject();
            PsiClass appendableClass = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass("java.lang.Appendable", GlobalSearchScope.allScope((Project)project));
            if (appendableClass == null) {
                return;
            }
            if (!containingClass.isInheritor(appendableClass, true)) {
                return;
            }
            this.registerMethodCallError(expression, containingClass);
        }

        private static boolean isConcatenation(PsiExpression expression) {
            if (!(expression instanceof PsiBinaryExpression)) {
                return false;
            }
            if (PsiUtil.isConstantExpression((PsiExpression)expression)) {
                return false;
            }
            PsiType type = expression.getType();
            if (type == null) {
                return false;
            }
            return type.equalsToText("java.lang.String");
        }
    }

    private static class ReplaceWithChainedAppendFix
    extends InspectionGadgetsFix {
        private ReplaceWithChainedAppendFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("string.concatenation.inside.string.buffer.append.replace.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/performance/StringConcatenationInsideStringBufferAppendInspection$ReplaceWithChainedAppendFix.getName must not return null");
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiClass containingClass;
            String qualifiedName;
            PsiElement methodNameElement = descriptor.getPsiElement();
            PsiReferenceExpression methodExpression = (PsiReferenceExpression)methodNameElement.getParent();
            if (methodExpression == null) {
                return;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)methodExpression.getParent();
            if (methodCallExpression == null) {
                return;
            }
            PsiExpressionList argumentList = methodCallExpression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            PsiExpression argument = arguments[0];
            PsiMethod method = methodCallExpression.resolveMethod();
            boolean useStringValueOf = method == null ? false : ((qualifiedName = (containingClass = method.getContainingClass()).getQualifiedName()) == null ? false : !qualifiedName.equals("java.lang.StringBuffer") && !qualifiedName.equals("java.lang.StringBuilder"));
            List<String> expressions = ReplaceWithChainedAppendFix.findConcatenationComponents(argument, useStringValueOf);
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            StringBuffer newExpressionBuffer = new StringBuffer();
            newExpressionBuffer.append(qualifier.getText());
            for (String expression : expressions) {
                newExpressionBuffer.append(".append(");
                newExpressionBuffer.append(expression);
                newExpressionBuffer.append(')');
            }
            String newExpression = newExpressionBuffer.toString();
            ReplaceWithChainedAppendFix.replaceExpression((PsiExpression)methodCallExpression, newExpression);
        }

        private static List<String> findConcatenationComponents(PsiExpression concatenation, boolean useStringValueOf) throws IncorrectOperationException {
            ArrayList<String> out = new ArrayList<String>();
            ReplaceWithChainedAppendFix.findConcatenationComponents(concatenation, out, useStringValueOf);
            return out;
        }

        private static void findConcatenationComponents(PsiExpression concatenation, @NonNls List<String> out, boolean useStringValueOf) throws IncorrectOperationException {
            PsiType type = concatenation.getType();
            if (concatenation instanceof PsiBinaryExpression) {
                if (type != null && type.equalsToText("java.lang.String")) {
                    PsiType lhsType;
                    PsiBinaryExpression binaryExpression = (PsiBinaryExpression)concatenation;
                    PsiExpression lhs = binaryExpression.getLOperand();
                    PsiExpression rhs = binaryExpression.getROperand();
                    assert (rhs != null);
                    if (!PsiUtil.isConstantExpression((PsiExpression)rhs)) {
                        ReplaceWithChainedAppendFix.findConcatenationComponents(lhs, out, useStringValueOf);
                        ReplaceWithChainedAppendFix.findConcatenationComponents(rhs, out, useStringValueOf);
                        return;
                    }
                    StringBuffer builder = new StringBuffer(rhs.getText());
                    while (lhs instanceof PsiBinaryExpression && (lhsType = lhs.getType()) != null && lhsType.equalsToText("java.lang.String")) {
                        binaryExpression = (PsiBinaryExpression)lhs;
                        rhs = binaryExpression.getROperand();
                        assert (rhs != null);
                        if (!PsiUtil.isConstantExpression((PsiExpression)rhs)) {
                            ReplaceWithChainedAppendFix.findConcatenationComponents(lhs, out, useStringValueOf);
                            out.add(builder.toString());
                            return;
                        }
                        lhs = binaryExpression.getLOperand();
                        builder.insert(0, " + ");
                        builder.insert(0, rhs.getText());
                    }
                    if (PsiUtil.isConstantExpression((PsiExpression)lhs)) {
                        builder.insert(0, " + ");
                        builder.insert(0, lhs.getText());
                        out.add(builder.toString());
                    } else {
                        ReplaceWithChainedAppendFix.findConcatenationComponents(lhs, out, useStringValueOf);
                        out.add(builder.toString());
                    }
                    return;
                }
            } else if (concatenation instanceof PsiParenthesizedExpression) {
                PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)concatenation;
                PsiExpression expression = parenthesizedExpression.getExpression();
                if (expression != null) {
                    out.add(expression.getText());
                }
                return;
            }
            if (useStringValueOf && type != null && !type.equalsToText("java.lang.String")) {
                out.add("String.valueOf(" + concatenation.getText() + ')');
            } else {
                out.add(concatenation.getText());
            }
        }
    }
}

