/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.portability;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ClassUtils;
import org.jetbrains.annotations.NotNull;

public class UseOfJDBCDriverClassInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("use.of.concrete.jdbc.driver.class.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/portability/UseOfJDBCDriverClassInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("use.of.concrete.jdbc.driver.class.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/portability/UseOfJDBCDriverClassInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UseOfJDBCDriverClassVisitor();
    }

    private static class UseOfJDBCDriverClassVisitor
    extends BaseInspectionVisitor {
        private UseOfJDBCDriverClassVisitor() {
        }

        public void visitVariable(@NotNull PsiVariable variable) {
            if (variable == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/portability/UseOfJDBCDriverClassInspection$UseOfJDBCDriverClassVisitor.visitVariable must not be null");
            }
            super.visitVariable(variable);
            PsiType type = variable.getType();
            if (!(type instanceof PsiClassType)) {
                return;
            }
            PsiType deepComponentType = type.getDeepComponentType();
            if (!(deepComponentType instanceof PsiClassType)) {
                return;
            }
            PsiClassType classType = (PsiClassType)deepComponentType;
            PsiClass resolveClass = classType.resolve();
            if (resolveClass == null) {
                return;
            }
            if (resolveClass.isEnum() || resolveClass.isInterface() || resolveClass.isAnnotationType()) {
                return;
            }
            if (resolveClass instanceof PsiTypeParameter) {
                return;
            }
            if (!ClassUtils.isSubclass(resolveClass, "java.sql.Driver")) {
                return;
            }
            PsiTypeElement typeElement = variable.getTypeElement();
            if (typeElement == null) {
                return;
            }
            this.registerError((PsiElement)typeElement, new Object[0]);
        }

        public void visitNewExpression(@NotNull PsiNewExpression newExpression) {
            if (newExpression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/portability/UseOfJDBCDriverClassInspection$UseOfJDBCDriverClassVisitor.visitNewExpression must not be null");
            }
            super.visitNewExpression(newExpression);
            PsiType type = newExpression.getType();
            if (type == null) {
                return;
            }
            if (!(type instanceof PsiClassType)) {
                return;
            }
            PsiClass resolveClass = ((PsiClassType)type).resolve();
            if (resolveClass == null) {
                return;
            }
            if (resolveClass.isEnum() || resolveClass.isInterface() || resolveClass.isAnnotationType()) {
                return;
            }
            if (resolveClass instanceof PsiTypeParameter) {
                return;
            }
            if (!ClassUtils.isSubclass(resolveClass, "java.sql.Driver")) {
                return;
            }
            this.registerNewExpressionError(newExpression, new Object[0]);
        }
    }
}

