/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.codeInsight.lookup.impl.ElementLookupRenderer;
import com.intellij.lang.properties.PropertiesFileType;
import com.intellij.lang.properties.PropertiesHighlighter;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.ResourceBundleImpl;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.Property;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.util.Icons;

public class PropertyLookupRenderer
implements ElementLookupRenderer<Property> {
    public boolean handlesItem(Object element) {
        return element instanceof Property;
    }

    public void renderElement(LookupItem item, Property property, LookupElementPresentation presentation) {
        PropertiesFile defaultPropertiesFile;
        Property defaultProperty;
        boolean hasBundle;
        presentation.setIcon(Icons.PROPERTY_ICON);
        presentation.setItemText(property.getUnescapedKey());
        PropertiesFile propertiesFile = property.getContainingFile();
        ResourceBundle resourceBundle = propertiesFile.getResourceBundle();
        String value = property.getValue();
        boolean bl = hasBundle = resourceBundle != ResourceBundleImpl.NULL;
        if (hasBundle && (defaultProperty = (defaultPropertiesFile = resourceBundle.getDefaultPropertiesFile(propertiesFile.getProject())).findPropertyByKey(property.getUnescapedKey())) != null) {
            value = defaultProperty.getValue();
        }
        if (presentation.isReal() && value != null && value.length() > 10) {
            value = value.substring(0, 10) + "...";
        }
        TextAttributes attrs = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(PropertiesHighlighter.PROPERTY_VALUE);
        presentation.setTailText("=" + value, attrs.getForegroundColor());
        if (hasBundle) {
            presentation.setTypeText(resourceBundle.getBaseName(), PropertiesFileType.FILE_ICON);
        }
    }
}

