/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.configuration;

import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.JUnitPatcher;
import com.intellij.execution.RunConfigurationExtension;
import com.intellij.execution.RunJavaConfiguration;
import com.intellij.execution.configurations.ConfigurationPerRunnerSettings;
import com.intellij.execution.configurations.DebuggingRunnerData;
import com.intellij.execution.configurations.JavaCommandLineState;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.execution.testframework.TestSearchScope;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.util.JavaParametersUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.LanguageLevelUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.progress.impl.ProgressManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.ex.JavaSdkUtil;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.util.PathUtil;
import com.intellij.util.PathsList;
import com.intellij.util.net.NetUtils;
import com.theoryinpractice.testng.configuration.SearchingForTestsTask;
import com.theoryinpractice.testng.configuration.TestNGConfiguration;
import com.theoryinpractice.testng.model.IDEARemoteTestRunnerClient;
import com.theoryinpractice.testng.model.TestData;
import com.theoryinpractice.testng.model.TestNGRemoteListener;
import com.theoryinpractice.testng.model.TestType;
import com.theoryinpractice.testng.ui.TestNGConsoleView;
import com.theoryinpractice.testng.ui.TestNGResults;
import com.theoryinpractice.testng.ui.actions.RerunFailedTestsAction;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.testng.RemoteTestNGStarter;
import org.testng.annotations.AfterClass;

public class TestNGRunnableState
extends JavaCommandLineState {
    private static final Logger LOG = Logger.getInstance((String)"TestNG Runner");
    private final ConfigurationPerRunnerSettings myConfigurationPerRunnerSettings;
    private final TestNGConfiguration config;
    private final RunnerSettings runnerSettings;
    private final IDEARemoteTestRunnerClient client;
    private int port;
    private String debugPort;
    private File myTempFile;
    private BackgroundableProcessIndicator mySearchForTestIndicator;

    public TestNGRunnableState(ExecutionEnvironment environment, TestNGConfiguration config) {
        super(environment);
        this.runnerSettings = environment.getRunnerSettings();
        this.myConfigurationPerRunnerSettings = environment.getConfigurationSettings();
        this.config = config;
        this.client = new IDEARemoteTestRunnerClient();
        if (this.runnerSettings.getData() instanceof DebuggingRunnerData) {
            DebuggingRunnerData debuggingRunnerData = (DebuggingRunnerData)this.runnerSettings.getData();
            this.debugPort = debuggingRunnerData.getDebugPort();
            if (this.debugPort.length() == 0) {
                try {
                    this.debugPort = DebuggerUtils.getInstance().findAvailableDebugAddress(true);
                }
                catch (ExecutionException e) {
                    LOG.error((Throwable)e);
                }
                debuggingRunnerData.setDebugPort(this.debugPort);
            }
            debuggingRunnerData.setLocal(true);
        }
    }

    public ExecutionResult execute(@NotNull Executor executor, @NotNull ProgramRunner runner) throws ExecutionException {
        if (executor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/theoryinpractice/testng/configuration/TestNGRunnableState.execute must not be null");
        }
        if (runner == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/theoryinpractice/testng/configuration/TestNGRunnableState.execute must not be null");
        }
        OSProcessHandler processHandler = null;
        try {
            processHandler = this.startProcess();
        }
        catch (ExecutionException e) {
            if (this.mySearchForTestIndicator != null && !this.mySearchForTestIndicator.isCanceled()) {
                this.mySearchForTestIndicator.cancel();
            }
            throw e;
        }
        final TestNGConsoleView console = new TestNGConsoleView(this.config, this.runnerSettings, this.myConfigurationPerRunnerSettings);
        console.initUI();
        for (RunConfigurationExtension ext : (RunConfigurationExtension[])Extensions.getExtensions((ExtensionPointName)RunConfigurationExtension.EP_NAME)) {
            ext.handleStartProcess((ModuleBasedConfiguration)this.config, processHandler);
        }
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(ProcessEvent event) {
                TestNGRunnableState.this.client.stopTest();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Project project = TestNGRunnableState.this.config.getProject();
                        if (project.isDisposed()) {
                            return;
                        }
                        TestConsoleProperties consoleProperties = console.getProperties();
                        if (consoleProperties == null) {
                            return;
                        }
                        String testRunDebugId = consoleProperties.isDebug() ? ToolWindowId.DEBUG : ToolWindowId.RUN;
                        TestNGResults resultsView = console.getResultsView();
                        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)project);
                        if (!Comparing.strEqual((String)toolWindowManager.getActiveToolWindowId(), (String)testRunDebugId)) {
                            toolWindowManager.notifyByBalloon(testRunDebugId, resultsView == null || resultsView.getStatus() == 1003 ? MessageType.WARNING : (resultsView.getStatus() == 1002 ? MessageType.ERROR : MessageType.INFO), resultsView == null ? "Tests were not started" : resultsView.getStatusLine(), null, null);
                        }
                    }
                });
            }

            public void startNotified(ProcessEvent event) {
                TestNGRemoteListener listener = new TestNGRemoteListener(console);
                TestNGRunnableState.this.client.startListening(listener, listener, TestNGRunnableState.this.port);
            }

            public void processWillTerminate(ProcessEvent event, boolean willBeDestroyed) {
                TestNGResults resultsView = console.getResultsView();
                if (resultsView != null) {
                    resultsView.finish();
                }
            }

            public void onTextAvailable(ProcessEvent event, Key outputType) {
                console.print(event.getText(), ConsoleViewContentType.getConsoleViewType((Key)outputType));
            }
        });
        console.attachToProcess((ProcessHandler)processHandler);
        RerunFailedTestsAction rerunFailedTestsAction = new RerunFailedTestsAction(console.getComponent());
        rerunFailedTestsAction.init(console.getProperties(), this.runnerSettings, this.myConfigurationPerRunnerSettings);
        rerunFailedTestsAction.setModelProvider((Getter)new Getter<TestFrameworkRunningModel>(){

            public TestFrameworkRunningModel get() {
                return console.getResultsView();
            }
        });
        DefaultExecutionResult result = new DefaultExecutionResult((ExecutionConsole)console, (ProcessHandler)processHandler);
        result.setRestartActions(new AnAction[]{rerunFailedTestsAction});
        return result;
    }

    protected JavaParameters createJavaParameters() throws ExecutionException {
        VirtualFile[] sources;
        Object[] patchers;
        Project project = this.config.getProject();
        JavaParameters javaParameters = new JavaParameters();
        javaParameters.setupEnvs(this.config.getPersistantData().getEnvs(), this.config.getPersistantData().PASS_PARENT_ENVS);
        javaParameters.getVMParametersList().add("-ea");
        javaParameters.setMainClass("org.testng.RemoteTestNGStarter");
        javaParameters.setWorkingDirectory(this.config.getProperty(2));
        javaParameters.getClassPath().add(PathUtil.getJarPathForClass(RemoteTestNGStarter.class));
        Module module = ((JavaRunConfigurationModule)this.config.getConfigurationModule()).getModule();
        LanguageLevel effectiveLanguageLevel = module == null ? LanguageLevelProjectExtension.getInstance((Project)project).getLanguageLevel() : LanguageLevelUtil.getEffectiveLanguageLevel((Module)module);
        boolean is15 = effectiveLanguageLevel != LanguageLevel.JDK_1_4 && effectiveLanguageLevel != LanguageLevel.JDK_1_3;
        LOG.info("Language level is " + effectiveLanguageLevel.toString());
        LOG.info("is15 is " + is15);
        javaParameters.getClassPath().add(is15 ? PathUtil.getJarPathForClass(AfterClass.class) : new File(PathManager.getPreinstalledPluginsPath(), "testng/lib-jdk14/testng-jdk14.jar").getPath());
        JavaParametersUtil.configureConfiguration((JavaParameters)javaParameters, (RunJavaConfiguration)this.config);
        Sdk jdk = module == null ? ProjectRootManager.getInstance((Project)project).getProjectJdk() : ModuleRootManager.getInstance((Module)module).getSdk();
        javaParameters.setJdk(jdk);
        for (Object patcher : patchers = Extensions.getExtensions((String)"com.intellij.junitPatcher")) {
            ((JUnitPatcher)patcher).patchJavaParameters(module, javaParameters);
        }
        JavaSdkUtil.addRtJar((PathsList)javaParameters.getClassPath());
        for (RunConfigurationExtension ext : (RunConfigurationExtension[])Extensions.getExtensions((ExtensionPointName)RunConfigurationExtension.EP_NAME)) {
            ext.updateJavaParameters((ModuleBasedConfiguration)this.config, javaParameters, this.getRunnerSettings());
        }
        LOG.info("Test scope is: " + this.config.getPersistantData().getScope());
        if (this.config.getPersistantData().getScope() == TestSearchScope.WHOLE_PROJECT) {
            LOG.info("Configuring for whole project");
            JavaParametersUtil.configureProject((Project)this.config.getProject(), (JavaParameters)javaParameters, (int)7, this.config.ALTERNATIVE_JRE_PATH_ENABLED ? this.config.ALTERNATIVE_JRE_PATH : null);
        } else {
            LOG.info("Configuring for module:" + ((JavaRunConfigurationModule)this.config.getConfigurationModule()).getModuleName());
            JavaParametersUtil.configureModule((RunConfigurationModule)this.config.getConfigurationModule(), (JavaParameters)javaParameters, (int)7, this.config.ALTERNATIVE_JRE_PATH_ENABLED ? this.config.ALTERNATIVE_JRE_PATH : null);
        }
        try {
            this.port = NetUtils.findAvailableSocketPort();
        }
        catch (IOException e) {
            throw new ExecutionException("Unable to bind to port " + this.port, (Throwable)e);
        }
        TestData data = this.config.getPersistantData();
        javaParameters.getProgramParametersList().add("-port", String.valueOf(this.port));
        if (!is15) {
            javaParameters.getProgramParametersList().add("-annotations", "javadoc");
        }
        if (data.getOutputDirectory() != null && !"".equals(data.getOutputDirectory())) {
            javaParameters.getProgramParametersList().add("-d", data.getOutputDirectory());
        }
        javaParameters.getProgramParametersList().add("-usedefaultlisteners", String.valueOf(data.USE_DEFAULT_REPORTERS));
        StringBuilder buf = new StringBuilder();
        if (data.TEST_LISTENERS != null && !data.TEST_LISTENERS.isEmpty()) {
            buf.append(StringUtil.join(data.TEST_LISTENERS, (String)";"));
        }
        for (Object o : Extensions.getExtensions((String)"com.theoryinpractice.testng.listener")) {
            boolean enabled = true;
            for (RunConfigurationExtension extension : (RunConfigurationExtension[])Extensions.getExtensions((ExtensionPointName)RunConfigurationExtension.EP_NAME)) {
                if (!extension.isListenerDisabled((ModuleBasedConfiguration)this.config, o)) continue;
                enabled = false;
                break;
            }
            if (!enabled) continue;
            if (buf.length() > 0) {
                buf.append(";");
            }
            buf.append(o.getClass().getName());
            javaParameters.getClassPath().add(PathUtil.getJarPathForClass(o.getClass()));
        }
        if (buf.length() > 0) {
            javaParameters.getProgramParametersList().add("-listener", buf.toString());
        }
        if ((sources = data.getScope() == TestSearchScope.WHOLE_PROJECT && TestType.PACKAGE.getType().equals(data.TEST_OBJECT) || module == null ? ProjectRootManager.getInstance((Project)project).getContentSourceRoots() : ModuleRootManager.getInstance((Module)module).getSourceRoots()).length > 0) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < sources.length; ++i) {
                VirtualFile source = sources[i];
                sb.append(source.getPath());
                if (i >= sources.length - 1) continue;
                sb.append(';');
            }
            javaParameters.getProgramParametersList().add("-sourcedir", sb.toString());
        }
        try {
            final ServerSocket serverSocket = new ServerSocket(0);
            javaParameters.getProgramParametersList().add("-socket" + serverSocket.getLocalPort());
            this.myTempFile = File.createTempFile("idea_testng", ".tmp");
            this.myTempFile.deleteOnExit();
            javaParameters.getProgramParametersList().add("-temp", this.myTempFile.getAbsolutePath());
            SearchingForTestsTask task = new SearchingForTestsTask(serverSocket, is15, this.config, this.myTempFile);
            this.mySearchForTestIndicator = new BackgroundableProcessIndicator(task){

                public void cancel() {
                    try {
                        if (!serverSocket.isClosed()) {
                            new Socket(InetAddress.getLocalHost(), serverSocket.getLocalPort());
                        }
                    }
                    catch (Throwable e) {
                        LOG.info(e);
                    }
                    super.cancel();
                }
            };
            ProgressManagerImpl.runProcessWithProgressAsynchronously((Task.Backgroundable)task, (ProgressIndicator)this.mySearchForTestIndicator);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        if (this.runnerSettings.getData() instanceof DebuggingRunnerData) {
            ParametersList params = javaParameters.getVMParametersList();
            String hostname = "localhost";
            try {
                hostname = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                // empty catch block
            }
            params.add("-Xdebug");
            params.add("-Xrunjdwp:transport=dt_socket,address=" + hostname + ':' + this.debugPort + ",suspend=y,server=n");
        }
        return javaParameters;
    }
}

