/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.svn;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.io.svn.SVNDataSource;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNWriter {
    private SVNWriter() {
    }

    public static void write(OutputStream os, String templateStr, Object[] src) throws SVNException {
        StringBuffer template = new StringBuffer(templateStr.length());
        for (int i = 0; i < templateStr.length(); ++i) {
            char ch = templateStr.charAt(i);
            if (Character.isWhitespace(ch)) continue;
            template.append(ch);
        }
        int offset = 0;
        try {
            for (int i = 0; i < template.length(); ++i) {
                Object item;
                char ch = template.charAt(i);
                if (ch == '(' || ch == ')') {
                    os.write((byte)ch);
                    os.write(32);
                    continue;
                }
                if ((item = src[offset++]) == null) {
                    if (ch != '*' && ch != '?') continue;
                    ++i;
                    continue;
                }
                if (item instanceof Date) {
                    item = SVNDate.formatDate((Date)item, true);
                }
                if (ch == 'i') {
                    InputStream is = ((SVNDataSource)item).getInputStream();
                    long length = ((SVNDataSource)item).lenght();
                    os.write(Long.toString(length).getBytes("UTF-8"));
                    os.write(58);
                    byte[] buffer = new byte[Math.min(2048, (int)length)];
                    while (true) {
                        int read;
                        if ((read = is.read(buffer)) > 0) {
                            os.write(buffer, 0, read);
                            continue;
                        }
                        if (read < 0) break;
                    }
                }
                if (ch == 'b') {
                    byte[] bytes = (byte[])item;
                    os.write(Integer.toString(bytes.length).getBytes("UTF-8"));
                    os.write(58);
                    os.write(bytes);
                } else if (ch == 'n') {
                    os.write(item.toString().getBytes("UTF-8"));
                } else if (ch == 'w') {
                    os.write(item.toString().getBytes("UTF-8"));
                } else if (ch == 's') {
                    os.write(Integer.toString(item.toString().getBytes("UTF-8").length).getBytes("UTF-8"));
                    os.write(58);
                    os.write(item.toString().getBytes("UTF-8"));
                } else if (ch == '*') {
                    Object[] list;
                    ch = template.charAt(i + 1);
                    if (item instanceof Object[]) {
                        list = (Object[])item;
                        for (int j = 0; j < list.length; ++j) {
                            if (ch == 's') {
                                os.write(Integer.toString(list[j].toString().getBytes("UTF-8").length).getBytes("UTF-8"));
                                os.write(58);
                                os.write(list[j].toString().getBytes("UTF-8"));
                            } else if (ch == 'w') {
                                os.write(list[j].toString().getBytes("UTF-8"));
                            }
                            os.write(32);
                        }
                    } else if (item instanceof long[] && ch == 'n') {
                        list = (long[])item;
                        for (int j = 0; j < list.length; ++j) {
                            os.write(Long.toString((long)list[j]).getBytes("UTF-8"));
                            os.write(32);
                        }
                    } else if (item instanceof Map && ch == 'l') {
                        Map map = (Map)item;
                        Iterator paths = map.keySet().iterator();
                        while (paths.hasNext()) {
                            String path = (String)paths.next();
                            String token = (String)map.get(path);
                            os.write(40);
                            os.write(32);
                            os.write(Integer.toString(path.getBytes("UTF-8").length).getBytes("UTF-8"));
                            os.write(58);
                            os.write(path.getBytes("UTF-8"));
                            os.write(32);
                            os.write(Integer.toString(token.getBytes("UTF-8").length).getBytes("UTF-8"));
                            os.write(58);
                            os.write(token.getBytes("UTF-8"));
                            os.write(32);
                            os.write(41);
                            os.write(32);
                        }
                    } else if (item instanceof SVNProperties && ch == 'l') {
                        SVNProperties props = (SVNProperties)item;
                        Iterator iterator = props.nameSet().iterator();
                        while (iterator.hasNext()) {
                            String name = (String)iterator.next();
                            SVNPropertyValue value = props.getSVNPropertyValue(name);
                            os.write(40);
                            os.write(32);
                            os.write(Integer.toString(name.getBytes("UTF-8").length).getBytes("UTF-8"));
                            os.write(58);
                            os.write(name.getBytes("UTF-8"));
                            os.write(32);
                            byte[] bytes = SVNPropertyValue.getPropertyAsBytes(value);
                            os.write(Integer.toString(bytes.length).getBytes("UTF-8"));
                            os.write(58);
                            os.write(bytes);
                            os.write(32);
                            os.write(41);
                            os.write(32);
                        }
                    }
                    ++i;
                }
                os.write(32);
            }
        }
        catch (IOException e) {
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_SVN_IO_ERROR, e.getMessage()), e, SVNLogType.NETWORK);
        }
    }
}

