/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.http;

import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.provider.http.HttpFileSystemConfigBuilder;

public class HttpClientFactory {
    private HttpClientFactory() {
    }

    public static HttpClient createConnection(String hostname, int port, String username, String password, FileSystemOptions fileSystemOptions) throws FileSystemException {
        HttpClient client;
        try {
            client = new HttpClient((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
            HostConfiguration config = new HostConfiguration();
            config.setHost(hostname, port);
            if (fileSystemOptions != null) {
                String proxyHost = HttpFileSystemConfigBuilder.getInstance().getProxyHost(fileSystemOptions);
                int proxyPort = HttpFileSystemConfigBuilder.getInstance().getProxyPort(fileSystemOptions);
                if (proxyHost != null && proxyPort > 0) {
                    config.setProxy(proxyHost, proxyPort);
                }
            }
            client.setHostConfiguration(config);
            if (username != null) {
                UsernamePasswordCredentials creds = new UsernamePasswordCredentials(username, password);
                client.getState().setCredentials(null, hostname, (Credentials)creds);
            }
            client.executeMethod((HttpMethod)new HeadMethod());
        }
        catch (Exception exc) {
            throw new FileSystemException("vfs.provider.http/connect.error", new Object[]{hostname}, (Throwable)exc);
        }
        return client;
    }
}

