/*
 * Decompiled with CFR 0.152.
 */
package javax.management.namespace;

import com.sun.jmx.mbeanserver.Util;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.security.Permission;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class JMXNamespacePermission
extends Permission {
    private static final long serialVersionUID = -2416928705275160661L;
    private static final String WILDPATH = "**//*";
    private static final int AddNotificationListener = 1;
    private static final int GetAttribute = 2;
    private static final int GetClassLoader = 4;
    private static final int GetClassLoaderFor = 8;
    private static final int GetClassLoaderRepository = 16;
    private static final int GetMBeanInfo = 64;
    private static final int GetObjectInstance = 128;
    private static final int Instantiate = 256;
    private static final int Invoke = 512;
    private static final int IsInstanceOf = 1024;
    private static final int QueryMBeans = 2048;
    private static final int QueryNames = 4096;
    private static final int RegisterMBean = 8192;
    private static final int RemoveNotificationListener = 16384;
    private static final int SetAttribute = 32768;
    private static final int UnregisterMBean = 65536;
    private static final int NONE = 0;
    private static final int ALL = 131039;
    private String actions;
    private transient int mask;
    private transient String mbeanServerName;
    private transient String member;
    private transient ObjectName objectName;
    private transient boolean allnames = false;

    private void parseActions() {
        if (this.actions == null) {
            throw new IllegalArgumentException("JMXNamespaceAccessPermission: actions can't be null");
        }
        if (this.actions.equals("")) {
            throw new IllegalArgumentException("JMXNamespaceAccessPermission: actions can't be empty");
        }
        int n = JMXNamespacePermission.getMask(this.actions);
        if ((n & 0x1FFDF) != n) {
            throw new IllegalArgumentException("Invalid actions mask");
        }
        if (n == 0) {
            throw new IllegalArgumentException("Invalid actions mask");
        }
        this.mask = n;
    }

    private void parseName() {
        String string;
        String string2 = this.getName();
        if (string2 == null) {
            throw new IllegalArgumentException("JMXNamespaceAccessPermission name cannot be null");
        }
        if (string2.equals("")) {
            throw new IllegalArgumentException("JMXNamespaceAccessPermission name cannot be empty");
        }
        int n = string2.indexOf("::");
        if (n < 0) {
            this.setMBeanServerName("*");
        } else {
            this.setMBeanServerName(string2.substring(0, n));
        }
        int n2 = n < 0 ? 0 : n + 2;
        int n3 = string2.indexOf("[", n2);
        if (n3 == -1) {
            this.objectName = null;
            this.allnames = true;
            n3 = string2.length();
        } else {
            if (!string2.endsWith("]")) {
                throw new IllegalArgumentException("JMXNamespaceAccessPermission: The ObjectName in the target name must be included in square brackets");
            }
            string = string2.substring(n3 + 1, string2.length() - 1);
            try {
                boolean bl;
                ObjectName objectName;
                if (string.equals("")) {
                    objectName = null;
                    bl = true;
                } else if (string.equals("-")) {
                    objectName = null;
                    bl = false;
                } else {
                    objectName = new ObjectName(string);
                    bl = false;
                }
                this.setObjectName(objectName, bl);
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                throw new IllegalArgumentException("JMXNamespaceAccessPermission: The target name does not specify a valid ObjectName", malformedObjectNameException);
            }
        }
        string = string2.substring(n2, n3);
        this.setMember(string);
    }

    private void setObjectName(ObjectName objectName, boolean bl) {
        if (objectName != null && !Util.wildpathmatch(objectName.getDomain(), WILDPATH)) {
            throw new IllegalArgumentException("The target name does not contain any namespace: " + String.valueOf(objectName));
        }
        if (objectName != null) {
            String string = objectName.getDomain();
            int n = "//".length();
            int n2 = string.indexOf("//");
            if (n2 < 0 || n2 + n == string.length()) {
                throw new IllegalArgumentException(String.valueOf(objectName) + ": no namespace in domain");
            }
        }
        this.objectName = objectName;
        this.allnames = bl;
    }

    private void initName(String string, String string2, ObjectName objectName, boolean bl) {
        this.setMBeanServerName(string);
        this.setMember(string2);
        this.setObjectName(objectName, bl);
    }

    private void setMBeanServerName(String string) {
        this.mbeanServerName = string == null || string.equals("-") ? null : (string.equals("") ? "*" : string);
    }

    private void setMember(String string) {
        this.member = string == null || string.equals("-") ? null : (string.equals("") ? "*" : string);
    }

    public JMXNamespacePermission(String string, String string2) {
        super(string);
        this.parseName();
        this.actions = string2;
        this.parseActions();
    }

    public JMXNamespacePermission(String string, String string2, ObjectName objectName, String string3) {
        this(string, string2, objectName, false, string3);
    }

    public JMXNamespacePermission(String string, String string2, String string3) {
        this(string, string2, null, true, string3);
    }

    private JMXNamespacePermission(String string, String string2, ObjectName objectName, boolean bl, String string3) {
        super(JMXNamespacePermission.makeName(string, string2, objectName, bl));
        this.initName(string, string2, objectName, bl);
        this.actions = string3;
        this.parseActions();
    }

    private static String makeName(String string, String string2, ObjectName objectName, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        if (string == null) {
            string = "-";
        }
        if (!string.equals("") && !string.equals("*")) {
            stringBuilder.append(string).append("::");
        }
        if (string2 == null) {
            string2 = "-";
        }
        stringBuilder.append(string2);
        if (objectName == null) {
            if (bl) {
                stringBuilder.append("[]");
            } else {
                stringBuilder.append("[-]");
            }
        } else {
            String string3 = objectName.getDomain();
            int n = "//".length();
            int n2 = string3.indexOf("//");
            if (n2 < 0 || n2 + n == string3.length()) {
                throw new IllegalArgumentException(String.valueOf(objectName) + ": no namespace in domain");
            }
            String string4 = objectName.getCanonicalName();
            stringBuilder.append("[").append(string4).append("]");
        }
        return stringBuilder.toString();
    }

    @Override
    public String getActions() {
        if (this.actions == null) {
            this.actions = JMXNamespacePermission.getActions(this.mask);
        }
        return this.actions;
    }

    private static String getActions(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        if ((n & 1) == 1) {
            bl = true;
            stringBuilder.append("addNotificationListener");
        }
        if ((n & 2) == 2) {
            if (bl) {
                stringBuilder.append(',');
            } else {
                bl = true;
            }
            stringBuilder.append("getAttribute");
        }
        if ((n & 4) == 4) {
            if (bl) {
                stringBuilder.append(',');
            } else {
                bl = true;
            }
            stringBuilder.append("getClassLoader");
        }
        if ((n & 8) == 8) {
            if (bl) {
                stringBuilder.append(',');
            } else {
                bl = true;
            }
            stringBuilder.append("getClassLoaderFor");
        }
        if ((n & 0x10) == 16) {
            if (bl) {
                stringBuilder.append(',');
            } else {
                bl = true;
            }
            stringBuilder.append("getClassLoaderRepository");
        }
        if ((n & 0x40) == 64) {
            if (bl) {
                stringBuilder.append(',');
            } else {
                bl = true;
            }
            stringBuilder.append("getMBeanInfo");
        }
        if ((n & 0x80) == 128) {
            if (bl) {
                stringBuilder.append(',');
            } else {
                bl = true;
            }
            stringBuilder.append("getObjectInstance");
        }
        if ((n & 0x100) == 256) {
            if (bl) {
                stringBuilder.append(',');
            } else {
                bl = true;
            }
            stringBuilder.append("instantiate");
        }
        if ((n & 0x200) == 512) {
            if (bl) {
                stringBuilder.append(',');
            } else {
                bl = true;
            }
            stringBuilder.append("invoke");
        }
        if ((n & 0x400) == 1024) {
            if (bl) {
                stringBuilder.append(',');
            } else {
                bl = true;
            }
            stringBuilder.append("isInstanceOf");
        }
        if ((n & 0x800) == 2048) {
            if (bl) {
                stringBuilder.append(',');
            } else {
                bl = true;
            }
            stringBuilder.append("queryMBeans");
        }
        if ((n & 0x1000) == 4096) {
            if (bl) {
                stringBuilder.append(',');
            } else {
                bl = true;
            }
            stringBuilder.append("queryNames");
        }
        if ((n & 0x2000) == 8192) {
            if (bl) {
                stringBuilder.append(',');
            } else {
                bl = true;
            }
            stringBuilder.append("registerMBean");
        }
        if ((n & 0x4000) == 16384) {
            if (bl) {
                stringBuilder.append(',');
            } else {
                bl = true;
            }
            stringBuilder.append("removeNotificationListener");
        }
        if ((n & 0x8000) == 32768) {
            if (bl) {
                stringBuilder.append(',');
            } else {
                bl = true;
            }
            stringBuilder.append("setAttribute");
        }
        if ((n & 0x10000) == 65536) {
            if (bl) {
                stringBuilder.append(',');
            } else {
                bl = true;
            }
            stringBuilder.append("unregisterMBean");
        }
        return stringBuilder.toString();
    }

    @Override
    public int hashCode() {
        return this.getName().hashCode() + this.getActions().hashCode();
    }

    private static int getMask(String string) {
        int n = 0;
        if (string == null) {
            return n;
        }
        if (string.equals("*")) {
            return 131039;
        }
        char[] cArray = string.toCharArray();
        int n2 = cArray.length - 1;
        if (n2 < 0) {
            return n;
        }
        while (n2 != -1) {
            int n3;
            char c;
            while (n2 != -1 && ((c = cArray[n2]) == ' ' || c == '\r' || c == '\n' || c == '\f' || c == '\t')) {
                --n2;
            }
            if (n2 >= 25 && cArray[n2 - 25] == 'r' && cArray[n2 - 24] == 'e' && cArray[n2 - 23] == 'm' && cArray[n2 - 22] == 'o' && cArray[n2 - 21] == 'v' && cArray[n2 - 20] == 'e' && cArray[n2 - 19] == 'N' && cArray[n2 - 18] == 'o' && cArray[n2 - 17] == 't' && cArray[n2 - 16] == 'i' && cArray[n2 - 15] == 'f' && cArray[n2 - 14] == 'i' && cArray[n2 - 13] == 'c' && cArray[n2 - 12] == 'a' && cArray[n2 - 11] == 't' && cArray[n2 - 10] == 'i' && cArray[n2 - 9] == 'o' && cArray[n2 - 8] == 'n' && cArray[n2 - 7] == 'L' && cArray[n2 - 6] == 'i' && cArray[n2 - 5] == 's' && cArray[n2 - 4] == 't' && cArray[n2 - 3] == 'e' && cArray[n2 - 2] == 'n' && cArray[n2 - 1] == 'e' && cArray[n2] == 'r') {
                n3 = 26;
                n |= 0x4000;
            } else if (n2 >= 23 && cArray[n2 - 23] == 'g' && cArray[n2 - 22] == 'e' && cArray[n2 - 21] == 't' && cArray[n2 - 20] == 'C' && cArray[n2 - 19] == 'l' && cArray[n2 - 18] == 'a' && cArray[n2 - 17] == 's' && cArray[n2 - 16] == 's' && cArray[n2 - 15] == 'L' && cArray[n2 - 14] == 'o' && cArray[n2 - 13] == 'a' && cArray[n2 - 12] == 'd' && cArray[n2 - 11] == 'e' && cArray[n2 - 10] == 'r' && cArray[n2 - 9] == 'R' && cArray[n2 - 8] == 'e' && cArray[n2 - 7] == 'p' && cArray[n2 - 6] == 'o' && cArray[n2 - 5] == 's' && cArray[n2 - 4] == 'i' && cArray[n2 - 3] == 't' && cArray[n2 - 2] == 'o' && cArray[n2 - 1] == 'r' && cArray[n2] == 'y') {
                n3 = 24;
                n |= 0x10;
            } else if (n2 >= 22 && cArray[n2 - 22] == 'a' && cArray[n2 - 21] == 'd' && cArray[n2 - 20] == 'd' && cArray[n2 - 19] == 'N' && cArray[n2 - 18] == 'o' && cArray[n2 - 17] == 't' && cArray[n2 - 16] == 'i' && cArray[n2 - 15] == 'f' && cArray[n2 - 14] == 'i' && cArray[n2 - 13] == 'c' && cArray[n2 - 12] == 'a' && cArray[n2 - 11] == 't' && cArray[n2 - 10] == 'i' && cArray[n2 - 9] == 'o' && cArray[n2 - 8] == 'n' && cArray[n2 - 7] == 'L' && cArray[n2 - 6] == 'i' && cArray[n2 - 5] == 's' && cArray[n2 - 4] == 't' && cArray[n2 - 3] == 'e' && cArray[n2 - 2] == 'n' && cArray[n2 - 1] == 'e' && cArray[n2] == 'r') {
                n3 = 23;
                n |= 1;
            } else if (n2 >= 16 && cArray[n2 - 16] == 'g' && cArray[n2 - 15] == 'e' && cArray[n2 - 14] == 't' && cArray[n2 - 13] == 'C' && cArray[n2 - 12] == 'l' && cArray[n2 - 11] == 'a' && cArray[n2 - 10] == 's' && cArray[n2 - 9] == 's' && cArray[n2 - 8] == 'L' && cArray[n2 - 7] == 'o' && cArray[n2 - 6] == 'a' && cArray[n2 - 5] == 'd' && cArray[n2 - 4] == 'e' && cArray[n2 - 3] == 'r' && cArray[n2 - 2] == 'F' && cArray[n2 - 1] == 'o' && cArray[n2] == 'r') {
                n3 = 17;
                n |= 8;
            } else if (n2 >= 16 && cArray[n2 - 16] == 'g' && cArray[n2 - 15] == 'e' && cArray[n2 - 14] == 't' && cArray[n2 - 13] == 'O' && cArray[n2 - 12] == 'b' && cArray[n2 - 11] == 'j' && cArray[n2 - 10] == 'e' && cArray[n2 - 9] == 'c' && cArray[n2 - 8] == 't' && cArray[n2 - 7] == 'I' && cArray[n2 - 6] == 'n' && cArray[n2 - 5] == 's' && cArray[n2 - 4] == 't' && cArray[n2 - 3] == 'a' && cArray[n2 - 2] == 'n' && cArray[n2 - 1] == 'c' && cArray[n2] == 'e') {
                n3 = 17;
                n |= 0x80;
            } else if (n2 >= 14 && cArray[n2 - 14] == 'u' && cArray[n2 - 13] == 'n' && cArray[n2 - 12] == 'r' && cArray[n2 - 11] == 'e' && cArray[n2 - 10] == 'g' && cArray[n2 - 9] == 'i' && cArray[n2 - 8] == 's' && cArray[n2 - 7] == 't' && cArray[n2 - 6] == 'e' && cArray[n2 - 5] == 'r' && cArray[n2 - 4] == 'M' && cArray[n2 - 3] == 'B' && cArray[n2 - 2] == 'e' && cArray[n2 - 1] == 'a' && cArray[n2] == 'n') {
                n3 = 15;
                n |= 0x10000;
            } else if (n2 >= 13 && cArray[n2 - 13] == 'g' && cArray[n2 - 12] == 'e' && cArray[n2 - 11] == 't' && cArray[n2 - 10] == 'C' && cArray[n2 - 9] == 'l' && cArray[n2 - 8] == 'a' && cArray[n2 - 7] == 's' && cArray[n2 - 6] == 's' && cArray[n2 - 5] == 'L' && cArray[n2 - 4] == 'o' && cArray[n2 - 3] == 'a' && cArray[n2 - 2] == 'd' && cArray[n2 - 1] == 'e' && cArray[n2] == 'r') {
                n3 = 14;
                n |= 4;
            } else if (n2 >= 12 && cArray[n2 - 12] == 'r' && cArray[n2 - 11] == 'e' && cArray[n2 - 10] == 'g' && cArray[n2 - 9] == 'i' && cArray[n2 - 8] == 's' && cArray[n2 - 7] == 't' && cArray[n2 - 6] == 'e' && cArray[n2 - 5] == 'r' && cArray[n2 - 4] == 'M' && cArray[n2 - 3] == 'B' && cArray[n2 - 2] == 'e' && cArray[n2 - 1] == 'a' && cArray[n2] == 'n') {
                n3 = 13;
                n |= 0x2000;
            } else if (n2 >= 11 && cArray[n2 - 11] == 'g' && cArray[n2 - 10] == 'e' && cArray[n2 - 9] == 't' && cArray[n2 - 8] == 'A' && cArray[n2 - 7] == 't' && cArray[n2 - 6] == 't' && cArray[n2 - 5] == 'r' && cArray[n2 - 4] == 'i' && cArray[n2 - 3] == 'b' && cArray[n2 - 2] == 'u' && cArray[n2 - 1] == 't' && cArray[n2] == 'e') {
                n3 = 12;
                n |= 2;
            } else if (n2 >= 11 && cArray[n2 - 11] == 'g' && cArray[n2 - 10] == 'e' && cArray[n2 - 9] == 't' && cArray[n2 - 8] == 'M' && cArray[n2 - 7] == 'B' && cArray[n2 - 6] == 'e' && cArray[n2 - 5] == 'a' && cArray[n2 - 4] == 'n' && cArray[n2 - 3] == 'I' && cArray[n2 - 2] == 'n' && cArray[n2 - 1] == 'f' && cArray[n2] == 'o') {
                n3 = 12;
                n |= 0x40;
            } else if (n2 >= 11 && cArray[n2 - 11] == 'i' && cArray[n2 - 10] == 's' && cArray[n2 - 9] == 'I' && cArray[n2 - 8] == 'n' && cArray[n2 - 7] == 's' && cArray[n2 - 6] == 't' && cArray[n2 - 5] == 'a' && cArray[n2 - 4] == 'n' && cArray[n2 - 3] == 'c' && cArray[n2 - 2] == 'e' && cArray[n2 - 1] == 'O' && cArray[n2] == 'f') {
                n3 = 12;
                n |= 0x400;
            } else if (n2 >= 11 && cArray[n2 - 11] == 's' && cArray[n2 - 10] == 'e' && cArray[n2 - 9] == 't' && cArray[n2 - 8] == 'A' && cArray[n2 - 7] == 't' && cArray[n2 - 6] == 't' && cArray[n2 - 5] == 'r' && cArray[n2 - 4] == 'i' && cArray[n2 - 3] == 'b' && cArray[n2 - 2] == 'u' && cArray[n2 - 1] == 't' && cArray[n2] == 'e') {
                n3 = 12;
                n |= 0x8000;
            } else if (n2 >= 10 && cArray[n2 - 10] == 'i' && cArray[n2 - 9] == 'n' && cArray[n2 - 8] == 's' && cArray[n2 - 7] == 't' && cArray[n2 - 6] == 'a' && cArray[n2 - 5] == 'n' && cArray[n2 - 4] == 't' && cArray[n2 - 3] == 'i' && cArray[n2 - 2] == 'a' && cArray[n2 - 1] == 't' && cArray[n2] == 'e') {
                n3 = 11;
                n |= 0x100;
            } else if (n2 >= 10 && cArray[n2 - 10] == 'q' && cArray[n2 - 9] == 'u' && cArray[n2 - 8] == 'e' && cArray[n2 - 7] == 'r' && cArray[n2 - 6] == 'y' && cArray[n2 - 5] == 'M' && cArray[n2 - 4] == 'B' && cArray[n2 - 3] == 'e' && cArray[n2 - 2] == 'a' && cArray[n2 - 1] == 'n' && cArray[n2] == 's') {
                n3 = 11;
                n |= 0x800;
            } else if (n2 >= 9 && cArray[n2 - 9] == 'q' && cArray[n2 - 8] == 'u' && cArray[n2 - 7] == 'e' && cArray[n2 - 6] == 'r' && cArray[n2 - 5] == 'y' && cArray[n2 - 4] == 'N' && cArray[n2 - 3] == 'a' && cArray[n2 - 2] == 'm' && cArray[n2 - 1] == 'e' && cArray[n2] == 's') {
                n3 = 10;
                n |= 0x1000;
            } else if (n2 >= 5 && cArray[n2 - 5] == 'i' && cArray[n2 - 4] == 'n' && cArray[n2 - 3] == 'v' && cArray[n2 - 2] == 'o' && cArray[n2 - 1] == 'k' && cArray[n2] == 'e') {
                n3 = 6;
                n |= 0x200;
            } else {
                throw new IllegalArgumentException("Invalid permission: " + string);
            }
            boolean bl = false;
            while (n2 >= n3 && !bl) {
                switch (cArray[n2 - n3]) {
                    case ',': {
                        bl = true;
                        break;
                    }
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid permission: " + string);
                    }
                }
                --n2;
            }
            n2 -= n3;
        }
        return n;
    }

    @Override
    public boolean implies(Permission permission) {
        if (!(permission instanceof JMXNamespacePermission)) {
            return false;
        }
        JMXNamespacePermission jMXNamespacePermission = (JMXNamespacePermission)permission;
        if ((this.mask & 0x800) == 2048 ? ((this.mask | 0x1000) & jMXNamespacePermission.mask) != jMXNamespacePermission.mask : (this.mask & jMXNamespacePermission.mask) != jMXNamespacePermission.mask) {
            return false;
        }
        if (jMXNamespacePermission.mbeanServerName != null) {
            if (this.mbeanServerName == null) {
                return false;
            }
            if (!jMXNamespacePermission.mbeanServerName.equals(this.mbeanServerName) && !Util.wildmatch(jMXNamespacePermission.mbeanServerName, this.mbeanServerName)) {
                return false;
            }
        }
        if (jMXNamespacePermission.member != null) {
            if (this.member == null) {
                return false;
            }
            if (!(this.member.equals("*") || this.member.equals(jMXNamespacePermission.member) || Util.wildmatch(jMXNamespacePermission.member, this.member))) {
                return false;
            }
        }
        return jMXNamespacePermission.objectName == null || !(this.objectName == null ? !this.allnames : !this.objectName.apply(jMXNamespacePermission.objectName) && !this.objectName.equals(jMXNamespacePermission.objectName));
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof JMXNamespacePermission)) {
            return false;
        }
        JMXNamespacePermission jMXNamespacePermission = (JMXNamespacePermission)object;
        return this.mask == jMXNamespacePermission.mask && this.getName().equals(jMXNamespacePermission.getName());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.parseName();
        this.parseActions();
    }
}

