/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.awt.FontFormatException;
import java.awt.GraphicsEnvironment;
import java.awt.font.FontRenderContext;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import sun.font.CharToGlyphMapper;
import sun.font.DelegateStrike;
import sun.font.FontManager;
import sun.font.FontStrike;
import sun.font.FontStrikeDesc;
import sun.font.NativeGlyphMapper;
import sun.font.NativeStrike;
import sun.font.PhysicalFont;
import sun.font.StrikeMetrics;

public class NativeFont
extends PhysicalFont {
    String encoding;
    private int numGlyphs = -1;
    boolean isBitmapDelegate;
    PhysicalFont delegateFont;

    public NativeFont(String string, boolean bl) throws FontFormatException {
        super(string, null);
        this.isBitmapDelegate = bl;
        if (GraphicsEnvironment.isHeadless()) {
            throw new FontFormatException("Native font in headless toolkit");
        }
        this.fontRank = 5;
        this.initNames();
        if (this.getNumGlyphs() == 0) {
            throw new FontFormatException("Couldn't locate font" + string);
        }
    }

    private void initNames() throws FontFormatException {
        int[] nArray = new int[14];
        int n = 1;
        int n2 = 1;
        String string = this.platName.toLowerCase(Locale.ENGLISH);
        if (string.startsWith("-")) {
            while (n2 != -1 && n < 14) {
                if ((n2 = string.indexOf(45, n2)) == -1) continue;
                nArray[n++] = n2++;
            }
        }
        if (n == 14 && n2 != -1) {
            String string2 = string.substring(nArray[1] + 1, nArray[2]);
            StringBuilder stringBuilder = new StringBuilder(string2);
            char c = Character.toUpperCase(stringBuilder.charAt(0));
            stringBuilder.replace(0, 1, String.valueOf(c));
            for (int i = 1; i < stringBuilder.length() - 1; ++i) {
                if (stringBuilder.charAt(i) != ' ') continue;
                c = Character.toUpperCase(stringBuilder.charAt(i + 1));
                stringBuilder.replace(i + 1, i + 2, String.valueOf(c));
            }
            this.familyName = stringBuilder.toString();
            String string3 = string.substring(nArray[2] + 1, nArray[3]);
            String string4 = string.substring(nArray[3] + 1, nArray[4]);
            String string5 = null;
            if (string3.indexOf("bold") >= 0 || string3.indexOf("demi") >= 0) {
                this.style |= 1;
                string5 = "Bold";
            }
            if (string4.equals("i") || string4.indexOf("italic") >= 0) {
                this.style |= 2;
                string5 = string5 == null ? "Italic" : string5 + " Italic";
            } else if (string4.equals("o") || string4.indexOf("oblique") >= 0) {
                this.style |= 2;
                string5 = string5 == null ? "Oblique" : string5 + " Oblique";
            }
            this.fullName = string5 == null ? this.familyName : this.familyName + " " + string5;
            this.encoding = string.substring(nArray[12] + 1);
            if (this.encoding.startsWith("-")) {
                this.encoding = string.substring(nArray[13] + 1);
            }
            if (this.encoding.indexOf("fontspecific") >= 0) {
                this.encoding = string2.indexOf("dingbats") >= 0 ? "dingbats" : (string2.indexOf("symbol") >= 0 ? "symbol" : "iso8859-1");
            }
        } else {
            throw new FontFormatException("Bad native name " + this.platName);
        }
    }

    static boolean hasExternalBitmaps(String string) {
        StringBuilder stringBuilder = new StringBuilder(string);
        int n = stringBuilder.indexOf("-0-");
        while (n >= 0) {
            stringBuilder.replace(n + 1, n + 2, "*");
            n = stringBuilder.indexOf("-0-", n);
        }
        String string2 = stringBuilder.toString();
        byte[] byArray = null;
        try {
            byArray = string2.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = string2.getBytes();
        }
        return NativeFont.haveBitmapFonts(byArray);
    }

    public static boolean fontExists(String string) {
        byte[] byArray = null;
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = string.getBytes();
        }
        return NativeFont.fontExists(byArray);
    }

    private static native boolean haveBitmapFonts(byte[] var0);

    private static native boolean fontExists(byte[] var0);

    @Override
    public CharToGlyphMapper getMapper() {
        if (this.mapper == null) {
            if (this.isBitmapDelegate) {
                this.mapper = new NativeGlyphMapper(this);
            } else {
                this.delegateFont = FontManager.getDefaultPhysicalFont();
                this.mapper = this.delegateFont.getMapper();
            }
        }
        return this.mapper;
    }

    @Override
    FontStrike createStrike(FontStrikeDesc fontStrikeDesc) {
        if (this.isBitmapDelegate) {
            return new NativeStrike(this, fontStrikeDesc);
        }
        if (this.delegateFont == null) {
            this.delegateFont = FontManager.getDefaultPhysicalFont();
        }
        if (this.delegateFont instanceof NativeFont) {
            return new NativeStrike((NativeFont)this.delegateFont, fontStrikeDesc);
        }
        FontStrike fontStrike = this.delegateFont.createStrike(fontStrikeDesc);
        return new DelegateStrike(this, fontStrikeDesc, fontStrike);
    }

    public Rectangle2D getMaxCharBounds(FontRenderContext fontRenderContext) {
        return null;
    }

    @Override
    native StrikeMetrics getFontMetrics(long var1);

    @Override
    native float getGlyphAdvance(long var1, int var3);

    @Override
    Rectangle2D.Float getGlyphOutlineBounds(long l, int n) {
        return new Rectangle2D.Float(0.0f, 0.0f, 0.0f, 0.0f);
    }

    @Override
    public GeneralPath getGlyphOutline(long l, int n, float f, float f2) {
        return null;
    }

    @Override
    native long getGlyphImage(long var1, int var3);

    native long getGlyphImageNoDefault(long var1, int var3);

    @Override
    void getGlyphMetrics(long l, int n, Point2D.Float float_) {
        throw new RuntimeException("this should be called on the strike");
    }

    @Override
    public GeneralPath getGlyphVectorOutline(long l, int[] nArray, int n, float f, float f2) {
        return null;
    }

    private native int countGlyphs(byte[] var1, int var2);

    @Override
    public int getNumGlyphs() {
        if (this.numGlyphs == -1) {
            byte[] byArray = this.getPlatformNameBytes(8);
            this.numGlyphs = this.countGlyphs(byArray, 8);
        }
        return this.numGlyphs;
    }

    PhysicalFont getDelegateFont() {
        if (this.delegateFont == null) {
            this.delegateFont = FontManager.getDefaultPhysicalFont();
        }
        return this.delegateFont;
    }

    byte[] getPlatformNameBytes(int n) {
        int[] nArray = new int[14];
        int n2 = 1;
        int n3 = 1;
        while (n3 != -1 && n2 < 14) {
            if ((n3 = this.platName.indexOf(45, n3)) == -1) continue;
            nArray[n2++] = n3++;
        }
        String string = Integer.toString(Math.abs(n) * 10);
        StringBuilder stringBuilder = new StringBuilder(this.platName);
        stringBuilder.replace(nArray[11] + 1, nArray[12], "*");
        stringBuilder.replace(nArray[9] + 1, nArray[10], "72");
        stringBuilder.replace(nArray[8] + 1, nArray[9], "72");
        stringBuilder.replace(nArray[7] + 1, nArray[8], string);
        stringBuilder.replace(nArray[6] + 1, nArray[7], "*");
        if (nArray[0] == 0 && nArray[1] == 1) {
            stringBuilder.replace(nArray[0] + 1, nArray[1], "*");
        }
        String string2 = stringBuilder.toString();
        byte[] byArray = null;
        try {
            byArray = string2.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = string2.getBytes();
        }
        return byArray;
    }

    public String toString() {
        return " ** Native Font: Family=" + this.familyName + " Name=" + this.fullName + " style=" + this.style + " nativeName=" + this.platName;
    }
}

