/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.jdi;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.PrimitiveType;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import com.sun.jdi.VirtualMachine;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import sun.jvm.hotspot.jdi.JNITypeParser;
import sun.jvm.hotspot.jdi.ReferenceTypeImpl;
import sun.jvm.hotspot.oops.ArrayKlass;
import sun.jvm.hotspot.oops.Instance;
import sun.jvm.hotspot.oops.InstanceKlass;
import sun.jvm.hotspot.oops.Klass;
import sun.jvm.hotspot.oops.ObjArrayKlass;
import sun.jvm.hotspot.oops.Symbol;
import sun.jvm.hotspot.oops.TypeArrayKlass;

public class ArrayTypeImpl
extends ReferenceTypeImpl
implements ArrayType {
    protected ArrayTypeImpl(VirtualMachine aVm, ArrayKlass aRef) {
        super(aVm, aRef);
    }

    public ArrayReference newInstance(int length) {
        this.vm.throwNotReadOnlyException("ArrayType.newInstance(int)");
        return null;
    }

    public String componentSignature() {
        return this.signature().substring(1);
    }

    public String componentTypeName() {
        JNITypeParser parser = new JNITypeParser(this.componentSignature());
        return parser.typeName();
    }

    public ClassLoaderReference classLoader() {
        if (this.ref() instanceof TypeArrayKlass) {
            return null;
        }
        Klass bottomKlass = ((ObjArrayKlass)this.ref()).getBottomKlass();
        if (bottomKlass instanceof TypeArrayKlass) {
            return null;
        }
        Instance xx = (Instance)((InstanceKlass)bottomKlass).getClassLoader();
        return this.vm.classLoaderMirror(xx);
    }

    void addVisibleMethods(Map methodMap) {
    }

    List getAllMethods() {
        return new ArrayList(0);
    }

    public Type componentType() throws ClassNotLoadedException {
        ArrayKlass k = (ArrayKlass)this.ref();
        if (k instanceof ObjArrayKlass) {
            Klass elementKlass = ((ObjArrayKlass)k).getElementKlass();
            if (elementKlass == null) {
                throw new ClassNotLoadedException(this.componentSignature());
            }
            return this.vm.referenceType(elementKlass);
        }
        return this.vm.primitiveTypeMirror(this.signature().charAt(1));
    }

    static boolean isComponentAssignable(Type destination, Type source) {
        if (source instanceof PrimitiveType) {
            return source.equals(destination);
        }
        if (destination instanceof PrimitiveType) {
            return false;
        }
        ReferenceTypeImpl refSource = (ReferenceTypeImpl)source;
        ReferenceTypeImpl refDestination = (ReferenceTypeImpl)destination;
        return refSource.isAssignableTo(refDestination);
    }

    boolean isAssignableTo(ReferenceType destType) {
        if (destType instanceof ArrayType) {
            try {
                Type destComponentType = ((ArrayType)destType).componentType();
                return ArrayTypeImpl.isComponentAssignable(destComponentType, this.componentType());
            }
            catch (ClassNotLoadedException e) {
                return false;
            }
        }
        Symbol typeName = ((ReferenceTypeImpl)destType).typeNameAsSymbol();
        if (destType instanceof InterfaceType) {
            return typeName.equals(this.vm.javaLangCloneable()) || typeName.equals(this.vm.javaIoSerializable());
        }
        return typeName.equals(this.vm.javaLangObject());
    }

    List inheritedTypes() {
        return new ArrayList(0);
    }

    int getModifiers() {
        try {
            Type t = this.componentType();
            if (t instanceof PrimitiveType) {
                return 17;
            }
            ReferenceType rt = (ReferenceType)t;
            return rt.modifiers();
        }
        catch (ClassNotLoadedException cnle) {
            cnle.printStackTrace();
            return -1;
        }
    }

    public String toString() {
        return "array class " + this.name() + " (" + this.loaderString() + ")";
    }

    public boolean isPrepared() {
        return true;
    }

    public boolean isVerified() {
        return true;
    }

    public boolean isInitialized() {
        return true;
    }

    public boolean failedToInitialize() {
        return false;
    }

    public boolean isAbstract() {
        return false;
    }

    public boolean isFinal() {
        return true;
    }
}

