/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Action;
import javax.swing.InputMap;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.openstreetmap.josm.actions.OpenFileAction;
import org.openstreetmap.josm.actions.downloadtasks.AbstractDownloadTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadGpsTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadTask;
import org.openstreetmap.josm.actions.downloadtasks.PostDownloadHandler;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.actions.search.SearchAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.coor.CoordinateFormat;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.PrimitiveDeepCopy;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.gui.GettingStarted;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.io.SaveLayersDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.preferences.MapPaintPreference;
import org.openstreetmap.josm.gui.preferences.ProjectionPreference;
import org.openstreetmap.josm.gui.preferences.TaggingPresetPreference;
import org.openstreetmap.josm.gui.preferences.ToolbarPreferences;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.OsmUrlToBounds;
import org.openstreetmap.josm.tools.PlatformHook;
import org.openstreetmap.josm.tools.PlatformHookOsx;
import org.openstreetmap.josm.tools.PlatformHookUnixoid;
import org.openstreetmap.josm.tools.PlatformHookWindows;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Main {
    public static Component parent;
    public static Main main;
    public static final ExecutorService worker;
    public static Preferences pref;
    public static PrimitiveDeepCopy pasteBuffer;
    public static Layer pasteSource;
    public static Projection proj;
    public static MapFrame map;
    public static boolean applet;
    public static ToolbarPreferences toolbar;
    public UndoRedoHandler undoRedo = new UndoRedoHandler();
    public final MainMenu menu;
    private GettingStarted gettingStarted = new GettingStarted();
    public static int debug_level;
    public static PlatformHook platform;
    public static boolean isOpenjdk;
    protected static JPanel contentPanePrivate;
    @Deprecated
    public static final JPanel contentPane;
    public static JPanel panel;
    protected static Rectangle bounds;
    protected static int windowState;
    private final OsmDataLayer.CommandQueueListener redoUndoListener = new OsmDataLayer.CommandQueueListener(){

        public void commandChanged(int queueSize, int redoSize) {
            Main.this.menu.undo.setEnabled(queueSize > 0);
            Main.this.menu.redo.setEnabled(redoSize > 0);
        }
    };

    public static boolean isDisplayingMapView() {
        if (map == null) {
            return false;
        }
        return Main.map.mapView != null;
    }

    public static final void debug(String msg) {
        if (debug_level <= 0) {
            return;
        }
        System.out.println(msg);
    }

    public final void setMapFrame(MapFrame map) {
        MapFrame old = Main.map;
        panel.setVisible(false);
        panel.removeAll();
        if (map != null) {
            map.fillPanel(panel);
        } else {
            old.destroy();
            panel.add((Component)this.gettingStarted, "Center");
        }
        panel.setVisible(true);
        this.redoUndoListener.commandChanged(0, 0);
        Main.map = map;
        PluginHandler.notifyMapFrameChanged(old, map);
    }

    public final void removeLayer(Layer layer) {
        if (map != null) {
            Main.map.mapView.removeLayer(layer);
            if (Main.map.mapView.getAllLayers().isEmpty()) {
                this.setMapFrame(null);
            }
        }
    }

    public Main() {
        main = this;
        isOpenjdk = System.getProperty("java.vm.name").toUpperCase().indexOf("OPENJDK") != -1;
        platform.startupHook();
        contentPanePrivate.add((Component)panel, "Center");
        panel.add((Component)this.gettingStarted, "Center");
        this.menu = new MainMenu();
        this.undoRedo.listenerCommands.add(this.redoUndoListener);
        contentPanePrivate.add((Component)Main.toolbar.control, "North");
        Main.registerActionShortcut((Action)this.menu.help, Shortcut.registerShortcut("system:help", I18n.tr("Help"), 112, 5));
        TaggingPresetPreference.initialize();
        MapPaintPreference.initialize();
        toolbar.refreshToolbarControl();
        Main.toolbar.control.updateUI();
        contentPanePrivate.updateUI();
    }

    public final void addLayer(Layer layer) {
        if (map == null) {
            MapFrame mapFrame = new MapFrame(contentPanePrivate);
            this.setMapFrame(mapFrame);
            mapFrame.selectMapMode((MapMode)mapFrame.getDefaultButtonAction());
            mapFrame.setVisible(true);
            mapFrame.initializeDialogsPane();
            layer.addPropertyChangeListener(LayerListDialog.getInstance().getModel());
        }
        Main.map.mapView.addLayer(layer);
    }

    public boolean hasEditLayer() {
        return this.getEditLayer() != null;
    }

    public OsmDataLayer getEditLayer() {
        if (map == null) {
            return null;
        }
        if (Main.map.mapView == null) {
            return null;
        }
        return Main.map.mapView.getEditLayer();
    }

    public DataSet getCurrentDataSet() {
        if (!this.hasEditLayer()) {
            return null;
        }
        return this.getEditLayer().data;
    }

    public Layer getActiveLayer() {
        if (map == null) {
            return null;
        }
        if (Main.map.mapView == null) {
            return null;
        }
        return Main.map.mapView.getActiveLayer();
    }

    public static void registerActionShortcut(Action action, Shortcut shortcut) {
        Main.registerActionShortcut(action, shortcut.getKeyStroke());
    }

    public static void registerActionShortcut(Action action, KeyStroke keyStroke) {
        if (keyStroke == null) {
            return;
        }
        InputMap inputMap = contentPanePrivate.getInputMap(2);
        Object existing = inputMap.get(keyStroke);
        if (existing != null && !existing.equals(action)) {
            System.out.println(String.format("Keystroke %s is already assigned to %s, will be overridden by %s", keyStroke, existing, action));
        }
        inputMap.put(keyStroke, action);
        contentPanePrivate.getActionMap().put(action, action);
    }

    public static void unregisterActionShortcut(Shortcut shortcut) {
        contentPanePrivate.getInputMap(2).remove(shortcut.getKeyStroke());
    }

    public static void preConstructorInit(Map<String, Collection<String>> args) {
        ProjectionPreference.setProjection();
        try {
            String defaultlaf = platform.getDefaultStyle();
            String laf = pref.get("laf", defaultlaf);
            try {
                UIManager.setLookAndFeel(laf);
            }
            catch (ClassNotFoundException e) {
                System.out.println("Look and Feel not found: " + laf);
                pref.put("laf", defaultlaf);
            }
            catch (UnsupportedLookAndFeelException e) {
                System.out.println("Look and Feel not supported: " + laf);
                pref.put("laf", defaultlaf);
            }
            toolbar = new ToolbarPreferences();
            contentPanePrivate.updateUI();
            panel.updateUI();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        UIManager.put("OptionPane.okIcon", ImageProvider.get("ok"));
        UIManager.put("OptionPane.yesIcon", UIManager.get("OptionPane.okIcon"));
        UIManager.put("OptionPane.cancelIcon", ImageProvider.get("cancel"));
        UIManager.put("OptionPane.noIcon", UIManager.get("OptionPane.cancelIcon"));
        I18n.fixJFileChooser();
        try {
            CoordinateFormat.setCoordinateFormat(CoordinateFormat.valueOf(pref.get("coordinates")));
        }
        catch (IllegalArgumentException iae) {
            CoordinateFormat.setCoordinateFormat(CoordinateFormat.DECIMAL_DEGREES);
        }
        Dimension screenDimension = Toolkit.getDefaultToolkit().getScreenSize();
        String geometry = null;
        geometry = args.containsKey("geometry") ? args.get("geometry").iterator().next() : pref.get("gui.geometry");
        if (geometry.length() != 0) {
            Matcher m = Pattern.compile("(\\d+)x(\\d+)(([+-])(\\d+)([+-])(\\d+))?").matcher(geometry);
            if (m.matches()) {
                int w = Integer.valueOf(m.group(1));
                int h = Integer.valueOf(m.group(2));
                int x = 0;
                int y = 0;
                if (m.group(3) != null) {
                    x = Integer.valueOf(m.group(5));
                    y = Integer.valueOf(m.group(7));
                    if (m.group(4).equals("-")) {
                        x = screenDimension.width - x - w;
                    }
                    if (m.group(6).equals("-")) {
                        y = screenDimension.height - y - h;
                    }
                }
                if (x > Toolkit.getDefaultToolkit().getScreenSize().width - 10) {
                    x = 0;
                }
                if (y > Toolkit.getDefaultToolkit().getScreenSize().height - 10) {
                    y = 0;
                }
                bounds = new Rectangle(x, y, w, h);
                if (!pref.get("gui.geometry").equals(geometry)) {
                    pref.put("gui.geometry", geometry);
                }
            } else {
                System.out.println("Ignoring malformed geometry: " + geometry);
            }
        }
        if (bounds == null) {
            bounds = !args.containsKey("no-maximize") ? new Rectangle(0, 0, screenDimension.width, screenDimension.height) : new Rectangle(1000, 740);
        }
    }

    public void postConstructorProcessCmdLine(Map<String, Collection<String>> args) {
        if (args.containsKey("download")) {
            ArrayList<File> fileList = new ArrayList<File>();
            for (String s : args.get("download")) {
                File f = null;
                switch (this.paramType(s)) {
                    case httpUrl: {
                        Main.downloadFromParamHttp(false, s);
                        break;
                    }
                    case bounds: {
                        Main.downloadFromParamBounds(false, s);
                        break;
                    }
                    case fileUrl: {
                        try {
                            f = new File(new URI(s));
                        }
                        catch (URISyntaxException e) {
                            JOptionPane.showMessageDialog(parent, I18n.tr("Ignoring malformed file URL: \"{0}\"", s), I18n.tr("Warning"), 2);
                        }
                        if (f == null) break;
                        fileList.add(f);
                        break;
                    }
                    case fileName: {
                        f = new File(s);
                        fileList.add(f);
                    }
                }
            }
            if (!fileList.isEmpty()) {
                OpenFileAction.openFiles(fileList);
            }
        }
        if (args.containsKey("downloadgps")) {
            for (String s : args.get("downloadgps")) {
                switch (this.paramType(s)) {
                    case httpUrl: {
                        Main.downloadFromParamHttp(true, s);
                        break;
                    }
                    case bounds: {
                        Main.downloadFromParamBounds(true, s);
                        break;
                    }
                    case fileUrl: 
                    case fileName: {
                        JOptionPane.showMessageDialog(parent, I18n.tr("Parameter \"downloadgps\" does not accept file names or file URLs"), I18n.tr("Warning"), 2);
                    }
                }
            }
        }
        if (args.containsKey("selection")) {
            for (String s : args.get("selection")) {
                SearchAction.search(s, SearchAction.SearchMode.add);
            }
        }
    }

    public static boolean saveUnsavedModifications() {
        if (map == null) {
            return true;
        }
        SaveLayersDialog dialog = new SaveLayersDialog(parent);
        ArrayList<OsmDataLayer> layersWithUnmodifiedChanges = new ArrayList<OsmDataLayer>();
        for (OsmDataLayer l : Main.map.mapView.getLayersOfType(OsmDataLayer.class)) {
            if (!l.requiresSaveToFile() && !l.requiresUploadToServer()) continue;
            layersWithUnmodifiedChanges.add(l);
        }
        dialog.prepareForSavingAndUpdatingLayersBeforeExit();
        if (!layersWithUnmodifiedChanges.isEmpty()) {
            dialog.getModel().populate(layersWithUnmodifiedChanges);
            dialog.setVisible(true);
            switch (dialog.getUserAction()) {
                case CANCEL: {
                    return false;
                }
                case PROCEED: {
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    private DownloadParamType paramType(String s) {
        if (s.startsWith("http:")) {
            return DownloadParamType.httpUrl;
        }
        if (s.startsWith("file:")) {
            return DownloadParamType.fileUrl;
        }
        StringTokenizer st = new StringTokenizer(s, ",");
        if (st.countTokens() == 4) {
            return DownloadParamType.bounds;
        }
        return DownloadParamType.fileName;
    }

    private static void downloadFromParamHttp(boolean rawGps, String s) {
        Bounds b = OsmUrlToBounds.parse(s);
        if (b == null) {
            JOptionPane.showMessageDialog(parent, I18n.tr("Ignoring malformed URL: \"{0}\"", s), I18n.tr("Warning"), 2);
        } else {
            Main.downloadFromParamBounds(rawGps, b);
        }
    }

    private static void downloadFromParamBounds(boolean rawGps, String s) {
        StringTokenizer st = new StringTokenizer(s, ",");
        if (st.countTokens() == 4) {
            Bounds b = new Bounds(new LatLon(Double.parseDouble(st.nextToken()), Double.parseDouble(st.nextToken())), new LatLon(Double.parseDouble(st.nextToken()), Double.parseDouble(st.nextToken())));
            Main.downloadFromParamBounds(rawGps, b);
        }
    }

    private static void downloadFromParamBounds(boolean rawGps, Bounds b) {
        AbstractDownloadTask task = rawGps ? new DownloadGpsTask() : new DownloadOsmTask();
        Future<?> future = task.download(true, b, null);
        worker.execute(new PostDownloadHandler((DownloadTask)task, future));
    }

    public static void determinePlatformHook() {
        String os = System.getProperty("os.name");
        if (os == null) {
            System.err.println("Your operating system has no name, so I'm guessing its some kind of *nix.");
            platform = new PlatformHookUnixoid();
        } else if (os.toLowerCase().startsWith("windows")) {
            platform = new PlatformHookWindows();
        } else if (os.equals("Linux") || os.equals("Solaris") || os.equals("SunOS") || os.equals("AIX") || os.equals("FreeBSD") || os.equals("NetBSD") || os.equals("OpenBSD")) {
            platform = new PlatformHookUnixoid();
        } else if (os.toLowerCase().startsWith("mac os x")) {
            platform = new PlatformHookOsx();
        } else {
            System.err.println("I don't know your operating system '" + os + "', so I'm guessing its some kind of *nix.");
            platform = new PlatformHookUnixoid();
        }
    }

    public static void saveGuiGeometry() {
        String newGeometry = "";
        String newToggleDlgWidth = null;
        try {
            Dimension screenDimension = Toolkit.getDefaultToolkit().getScreenSize();
            int width = (int)bounds.getWidth();
            int height = (int)bounds.getHeight();
            int x = (int)bounds.getX();
            int y = (int)bounds.getY();
            if (width > screenDimension.width) {
                width = screenDimension.width;
            }
            if (height > screenDimension.height) {
                width = screenDimension.height;
            }
            if (x < 0) {
                x = 0;
            }
            if (y < 0) {
                y = 0;
            }
            newGeometry = width + "x" + height + "+" + x + "+" + y;
            if (map != null && (newToggleDlgWidth = Integer.toString(map.getToggleDlgWidth())).equals(Integer.toString(Main.map.DEF_TOGGLE_DLG_WIDTH))) {
                newToggleDlgWidth = "";
            }
        }
        catch (Exception e) {
            System.out.println("Failed to get GUI geometry: " + e);
            e.printStackTrace();
        }
        boolean maximized = (windowState & 6) != 0;
        pref.put("gui.maximized", maximized);
        pref.put("gui.geometry", newGeometry);
        if (newToggleDlgWidth != null) {
            pref.put("toggleDialogs.width", newToggleDlgWidth);
        }
    }

    public static void addListener() {
        parent.addComponentListener(new WindowPositionSizeListener());
        ((JFrame)parent).addWindowStateListener(new WindowPositionSizeListener());
    }

    static {
        worker = Executors.newSingleThreadExecutor();
        pref = new Preferences();
        pasteBuffer = new PrimitiveDeepCopy();
        applet = false;
        debug_level = 1;
        contentPane = contentPanePrivate = new JPanel(new BorderLayout());
        panel = new JPanel(new BorderLayout());
        windowState = 0;
    }

    private static class WindowPositionSizeListener
    extends WindowAdapter
    implements ComponentListener {
        private WindowPositionSizeListener() {
        }

        public void windowStateChanged(WindowEvent e) {
            windowState = e.getNewState();
        }

        public void componentHidden(ComponentEvent e) {
        }

        public void componentMoved(ComponentEvent e) {
            this.handleComponentEvent(e);
        }

        public void componentResized(ComponentEvent e) {
            this.handleComponentEvent(e);
        }

        public void componentShown(ComponentEvent e) {
        }

        private void handleComponentEvent(ComponentEvent e) {
            Component c = e.getComponent();
            if (c instanceof JFrame && windowState == 0) {
                bounds = ((JFrame)c).getBounds();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum DownloadParamType {
        httpUrl,
        fileUrl,
        bounds,
        fileName;

    }
}

