/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.corrector.ReverseWayTagCorrector;
import org.openstreetmap.josm.corrector.UserCancelException;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReverseWayAction
extends JosmAction {
    public ReverseWayAction() {
        super(I18n.tr("Reverse Ways"), "wayflip", I18n.tr("Reverse the direction of all selected ways."), Shortcut.registerShortcut("tools:reverse", I18n.tr("Tool: {0}", I18n.tr("Reverse Ways")), 82, 3), true);
        this.putValue("help", HelpUtil.ht("/Action/ReverseWay"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.getCurrentDataSet() == null) {
            return;
        }
        Collection<Way> sel = this.getCurrentDataSet().getSelectedWays();
        if (sel.isEmpty()) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Please select at least one way."), I18n.tr("Information"), 1);
            return;
        }
        boolean propertiesUpdated = false;
        ReverseWayTagCorrector reverseWayTagCorrector = new ReverseWayTagCorrector();
        LinkedList<Command> c = new LinkedList<Command>();
        for (Way w : sel) {
            Way wnew = new Way(w);
            List<Node> nodesCopy = wnew.getNodes();
            Collections.reverse(nodesCopy);
            wnew.setNodes(nodesCopy);
            if (Main.pref.getBoolean("tag-correction.reverse-way", true)) {
                try {
                    Collection<Command> changePropertyCommands = reverseWayTagCorrector.execute(w, wnew);
                    propertiesUpdated = propertiesUpdated || changePropertyCommands != null && !changePropertyCommands.isEmpty();
                    c.addAll(changePropertyCommands);
                }
                catch (UserCancelException ex) {
                    return;
                }
            }
            c.add(new ChangeCommand(w, wnew));
        }
        Main.main.undoRedo.add(new SequenceCommand(I18n.tr("Reverse ways"), c));
        if (propertiesUpdated) {
            this.getCurrentDataSet().fireSelectionChanged();
        }
        Main.map.repaint();
    }

    protected int getNumWaysInSelection() {
        if (this.getCurrentDataSet() == null) {
            return 0;
        }
        int ret = 0;
        for (OsmPrimitive primitive : this.getCurrentDataSet().getSelected()) {
            if (!(primitive instanceof Way)) continue;
            ++ret;
        }
        return ret;
    }

    @Override
    protected void updateEnabledState() {
        if (this.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(this.getCurrentDataSet().getSelected());
        }
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        if (selection == null) {
            this.setEnabled(false);
            return;
        }
        int n = 0;
        for (OsmPrimitive osmPrimitive : selection) {
            if (!(osmPrimitive instanceof Way)) continue;
            ++n;
        }
        this.setEnabled(n > 0);
    }
}

