/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SplitWayAction
extends JosmAction {
    public SplitWayAction() {
        super(I18n.tr("Split Way"), "splitway", I18n.tr("Split a way at the selected node."), Shortcut.registerShortcut("tools:splitway", I18n.tr("Tool: {0}", I18n.tr("Split Way")), 80, 3), true);
        this.putValue("help", HelpUtil.ht("/Action/SplitWay"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        List<List<Node>> wayChunks;
        Collection<OsmPrimitive> selection = this.getCurrentDataSet().getSelected();
        List<Node> selectedNodes = OsmPrimitive.getFilteredList(selection, Node.class);
        List<Way> selectedWays = OsmPrimitive.getFilteredList(selection, Way.class);
        if (!this.checkSelection(selection)) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("The current selection cannot be used for splitting."), I18n.tr("Warning"), 2);
            return;
        }
        Way selectedWay = null;
        if (!selectedWays.isEmpty()) {
            selectedWay = selectedWays.get(0);
        }
        if (selectedWay == null && !selectedNodes.isEmpty()) {
            HashMap<Way, Integer> wayOccurenceCounter = new HashMap<Way, Integer>();
            for (Node node : selectedNodes) {
                block1: for (Way w : OsmPrimitive.getFilteredList(node.getReferrers(), Way.class)) {
                    int last;
                    if (!w.isUsable() || (last = w.getNodesCount() - 1) <= 0) continue;
                    boolean circular = w.isClosed();
                    int i = 0;
                    for (Node wn : w.getNodes()) {
                        if ((circular || i > 0 && i < last) && node.equals(wn)) {
                            Integer old = (Integer)wayOccurenceCounter.get(w);
                            wayOccurenceCounter.put(w, old == null ? 1 : old + 1);
                            continue block1;
                        }
                        ++i;
                    }
                }
            }
            if (wayOccurenceCounter.isEmpty()) {
                JOptionPane.showMessageDialog(Main.parent, I18n.trn("The selected node is not in the middle of any way.", "The selected nodes are not in the middle of any way.", selectedNodes.size()), I18n.tr("Warning"), 2);
                return;
            }
            for (Map.Entry entry : wayOccurenceCounter.entrySet()) {
                if (!((Integer)entry.getValue()).equals(selectedNodes.size())) continue;
                if (selectedWay != null) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.trn("There is more than one way using the node you selected. Please select the way also.", "There is more than one way using the nodes you selected. Please select the way also.", selectedNodes.size()), I18n.tr("Warning"), 2);
                    return;
                }
                selectedWay = (Way)entry.getKey();
            }
            if (selectedWay == null) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("The selected nodes do not share the same way."), I18n.tr("Warning"), 2);
                return;
            }
        } else if (selectedWay != null && !selectedNodes.isEmpty()) {
            HashSet<Node> nds = new HashSet<Node>(selectedNodes);
            nds.removeAll(selectedWay.getNodes());
            if (!nds.isEmpty()) {
                JOptionPane.showMessageDialog(Main.parent, I18n.trn("The selected way does not contain the selected node.", "The selected way does not contain all the selected nodes.", selectedNodes.size()), I18n.tr("Warning"), 2);
                return;
            }
        }
        if ((wayChunks = SplitWayAction.buildSplitChunks(selectedWay, selectedNodes)) != null) {
            SplitWayResult result = SplitWayAction.splitWay(this.getEditLayer(), selectedWay, wayChunks);
            Main.main.undoRedo.add(result.getCommand());
            this.getCurrentDataSet().setSelected(result.getNewSelection());
        }
    }

    private boolean checkSelection(Collection<? extends OsmPrimitive> selection) {
        boolean way = false;
        boolean node = false;
        for (OsmPrimitive osmPrimitive : selection) {
            if (osmPrimitive instanceof Way && !way) {
                way = true;
                continue;
            }
            if (osmPrimitive instanceof Node) {
                node = true;
                continue;
            }
            return false;
        }
        return node;
    }

    public static List<List<Node>> buildSplitChunks(Way wayToSplit, List<Node> splitPoints) {
        CheckParameterUtil.ensureParameterNotNull(wayToSplit, "wayToSplit");
        CheckParameterUtil.ensureParameterNotNull(splitPoints, "splitPoints");
        HashSet<Node> nodeSet = new HashSet<Node>(splitPoints);
        LinkedList<List<Node>> wayChunks = new LinkedList<List<Node>>();
        ArrayList<Node> currentWayChunk = new ArrayList<Node>();
        wayChunks.add(currentWayChunk);
        Iterator<Node> it = wayToSplit.getNodes().iterator();
        while (it.hasNext()) {
            Node currentNode = it.next();
            boolean atEndOfWay = currentWayChunk.isEmpty() || !it.hasNext();
            currentWayChunk.add(currentNode);
            if (!nodeSet.contains(currentNode) || atEndOfWay) continue;
            currentWayChunk = new ArrayList();
            currentWayChunk.add(currentNode);
            wayChunks.add(currentWayChunk);
        }
        List lastWayChunk = (List)wayChunks.get(wayChunks.size() - 1);
        if (wayChunks.size() >= 2 && ((List)wayChunks.get(0)).get(0) == lastWayChunk.get(lastWayChunk.size() - 1) && !nodeSet.contains(((List)wayChunks.get(0)).get(0))) {
            if (wayChunks.size() == 2) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("You must select two or more nodes to split a circular way."), I18n.tr("Warning"), 2);
                return null;
            }
            lastWayChunk.remove(lastWayChunk.size() - 1);
            lastWayChunk.addAll((Collection)wayChunks.get(0));
            wayChunks.remove(wayChunks.size() - 1);
            wayChunks.set(0, lastWayChunk);
        }
        if (wayChunks.size() < 2) {
            if (((List)wayChunks.get(0)).get(0) == ((List)wayChunks.get(0)).get(((List)wayChunks.get(0)).size() - 1)) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("You must select two or more nodes to split a circular way."), I18n.tr("Warning"), 2);
            } else {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("The way cannot be split at the selected nodes. (Hint: Select nodes in the middle of the way.)"), I18n.tr("Warning"), 2);
            }
            return null;
        }
        return wayChunks;
    }

    public static SplitWayResult splitWay(OsmDataLayer layer, Way way, List<List<Node>> wayChunks) {
        ArrayList<Command> commandList = new ArrayList<Command>(wayChunks.size());
        ArrayList<Way> newSelection = new ArrayList<Way>(wayChunks.size());
        Iterator<List<Node>> chunkIt = wayChunks.iterator();
        Way changedWay = new Way(way);
        changedWay.setNodes(chunkIt.next());
        commandList.add(new ChangeCommand(way, changedWay));
        newSelection.add(way);
        ArrayList<Way> newWays = new ArrayList<Way>();
        while (chunkIt.hasNext()) {
            Way wayToAdd = new Way();
            wayToAdd.setKeys(way.getKeys());
            newWays.add(wayToAdd);
            wayToAdd.setNodes(chunkIt.next());
            commandList.add(new AddCommand(layer, wayToAdd));
            newSelection.add(wayToAdd);
        }
        boolean warnmerole = false;
        boolean warnme = false;
        for (Relation r : OsmPrimitive.getFilteredList(way.getReferrers(), Relation.class)) {
            if (!r.isUsable()) continue;
            Relation c = null;
            String type = r.get("type");
            if (type == null) {
                type = "";
            }
            int i = 0;
            List<RelationMember> relationMembers = r.getMembers();
            for (RelationMember rm : relationMembers) {
                if (rm.isWay() && rm.getMember() == way) {
                    boolean insert = true;
                    if ("restriction".equals(type)) {
                        String role = rm.getRole();
                        if ("from".equals(role) || "to".equals(role)) {
                            OsmPrimitive via = null;
                            for (RelationMember rmv : r.getMembers()) {
                                if (!"via".equals(rmv.getRole())) continue;
                                via = rmv.getMember();
                            }
                            ArrayList<Node> nodes = new ArrayList<Node>();
                            if (via != null) {
                                if (via instanceof Node) {
                                    nodes.add((Node)via);
                                } else if (via instanceof Way) {
                                    nodes.add(((Way)via).lastNode());
                                    nodes.add(((Way)via).firstNode());
                                }
                            }
                            Way res = null;
                            for (Node n : nodes) {
                                if (!changedWay.isFirstLastNode(n)) continue;
                                res = way;
                            }
                            if (res == null) {
                                for (Way wayToAdd : newWays) {
                                    for (Node n : nodes) {
                                        if (!wayToAdd.isFirstLastNode(n)) continue;
                                        res = wayToAdd;
                                    }
                                }
                                if (res != null) {
                                    if (c == null) {
                                        c = new Relation(r);
                                    }
                                    c.addMember(new RelationMember(role, res));
                                    c.removeMembersFor(way);
                                    insert = false;
                                }
                            } else {
                                insert = false;
                            }
                        } else if (!"via".equals(role)) {
                            warnme = true;
                        }
                    } else if (!"route".equals(type) && !"multipolygon".equals(type)) {
                        warnme = true;
                    }
                    if (c == null) {
                        c = new Relation(r);
                    }
                    if (insert) {
                        if (rm.hasRole() && !"multipolygon".equals(type)) {
                            warnmerole = true;
                        }
                        Boolean backwards = null;
                        int k = 1;
                        while (i - k >= 0 || i + k < relationMembers.size()) {
                            Way w;
                            if (i - k >= 0 && relationMembers.get(i - k).isWay()) {
                                w = relationMembers.get(i - k).getWay();
                                if (w.lastNode() == way.firstNode() || w.firstNode() == way.firstNode()) {
                                    backwards = false;
                                    break;
                                }
                                if (w.firstNode() != way.lastNode() && w.lastNode() != way.lastNode()) break;
                                backwards = true;
                                break;
                            }
                            if (i + k < relationMembers.size() && relationMembers.get(i + k).isWay()) {
                                w = relationMembers.get(i + k).getWay();
                                if (w.lastNode() == way.firstNode() || w.firstNode() == way.firstNode()) {
                                    backwards = true;
                                    break;
                                }
                                if (w.firstNode() != way.lastNode() && w.lastNode() != way.lastNode()) break;
                                backwards = false;
                                break;
                            }
                            ++k;
                        }
                        int j = i;
                        for (Way wayToAdd : newWays) {
                            RelationMember em = new RelationMember(rm.getRole(), wayToAdd);
                            ++j;
                            if (backwards != null && backwards.booleanValue()) {
                                c.addMember(i, em);
                                continue;
                            }
                            c.addMember(j, em);
                        }
                        i = j;
                    }
                }
                ++i;
            }
            if (c == null) continue;
            commandList.add(new ChangeCommand(layer, r, c));
        }
        if (warnmerole) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>A role based relation membership was copied to all new ways.<br>You should verify this and correct it when necessary.</html>"), I18n.tr("Warning"), 2);
        } else if (warnme) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>A relation membership was copied to all new ways.<br>You should verify this and correct it when necessary.</html>"), I18n.tr("Warning"), 2);
        }
        return new SplitWayResult(new SequenceCommand(I18n.tr("Split way {0} into {1} parts", way.getDisplayName(DefaultNameFormatter.getInstance()), wayChunks.size()), commandList), newSelection, way, newWays);
    }

    public static SplitWayResult split(OsmDataLayer layer, Way way, List<Node> atNodes) {
        List<List<Node>> chunks = SplitWayAction.buildSplitChunks(way, atNodes);
        if (chunks == null) {
            return null;
        }
        return SplitWayAction.splitWay(layer, way, chunks);
    }

    @Override
    protected void updateEnabledState() {
        if (this.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(this.getCurrentDataSet().getSelected());
        }
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        if (selection == null) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(this.checkSelection(selection));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SplitWayResult {
        private final Command command;
        private final List<? extends PrimitiveId> newSelection;
        private Way originalWay;
        private List<Way> newWays;

        public SplitWayResult(Command command, List<? extends PrimitiveId> newSelection, Way originalWay, List<Way> newWays) {
            this.command = command;
            this.newSelection = newSelection;
            this.originalWay = originalWay;
            this.newWays = newWays;
        }

        public Command getCommand() {
            return this.command;
        }

        public List<? extends PrimitiveId> getNewSelection() {
            return this.newSelection;
        }

        public Way getOriginalWay() {
            return this.originalWay;
        }

        public List<Way> getNewWays() {
            return this.newWays;
        }
    }
}

