/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.mapmode;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.util.LinkedList;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.MoveCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.osm.visitor.paint.PaintColors;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.MapViewPaintable;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public class ExtrudeAction
extends MapMode
implements MapViewPaintable {
    private Mode mode = Mode.select;
    private long mouseDownTime = 0L;
    private WaySegment selectedSegment = null;
    private Color selectedColor;
    private Cursor oldCursor;
    private Point initialMousePos;
    private int initialMoveDelay = 200;
    private EastNorth initialN1en;
    private EastNorth initialN2en;
    private EastNorth newN1en;
    private EastNorth newN2en;
    private EastNorth lastTranslatedN1en;

    public ExtrudeAction(MapFrame mapFrame) {
        super(I18n.tr("Extrude"), "extrude/extrude", I18n.tr("Create areas"), Shortcut.registerShortcut("mapmode:extrude", I18n.tr("Mode: {0}", I18n.tr("Extrude")), 88, 3), mapFrame, ExtrudeAction.getCursor("normal", "rectangle", 0));
        this.putValue("help", "Action/Extrude/Extrude");
        this.initialMoveDelay = Main.pref.getInteger("edit.initial-move-delay", 200);
        this.selectedColor = PaintColors.SELECTED.get();
    }

    private static Cursor getCursor(String name, String mod, int def) {
        try {
            return ImageProvider.getCursor(name, mod);
        }
        catch (Exception exception) {
            return Cursor.getPredefinedCursor(def);
        }
    }

    private void setCursor(Cursor c) {
        if (this.oldCursor == null) {
            this.oldCursor = Main.map.mapView.getCursor();
            Main.map.mapView.setCursor(c);
        }
    }

    private void restoreCursor() {
        if (this.oldCursor != null) {
            Main.map.mapView.setCursor(this.oldCursor);
            this.oldCursor = null;
        }
    }

    public void enterMode() {
        super.enterMode();
        Main.map.mapView.addMouseListener(this);
        Main.map.mapView.addMouseMotionListener(this);
    }

    public void exitMode() {
        super.exitMode();
        Main.map.mapView.removeMouseListener(this);
        Main.map.mapView.removeMouseMotionListener(this);
        Main.map.mapView.removeTemporaryLayer(this);
    }

    public void mouseDragged(MouseEvent e) {
        if (!Main.map.mapView.isActiveLayerVisible()) {
            return;
        }
        if (System.currentTimeMillis() - this.mouseDownTime < (long)this.initialMoveDelay) {
            return;
        }
        if (this.mode != Mode.select) {
            Node nd1 = this.selectedSegment.way.getNode(this.selectedSegment.lowerIndex);
            Node nd2 = this.selectedSegment.way.getNode(this.selectedSegment.lowerIndex + 1);
            EastNorth en1 = nd1.getEastNorth();
            EastNorth en2 = nd2.getEastNorth();
            EastNorth en3 = Main.map.mapView.getEastNorth(e.getPoint().x, e.getPoint().y);
            double u = ((en3.east() - en1.east()) * (en2.east() - en1.east()) + (en3.north() - en1.north()) * (en2.north() - en1.north())) / en2.distanceSq(en1);
            EastNorth base = new EastNorth(en1.east() + u * (en2.east() - en1.east()), en1.north() + u * (en2.north() - en1.north()));
            double distance = Main.proj.eastNorth2latlon(base).greatCircleDistance(Main.proj.eastNorth2latlon(en3));
            Main.map.statusLine.setDist(distance);
            this.updateStatusLine();
            double xoff = en3.east() - base.east();
            double yoff = en3.north() - base.north();
            this.newN1en = new EastNorth(en1.getX() + xoff, en1.getY() + yoff);
            this.newN2en = new EastNorth(en2.getX() + xoff, en2.getY() + yoff);
            Main.map.statusLine.setDist(Main.proj.eastNorth2latlon(this.initialN1en).greatCircleDistance(Main.proj.eastNorth2latlon(this.newN1en)));
            this.updateStatusLine();
            this.setCursor(Cursor.getPredefinedCursor(13));
            if (this.mode != Mode.extrude && this.mode == Mode.translate) {
                Command c;
                Command command = c = !Main.main.undoRedo.commands.isEmpty() ? Main.main.undoRedo.commands.getLast() : null;
                if (c instanceof SequenceCommand) {
                    c = ((SequenceCommand)c).getLastCommand();
                }
                Node n1 = this.selectedSegment.way.getNode(this.selectedSegment.lowerIndex);
                Node n2 = this.selectedSegment.way.getNode(this.selectedSegment.lowerIndex + 1);
                EastNorth difference = new EastNorth(this.newN1en.getX() - this.lastTranslatedN1en.getX(), this.newN1en.getY() - this.lastTranslatedN1en.getY());
                if (c instanceof MoveCommand && ((MoveCommand)c).getParticipatingPrimitives().contains(n1) && ((MoveCommand)c).getParticipatingPrimitives().contains(n2) && ((MoveCommand)c).getParticipatingPrimitives().size() == 2) {
                    ((MoveCommand)c).moveAgain(difference.getX(), difference.getY());
                    this.lastTranslatedN1en = this.newN1en;
                } else {
                    LinkedList<OsmPrimitive> nodelist = new LinkedList<OsmPrimitive>();
                    nodelist.add(n1);
                    nodelist.add(n2);
                    c = new MoveCommand(nodelist, difference.getX(), difference.getY());
                    Main.main.undoRedo.add(c);
                    this.lastTranslatedN1en = this.newN1en;
                }
            }
            Main.map.mapView.repaint();
        }
    }

    private static Line2D createSemiInfiniteLine(Point2D start, Point2D unitvector, Graphics2D g) {
        Rectangle bounds = g.getDeviceConfiguration().getBounds();
        try {
            AffineTransform invtrans = g.getTransform().createInverse();
            Point2D widthpoint = invtrans.deltaTransform(new Point2D.Double(bounds.width, 0.0), null);
            Point2D heightpoint = invtrans.deltaTransform(new Point2D.Double(0.0, bounds.height), null);
            double linelength = Math.abs(widthpoint.getX()) + Math.abs(widthpoint.getY()) + Math.abs(heightpoint.getX()) + Math.abs(heightpoint.getY());
            return new Line2D.Double(start, new Point2D.Double(start.getX() + unitvector.getX() * linelength, start.getY() + unitvector.getY() * linelength));
        }
        catch (NoninvertibleTransformException e) {
            return new Line2D.Double(start, new Point2D.Double(start.getX() + unitvector.getX() * 10.0, start.getY() + unitvector.getY() * 10.0));
        }
    }

    public void paint(Graphics2D g, MapView mv, Bounds box) {
        if (this.mode != Mode.select && this.newN1en != null) {
            Graphics2D g2 = g;
            g2.setColor(this.selectedColor);
            g2.setStroke(new BasicStroke(3.0f, 1, 1));
            Point p1 = mv.getPoint(this.initialN1en);
            Point p2 = mv.getPoint(this.initialN2en);
            Point p3 = mv.getPoint(this.newN1en);
            Point p4 = mv.getPoint(this.newN2en);
            if (this.mode == Mode.extrude) {
                GeneralPath b = new GeneralPath();
                b.moveTo(p1.x, p1.y);
                b.lineTo(p3.x, p3.y);
                b.lineTo(p4.x, p4.y);
                b.lineTo(p2.x, p2.y);
                b.lineTo(p1.x, p1.y);
                g2.draw(b);
                g2.setStroke(new BasicStroke(1.0f));
            } else if (this.mode == Mode.translate) {
                Line2D.Double newline = new Line2D.Double(p3, p4);
                g2.draw(newline);
                g2.setStroke(new BasicStroke(1.0f));
                Line2D.Double oldline = new Line2D.Double(p1, p2);
                g2.draw(oldline);
                EastNorth segmentVector = new EastNorth(this.initialN2en.getX() - this.initialN1en.getX(), this.initialN2en.getY() - this.initialN1en.getY());
                double fac = 1.0 / Math.hypot(segmentVector.getX(), segmentVector.getY());
                EastNorth normalUnitVector = new EastNorth(segmentVector.getY() * fac, segmentVector.getX() * fac);
                Point2D.Double centerpoint = new Point2D.Double((p1.getX() + p2.getX()) * 0.5, (p1.getY() + p2.getY()) * 0.5);
                EastNorth drawnorm = this.newN1en == null || this.newN1en.getX() > this.initialN1en.getX() == normalUnitVector.getX() > -0.0 ? normalUnitVector : new EastNorth(-normalUnitVector.getX(), -normalUnitVector.getY());
                Line2D normline = ExtrudeAction.createSemiInfiniteLine(centerpoint, drawnorm, g2);
                g2.draw(normline);
                double factor = 1.0 / g2.getTransform().getScaleX();
                double raoffsetx = 8.0 * factor * drawnorm.getX();
                double raoffsety = 8.0 * factor * drawnorm.getY();
                Point2D.Double ra1 = new Point2D.Double(((Point2D)centerpoint).getX() + raoffsetx, ((Point2D)centerpoint).getY() + raoffsety);
                Point2D.Double ra3 = new Point2D.Double(((Point2D)centerpoint).getX() - raoffsety, ((Point2D)centerpoint).getY() + raoffsetx);
                Point2D.Double ra2 = new Point2D.Double(((Point2D)ra1).getX() - raoffsety, ((Point2D)ra1).getY() + raoffsetx);
                GeneralPath ra = new GeneralPath();
                ra.moveTo((float)((Point2D)ra1).getX(), (float)((Point2D)ra1).getY());
                ra.lineTo((float)((Point2D)ra2).getX(), (float)((Point2D)ra2).getY());
                ra.lineTo((float)((Point2D)ra3).getX(), (float)((Point2D)ra3).getY());
                g2.draw(ra);
            }
        }
    }

    public void mousePressed(MouseEvent e) {
        if (!Main.map.mapView.isActiveLayerVisible()) {
            return;
        }
        if (!((Boolean)this.getValue("active")).booleanValue()) {
            return;
        }
        if (e.getButton() != 1) {
            return;
        }
        this.selectedSegment = Main.map.mapView.getNearestWaySegment(e.getPoint(), OsmPrimitive.isSelectablePredicate);
        if (this.selectedSegment != null) {
            this.initialN1en = this.selectedSegment.way.getNode(this.selectedSegment.lowerIndex).getEastNorth();
            this.initialN2en = this.selectedSegment.way.getNode(this.selectedSegment.lowerIndex + 1).getEastNorth();
            this.newN1en = null;
            this.newN2en = null;
            Main.map.mapView.addTemporaryLayer(this);
            this.updateStatusLine();
            Main.map.mapView.repaint();
            this.mouseDownTime = System.currentTimeMillis();
            this.initialMousePos = e.getPoint();
            if ((e.getModifiers() & 2) != 0) {
                this.mode = Mode.translate;
                this.lastTranslatedN1en = this.initialN1en;
            } else {
                this.mode = Mode.extrude;
                this.getCurrentDataSet().setSelected(this.selectedSegment.way);
            }
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (!Main.map.mapView.isActiveLayerVisible()) {
            return;
        }
        if (this.mode != Mode.select) {
            if (this.mode == Mode.extrude) {
                if (e.getPoint().distance(this.initialMousePos) > 10.0 && this.newN1en != null) {
                    Node n1 = this.selectedSegment.way.getNode(this.selectedSegment.lowerIndex);
                    Node n3 = new Node(Main.proj.eastNorth2latlon(this.newN2en));
                    Node n4 = new Node(Main.proj.eastNorth2latlon(this.newN1en));
                    Way wnew = new Way(this.selectedSegment.way);
                    wnew.addNode(this.selectedSegment.lowerIndex + 1, n3);
                    wnew.addNode(this.selectedSegment.lowerIndex + 1, n4);
                    if (wnew.getNodesCount() == 4) {
                        wnew.addNode(n1);
                    }
                    LinkedList<Command> cmds = new LinkedList<Command>();
                    cmds.add(new AddCommand(n4));
                    cmds.add(new AddCommand(n3));
                    cmds.add(new ChangeCommand(this.selectedSegment.way, wnew));
                    SequenceCommand c = new SequenceCommand(I18n.tr("Extrude Way"), cmds);
                    Main.main.undoRedo.add(c);
                }
            } else if (this.mode == Mode.translate) {
                // empty if block
            }
            this.restoreCursor();
            Main.map.mapView.removeTemporaryLayer(this);
            this.selectedSegment = null;
            this.mode = Mode.select;
            this.updateStatusLine();
            Main.map.mapView.repaint();
        }
    }

    public String getModeHelpText() {
        if (this.mode == Mode.translate) {
            return I18n.tr("Move a segment along its normal, then release the mouse button.");
        }
        if (this.mode == Mode.extrude) {
            return I18n.tr("Draw a rectangle of the desired size, then release the mouse button.");
        }
        return I18n.tr("Drag a way segment to make a rectangle. Ctrl-drag to move a segment along its normal.");
    }

    public boolean layerIsSupported(Layer l) {
        return l instanceof OsmDataLayer;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Mode {
        extrude,
        translate,
        select;

    }
}

