/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data;

import org.openstreetmap.josm.data.coor.EastNorth;

public class ProjectionBounds {
    public EastNorth min;
    public EastNorth max;

    public ProjectionBounds(EastNorth min, EastNorth max) {
        this.min = min;
        this.max = max;
    }

    public ProjectionBounds(EastNorth p) {
        this.min = p;
        this.max = p;
    }

    public ProjectionBounds(EastNorth center, double east, double north) {
        this.min = new EastNorth(center.east() - east / 2.0, center.north() - north / 2.0);
        this.max = new EastNorth(center.east() + east / 2.0, center.north() + north / 2.0);
    }

    public void extend(EastNorth e) {
        if (e.east() < this.min.east() || e.north() < this.min.north()) {
            this.min = new EastNorth(Math.min(e.east(), this.min.east()), Math.min(e.north(), this.min.north()));
        }
        if (e.east() > this.max.east() || e.north() > this.max.north()) {
            this.max = new EastNorth(Math.max(e.east(), this.max.east()), Math.max(e.north(), this.max.north()));
        }
    }

    public EastNorth getCenter() {
        return this.min.getCenter(this.max);
    }

    public String toString() {
        return "ProjectionBounds[" + this.min.east() + "," + this.min.north() + "," + this.max.east() + "," + this.max.north() + "]";
    }
}

