/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.awt.geom.Area;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.DataIntegrityProblemException;
import org.openstreetmap.josm.data.osm.DataSource;
import org.openstreetmap.josm.data.osm.DatasetCollection;
import org.openstreetmap.josm.data.osm.Hash;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.NodeData;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.QuadBuckets;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationData;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.SimplePrimitiveId;
import org.openstreetmap.josm.data.osm.Storage;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WayData;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.ChangesetIdChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListener;
import org.openstreetmap.josm.data.osm.event.NodeMovedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesAddedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesRemovedEvent;
import org.openstreetmap.josm.data.osm.event.RelationMembersChangedEvent;
import org.openstreetmap.josm.data.osm.event.TagsChangedEvent;
import org.openstreetmap.josm.data.osm.event.WayNodesChangedEvent;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionManager;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Predicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSet
implements Cloneable {
    private static final int MAX_SINGLE_EVENTS = 30;
    private static final int MAX_EVENTS = 1000;
    private Storage<OsmPrimitive> allPrimitives = new Storage<OsmPrimitive>(new IdHash(), 16, true);
    private Map<PrimitiveId, OsmPrimitive> primitivesMap = this.allPrimitives.foreignKey(new IdHash());
    private List<DataSetListener> listeners = new ArrayList<DataSetListener>();
    private int updateCount;
    private final List<AbstractDatasetChangedEvent> cachedEvents = new ArrayList<AbstractDatasetChangedEvent>();
    private int highlightUpdateCount;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private AutoCompletionManager autocomplete;
    private String version;
    private QuadBuckets<Node> nodes = new QuadBuckets();
    private QuadBuckets<Way> ways = new QuadBuckets();
    private Collection<Relation> relations = new ArrayList<Relation>();
    public Collection<DataSource> dataSources = new LinkedList<DataSource>();
    public static final Collection<SelectionChangedListener> selListeners = Collections.synchronizedList(new LinkedList());
    LinkedHashSet<OsmPrimitive> selectedPrimitives = new LinkedHashSet();

    public Lock getReadLock() {
        return this.lock.readLock();
    }

    public int getHighlightUpdateCount() {
        return this.highlightUpdateCount;
    }

    public AutoCompletionManager getAutoCompletionManager() {
        if (this.autocomplete == null) {
            this.autocomplete = new AutoCompletionManager(this);
            this.addDataSetListener(this.autocomplete);
        }
        return this.autocomplete;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    private <T extends OsmPrimitive> Collection<T> getPrimitives(Predicate<OsmPrimitive> predicate) {
        return new DatasetCollection(this.allPrimitives, predicate);
    }

    public Collection<Node> getNodes() {
        return this.getPrimitives(OsmPrimitive.nodePredicate);
    }

    public List<Node> searchNodes(BBox bbox) {
        return this.nodes.search(bbox);
    }

    public Collection<Way> getWays() {
        return this.getPrimitives(OsmPrimitive.wayPredicate);
    }

    public List<Way> searchWays(BBox bbox) {
        return this.ways.search(bbox);
    }

    public Collection<Relation> getRelations() {
        return this.getPrimitives(OsmPrimitive.relationPredicate);
    }

    public List<Relation> searchRelations(BBox bbox) {
        ArrayList<Relation> result = new ArrayList<Relation>();
        for (Relation r : this.relations) {
            if (!r.getBBox().intersects(bbox)) continue;
            result.add(r);
        }
        return result;
    }

    public Collection<OsmPrimitive> allPrimitives() {
        return this.getPrimitives(OsmPrimitive.allPredicate);
    }

    public Collection<OsmPrimitive> allNonDeletedPrimitives() {
        return this.getPrimitives(OsmPrimitive.nonDeletedPredicate);
    }

    public Collection<OsmPrimitive> allNonDeletedCompletePrimitives() {
        return this.getPrimitives(OsmPrimitive.nonDeletedCompletePredicate);
    }

    public Collection<OsmPrimitive> allNonDeletedPhysicalPrimitives() {
        return this.getPrimitives(OsmPrimitive.nonDeletedPhysicalPredicate);
    }

    public Collection<OsmPrimitive> allModifiedPrimitives() {
        return this.getPrimitives(OsmPrimitive.modifiedPredicate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPrimitive(OsmPrimitive primitive) {
        this.beginUpdate();
        try {
            if (this.getPrimitiveById(primitive) != null) {
                throw new DataIntegrityProblemException(I18n.tr("Unable to add primitive {0} to the dataset because it is already included", primitive.toString()));
            }
            primitive.updatePosition();
            if (primitive instanceof Node) {
                this.nodes.add((Node)primitive);
            } else if (primitive instanceof Way) {
                this.ways.add((Way)primitive);
            } else if (primitive instanceof Relation) {
                this.relations.add((Relation)primitive);
            }
            this.allPrimitives.add(primitive);
            primitive.setDataset(this);
            this.firePrimitivesAdded(Collections.singletonList(primitive), false);
        }
        finally {
            this.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OsmPrimitive addPrimitive(PrimitiveData data) {
        this.beginUpdate();
        try {
            OsmPrimitive result;
            if (data instanceof NodeData) {
                result = new Node();
            } else if (data instanceof WayData) {
                result = new Way();
            } else if (data instanceof RelationData) {
                result = new Relation();
            } else {
                throw new AssertionError();
            }
            result.setDataset(this);
            ((OsmPrimitive)result).load(data);
            this.addPrimitive(result);
            OsmPrimitive osmPrimitive = result;
            return osmPrimitive;
        }
        finally {
            this.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePrimitive(PrimitiveId primitiveId) {
        this.beginUpdate();
        try {
            OsmPrimitive primitive = this.getPrimitiveByIdChecked(primitiveId);
            if (primitive == null) {
                return;
            }
            if (primitive instanceof Node) {
                this.nodes.remove(primitive);
            } else if (primitive instanceof Way) {
                this.ways.remove(primitive);
            } else if (primitive instanceof Relation) {
                this.relations.remove(primitive);
            }
            this.selectedPrimitives.remove(primitive);
            this.allPrimitives.remove(primitive);
            primitive.setDataset(null);
            this.firePrimitivesRemoved(Collections.singletonList(primitive), false);
        }
        finally {
            this.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireSelectionChanged() {
        Collection<SelectionChangedListener> collection = selListeners;
        synchronized (collection) {
            List<OsmPrimitive> currentSelection = Collections.unmodifiableList(new ArrayList<OsmPrimitive>(this.selectedPrimitives));
            for (SelectionChangedListener l : selListeners) {
                l.selectionChanged(currentSelection);
            }
        }
    }

    public Collection<OsmPrimitive> getSelectedNodesAndWays() {
        LinkedList<OsmPrimitive> sel = new LinkedList<OsmPrimitive>();
        for (OsmPrimitive osm : this.selectedPrimitives) {
            if (!(osm instanceof Way) && !(osm instanceof Node)) continue;
            sel.add(osm);
        }
        return sel;
    }

    public Collection<OsmPrimitive> getSelected() {
        return Collections.unmodifiableSet(this.selectedPrimitives);
    }

    public Collection<Node> getSelectedNodes() {
        ArrayList<Node> result = new ArrayList<Node>(this.selectedPrimitives.size());
        for (OsmPrimitive primitive : this.selectedPrimitives) {
            if (!(primitive instanceof Node)) continue;
            result.add((Node)primitive);
        }
        return result;
    }

    public Collection<Way> getSelectedWays() {
        ArrayList<Way> result = new ArrayList<Way>(this.selectedPrimitives.size());
        for (OsmPrimitive primitive : this.selectedPrimitives) {
            if (!(primitive instanceof Way)) continue;
            result.add((Way)primitive);
        }
        return result;
    }

    public Collection<Relation> getSelectedRelations() {
        ArrayList<Relation> result = new ArrayList<Relation>(this.selectedPrimitives.size() / 10);
        for (OsmPrimitive primitive : this.selectedPrimitives) {
            if (!(primitive instanceof Relation)) continue;
            result.add((Relation)primitive);
        }
        return result;
    }

    public boolean isSelected(OsmPrimitive osm) {
        return this.selectedPrimitives.contains(osm);
    }

    public void toggleSelected(Collection<? extends PrimitiveId> osm) {
        boolean changed = false;
        for (PrimitiveId primitiveId : osm) {
            changed |= this.__toggleSelected(primitiveId);
        }
        if (changed) {
            this.fireSelectionChanged();
        }
    }

    public void toggleSelected(PrimitiveId ... osm) {
        this.toggleSelected(Arrays.asList(osm));
    }

    private boolean __toggleSelected(PrimitiveId primitiveId) {
        OsmPrimitive primitive = this.getPrimitiveByIdChecked(primitiveId);
        if (primitive == null) {
            return false;
        }
        if (!this.selectedPrimitives.remove(primitive)) {
            this.selectedPrimitives.add(primitive);
        }
        return true;
    }

    public void setSelected(Collection<? extends PrimitiveId> selection, boolean fireSelectionChangeEvent) {
        boolean wasEmpty = this.selectedPrimitives.isEmpty();
        this.selectedPrimitives = new LinkedHashSet();
        this.addSelected(selection, fireSelectionChangeEvent);
        if (!wasEmpty && this.selectedPrimitives.isEmpty() && fireSelectionChangeEvent) {
            this.fireSelectionChanged();
        }
    }

    public void setSelected(Collection<? extends PrimitiveId> selection) {
        this.setSelected(selection, true);
    }

    public void setSelected(PrimitiveId ... osm) {
        if (osm.length == 1 && osm[0] == null) {
            this.setSelected(new PrimitiveId[0]);
            return;
        }
        List<PrimitiveId> list = Arrays.asList(osm);
        this.setSelected(list);
    }

    public void addSelected(Collection<? extends PrimitiveId> selection) {
        this.addSelected(selection, true);
    }

    public void addSelected(PrimitiveId ... osm) {
        this.addSelected(Arrays.asList(osm));
    }

    public void addSelected(Collection<? extends PrimitiveId> selection, boolean fireSelectionChangeEvent) {
        boolean changed = false;
        for (PrimitiveId primitiveId : selection) {
            OsmPrimitive primitive = this.getPrimitiveByIdChecked(primitiveId);
            if (primitive == null) continue;
            changed |= this.selectedPrimitives.add(primitive);
        }
        if (fireSelectionChangeEvent && changed) {
            this.fireSelectionChanged();
        }
    }

    public void clearSelection(PrimitiveId ... osm) {
        this.clearSelection(Arrays.asList(osm));
    }

    public void clearSelection(Collection<? extends PrimitiveId> list) {
        boolean changed = false;
        for (PrimitiveId primitiveId : list) {
            OsmPrimitive primitive = this.getPrimitiveById(primitiveId);
            if (primitive == null) continue;
            changed |= this.selectedPrimitives.remove(primitive);
        }
        if (changed) {
            this.fireSelectionChanged();
        }
    }

    public void clearSelection() {
        if (!this.selectedPrimitives.isEmpty()) {
            this.selectedPrimitives.clear();
            this.fireSelectionChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSet clone() {
        this.getReadLock().lock();
        try {
            Relation newRelation;
            DataSet ds = new DataSet();
            HashMap<OsmPrimitive, OsmPrimitive> primitivesMap = new HashMap<OsmPrimitive, OsmPrimitive>();
            for (Node n : this.nodes) {
                Node newNode = new Node(n);
                primitivesMap.put(n, newNode);
                ds.addPrimitive(newNode);
            }
            for (Way w : this.ways) {
                Way newWay = new Way(w);
                primitivesMap.put(w, newWay);
                ArrayList<Node> newNodes = new ArrayList<Node>();
                for (Node n : w.getNodes()) {
                    newNodes.add((Node)primitivesMap.get(n));
                }
                newWay.setNodes(newNodes);
                ds.addPrimitive(newWay);
            }
            for (Relation r : this.relations) {
                newRelation = new Relation(r, r.isNew());
                newRelation.setMembers(null);
                primitivesMap.put(r, newRelation);
                ds.addPrimitive(newRelation);
            }
            for (Relation r : this.relations) {
                newRelation = (Relation)primitivesMap.get(r);
                ArrayList<RelationMember> newMembers = new ArrayList<RelationMember>();
                for (RelationMember rm : r.getMembers()) {
                    newMembers.add(new RelationMember(rm.getRole(), (OsmPrimitive)primitivesMap.get(rm.getMember())));
                }
                newRelation.setMembers(newMembers);
            }
            for (DataSource source : this.dataSources) {
                ds.dataSources.add(new DataSource(source.bounds, source.origin));
            }
            ds.version = this.version;
            DataSet dataSet = ds;
            return dataSet;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    public Area getDataSourceArea() {
        if (this.dataSources.isEmpty()) {
            return null;
        }
        Area a = new Area();
        for (DataSource source : this.dataSources) {
            a.add(new Area(source.bounds.asRect()));
        }
        return a;
    }

    public OsmPrimitive getPrimitiveById(long id, OsmPrimitiveType type) {
        return this.getPrimitiveById(new SimplePrimitiveId(id, type), false);
    }

    public OsmPrimitive getPrimitiveById(PrimitiveId primitiveId) {
        return this.getPrimitiveById(primitiveId, false);
    }

    public OsmPrimitive getPrimitiveById(PrimitiveId primitiveId, boolean createNew) {
        OsmPrimitive result = this.primitivesMap.get(primitiveId);
        if (result == null && createNew) {
            switch (primitiveId.getType()) {
                case NODE: {
                    result = new Node(primitiveId.getUniqueId(), true);
                    break;
                }
                case WAY: {
                    result = new Way(primitiveId.getUniqueId(), true);
                    break;
                }
                case RELATION: {
                    result = new Relation(primitiveId.getUniqueId(), true);
                }
            }
            this.addPrimitive(result);
        }
        return result;
    }

    private OsmPrimitive getPrimitiveByIdChecked(PrimitiveId primitiveId) {
        OsmPrimitive result = this.getPrimitiveById(primitiveId);
        if (result == null) {
            System.out.println(I18n.tr("JOSM expected to find primitive [{0} {1}] in dataset but it is not there. Please report this  at http://josm.openstreetmap.de . This is not a critical error, it should be safe to continue in your work.", new Object[]{primitiveId.getType(), Long.toString(primitiveId.getUniqueId())}));
            new Exception().printStackTrace();
        }
        return result;
    }

    private void deleteWay(Way way) {
        way.setNodes(null);
        way.setDeleted(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlinkNodeFromWays(Node node) {
        this.beginUpdate();
        try {
            for (Way way : this.ways) {
                List<Node> nodes = way.getNodes();
                if (!nodes.remove(node)) continue;
                if (nodes.size() < 2) {
                    this.deleteWay(way);
                    continue;
                }
                way.setNodes(nodes);
            }
        }
        finally {
            this.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlinkPrimitiveFromRelations(OsmPrimitive primitive) {
        this.beginUpdate();
        try {
            for (Relation relation : this.relations) {
                List<RelationMember> members = relation.getMembers();
                Iterator<RelationMember> it = members.iterator();
                boolean removed = false;
                while (it.hasNext()) {
                    RelationMember member = it.next();
                    if (!member.getMember().equals(primitive)) continue;
                    it.remove();
                    removed = true;
                }
                if (!removed) continue;
                relation.setMembers(members);
            }
        }
        finally {
            this.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlinkReferencesToPrimitive(OsmPrimitive referencedPrimitive) {
        this.beginUpdate();
        try {
            if (referencedPrimitive instanceof Node) {
                this.unlinkNodeFromWays((Node)referencedPrimitive);
                this.unlinkPrimitiveFromRelations(referencedPrimitive);
            } else {
                this.unlinkPrimitiveFromRelations(referencedPrimitive);
            }
        }
        finally {
            this.endUpdate();
        }
    }

    public boolean isModified() {
        for (Node n : this.nodes) {
            if (!n.isModified()) continue;
            return true;
        }
        for (Way w : this.ways) {
            if (!w.isModified()) continue;
            return true;
        }
        for (Relation r : this.relations) {
            if (!r.isModified()) continue;
            return true;
        }
        return false;
    }

    private void reindexNode(Node node, LatLon newCoor) {
        this.nodes.remove(node);
        node.setCoorInternal(newCoor);
        this.nodes.add(node);
        for (OsmPrimitive primitive : node.getReferrers()) {
            if (primitive instanceof Way) {
                this.reindexWay((Way)primitive);
                continue;
            }
            this.reindexRelation((Relation)primitive);
        }
    }

    private void reindexWay(Way way) {
        BBox before = way.getBBox();
        this.ways.remove(way);
        way.updatePosition();
        this.ways.add(way);
        if (!way.getBBox().equals(before)) {
            for (OsmPrimitive primitive : way.getReferrers()) {
                this.reindexRelation((Relation)primitive);
            }
        }
    }

    private void reindexRelation(Relation relation) {
        BBox before = relation.getBBox();
        relation.updatePosition();
        if (!before.equals(relation.getBBox())) {
            for (OsmPrimitive primitive : relation.getReferrers()) {
                this.reindexRelation((Relation)primitive);
            }
        }
    }

    public void addDataSetListener(DataSetListener dsl) {
        this.listeners.add(dsl);
    }

    public void removeDataSetListener(DataSetListener dsl) {
        this.listeners.remove(dsl);
    }

    public void beginUpdate() {
        this.lock.writeLock().lock();
        ++this.updateCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endUpdate() {
        if (this.updateCount > 0) {
            --this.updateCount;
            if (this.updateCount == 0) {
                ArrayList<AbstractDatasetChangedEvent> eventsCopy = new ArrayList<AbstractDatasetChangedEvent>(this.cachedEvents);
                this.cachedEvents.clear();
                this.lock.writeLock().unlock();
                if (!eventsCopy.isEmpty()) {
                    this.lock.readLock().lock();
                    try {
                        if (eventsCopy.size() < 30) {
                            for (AbstractDatasetChangedEvent event : eventsCopy) {
                                this.fireEventToListeners(event);
                            }
                        }
                        if (eventsCopy.size() == 1000) {
                            this.fireEventToListeners(new DataChangedEvent(this));
                        }
                        this.fireEventToListeners(new DataChangedEvent(this, eventsCopy));
                    }
                    finally {
                        this.lock.readLock().unlock();
                    }
                }
            } else {
                this.lock.writeLock().unlock();
            }
        } else {
            throw new AssertionError((Object)"endUpdate called without beginUpdate");
        }
    }

    private void fireEventToListeners(AbstractDatasetChangedEvent event) {
        for (DataSetListener listener : this.listeners) {
            event.fire(listener);
        }
    }

    private void fireEvent(AbstractDatasetChangedEvent event) {
        if (this.updateCount == 0) {
            throw new AssertionError((Object)"dataset events can be fired only when dataset is locked");
        }
        if (this.cachedEvents.size() < 1000) {
            this.cachedEvents.add(event);
        }
    }

    void firePrimitivesAdded(Collection<? extends OsmPrimitive> added, boolean wasIncomplete) {
        this.fireEvent(new PrimitivesAddedEvent(this, added, wasIncomplete));
    }

    void firePrimitivesRemoved(Collection<? extends OsmPrimitive> removed, boolean wasComplete) {
        this.fireEvent(new PrimitivesRemovedEvent(this, removed, wasComplete));
    }

    void fireTagsChanged(OsmPrimitive prim, Map<String, String> originalKeys) {
        this.fireEvent(new TagsChangedEvent(this, prim, originalKeys));
    }

    void fireRelationMembersChanged(Relation r) {
        this.reindexRelation(r);
        this.fireEvent(new RelationMembersChangedEvent(this, r));
    }

    void fireNodeMoved(Node node, LatLon newCoor) {
        this.reindexNode(node, newCoor);
        this.fireEvent(new NodeMovedEvent(this, node));
    }

    void fireWayNodesChanged(Way way) {
        this.reindexWay(way);
        this.fireEvent(new WayNodesChangedEvent(this, way));
    }

    void fireChangesetIdChanged(OsmPrimitive primitive, int oldChangesetId, int newChangesetId) {
        this.fireEvent(new ChangesetIdChangedEvent(this, Collections.singletonList(primitive), oldChangesetId, newChangesetId));
    }

    void fireHighlightingChanged(OsmPrimitive primitive) {
        ++this.highlightUpdateCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clenupDeletedPrimitives() {
        this.beginUpdate();
        try {
            if (this.cleanupDeleted(this.nodes.iterator()) | this.cleanupDeleted(this.ways.iterator()) | this.cleanupDeleted(this.relations.iterator())) {
                this.fireSelectionChanged();
            }
        }
        finally {
            this.endUpdate();
        }
    }

    private boolean cleanupDeleted(Iterator<? extends OsmPrimitive> it) {
        boolean changed = false;
        while (it.hasNext()) {
            OsmPrimitive primitive = it.next();
            if (!primitive.isDeleted()) continue;
            this.selectedPrimitives.remove(primitive);
            this.allPrimitives.remove(primitive);
            primitive.setDataset(null);
            changed = true;
            it.remove();
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.beginUpdate();
        try {
            this.clearSelection();
            for (OsmPrimitive primitive : this.allPrimitives) {
                primitive.setDataset(null);
            }
            this.nodes.clear();
            this.ways.clear();
            this.relations.clear();
            this.allPrimitives.clear();
        }
        finally {
            this.endUpdate();
        }
    }

    public void deleteInvisible() {
        for (OsmPrimitive primitive : this.allPrimitives) {
            if (primitive.isVisible()) continue;
            primitive.setDeleted(true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IdHash
    implements Hash<PrimitiveId, OsmPrimitive> {
        private IdHash() {
        }

        @Override
        public int getHashCode(PrimitiveId k) {
            return (int)k.getUniqueId() ^ k.getType().hashCode();
        }

        @Override
        public boolean equals(PrimitiveId key, OsmPrimitive value) {
            if (key == null || value == null) {
                return false;
            }
            return key.getUniqueId() == value.getUniqueId() && key.getType() == value.getType();
        }
    }
}

