/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.AbstractVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrimitiveDeepCopy {
    private final List<PrimitiveData> directlyAdded = new ArrayList<PrimitiveData>();
    private final List<PrimitiveData> referenced = new ArrayList<PrimitiveData>();

    public PrimitiveDeepCopy() {
    }

    public PrimitiveDeepCopy(Collection<OsmPrimitive> primitives) {
        this.makeCopy(primitives);
    }

    public final void makeCopy(final Collection<OsmPrimitive> primitives) {
        this.directlyAdded.clear();
        this.referenced.clear();
        final HashSet visitedNodeIds = new HashSet();
        final HashSet visitedWayIds = new HashSet();
        final HashSet visitedRelationIds = new HashSet();
        new AbstractVisitor(){
            boolean firstIteration;

            public void visit(Node n) {
                if (!visitedNodeIds.add(n.getUniqueId())) {
                    return;
                }
                (this.firstIteration ? PrimitiveDeepCopy.this.directlyAdded : PrimitiveDeepCopy.this.referenced).add(n.save());
            }

            public void visit(Way w) {
                if (!visitedWayIds.add(w.getUniqueId())) {
                    return;
                }
                (this.firstIteration ? PrimitiveDeepCopy.this.directlyAdded : PrimitiveDeepCopy.this.referenced).add(w.save());
                this.firstIteration = false;
                for (Node n : w.getNodes()) {
                    this.visit(n);
                }
            }

            public void visit(Relation r) {
                if (!visitedRelationIds.add(r.getUniqueId())) {
                    return;
                }
                (this.firstIteration ? PrimitiveDeepCopy.this.directlyAdded : PrimitiveDeepCopy.this.referenced).add(r.save());
                this.firstIteration = false;
                for (RelationMember m : r.getMembers()) {
                    m.getMember().visit(this);
                }
            }

            public void visitAll() {
                for (OsmPrimitive osm : primitives) {
                    this.firstIteration = true;
                    osm.visit(this);
                }
            }
        }.visitAll();
    }

    public List<PrimitiveData> getDirectlyAdded() {
        return this.directlyAdded;
    }

    public List<PrimitiveData> getReferenced() {
        return this.referenced;
    }

    public List<PrimitiveData> getAll() {
        ArrayList<PrimitiveData> result = new ArrayList<PrimitiveData>(this.directlyAdded.size() + this.referenced.size());
        result.addAll(this.directlyAdded);
        result.addAll(this.referenced);
        return result;
    }

    public boolean isEmpty() {
        return this.directlyAdded.isEmpty() && this.referenced.isEmpty();
    }
}

