/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection;

import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.tools.I18n;

public class SwissGrid
implements Projection {
    public EastNorth latlon2eastNorth(LatLon wgs) {
        double phi = 3600.0 * wgs.lat();
        double lambda = 3600.0 * wgs.lon();
        double phiprime = (phi - 169028.66) / 10000.0;
        double lambdaprime = (lambda - 26782.5) / 10000.0;
        double lambdaprime_2 = Math.pow(lambdaprime, 2.0);
        double phiprime_2 = Math.pow(phiprime, 2.0);
        double north = 200147.07 + 308807.95 * phiprime + 3745.25 * lambdaprime_2 + 76.63 * phiprime_2 - 194.56 * lambdaprime_2 * phiprime + 119.79 * Math.pow(phiprime, 3.0);
        double east = 600072.37 + 211455.93 * lambdaprime - 10938.51 * lambdaprime * phiprime - 0.36 * lambdaprime * phiprime_2 - 44.54 * Math.pow(lambdaprime, 3.0);
        return new EastNorth(east, north);
    }

    public LatLon eastNorth2latlon(EastNorth xy) {
        double yp = (xy.east() - 600000.0) / 1000000.0;
        double xp = (xy.north() - 200000.0) / 1000000.0;
        double xp_2 = Math.pow(xp, 2.0);
        double yp_2 = Math.pow(yp, 2.0);
        double lmbp = 2.6779094 + 4.728982 * yp + 0.791484 * yp * xp + 0.1306 * yp * xp_2 - 0.0436 * Math.pow(yp, 3.0);
        double phip = 16.9023892 + 3.238272 * xp - 0.270978 * yp_2 - 0.002528 * xp_2 - 0.0447 * yp_2 * xp - 0.014 * Math.pow(xp, 3.0);
        double lmb = lmbp * 100.0 / 36.0;
        double phi = phip * 100.0 / 36.0;
        return new LatLon(phi, lmb);
    }

    public String toString() {
        return I18n.tr("Swiss Grid (Switzerland)");
    }

    public String toCode() {
        return "EPSG:21781";
    }

    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    public String getCacheDirectoryName() {
        return "swissgrid";
    }

    public Bounds getWorldBoundsLatLon() {
        return new Bounds(new LatLon(45.7, 5.7), new LatLon(47.9, 10.6));
    }

    public double getDefaultZoomInPPD() {
        return 1.01;
    }
}

