/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.zip.CRC32;
import javax.swing.JComponent;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.ProjectionBounds;
import org.openstreetmap.josm.data.coor.CachedLatLon;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.gui.help.Helpful;
import org.openstreetmap.josm.tools.Predicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NavigatableComponent
extends JComponent
implements Helpful {
    private static final CopyOnWriteArrayList<ZoomChangeListener> zoomChangeListeners = new CopyOnWriteArrayList();
    public static final int snapDistance = Main.pref.getInteger("node.snap-distance", 10);
    public static final int snapDistanceSq = NavigatableComponent.sqr(snapDistance);
    private double scale = Main.proj.getDefaultZoomInPPD();
    protected EastNorth center = this.calculateDefaultCenter();
    private Stack<ZoomData> zoomUndoBuffer = new Stack();
    private Stack<ZoomData> zoomRedoBuffer = new Stack();
    private Date zoomTimestamp = new Date();

    public static void removeZoomChangeListener(ZoomChangeListener listener) {
        zoomChangeListeners.remove(listener);
    }

    public static void addZoomChangeListener(ZoomChangeListener listener) {
        if (listener != null) {
            zoomChangeListeners.addIfAbsent(listener);
        }
    }

    protected static void fireZoomChanged() {
        for (ZoomChangeListener l : zoomChangeListeners) {
            l.zoomChanged();
        }
    }

    private static int sqr(int a) {
        return a * a;
    }

    public NavigatableComponent() {
        this.setLayout(null);
    }

    protected DataSet getCurrentDataSet() {
        return Main.main.getCurrentDataSet();
    }

    private EastNorth calculateDefaultCenter() {
        Bounds b = Main.proj.getWorldBoundsLatLon();
        double lat = (b.getMax().lat() + b.getMin().lat()) / 2.0;
        double lon = (b.getMax().lon() + b.getMin().lon()) / 2.0;
        return Main.proj.latlon2eastNorth(new LatLon(lat, lon));
    }

    public String getDist100PixelText() {
        double dist = this.getDist100Pixel();
        return dist >= 2000.0 ? Math.round(dist / 100.0) / 10L + " km" : (dist >= 1.0 ? Math.round(dist * 10.0) / 10L + " m" : "< 1 m");
    }

    public double getDist100Pixel() {
        int w = this.getWidth() / 2;
        int h = this.getHeight() / 2;
        LatLon ll1 = this.getLatLon(w - 50, h);
        LatLon ll2 = this.getLatLon(w + 50, h);
        return ll1.greatCircleDistance(ll2);
    }

    public EastNorth getCenter() {
        return this.center;
    }

    public EastNorth getEastNorth(int x, int y) {
        return new EastNorth(this.center.east() + ((double)x - (double)this.getWidth() / 2.0) * this.scale, this.center.north() - ((double)y - (double)this.getHeight() / 2.0) * this.scale);
    }

    public ProjectionBounds getProjectionBounds() {
        return new ProjectionBounds(new EastNorth(this.center.east() - (double)this.getWidth() / 2.0 * this.scale, this.center.north() - (double)this.getHeight() / 2.0 * this.scale), new EastNorth(this.center.east() + (double)this.getWidth() / 2.0 * this.scale, this.center.north() + (double)this.getHeight() / 2.0 * this.scale));
    }

    public ProjectionBounds getMaxProjectionBounds() {
        Bounds b = this.getProjection().getWorldBoundsLatLon();
        return new ProjectionBounds(this.getProjection().latlon2eastNorth(b.getMin()), this.getProjection().latlon2eastNorth(b.getMax()));
    }

    public Bounds getRealBounds() {
        return new Bounds(this.getProjection().eastNorth2latlon(new EastNorth(this.center.east() - (double)this.getWidth() / 2.0 * this.scale, this.center.north() - (double)this.getHeight() / 2.0 * this.scale)), this.getProjection().eastNorth2latlon(new EastNorth(this.center.east() + (double)this.getWidth() / 2.0 * this.scale, this.center.north() + (double)this.getHeight() / 2.0 * this.scale)));
    }

    public LatLon getLatLon(int x, int y) {
        return this.getProjection().eastNorth2latlon(this.getEastNorth(x, y));
    }

    public Bounds getLatLonBounds(Rectangle r) {
        EastNorth p1 = this.getEastNorth(r.x, r.y);
        EastNorth p2 = this.getEastNorth(r.x + r.width, r.y + r.height);
        Bounds result = new Bounds(Main.proj.eastNorth2latlon(p1));
        double eastMin = Math.min(p1.east(), p2.east());
        double eastMax = Math.max(p1.east(), p2.east());
        double northMin = Math.min(p1.north(), p2.north());
        double northMax = Math.max(p1.north(), p2.north());
        double deltaEast = (eastMax - eastMin) / 10.0;
        double deltaNorth = (northMax - northMin) / 10.0;
        for (int i = 0; i < 10; ++i) {
            result.extend(Main.proj.eastNorth2latlon(new EastNorth(eastMin + (double)i * deltaEast, northMin)));
            result.extend(Main.proj.eastNorth2latlon(new EastNorth(eastMin + (double)i * deltaEast, northMax)));
            result.extend(Main.proj.eastNorth2latlon(new EastNorth(eastMin, northMin + (double)i * deltaNorth)));
            result.extend(Main.proj.eastNorth2latlon(new EastNorth(eastMax, northMin + (double)i * deltaNorth)));
        }
        return result;
    }

    public Point getPoint(EastNorth p) {
        if (null == p) {
            return new Point();
        }
        double x = (p.east() - this.center.east()) / this.scale + (double)(this.getWidth() / 2);
        double y = (this.center.north() - p.north()) / this.scale + (double)(this.getHeight() / 2);
        return new Point((int)x, (int)y);
    }

    public Point getPoint(LatLon latlon) {
        if (latlon == null) {
            return new Point();
        }
        if (latlon instanceof CachedLatLon) {
            return this.getPoint(((CachedLatLon)latlon).getEastNorth());
        }
        return this.getPoint(this.getProjection().latlon2eastNorth(latlon));
    }

    public Point getPoint(Node n) {
        return this.getPoint(n.getEastNorth());
    }

    private void zoomTo(EastNorth newCenter, double newScale) {
        Bounds b = this.getProjection().getWorldBoundsLatLon();
        CachedLatLon cl = new CachedLatLon(newCenter);
        boolean changed = false;
        double lat = cl.lat();
        double lon = cl.lon();
        if (lat < b.getMin().lat()) {
            changed = true;
            lat = b.getMin().lat();
        } else if (lat > b.getMax().lat()) {
            changed = true;
            lat = b.getMax().lat();
        }
        if (lon < b.getMin().lon()) {
            changed = true;
            lon = b.getMin().lon();
        } else if (lon > b.getMax().lon()) {
            changed = true;
            lon = b.getMax().lon();
        }
        if (changed) {
            newCenter = new CachedLatLon(lat, lon).getEastNorth();
        }
        int width = this.getWidth() / 2;
        int height = this.getHeight() / 2;
        LatLon l1 = new LatLon(b.getMin().lat(), lon);
        LatLon l2 = new LatLon(b.getMax().lat(), lon);
        EastNorth e1 = this.getProjection().latlon2eastNorth(l1);
        EastNorth e2 = this.getProjection().latlon2eastNorth(l2);
        double d = e2.north() - e1.north();
        if (d < (double)height * newScale) {
            double newScaleH = d / (double)height;
            e1 = this.getProjection().latlon2eastNorth(new LatLon(lat, b.getMin().lon()));
            e2 = this.getProjection().latlon2eastNorth(new LatLon(lat, b.getMax().lon()));
            d = e2.east() - e1.east();
            if (d < (double)width * newScale) {
                newScale = Math.max(newScaleH, d / (double)width);
            }
        } else if (newScale < (d /= l1.greatCircleDistance(l2) * (double)height * 10.0)) {
            newScale = d;
        }
        if (!newCenter.equals(this.center) || this.scale != newScale) {
            this.pushZoomUndo(this.center, this.scale);
            this.zoomNoUndoTo(newCenter, newScale);
        }
    }

    private void zoomNoUndoTo(EastNorth newCenter, double newScale) {
        if (!newCenter.equals(this.center)) {
            EastNorth oldCenter = this.center;
            this.center = newCenter;
            this.firePropertyChange("center", oldCenter, newCenter);
        }
        if (this.scale != newScale) {
            double oldScale = this.scale;
            this.scale = newScale;
            this.firePropertyChange("scale", oldScale, newScale);
        }
        this.repaint();
        NavigatableComponent.fireZoomChanged();
    }

    public void zoomTo(EastNorth newCenter) {
        this.zoomTo(newCenter, this.scale);
    }

    public void zoomTo(LatLon newCenter) {
        if (newCenter instanceof CachedLatLon) {
            this.zoomTo(((CachedLatLon)newCenter).getEastNorth(), this.scale);
        } else {
            this.zoomTo(this.getProjection().latlon2eastNorth(newCenter), this.scale);
        }
    }

    public void zoomToFactor(double x, double y, double factor) {
        double newScale = this.scale * factor;
        this.zoomTo(new EastNorth(this.center.east() - (x - (double)this.getWidth() / 2.0) * (newScale - this.scale), this.center.north() + (y - (double)this.getHeight() / 2.0) * (newScale - this.scale)), newScale);
    }

    public void zoomToFactor(EastNorth newCenter, double factor) {
        this.zoomTo(newCenter, this.scale * factor);
    }

    public void zoomToFactor(double factor) {
        this.zoomTo(this.center, this.scale * factor);
    }

    public void zoomTo(ProjectionBounds box) {
        int h;
        int w = this.getWidth() - 20;
        if (w < 20) {
            w = 20;
        }
        if ((h = this.getHeight() - 20) < 20) {
            h = 20;
        }
        double scaleX = (box.max.east() - box.min.east()) / (double)w;
        double scaleY = (box.max.north() - box.min.north()) / (double)h;
        double newScale = Math.max(scaleX, scaleY);
        this.zoomTo(box.getCenter(), newScale);
    }

    public void zoomTo(Bounds box) {
        this.zoomTo(new ProjectionBounds(this.getProjection().latlon2eastNorth(box.getMin()), this.getProjection().latlon2eastNorth(box.getMax())));
    }

    private void pushZoomUndo(EastNorth center, double scale) {
        Date now = new Date();
        if ((double)(now.getTime() - this.zoomTimestamp.getTime()) > Main.pref.getDouble("zoom.undo.delay", 1.0) * 1000.0) {
            this.zoomUndoBuffer.push(new ZoomData(center, scale));
            if (this.zoomUndoBuffer.size() > Main.pref.getInteger("zoom.undo.max", 50)) {
                this.zoomUndoBuffer.remove(0);
            }
            this.zoomRedoBuffer.clear();
        }
        this.zoomTimestamp = now;
    }

    public void zoomPrevious() {
        if (!this.zoomUndoBuffer.isEmpty()) {
            ZoomData zoom = this.zoomUndoBuffer.pop();
            this.zoomRedoBuffer.push(new ZoomData(this.center, this.scale));
            this.zoomNoUndoTo(zoom.getCenterEastNorth(), zoom.getScale());
        }
    }

    public void zoomNext() {
        if (!this.zoomRedoBuffer.isEmpty()) {
            ZoomData zoom = this.zoomRedoBuffer.pop();
            this.zoomUndoBuffer.push(new ZoomData(this.center, this.scale));
            this.zoomNoUndoTo(zoom.getCenterEastNorth(), zoom.getScale());
        }
    }

    public boolean hasZoomUndoEntries() {
        return !this.zoomUndoBuffer.isEmpty();
    }

    public boolean hasZoomRedoEntries() {
        return !this.zoomRedoBuffer.isEmpty();
    }

    private BBox getSnapDistanceBBox(Point p) {
        return new BBox(this.getLatLon(p.x - snapDistance, p.y - snapDistance), this.getLatLon(p.x + snapDistance, p.y + snapDistance));
    }

    @Deprecated
    public final Node getNearestNode(Point p) {
        return this.getNearestNode(p, OsmPrimitive.isUsablePredicate);
    }

    public final Node getNearestNode(Point p, Predicate<OsmPrimitive> predicate) {
        DataSet ds = this.getCurrentDataSet();
        if (ds == null) {
            return null;
        }
        double minDistanceSq = snapDistanceSq;
        Node minPrimitive = null;
        for (Node n : ds.searchNodes(this.getSnapDistanceBBox(p))) {
            if (!predicate.evaluate(n)) continue;
            Point sp = this.getPoint(n);
            double dist = p.distanceSq(sp);
            if (dist < minDistanceSq) {
                minDistanceSq = dist;
                minPrimitive = n;
                continue;
            }
            if (dist != minDistanceSq || minPrimitive == null || (!n.isNew() || !ds.isSelected(n)) && (ds.isSelected(minPrimitive) || !ds.isSelected(n) && !n.isNew())) continue;
            minPrimitive = n;
        }
        return minPrimitive;
    }

    public final List<WaySegment> getNearestWaySegments(Point p, Predicate<OsmPrimitive> predicate) {
        TreeMap nearest = new TreeMap();
        DataSet ds = this.getCurrentDataSet();
        if (ds == null) {
            return null;
        }
        for (Way w : ds.searchWays(this.getSnapDistanceBBox(p))) {
            if (!predicate.evaluate(w)) continue;
            Node lastN = null;
            int i = -2;
            for (Node n : w.getNodes()) {
                double b;
                ++i;
                if (n.isDeleted() || n.isIncomplete()) continue;
                if (lastN == null) {
                    lastN = n;
                    continue;
                }
                Point A = this.getPoint(lastN);
                Point B = this.getPoint(n);
                double c = A.distanceSq(B);
                double a = p.distanceSq(B);
                double perDist = a - (a - (b = p.distanceSq(A)) + c) * (a - b + c) / 4.0 / c;
                if (perDist < (double)snapDistanceSq && a < c + (double)snapDistanceSq && b < c + (double)snapDistanceSq) {
                    List<WaySegment> l;
                    if (ds.isSelected(w)) {
                        perDist -= 1.0E-5;
                    }
                    if (nearest.containsKey(perDist)) {
                        l = (List)nearest.get(perDist);
                    } else {
                        l = new LinkedList();
                        nearest.put(perDist, l);
                    }
                    l.add(new WaySegment(w, i));
                }
                lastN = n;
            }
        }
        ArrayList<WaySegment> nearestList = new ArrayList<WaySegment>();
        for (List wss : nearest.values()) {
            nearestList.addAll(wss);
        }
        return nearestList;
    }

    public final WaySegment getNearestWaySegment(Point p, Collection<WaySegment> ignore, Predicate<OsmPrimitive> predicate) {
        List<WaySegment> nearest = this.getNearestWaySegments(p, predicate);
        if (nearest == null) {
            return null;
        }
        if (ignore != null) {
            nearest.removeAll(ignore);
        }
        return nearest.isEmpty() ? null : nearest.get(0);
    }

    public final WaySegment getNearestWaySegment(Point p, Predicate<OsmPrimitive> predicate) {
        return this.getNearestWaySegment(p, null, predicate);
    }

    @Deprecated
    public final Way getNearestWay(Point p) {
        return this.getNearestWay(p, OsmPrimitive.isUsablePredicate);
    }

    public final Way getNearestWay(Point p, Predicate<OsmPrimitive> predicate) {
        WaySegment nearestWaySeg = this.getNearestWaySegment(p, predicate);
        return nearestWaySeg == null ? null : nearestWaySeg.way;
    }

    public OsmPrimitive getNearest(Point p, Predicate<OsmPrimitive> predicate) {
        OsmPrimitive osm = this.getNearestNode(p, predicate);
        if (osm == null) {
            osm = this.getNearestWay(p, predicate);
        }
        return osm;
    }

    public Collection<OsmPrimitive> getNearestCollection(Point p, Predicate<OsmPrimitive> predicate) {
        OsmPrimitive osm = this.getNearest(p, predicate);
        if (osm == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(osm);
    }

    public Collection<OsmPrimitive> getAllNearest(Point p, Predicate<OsmPrimitive> predicate) {
        HashSet<OsmPrimitive> nearest = new HashSet<OsmPrimitive>();
        DataSet ds = this.getCurrentDataSet();
        if (ds == null) {
            return null;
        }
        block0: for (Way w : ds.searchWays(this.getSnapDistanceBBox(p))) {
            if (!predicate.evaluate(w)) continue;
            Node lastN = null;
            for (Node n : w.getNodes()) {
                double b;
                if (!predicate.evaluate(n)) continue;
                if (lastN == null) {
                    lastN = n;
                    continue;
                }
                Point A = this.getPoint(lastN);
                Point B = this.getPoint(n);
                double c = A.distanceSq(B);
                double a = p.distanceSq(B);
                double perDist = a - (a - (b = p.distanceSq(A)) + c) * (a - b + c) / 4.0 / c;
                if (perDist < (double)snapDistanceSq && a < c + (double)snapDistanceSq && b < c + (double)snapDistanceSq) {
                    nearest.add(w);
                    continue block0;
                }
                lastN = n;
            }
        }
        for (Node n : ds.searchNodes(this.getSnapDistanceBBox(p))) {
            if (!n.isUsable() || !(this.getPoint(n).distanceSq(p) < (double)snapDistanceSq)) continue;
            nearest.add(n);
        }
        return nearest.isEmpty() ? null : nearest;
    }

    public Collection<Node> getNearestNodes(Point p, Predicate<OsmPrimitive> predicate) {
        HashSet<Node> nearest = new HashSet<Node>();
        DataSet ds = this.getCurrentDataSet();
        if (ds == null) {
            return null;
        }
        for (Node n : ds.searchNodes(this.getSnapDistanceBBox(p))) {
            if (!predicate.evaluate(n) || !(this.getPoint(n).distanceSq(p) < (double)snapDistanceSq)) continue;
            nearest.add(n);
        }
        return nearest.isEmpty() ? null : nearest;
    }

    public final Collection<Node> getNearestNodes(Point p, Collection<Node> ignore, Predicate<OsmPrimitive> predicate) {
        Collection<Node> nearest = this.getNearestNodes(p, predicate);
        if (nearest == null) {
            return null;
        }
        if (ignore != null) {
            nearest.removeAll(ignore);
        }
        return nearest.isEmpty() ? null : nearest;
    }

    public Projection getProjection() {
        return Main.proj;
    }

    @Override
    public String helpTopic() {
        String n = this.getClass().getName();
        return n.substring(n.lastIndexOf(46) + 1);
    }

    public int getViewID() {
        String x = this.center.east() + "_" + this.center.north() + "_" + this.scale + "_" + this.getWidth() + "_" + this.getHeight() + "_" + ((Object)this.getProjection()).toString();
        CRC32 id = new CRC32();
        id.update(x.getBytes());
        return (int)id.getValue();
    }

    private class ZoomData {
        LatLon center;
        double scale;

        public ZoomData(EastNorth center, double scale) {
            this.center = new CachedLatLon(center);
            this.scale = scale;
        }

        public EastNorth getCenterEastNorth() {
            return NavigatableComponent.this.getProjection().latlon2eastNorth(this.center);
        }

        public double getScale() {
            return this.scale;
        }
    }

    public static interface ZoomChangeListener {
        public void zoomChanged();
    }
}

