/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.DefaultListSelectionModel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListener;
import org.openstreetmap.josm.data.osm.event.NodeMovedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesAddedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesRemovedEvent;
import org.openstreetmap.josm.data.osm.event.RelationMembersChangedEvent;
import org.openstreetmap.josm.data.osm.event.TagsChangedEvent;
import org.openstreetmap.josm.data.osm.event.WayNodesChangedEvent;
import org.openstreetmap.josm.gui.dialogs.relation.IMemberModelListener;
import org.openstreetmap.josm.gui.dialogs.relation.RelationNodeMap;
import org.openstreetmap.josm.gui.dialogs.relation.WayConnectionType;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemberTableModel
extends AbstractTableModel
implements TableModelListener,
SelectionChangedListener,
DataSetListener {
    private List<RelationMember> members = new ArrayList<RelationMember>();
    private List<WayConnectionType> connectionType = null;
    private DefaultListSelectionModel listSelectionModel;
    private CopyOnWriteArrayList<IMemberModelListener> listeners = new CopyOnWriteArrayList();
    private OsmDataLayer layer;

    public MemberTableModel(OsmDataLayer layer) {
        this.layer = layer;
        this.addTableModelListener(this);
    }

    public OsmDataLayer getLayer() {
        return this.layer;
    }

    public void register() {
        DataSet.selListeners.add(this);
        this.getLayer().data.addDataSetListener(this);
    }

    public void unregister() {
        DataSet.selListeners.remove(this);
        this.getLayer().data.removeDataSetListener(this);
    }

    @Override
    public void selectionChanged(Collection<? extends OsmPrimitive> newSelection) {
        if (Main.main.getEditLayer() != this.layer) {
            return;
        }
        Collection<RelationMember> sel = this.getSelectedMembers();
        this.fireTableDataChanged();
        this.setSelectedMembers(sel);
    }

    @Override
    public void dataChanged(DataChangedEvent event) {
        Collection<RelationMember> sel = this.getSelectedMembers();
        this.fireTableDataChanged();
        this.setSelectedMembers(sel);
    }

    @Override
    public void nodeMoved(NodeMovedEvent event) {
    }

    @Override
    public void primtivesAdded(PrimitivesAddedEvent event) {
    }

    @Override
    public void primtivesRemoved(PrimitivesRemovedEvent event) {
    }

    @Override
    public void relationMembersChanged(RelationMembersChangedEvent event) {
    }

    @Override
    public void tagsChanged(TagsChangedEvent event) {
        Collection<RelationMember> sel = this.getSelectedMembers();
        for (int i = 0; i < this.members.size(); ++i) {
            if (this.members.get(i).getMember() != event.getPrimitive()) continue;
            this.fireTableCellUpdated(i, 1);
        }
        this.setSelectedMembers(sel);
    }

    @Override
    public void wayNodesChanged(WayNodesChangedEvent event) {
    }

    @Override
    public void otherDatasetChange(AbstractDatasetChangedEvent event) {
    }

    public void addMemberModelListener(IMemberModelListener listener) {
        if (listener != null) {
            this.listeners.addIfAbsent(listener);
        }
    }

    public void removeMemberModelListener(IMemberModelListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireMakeMemberVisible(int index) {
        for (IMemberModelListener listener : this.listeners) {
            listener.makeMemberVisible(index);
        }
    }

    public void populate(Relation relation) {
        this.members.clear();
        if (relation != null) {
            this.members.addAll(new Relation(relation).getMembers());
        }
        this.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public int getRowCount() {
        return this.members.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.members.get(rowIndex).getRole();
            }
            case 1: {
                return this.members.get(rowIndex).getMember();
            }
            case 2: {
                return this.wayConnection(rowIndex);
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 0;
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        RelationMember member = this.members.get(rowIndex);
        RelationMember newMember = new RelationMember(value.toString(), member.getMember());
        this.members.remove(rowIndex);
        this.members.add(rowIndex, newMember);
    }

    public OsmPrimitive getReferredPrimitive(int idx) {
        return this.members.get(idx).getMember();
    }

    public void moveUp(int[] selectedRows) {
        if (!this.canMoveUp(selectedRows)) {
            return;
        }
        for (int row : selectedRows) {
            RelationMember member1 = this.members.get(row);
            RelationMember member2 = this.members.get(row - 1);
            this.members.set(row, member2);
            this.members.set(row - 1, member1);
        }
        this.fireTableDataChanged();
        this.getSelectionModel().setValueIsAdjusting(true);
        this.getSelectionModel().clearSelection();
        for (int row : selectedRows) {
            this.getSelectionModel().addSelectionInterval(--row, row);
        }
        this.getSelectionModel().setValueIsAdjusting(false);
        this.fireMakeMemberVisible(selectedRows[0] - 1);
    }

    public void moveDown(int[] selectedRows) {
        if (!this.canMoveDown(selectedRows)) {
            return;
        }
        for (int i = selectedRows.length - 1; i >= 0; --i) {
            int row = selectedRows[i];
            RelationMember member1 = this.members.get(row);
            RelationMember member2 = this.members.get(row + 1);
            this.members.set(row, member2);
            this.members.set(row + 1, member1);
        }
        this.fireTableDataChanged();
        this.getSelectionModel();
        this.getSelectionModel().setValueIsAdjusting(true);
        this.getSelectionModel().clearSelection();
        for (int row : selectedRows) {
            this.getSelectionModel().addSelectionInterval(++row, row);
        }
        this.getSelectionModel().setValueIsAdjusting(false);
        this.fireMakeMemberVisible(selectedRows[0] + 1);
    }

    public void remove(int[] selectedRows) {
        if (!this.canRemove(selectedRows)) {
            return;
        }
        int offset = 0;
        for (int row : selectedRows) {
            this.members.remove(row -= offset);
            ++offset;
        }
        this.fireTableDataChanged();
    }

    public boolean canMoveUp(int[] rows) {
        if (rows == null || rows.length == 0) {
            return false;
        }
        Arrays.sort(rows);
        return rows[0] > 0 && this.members.size() > 0;
    }

    public boolean canMoveDown(int[] rows) {
        if (rows == null || rows.length == 0) {
            return false;
        }
        Arrays.sort(rows);
        return this.members.size() > 0 && rows[rows.length - 1] < this.members.size() - 1;
    }

    public boolean canRemove(int[] rows) {
        return rows != null && rows.length != 0;
    }

    public DefaultListSelectionModel getSelectionModel() {
        if (this.listSelectionModel == null) {
            this.listSelectionModel = new DefaultListSelectionModel();
            this.listSelectionModel.setSelectionMode(2);
        }
        return this.listSelectionModel;
    }

    public void removeMembersReferringTo(List<? extends OsmPrimitive> primitives) {
        if (primitives == null) {
            return;
        }
        Iterator<RelationMember> it = this.members.iterator();
        while (it.hasNext()) {
            RelationMember member = it.next();
            if (!primitives.contains(member.getMember())) continue;
            it.remove();
        }
        this.fireTableDataChanged();
    }

    public void applyToRelation(Relation relation) {
        relation.setMembers(this.members);
    }

    public boolean hasSameMembersAs(Relation relation) {
        if (relation == null) {
            return false;
        }
        if (relation.getMembersCount() != this.members.size()) {
            return false;
        }
        for (int i = 0; i < relation.getMembersCount(); ++i) {
            if (relation.getMember(i).equals(this.members.get(i))) continue;
            return false;
        }
        return true;
    }

    public Set<OsmPrimitive> getIncompleteMemberPrimitives() {
        HashSet<OsmPrimitive> ret = new HashSet<OsmPrimitive>();
        for (RelationMember member : this.members) {
            if (!member.getMember().isIncomplete()) continue;
            ret.add(member.getMember());
        }
        return ret;
    }

    public Set<OsmPrimitive> getSelectedIncompleteMemberPrimitives() {
        HashSet<OsmPrimitive> ret = new HashSet<OsmPrimitive>();
        for (RelationMember member : this.getSelectedMembers()) {
            if (!member.getMember().isIncomplete()) continue;
            ret.add(member.getMember());
        }
        return ret;
    }

    public boolean hasIncompleteMembers() {
        for (RelationMember member : this.members) {
            if (!member.getMember().isIncomplete()) continue;
            return true;
        }
        return false;
    }

    public boolean hasIncompleteSelectedMembers() {
        for (RelationMember member : this.getSelectedMembers()) {
            if (!member.getMember().isIncomplete()) continue;
            return true;
        }
        return false;
    }

    protected List<Integer> getSelectedIndices() {
        ArrayList<Integer> selectedIndices = new ArrayList<Integer>();
        for (int i = 0; i < this.members.size(); ++i) {
            if (!this.getSelectionModel().isSelectedIndex(i)) continue;
            selectedIndices.add(i);
        }
        return selectedIndices;
    }

    public void addMembersAtBeginning(List<OsmPrimitive> primitives) {
        if (primitives == null) {
            return;
        }
        for (OsmPrimitive primitive : primitives) {
            RelationMember member = new RelationMember("", primitive);
            this.members.add(0, member);
        }
        this.fireTableDataChanged();
        this.getSelectionModel().clearSelection();
        for (int i = 0; i < primitives.size(); ++i) {
            this.getSelectionModel().addSelectionInterval(i, i);
        }
        this.fireMakeMemberVisible(0);
    }

    public void addMembersAtEnd(List<? extends OsmPrimitive> primitives) {
        if (primitives == null) {
            return;
        }
        for (OsmPrimitive osmPrimitive : primitives) {
            RelationMember member = new RelationMember("", osmPrimitive);
            this.members.add(member);
        }
        this.fireTableDataChanged();
        this.getSelectionModel().clearSelection();
        for (int i = 0; i < primitives.size(); ++i) {
            this.getSelectionModel().addSelectionInterval(this.members.size() - 1 - i, this.members.size() - 1 - i);
        }
        this.fireMakeMemberVisible(this.members.size() - 1);
    }

    public void addMembersBeforeIdx(List<? extends OsmPrimitive> primitives, int idx) {
        if (primitives == null) {
            return;
        }
        for (OsmPrimitive osmPrimitive : primitives) {
            RelationMember member = new RelationMember("", osmPrimitive);
            this.members.add(idx, member);
        }
        this.fireTableDataChanged();
        this.getSelectionModel().setValueIsAdjusting(true);
        this.getSelectionModel().clearSelection();
        for (int i = 0; i < primitives.size(); ++i) {
            this.getSelectionModel().addSelectionInterval(idx + i, idx + i);
        }
        this.getSelectionModel().setValueIsAdjusting(false);
        this.fireMakeMemberVisible(idx);
    }

    public void addMembersAfterIdx(List<? extends OsmPrimitive> primitives, int idx) {
        if (primitives == null) {
            return;
        }
        int j = 1;
        for (OsmPrimitive osmPrimitive : primitives) {
            RelationMember member = new RelationMember("", osmPrimitive);
            this.members.add(idx + j, member);
            ++j;
        }
        this.fireTableDataChanged();
        this.getSelectionModel().setValueIsAdjusting(true);
        this.getSelectionModel().clearSelection();
        for (int i = 0; i < primitives.size(); ++i) {
            this.getSelectionModel().addSelectionInterval(idx + 1 + i, idx + 1 + i);
        }
        this.getSelectionModel().setValueIsAdjusting(false);
        this.fireMakeMemberVisible(idx + 1);
    }

    public int getNumMembersWithPrimitive(OsmPrimitive primitive) {
        int count = 0;
        for (RelationMember member : this.members) {
            if (!member.getMember().equals(primitive)) continue;
            ++count;
        }
        return count;
    }

    public void updateRole(int[] idx, String role) {
        if (idx == null || idx.length == 0) {
            return;
        }
        for (int row : idx) {
            RelationMember oldMember = this.members.get(row);
            RelationMember newMember = new RelationMember(role, oldMember.getMember());
            this.members.remove(row);
            this.members.add(row, newMember);
        }
        this.fireTableDataChanged();
        for (int row : idx) {
            this.getSelectionModel().addSelectionInterval(row, row);
        }
    }

    public Collection<RelationMember> getSelectedMembers() {
        ArrayList<RelationMember> selectedMembers = new ArrayList<RelationMember>();
        for (int i : this.getSelectedIndices()) {
            selectedMembers.add(this.members.get(i));
        }
        return selectedMembers;
    }

    public Set<OsmPrimitive> getSelectedChildPrimitives() {
        HashSet<OsmPrimitive> ret = new HashSet<OsmPrimitive>();
        for (RelationMember m : this.getSelectedMembers()) {
            ret.add(m.getMember());
        }
        return ret;
    }

    public Set<OsmPrimitive> getChildPrimitives(Collection<? extends OsmPrimitive> referenceSet) {
        HashSet<OsmPrimitive> ret = new HashSet<OsmPrimitive>();
        if (referenceSet == null) {
            return null;
        }
        for (RelationMember m : this.members) {
            if (!referenceSet.contains(m.getMember())) continue;
            ret.add(m.getMember());
        }
        return ret;
    }

    public void setSelectedMembers(Collection<RelationMember> selectedMembers) {
        if (selectedMembers == null || selectedMembers.isEmpty()) {
            this.getSelectionModel().clearSelection();
            return;
        }
        HashSet<Integer> selectedIndices = new HashSet<Integer>();
        for (RelationMember member : selectedMembers) {
            int idx = this.members.indexOf(member);
            if (idx < 0) continue;
            selectedIndices.add(idx);
        }
        this.setSelectedMembersIdx(selectedIndices);
    }

    public void setSelectedMembersIdx(Collection<Integer> selectedIndices) {
        if (selectedIndices == null || selectedIndices.isEmpty()) {
            this.getSelectionModel().clearSelection();
            return;
        }
        this.getSelectionModel().setValueIsAdjusting(true);
        this.getSelectionModel().clearSelection();
        for (int row : selectedIndices) {
            this.getSelectionModel().addSelectionInterval(row, row);
        }
        this.getSelectionModel().setValueIsAdjusting(false);
        if (selectedIndices.size() > 0) {
            this.fireMakeMemberVisible(Collections.min(selectedIndices));
        }
    }

    public boolean isEditableRelation(int index) {
        if (index < 0 || index >= this.members.size()) {
            return false;
        }
        RelationMember member = this.members.get(index);
        if (!member.isRelation()) {
            return false;
        }
        Relation r = member.getRelation();
        return !r.isIncomplete();
    }

    public boolean hasMembersReferringTo(Collection<OsmPrimitive> primitives) {
        if (primitives == null || primitives.isEmpty()) {
            return false;
        }
        HashSet<OsmPrimitive> referrers = new HashSet<OsmPrimitive>();
        for (RelationMember member : this.members) {
            referrers.add(member.getMember());
        }
        for (OsmPrimitive referred : primitives) {
            if (!referrers.contains(referred)) continue;
            return true;
        }
        return false;
    }

    public void selectMembersReferringTo(Collection<? extends OsmPrimitive> primitives) {
        if (primitives == null) {
            return;
        }
        this.getSelectionModel().setValueIsAdjusting(true);
        this.getSelectionModel().clearSelection();
        for (int i = 0; i < this.members.size(); ++i) {
            RelationMember m = this.members.get(i);
            if (!primitives.contains(m.getMember())) continue;
            this.getSelectionModel().addSelectionInterval(i, i);
        }
        this.getSelectionModel().setValueIsAdjusting(false);
        if (this.getSelectedIndices().size() > 0) {
            this.fireMakeMemberVisible(this.getSelectedIndices().get(0));
        }
    }

    public boolean isInJosmSelection(OsmPrimitive primitive) {
        return this.layer.data.isSelected(primitive);
    }

    protected boolean isActiveLayer() {
        if (Main.map == null || Main.map.mapView == null) {
            return false;
        }
        return Main.map.mapView.getActiveLayer() == this.layer;
    }

    private static Node getUnusedNode(RelationMember element, RelationMember linked_element) {
        Node result = null;
        if (element.isWay()) {
            Way w = element.getWay();
            if (linked_element.isWay()) {
                Way x = linked_element.getWay();
                result = w.firstNode() == x.firstNode() || w.firstNode() == x.lastNode() ? w.lastNode() : w.firstNode();
            } else if (linked_element.isNode()) {
                Node m = linked_element.getNode();
                result = w.firstNode() == m ? w.lastNode() : w.firstNode();
            }
        } else if (element.isNode()) {
            Node n;
            result = n = element.getNode();
        }
        return result;
    }

    private List<RelationMember> sortMembers(List<RelationMember> relationMembers) {
        LinkedList<Integer> group;
        Integer first;
        RelationNodeMap map = new RelationNodeMap(relationMembers);
        ArrayList allGroups = new ArrayList();
        while ((first = map.pop()) != null) {
            group = new LinkedList<Integer>();
            group.add(first);
            allGroups.add(group);
            Integer next = first;
            while ((next = map.popAdjacent(next)) != null) {
                group.addLast(next);
            }
            next = first;
            while ((next = map.popAdjacent(next)) != null) {
                group.addFirst(next);
            }
        }
        group = new LinkedList();
        group.addAll(map.getNotSortableMembers());
        allGroups.add(group);
        ArrayList<RelationMember> newMembers = new ArrayList<RelationMember>();
        for (LinkedList linkedList : allGroups) {
            for (Integer p : linkedList) {
                newMembers.add(relationMembers.get(p));
            }
        }
        return newMembers;
    }

    void sort() {
        List<RelationMember> newMembers;
        ArrayList<RelationMember> selectedMembers = new ArrayList<RelationMember>(this.getSelectedMembers());
        List<RelationMember> sortedMembers = null;
        if (selectedMembers.size() <= 1) {
            sortedMembers = newMembers = this.sortMembers(this.members);
        } else {
            sortedMembers = this.sortMembers(selectedMembers);
            List<Integer> selectedIndices = this.getSelectedIndices();
            newMembers = new ArrayList<RelationMember>();
            boolean inserted = false;
            for (int i = 0; i < this.members.size(); ++i) {
                if (selectedIndices.contains(i)) {
                    if (inserted) continue;
                    newMembers.addAll(sortedMembers);
                    inserted = true;
                    continue;
                }
                newMembers.add(this.members.get(i));
            }
        }
        if (this.members.size() != newMembers.size()) {
            throw new AssertionError();
        }
        this.members.clear();
        this.members.addAll(newMembers);
        this.fireTableDataChanged();
        this.setSelectedMembers(sortedMembers);
    }

    private WayConnectionType.Direction determineDirection(int ref_i, WayConnectionType.Direction ref_direction, int k) {
        if (ref_i < 0 || k < 0 || ref_i >= this.members.size() || k >= this.members.size()) {
            return WayConnectionType.Direction.NONE;
        }
        if (ref_direction == WayConnectionType.Direction.NONE) {
            return WayConnectionType.Direction.NONE;
        }
        RelationMember m_ref = this.members.get(ref_i);
        RelationMember m = this.members.get(k);
        Way way_ref = null;
        Way way = null;
        if (m_ref.isWay()) {
            way_ref = m_ref.getWay();
        }
        if (m.isWay()) {
            way = m.getWay();
        }
        if (way_ref == null || way == null) {
            return WayConnectionType.Direction.NONE;
        }
        List<Object> refNodes = new ArrayList<Node>();
        switch (ref_direction) {
            case FORWARD: {
                refNodes.add(way_ref.lastNode());
                break;
            }
            case BACKWARD: {
                refNodes.add(way_ref.firstNode());
                break;
            }
            case ROUNDABOUT_LEFT: 
            case ROUNDABOUT_RIGHT: {
                refNodes = way_ref.getNodes();
            }
        }
        if (refNodes == null) {
            return WayConnectionType.Direction.NONE;
        }
        for (Node node : refNodes) {
            if (node == null) continue;
            if (this.roundaboutType(k) != WayConnectionType.Direction.NONE) {
                for (Node nn : way.getNodes()) {
                    if (node != nn) continue;
                    return this.roundaboutType(k);
                }
                continue;
            }
            if (node == way.firstNode()) {
                return WayConnectionType.Direction.FORWARD;
            }
            if (node != way.lastNode()) continue;
            return WayConnectionType.Direction.BACKWARD;
        }
        return WayConnectionType.Direction.NONE;
    }

    private WayConnectionType.Direction roundaboutType(int i) {
        RelationMember m = this.members.get(i);
        if (m == null || !m.isWay()) {
            return WayConnectionType.Direction.NONE;
        }
        Way w = m.getWay();
        return MemberTableModel.roundaboutType(w);
    }

    static WayConnectionType.Direction roundaboutType(Way w) {
        if (w != null && "roundabout".equals(w.get("junction")) && w.getNodesCount() < 200 && w.getNodesCount() > 2 && w.getNode(0) != null && w.getNode(1) != null && w.getNode(2) != null && w.firstNode() == w.lastNode()) {
            EastNorth en1 = w.getNode(0).getEastNorth();
            EastNorth en2 = w.getNode(1).getEastNorth();
            EastNorth en3 = w.getNode(2).getEastNorth();
            en1 = en1.sub(en2);
            en2 = en2.sub(en3);
            return en1.north() * en2.east() - en2.north() * en1.east() > 0.0 ? WayConnectionType.Direction.ROUNDABOUT_LEFT : WayConnectionType.Direction.ROUNDABOUT_RIGHT;
        }
        return WayConnectionType.Direction.NONE;
    }

    private WayConnectionType wayConnection(int i) {
        if (this.connectionType == null) {
            this.updateLinks();
        }
        return this.connectionType.get(i);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.connectionType = null;
    }

    void reverse() {
        List<Integer> selectedIndices = this.getSelectedIndices();
        List<Integer> selectedIndicesReversed = this.getSelectedIndices();
        if (selectedIndices.size() <= 1) {
            Collections.reverse(this.members);
            this.fireTableDataChanged();
            this.setSelectedMembers(this.members);
        } else {
            Collections.reverse(selectedIndicesReversed);
            ArrayList<RelationMember> newMembers = new ArrayList<RelationMember>(this.members);
            for (int i = 0; i < selectedIndices.size(); ++i) {
                newMembers.set(selectedIndices.get(i), this.members.get(selectedIndicesReversed.get(i)));
            }
            if (this.members.size() != newMembers.size()) {
                throw new AssertionError();
            }
            this.members.clear();
            this.members.addAll(newMembers);
            this.fireTableDataChanged();
            this.setSelectedMembersIdx(selectedIndices);
        }
    }

    public void updateLinks() {
        this.connectionType = null;
        ArrayList<WayConnectionType> con = new ArrayList<WayConnectionType>();
        for (int i = 0; i < this.members.size(); ++i) {
            con.add(null);
        }
        int firstGroupIdx = 0;
        boolean resetFirstGoupIdx = false;
        for (int i = 0; i < this.members.size(); ++i) {
            boolean loop;
            boolean linkNext;
            WayConnectionType.Direction dir;
            boolean linkPrev;
            RelationMember m;
            if (resetFirstGoupIdx) {
                firstGroupIdx = i;
                resetFirstGoupIdx = false;
            }
            if (!(m = this.members.get(i)).isWay()) {
                con.set(i, new WayConnectionType());
                resetFirstGoupIdx = true;
                continue;
            }
            Way w = m.getWay();
            if (w == null || w.isIncomplete()) {
                con.set(i, new WayConnectionType());
                resetFirstGoupIdx = true;
                continue;
            }
            boolean bl = linkPrev = i != firstGroupIdx;
            if (linkPrev) {
                dir = this.determineDirection(i - 1, con.get((int)(i - 1)).direction, i);
                linkNext = this.determineDirection(i, dir, i + 1) != WayConnectionType.Direction.NONE;
            } else {
                if (this.roundaboutType(i) != WayConnectionType.Direction.NONE) {
                    dir = this.determineDirection(i, this.roundaboutType(i), i + 1) != WayConnectionType.Direction.NONE ? this.roundaboutType(i) : WayConnectionType.Direction.NONE;
                } else {
                    WayConnectionType.Direction direction = dir = this.determineDirection(i, WayConnectionType.Direction.FORWARD, i + 1) != WayConnectionType.Direction.NONE ? WayConnectionType.Direction.FORWARD : WayConnectionType.Direction.NONE;
                    if (dir == WayConnectionType.Direction.NONE) {
                        dir = this.determineDirection(i, WayConnectionType.Direction.BACKWARD, i + 1) != WayConnectionType.Direction.NONE ? WayConnectionType.Direction.BACKWARD : WayConnectionType.Direction.NONE;
                    }
                }
                boolean bl2 = linkNext = dir != WayConnectionType.Direction.NONE;
                if (dir == WayConnectionType.Direction.NONE && this.roundaboutType(i) != WayConnectionType.Direction.NONE) {
                    dir = this.roundaboutType(i);
                }
            }
            con.set(i, new WayConnectionType(linkPrev, linkNext, dir));
            if (linkNext) continue;
            if (i == firstGroupIdx) {
                loop = this.determineDirection(i, WayConnectionType.Direction.FORWARD, i) == WayConnectionType.Direction.FORWARD;
            } else {
                boolean bl3 = loop = this.determineDirection(i, dir, firstGroupIdx) == con.get((int)firstGroupIdx).direction;
            }
            if (loop) {
                for (int j = firstGroupIdx; j <= i; ++j) {
                    con.get((int)j).isLoop = true;
                }
            }
            resetFirstGoupIdx = true;
        }
        this.connectionType = con;
    }
}

