/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.download;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.download.BookmarkSelection;
import org.openstreetmap.josm.gui.download.BoundingBoxSelection;
import org.openstreetmap.josm.gui.download.DownloadSelection;
import org.openstreetmap.josm.gui.download.PlaceSelection;
import org.openstreetmap.josm.gui.download.SlippyMapChooser;
import org.openstreetmap.josm.gui.download.TileSelection;
import org.openstreetmap.josm.gui.help.ContextSensitiveHelpAction;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.OsmUrlToBounds;
import org.openstreetmap.josm.tools.WindowGeometry;

public class DownloadDialog
extends JDialog {
    private static final Logger logger = Logger.getLogger(DownloadDialog.class.getName());
    private static DownloadDialog instance;
    private final List<DownloadSelection> downloadSelections = new ArrayList<DownloadSelection>();
    private final JTabbedPane tpDownloadAreaSelectors = new JTabbedPane();
    private JCheckBox cbNewLayer;
    private final JLabel sizeCheck = new JLabel();
    private Bounds currentBounds = null;
    private boolean canceled;
    private JCheckBox cbDownloadOsmData;
    private JCheckBox cbDownloadGpxData;
    private DownloadAction actDownload;
    private SideButton btnDownload;

    public static DownloadDialog getInstance() {
        if (instance == null) {
            instance = new DownloadDialog(Main.parent);
        }
        return instance;
    }

    private void makeCheckBoxRespondToEnter(JCheckBox cb) {
        cb.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "doDownload");
        cb.getActionMap().put("doDownload", this.actDownload);
    }

    public JPanel buildMainPanel() {
        JPanel pnl = new JPanel();
        pnl.setLayout(new GridBagLayout());
        pnl.add((Component)new JLabel(I18n.tr("Data Sources and Types:")), GBC.std().insets(5, 5, 1, 5));
        this.cbDownloadOsmData = new JCheckBox(I18n.tr("OpenStreetMap data"), true);
        this.cbDownloadOsmData.setToolTipText(I18n.tr("Select to download OSM data in the selected download area."));
        pnl.add((Component)this.cbDownloadOsmData, GBC.std().insets(1, 5, 1, 5));
        this.cbDownloadGpxData = new JCheckBox(I18n.tr("Raw GPS data"));
        this.cbDownloadGpxData.setToolTipText(I18n.tr("Select to download GPS traces in the selected download area."));
        pnl.add((Component)this.cbDownloadGpxData, GBC.eol().insets(5, 5, 1, 5));
        this.downloadSelections.add(new SlippyMapChooser());
        this.downloadSelections.add(new BookmarkSelection());
        this.downloadSelections.add(new BoundingBoxSelection());
        this.downloadSelections.add(new PlaceSelection());
        this.downloadSelections.add(new TileSelection());
        PluginHandler.addDownloadSelection(this.downloadSelections);
        for (DownloadSelection s : this.downloadSelections) {
            s.addGui(this);
        }
        pnl.add((Component)this.tpDownloadAreaSelectors, GBC.eol().fill());
        try {
            this.tpDownloadAreaSelectors.setSelectedIndex(Main.pref.getInteger("download.tab", 0));
        }
        catch (Exception ex) {
            Main.pref.putInteger("download.tab", 0);
        }
        Font labelFont = this.sizeCheck.getFont();
        this.sizeCheck.setFont(labelFont.deriveFont(0, labelFont.getSize()));
        this.cbNewLayer = new JCheckBox(I18n.tr("Download as new layer"));
        this.cbNewLayer.setToolTipText(I18n.tr("<html>Select to download data into a new data layer.<br>Unselect to download into the currently active data layer.</html>"));
        pnl.add((Component)this.cbNewLayer, GBC.std().anchor(17).insets(5, 5, 5, 5));
        pnl.add((Component)this.sizeCheck, GBC.eol().anchor(13).insets(5, 5, 5, 5));
        return pnl;
    }

    protected JPanel buildButtonPanel() {
        JPanel pnl = new JPanel();
        pnl.setLayout(new FlowLayout());
        this.actDownload = new DownloadAction();
        this.btnDownload = new SideButton(this.actDownload);
        pnl.add(this.btnDownload);
        this.btnDownload.setFocusable(true);
        this.btnDownload.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "download");
        this.btnDownload.getActionMap().put("download", this.actDownload);
        this.makeCheckBoxRespondToEnter(this.cbDownloadGpxData);
        this.makeCheckBoxRespondToEnter(this.cbDownloadOsmData);
        this.makeCheckBoxRespondToEnter(this.cbNewLayer);
        CancelAction actCancel = new CancelAction();
        SideButton btnCancel = new SideButton(actCancel);
        pnl.add(btnCancel);
        btnCancel.setFocusable(true);
        btnCancel.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "enter");
        btnCancel.getActionMap().put("enter", actCancel);
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "cancel");
        this.getRootPane().getActionMap().put("cancel", actCancel);
        SideButton btnHelp = new SideButton(new ContextSensitiveHelpAction(HelpUtil.ht("/Dialog/DownloadDialog")));
        pnl.add(btnHelp);
        btnHelp.setFocusable(true);
        btnHelp.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "enter");
        btnHelp.getActionMap().put("enter", btnHelp.getAction());
        return pnl;
    }

    public DownloadDialog(Component parent) {
        super(JOptionPane.getFrameForComponent(parent), I18n.tr("Download"), true);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.buildMainPanel(), "Center");
        this.getContentPane().add((Component)this.buildButtonPanel(), "South");
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(86, 2), "checkClipboardContents");
        this.getRootPane().getActionMap().put("checkClipboardContents", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                DownloadDialog.this.checkClipboardContents();
            }
        });
        HelpUtil.setHelpContext(this.getRootPane(), HelpUtil.ht("/Dialog/DownloadDialog"));
        this.addWindowListener(new WindowEventHandler());
        this.restoreSettings();
    }

    private void checkClipboardContents() {
        String result = "";
        Transferable contents = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
        if (contents == null || !contents.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            return;
        }
        try {
            result = (String)contents.getTransferData(DataFlavor.stringFlavor);
        }
        catch (Exception ex) {
            return;
        }
        Bounds b = OsmUrlToBounds.parse(result);
        if (b != null) {
            this.boundingBoxChanged(new Bounds(b), null);
        }
    }

    private void updateSizeCheck() {
        if (this.currentBounds == null) {
            this.sizeCheck.setText(I18n.tr("No area selected yet"));
            this.sizeCheck.setForeground(Color.darkGray);
        } else if (this.currentBounds.getArea() > Main.pref.getDouble("osm-server.max-request-area", 0.25)) {
            this.sizeCheck.setText(I18n.tr("Download area too large; will probably be rejected by server"));
            this.sizeCheck.setForeground(Color.red);
        } else {
            this.sizeCheck.setText(I18n.tr("Download area ok, size probably acceptable to server"));
            this.sizeCheck.setForeground(Color.darkGray);
        }
    }

    public void boundingBoxChanged(Bounds b, DownloadSelection eventSource) {
        this.currentBounds = b;
        for (DownloadSelection s : this.downloadSelections) {
            if (s == eventSource) continue;
            s.setDownloadArea(this.currentBounds);
        }
        this.updateSizeCheck();
    }

    public void startDownload(Bounds b) {
        this.currentBounds = b;
        this.actDownload.run();
    }

    public boolean isDownloadOsmData() {
        return this.cbDownloadOsmData.isSelected();
    }

    public boolean isDownloadGpxData() {
        return this.cbDownloadGpxData.isSelected();
    }

    public boolean isNewLayerRequired() {
        return this.cbNewLayer.isSelected();
    }

    public void addDownloadAreaSelector(JPanel selector, String displayName) {
        this.tpDownloadAreaSelectors.add(displayName, selector);
    }

    public void rememberSettings() {
        Main.pref.put("download.tab", Integer.toString(this.tpDownloadAreaSelectors.getSelectedIndex()));
        Main.pref.put("download.osm", this.cbDownloadOsmData.isSelected());
        Main.pref.put("download.gps", this.cbDownloadGpxData.isSelected());
        Main.pref.put("download.newlayer", this.cbNewLayer.isSelected());
        if (this.currentBounds != null) {
            Main.pref.put("osm-download.bounds", this.currentBounds.encodeAsString(";"));
        }
    }

    public void restoreSettings() {
        this.cbDownloadOsmData.setSelected(Main.pref.getBoolean("download.osm", true));
        this.cbDownloadGpxData.setSelected(Main.pref.getBoolean("download.gps", false));
        this.cbNewLayer.setSelected(Main.pref.getBoolean("download.newlayer", false));
        int idx = Main.pref.getInteger("download.tab", 0);
        if (idx < 0 || idx > this.tpDownloadAreaSelectors.getTabCount()) {
            idx = 0;
        }
        this.tpDownloadAreaSelectors.setSelectedIndex(idx);
        if (Main.map != null) {
            MapView mv = Main.map.mapView;
            this.currentBounds = new Bounds(mv.getLatLon(0, mv.getHeight()), mv.getLatLon(mv.getWidth(), 0));
            this.boundingBoxChanged(this.currentBounds, null);
        } else if (Main.pref.hasKey("osm-download.bounds")) {
            try {
                this.currentBounds = new Bounds(Main.pref.get("osm-download.bounds"), ";");
                this.boundingBoxChanged(this.currentBounds, null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public Bounds getSelectedDownloadArea() {
        return this.currentBounds;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            new WindowGeometry(this.getClass().getName() + ".geometry", WindowGeometry.centerInWindow(this.getParent(), new Dimension(1000, 600))).applySafe(this);
        } else if (!visible && this.isShowing()) {
            new WindowGeometry(this).remember(this.getClass().getName() + ".geometry");
        }
        super.setVisible(visible);
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    protected void setCanceled(boolean canceled) {
        this.canceled = canceled;
    }

    class WindowEventHandler
    extends WindowAdapter {
        WindowEventHandler() {
        }

        public void windowClosing(WindowEvent e) {
            new CancelAction().run();
        }

        public void windowActivated(WindowEvent e) {
            DownloadDialog.this.btnDownload.requestFocusInWindow();
        }
    }

    class DownloadAction
    extends AbstractAction {
        public DownloadAction() {
            this.putValue("Name", I18n.tr("Download"));
            this.putValue("SmallIcon", ImageProvider.get("download"));
            this.putValue("ShortDescription", I18n.tr("Click do download the currently selected area"));
        }

        public void run() {
            if (DownloadDialog.this.currentBounds == null) {
                JOptionPane.showMessageDialog(DownloadDialog.this, I18n.tr("Please select a download area first."), I18n.tr("Error"), 0);
                return;
            }
            if (!DownloadDialog.this.isDownloadOsmData() && !DownloadDialog.this.isDownloadGpxData()) {
                JOptionPane.showMessageDialog(DownloadDialog.this, I18n.tr("<html>Neither <strong>{0}</strong> nor <strong>{1}</strong> is enabled.<br>Please chose to either download OSM data, or GPX data, or both.</html>", DownloadDialog.this.cbDownloadOsmData.getText(), DownloadDialog.this.cbDownloadGpxData.getText()), I18n.tr("Error"), 0);
                return;
            }
            DownloadDialog.this.setCanceled(false);
            DownloadDialog.this.setVisible(false);
        }

        public void actionPerformed(ActionEvent e) {
            this.run();
        }
    }

    class CancelAction
    extends AbstractAction {
        public CancelAction() {
            this.putValue("Name", I18n.tr("Cancel"));
            this.putValue("SmallIcon", ImageProvider.get("cancel"));
            this.putValue("ShortDescription", I18n.tr("Click to close the dialog and to abort downloading"));
        }

        public void run() {
            DownloadDialog.this.setCanceled(true);
            DownloadDialog.this.setVisible(false);
        }

        public void actionPerformed(ActionEvent e) {
            this.run();
        }
    }
}

