/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import org.openstreetmap.josm.gui.history.HistoryBrowserModel;
import org.openstreetmap.josm.tools.I18n;

public class TagTableCellRenderer
extends JLabel
implements TableCellRenderer {
    private static Logger logger = Logger.getLogger(TagTableCellRenderer.class.getName());
    public static final Color BGCOLOR_DIFFERENCE = new Color(255, 197, 197);

    public TagTableCellRenderer() {
        this.setOpaque(true);
    }

    protected void renderName(String key, HistoryBrowserModel.TagTableModel model, boolean isSelected) {
        String text = key;
        Color bgColor = UIManager.getColor("Table.background");
        Color fgColor = UIManager.getColor("Table.foreground");
        Font font = UIManager.getFont("Table.font");
        if (!model.hasTag(key)) {
            text = I18n.tr("not present");
            bgColor = BGCOLOR_DIFFERENCE;
            font = font.deriveFont(2);
        } else if (!model.oppositeHasTag(key)) {
            bgColor = BGCOLOR_DIFFERENCE;
        }
        if (isSelected) {
            bgColor = UIManager.getColor("Table.backgroundSelected");
            fgColor = UIManager.getColor("Table.foregroundSelected");
        }
        this.setText(text);
        this.setToolTipText(text);
        this.setBackground(bgColor);
        this.setForeground(fgColor);
        this.setFont(font);
    }

    protected void renderValue(String key, HistoryBrowserModel.TagTableModel model, boolean isSelected) {
        String text = "";
        Color bgColor = UIManager.getColor("Table.background");
        Color fgColor = UIManager.getColor("Table.foreground");
        Font font = UIManager.getFont("Table.font");
        if (!model.hasTag(key)) {
            text = I18n.tr("not present");
            bgColor = BGCOLOR_DIFFERENCE;
            font = font.deriveFont(2);
        } else {
            text = model.getValue(key);
            if (!model.hasSameValueAsOpposite(key)) {
                bgColor = BGCOLOR_DIFFERENCE;
            }
        }
        if (isSelected) {
            bgColor = UIManager.getColor("Table.backgroundSelected");
            fgColor = UIManager.getColor("Table.foregroundSelected");
        }
        this.setText(text);
        this.setToolTipText(text);
        this.setBackground(bgColor);
        this.setForeground(fgColor);
        this.setFont(font);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        String key = (String)value;
        HistoryBrowserModel.TagTableModel model = this.getTagTableModel(table);
        switch (column) {
            case 0: {
                this.renderName(key, model, isSelected);
                break;
            }
            case 1: {
                this.renderValue(key, model, isSelected);
            }
        }
        return this;
    }

    protected HistoryBrowserModel.TagTableModel getTagTableModel(JTable table) {
        return (HistoryBrowserModel.TagTableModel)table.getModel();
    }
}

