/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.io.ChangesetCommentModel;
import org.openstreetmap.josm.gui.io.UploadParameterSummaryPanel;
import org.openstreetmap.josm.gui.widgets.HistoryComboBox;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class BasicUploadSettingsPanel
extends JPanel {
    public static final String HISTORY_KEY = "upload.comment.history";
    private HistoryComboBox hcbUploadComment;
    private UploadParameterSummaryPanel pnlUploadParameterSummary;
    private ChangesetCommentModel changesetCommentModel;

    protected JPanel buildUploadCommentPanel() {
        JPanel pnl = new JPanel();
        pnl.setLayout(new GridBagLayout());
        pnl.add((Component)new JLabel(I18n.tr("Provide a brief comment for the changes you are uploading:")), GBC.eol().insets(0, 5, 10, 3));
        this.hcbUploadComment = new HistoryComboBox();
        this.hcbUploadComment.setToolTipText(I18n.tr("Enter an upload comment (min. 3 characters)"));
        LinkedList<String> cmtHistory = new LinkedList<String>(Main.pref.getCollection(HISTORY_KEY, new LinkedList<String>()));
        Collections.reverse(cmtHistory);
        this.hcbUploadComment.setPossibleItems(cmtHistory);
        this.hcbUploadComment.getEditor().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BasicUploadSettingsPanel.this.changesetCommentModel.setComment(BasicUploadSettingsPanel.this.hcbUploadComment.getText());
            }
        });
        this.hcbUploadComment.getEditor().getEditorComponent().addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                BasicUploadSettingsPanel.this.changesetCommentModel.setComment(BasicUploadSettingsPanel.this.hcbUploadComment.getText());
            }
        });
        pnl.add((Component)this.hcbUploadComment, GBC.eol().fill(2));
        return pnl;
    }

    protected void build() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.add((Component)this.buildUploadCommentPanel(), "North");
        this.pnlUploadParameterSummary = new UploadParameterSummaryPanel();
        this.add((Component)this.pnlUploadParameterSummary, "Center");
    }

    public BasicUploadSettingsPanel(ChangesetCommentModel changesetCommentModel) {
        CheckParameterUtil.ensureParameterNotNull(changesetCommentModel, "changesetCommentModel");
        this.changesetCommentModel = changesetCommentModel;
        changesetCommentModel.addObserver(new ChangesetCommentObserver());
        this.build();
    }

    public void setUploadCommentDownFocusTraversalHandler(final Action handler) {
        this.hcbUploadComment.getEditor().addActionListener(handler);
        this.hcbUploadComment.getEditor().getEditorComponent().addKeyListener(new KeyListener(){

            public void keyTyped(KeyEvent e) {
                if (e.getKeyCode() == 9) {
                    handler.actionPerformed(new ActionEvent(BasicUploadSettingsPanel.this.hcbUploadComment, 0, "focusDown"));
                }
            }

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
            }
        });
    }

    public void rememberUserInput() {
        this.hcbUploadComment.addCurrentItemToHistory();
        Main.pref.putCollection(HISTORY_KEY, this.hcbUploadComment.getHistory());
    }

    public void startUserInput() {
        List<String> history = this.hcbUploadComment.getHistory();
        if (history != null && !history.isEmpty()) {
            this.hcbUploadComment.setText(history.get(0));
        }
        this.hcbUploadComment.requestFocusInWindow();
        this.hcbUploadComment.getEditor().getEditorComponent().requestFocusInWindow();
    }

    public void initEditingOfUploadComment() {
        this.hcbUploadComment.getEditor().selectAll();
        this.hcbUploadComment.requestFocusInWindow();
    }

    public UploadParameterSummaryPanel getUploadParameterSummaryPanel() {
        return this.pnlUploadParameterSummary;
    }

    class ChangesetCommentObserver
    implements Observer {
        ChangesetCommentObserver() {
        }

        public void update(Observable o, Object arg) {
            if (!(o instanceof ChangesetCommentModel)) {
                return;
            }
            String newComment = (String)arg;
            if (!BasicUploadSettingsPanel.this.hcbUploadComment.getText().equals(newComment)) {
                BasicUploadSettingsPanel.this.hcbUploadComment.setText(newComment);
            }
        }
    }
}

