/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.swing.AbstractAction;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.UploadAction;
import org.openstreetmap.josm.data.APIDataSet;
import org.openstreetmap.josm.gui.ExceptionDialogUtil;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.io.AbstractIOTask;
import org.openstreetmap.josm.gui.io.SaveLayerInfo;
import org.openstreetmap.josm.gui.io.SaveLayerTask;
import org.openstreetmap.josm.gui.io.SaveLayersModel;
import org.openstreetmap.josm.gui.io.SaveLayersTable;
import org.openstreetmap.josm.gui.io.UploadAndSaveProgressRenderer;
import org.openstreetmap.josm.gui.io.UploadDialog;
import org.openstreetmap.josm.gui.io.UploadLayerTask;
import org.openstreetmap.josm.gui.io.UploadOrSaveState;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.progress.SwingRenderingProgressMonitor;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.WindowGeometry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SaveLayersDialog
extends JDialog {
    private SaveLayersModel model;
    private UserAction action = UserAction.CANCEL;
    private UploadAndSaveProgressRenderer pnlUploadLayers;
    private SaveAndProceedAction saveAndProceedAction;
    private DiscardAndProceedAction discardAndProceedAction;
    private CancelAction cancelAction;
    private SaveAndUploadTask saveAndUploadTask;

    protected void build() {
        WindowGeometry geometry = WindowGeometry.centerOnScreen(new Dimension(600, 300));
        geometry.apply(this);
        this.getContentPane().setLayout(new BorderLayout());
        this.model = new SaveLayersModel();
        SaveLayersTable table = new SaveLayersTable(this.model);
        JScrollPane pane = new JScrollPane(table);
        this.model.addPropertyChangeListener(table);
        this.getContentPane().add((Component)pane, "Center");
        this.getContentPane().add((Component)this.buildButtonRow(), "South");
        table.getTableHeader().setPreferredSize(new Dimension(table.getTableHeader().getWidth(), 40));
        this.addWindowListener(new WindowClosingAdapter());
    }

    protected JPanel buildButtonRow() {
        JPanel pnl = new JPanel();
        pnl.setLayout(new FlowLayout(1));
        this.saveAndProceedAction = new SaveAndProceedAction();
        this.model.addPropertyChangeListener(this.saveAndProceedAction);
        pnl.add(new SideButton(this.saveAndProceedAction));
        this.discardAndProceedAction = new DiscardAndProceedAction();
        this.model.addPropertyChangeListener(this.discardAndProceedAction);
        pnl.add(new SideButton(this.discardAndProceedAction));
        this.cancelAction = new CancelAction();
        pnl.add(new SideButton(this.cancelAction));
        JPanel pnl2 = new JPanel();
        pnl2.setLayout(new BorderLayout());
        this.pnlUploadLayers = new UploadAndSaveProgressRenderer();
        pnl2.add((Component)this.pnlUploadLayers, "Center");
        this.model.addPropertyChangeListener(this.pnlUploadLayers);
        pnl2.add((Component)pnl, "South");
        return pnl2;
    }

    public void prepareForSavingAndUpdatingLayersBeforeExit() {
        this.setTitle(I18n.tr("Unsaved changes - Save/Upload before exiting?"));
        this.saveAndProceedAction.initForSaveAndExit();
        this.discardAndProceedAction.initForDiscardAndExit();
    }

    public void prepareForSavingAndUpdatingLayersBeforeDelete() {
        this.setTitle(I18n.tr("Unsaved changes - Save/Upload before deleting?"));
        this.saveAndProceedAction.initForSaveAndDelete();
        this.discardAndProceedAction.initForDiscardAndDelete();
    }

    public SaveLayersDialog(Component parent) {
        super(JOptionPane.getFrameForComponent(parent), true);
        this.build();
    }

    public UserAction getUserAction() {
        return this.action;
    }

    public SaveLayersModel getModel() {
        return this.model;
    }

    protected void launchSafeAndUploadTask() {
        SwingRenderingProgressMonitor monitor = new SwingRenderingProgressMonitor(this.pnlUploadLayers);
        monitor.beginTask(I18n.tr("Uploading and saving modified layers ..."));
        this.saveAndUploadTask = new SaveAndUploadTask(this.model, monitor);
        new Thread(this.saveAndUploadTask).start();
    }

    protected void cancelSafeAndUploadTask() {
        if (this.saveAndUploadTask != null) {
            this.saveAndUploadTask.cancel();
        }
        this.model.setMode(SaveLayersModel.Mode.EDITING_DATA);
    }

    protected void warnLayersWithConflictsAndUploadRequest(List<SaveLayerInfo> infos) {
        String msg = I18n.trn("<html>{0} layer has unresolved conflicts.<br>Either resolve them first or discard the modifications.<br>Layer with conflicts:</html>", "<html>{0} layers have unresolved conflicts.<br>Either resolve them first or discard the modifications.<br>Layers with conflicts:</html>", infos.size(), infos.size());
        JOptionPane.showConfirmDialog(Main.parent, new LayerListWarningMessagePanel(msg, infos), I18n.tr("Unsaved data and conflicts"), -1, 2);
    }

    protected void warnLayersWithoutFilesAndSaveRequest(List<SaveLayerInfo> infos) {
        String msg = I18n.trn("<html>{0} layer needs saving but has no associated file.<br>Either select a file for this layer or discard the changes.<br>Layer without a file:</html>", "<html>{0} layers need saving but have no associated file.<br>Either select a file for each of them or discard the changes.<br>Layers without a file:</html>", infos.size(), infos.size());
        JOptionPane.showConfirmDialog(Main.parent, new LayerListWarningMessagePanel(msg, infos), I18n.tr("Unsaved data and missing associated file"), -1, 2);
    }

    protected void warnLayersWithIllegalFilesAndSaveRequest(List<SaveLayerInfo> infos) {
        String msg = I18n.trn("<html>{0} layer needs saving but has an associated file<br>which cannot be written.<br>Either select another file for this layer or discard the changes.<br>Layer with a non-writable file:</html>", "<html>{0} layers need saving but have associated files<br>which cannot be written.<br>Either select another file for each of them or discard the changes.<br>Layers with non-writable files:</html>", infos.size(), infos.size());
        JOptionPane.showConfirmDialog(Main.parent, new LayerListWarningMessagePanel(msg, infos), I18n.tr("Unsaved data non-writable files"), -1, 2);
    }

    protected boolean confirmSaveLayerInfosOK() {
        List<SaveLayerInfo> layerInfos = this.model.getLayersWithConflictsAndUploadRequest();
        if (!layerInfos.isEmpty()) {
            this.warnLayersWithConflictsAndUploadRequest(layerInfos);
            return false;
        }
        layerInfos = this.model.getLayersWithoutFilesAndSaveRequest();
        if (!layerInfos.isEmpty()) {
            this.warnLayersWithoutFilesAndSaveRequest(layerInfos);
            return false;
        }
        layerInfos = this.model.getLayersWithIllegalFilesAndSaveRequest();
        if (!layerInfos.isEmpty()) {
            this.warnLayersWithIllegalFilesAndSaveRequest(layerInfos);
            return false;
        }
        return true;
    }

    protected void setUserAction(UserAction action) {
        this.action = action;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SaveAndUploadTask
    implements Runnable {
        private SaveLayersModel model;
        private ProgressMonitor monitor;
        private ExecutorService worker;
        private boolean cancelled;
        private Future<?> currentFuture;
        private AbstractIOTask currentTask;

        public SaveAndUploadTask(SaveLayersModel model, ProgressMonitor monitor) {
            this.model = model;
            this.monitor = monitor;
            this.worker = Executors.newSingleThreadExecutor();
        }

        protected void uploadLayers(List<SaveLayerInfo> toUpload) {
            for (SaveLayerInfo layerInfo : toUpload) {
                if (this.cancelled) {
                    this.model.setUploadState(layerInfo.getLayer(), UploadOrSaveState.CANCELLED);
                    continue;
                }
                this.monitor.subTask(I18n.tr("Preparing layer ''{0}'' for upload ...", layerInfo.getName()));
                if (!new UploadAction().checkPreUploadConditions(layerInfo.getLayer())) {
                    this.model.setUploadState(layerInfo.getLayer(), UploadOrSaveState.FAILED);
                    continue;
                }
                UploadDialog dialog = UploadDialog.getUploadDialog();
                dialog.setUploadedPrimitives(new APIDataSet(layerInfo.getLayer().data));
                dialog.setVisible(true);
                if (dialog.isCanceled()) {
                    this.model.setUploadState(layerInfo.getLayer(), UploadOrSaveState.CANCELLED);
                    continue;
                }
                dialog.rememberUserInput();
                this.currentTask = new UploadLayerTask(UploadDialog.getUploadDialog().getUploadStrategySpecification(), layerInfo.getLayer(), this.monitor, UploadDialog.getUploadDialog().getChangeset());
                this.currentFuture = this.worker.submit(this.currentTask);
                try {
                    this.currentFuture.get();
                }
                catch (CancellationException e) {
                    this.model.setUploadState(layerInfo.getLayer(), UploadOrSaveState.CANCELLED);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.model.setUploadState(layerInfo.getLayer(), UploadOrSaveState.FAILED);
                    ExceptionDialogUtil.explainException(e);
                }
                if (this.currentTask.isCancelled()) {
                    this.model.setUploadState(layerInfo.getLayer(), UploadOrSaveState.CANCELLED);
                } else if (this.currentTask.isFailed()) {
                    this.currentTask.getLastException().printStackTrace();
                    ExceptionDialogUtil.explainException(this.currentTask.getLastException());
                    this.model.setUploadState(layerInfo.getLayer(), UploadOrSaveState.FAILED);
                } else {
                    this.model.setUploadState(layerInfo.getLayer(), UploadOrSaveState.OK);
                }
                this.currentTask = null;
                this.currentFuture = null;
            }
        }

        protected void saveLayers(List<SaveLayerInfo> toSave) {
            for (SaveLayerInfo layerInfo : toSave) {
                if (this.cancelled) {
                    this.model.setSaveState(layerInfo.getLayer(), UploadOrSaveState.CANCELLED);
                    continue;
                }
                this.currentTask = new SaveLayerTask(layerInfo, this.monitor);
                this.currentFuture = this.worker.submit(this.currentTask);
                try {
                    this.currentFuture.get();
                }
                catch (CancellationException e) {
                    this.model.setSaveState(layerInfo.getLayer(), UploadOrSaveState.CANCELLED);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.model.setSaveState(layerInfo.getLayer(), UploadOrSaveState.FAILED);
                    ExceptionDialogUtil.explainException(e);
                }
                if (this.currentTask.isCancelled()) {
                    this.model.setSaveState(layerInfo.getLayer(), UploadOrSaveState.CANCELLED);
                } else if (this.currentTask.isFailed()) {
                    if (this.currentTask.getLastException() != null) {
                        this.currentTask.getLastException().printStackTrace();
                        ExceptionDialogUtil.explainException(this.currentTask.getLastException());
                    }
                    this.model.setSaveState(layerInfo.getLayer(), UploadOrSaveState.FAILED);
                } else {
                    this.model.setSaveState(layerInfo.getLayer(), UploadOrSaveState.OK);
                }
                this.currentTask = null;
                this.currentFuture = null;
            }
        }

        protected void warnBecauseOfUnsavedData() {
            int numProblems = this.model.getNumCancel() + this.model.getNumFailed();
            if (numProblems == 0) {
                return;
            }
            String msg = I18n.trn("<html>An upload and/or save operation of one layer with modifications<br>was cancelled or has failed.</html>", "<html>Upload and/or save operations of {0} layers with modifications<br>were cancelled or have failed.</html>", numProblems, numProblems);
            JOptionPane.showMessageDialog(Main.parent, msg, I18n.tr("Incomplete upload and/or save"), 2);
        }

        @Override
        public void run() {
            List<SaveLayerInfo> toSave;
            this.model.setMode(SaveLayersModel.Mode.UPLOADING_AND_SAVING);
            List<SaveLayerInfo> toUpload = this.model.getLayersToUpload();
            if (!toUpload.isEmpty()) {
                this.uploadLayers(toUpload);
            }
            if (!(toSave = this.model.getLayersToSave()).isEmpty()) {
                this.saveLayers(toSave);
            }
            this.model.setMode(SaveLayersModel.Mode.EDITING_DATA);
            if (this.model.hasUnsavedData()) {
                this.warnBecauseOfUnsavedData();
                this.model.setMode(SaveLayersModel.Mode.EDITING_DATA);
                if (this.cancelled) {
                    SaveLayersDialog.this.setUserAction(UserAction.CANCEL);
                    SaveLayersDialog.this.setVisible(false);
                }
            } else {
                SaveLayersDialog.this.setUserAction(UserAction.PROCEED);
                SaveLayersDialog.this.setVisible(false);
            }
        }

        public void cancel() {
            if (this.currentTask != null) {
                this.currentTask.cancel();
            }
            this.cancelled = true;
        }
    }

    class SaveAndProceedAction
    extends AbstractAction
    implements PropertyChangeListener {
        public SaveAndProceedAction() {
            this.initForSaveAndExit();
        }

        public void initForSaveAndExit() {
            this.putValue("Name", I18n.tr("Save/Upload and Exit"));
            this.putValue("ShortDescription", I18n.tr("Exit JOSM with saving. Unsaved changes are uploaded and/or saved."));
            this.putValue("SmallIcon", ImageProvider.get("exit"));
        }

        public void initForSaveAndDelete() {
            this.putValue("Name", I18n.tr("Save/Upload and Delete"));
            this.putValue("ShortDescription", I18n.tr("Save/Upload layers before deleting. Unsaved changes are not lost."));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "delete"));
        }

        public void actionPerformed(ActionEvent e) {
            if (!SaveLayersDialog.this.confirmSaveLayerInfosOK()) {
                return;
            }
            SaveLayersDialog.this.launchSafeAndUploadTask();
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals(SaveLayersModel.MODE_PROP)) {
                SaveLayersModel.Mode mode = (SaveLayersModel.Mode)((Object)evt.getNewValue());
                switch (mode) {
                    case EDITING_DATA: {
                        this.setEnabled(true);
                        break;
                    }
                    case UPLOADING_AND_SAVING: {
                        this.setEnabled(false);
                    }
                }
            }
        }
    }

    class DiscardAndProceedAction
    extends AbstractAction
    implements PropertyChangeListener {
        public DiscardAndProceedAction() {
            this.initForDiscardAndExit();
        }

        public void initForDiscardAndExit() {
            this.putValue("Name", I18n.tr("Discard and Exit"));
            this.putValue("ShortDescription", I18n.tr("Exit JOSM without saving. Unsaved changes are lost."));
            this.putValue("SmallIcon", ImageProvider.get("exit"));
        }

        public void initForDiscardAndDelete() {
            this.putValue("Name", I18n.tr("Discard and Delete"));
            this.putValue("ShortDescription", I18n.tr("Delete layers without saving. Unsaved changes are lost."));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "delete"));
        }

        public void actionPerformed(ActionEvent e) {
            SaveLayersDialog.this.setUserAction(UserAction.PROCEED);
            SaveLayersDialog.this.setVisible(false);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals(SaveLayersModel.MODE_PROP)) {
                SaveLayersModel.Mode mode = (SaveLayersModel.Mode)((Object)evt.getNewValue());
                switch (mode) {
                    case EDITING_DATA: {
                        this.setEnabled(true);
                        break;
                    }
                    case UPLOADING_AND_SAVING: {
                        this.setEnabled(false);
                    }
                }
            }
        }
    }

    class CancelAction
    extends AbstractAction {
        public CancelAction() {
            this.putValue("Name", I18n.tr("Cancel"));
            this.putValue("ShortDescription", I18n.tr("Close this dialog and resume editing in JOSM"));
            this.putValue("SmallIcon", ImageProvider.get("cancel"));
        }

        protected void cancelWhenInEditingModel() {
            SaveLayersDialog.this.setUserAction(UserAction.CANCEL);
            SaveLayersDialog.this.setVisible(false);
        }

        protected void cancelWhenInSaveAndUploadingMode() {
            SaveLayersDialog.this.cancelSafeAndUploadTask();
        }

        public void cancel() {
            switch (SaveLayersDialog.this.model.getMode()) {
                case EDITING_DATA: {
                    this.cancelWhenInEditingModel();
                    break;
                }
                case UPLOADING_AND_SAVING: {
                    SaveLayersDialog.this.cancelSafeAndUploadTask();
                }
            }
        }

        public void actionPerformed(ActionEvent e) {
            this.cancel();
        }
    }

    class WindowClosingAdapter
    extends WindowAdapter {
        WindowClosingAdapter() {
        }

        public void windowClosing(WindowEvent e) {
            SaveLayersDialog.this.cancelAction.cancel();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LayerListWarningMessagePanel
    extends JPanel {
        private JLabel lblMessage;
        private JList lstLayers;

        protected void build() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.gridx = 0;
            gc.gridy = 0;
            gc.fill = 2;
            gc.weightx = 1.0;
            gc.weighty = 0.0;
            this.lblMessage = new JLabel();
            this.add((Component)this.lblMessage, gc);
            this.lblMessage.setHorizontalAlignment(2);
            this.lstLayers = new JList();
            this.lstLayers.setCellRenderer(new DefaultListCellRenderer(){

                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    SaveLayerInfo info = (SaveLayerInfo)value;
                    this.setIcon(info.getLayer().getIcon());
                    this.setText(info.getName());
                    return this;
                }
            });
            gc.gridx = 0;
            gc.gridy = 1;
            gc.fill = 2;
            gc.weightx = 1.0;
            gc.weighty = 1.0;
            this.add((Component)this.lstLayers, gc);
        }

        public LayerListWarningMessagePanel(String msg, List<SaveLayerInfo> infos) {
            this.build();
            this.lblMessage.setText(msg);
            this.lstLayers.setListData(infos.toArray());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum UserAction {
        PROCEED,
        CANCEL;

    }
}

