/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.DefaultListSelectionModel;
import javax.swing.table.AbstractTableModel;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.TagCollection;
import org.openstreetmap.josm.data.osm.Tagged;
import org.openstreetmap.josm.gui.tagging.TagModel;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagEditorModel
extends AbstractTableModel {
    private static final Logger logger = Logger.getLogger(TagEditorModel.class.getName());
    public static final String PROP_DIRTY = TagEditorModel.class.getName() + ".dirty";
    protected final ArrayList<TagModel> tags = new ArrayList();
    private boolean dirty = false;
    private final PropertyChangeSupport propChangeSupport = new PropertyChangeSupport(this);
    private DefaultListSelectionModel rowSelectionModel;
    private DefaultListSelectionModel colSelectionModel;

    public TagEditorModel() {
        this.rowSelectionModel = new DefaultListSelectionModel();
        this.colSelectionModel = new DefaultListSelectionModel();
    }

    public TagEditorModel(DefaultListSelectionModel rowSelectionModel, DefaultListSelectionModel colSelectionModel) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull(rowSelectionModel, "rowSelectionModel");
        CheckParameterUtil.ensureParameterNotNull(colSelectionModel, "colSelectionModel");
        this.rowSelectionModel = rowSelectionModel;
        this.colSelectionModel = colSelectionModel;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propChangeSupport.addPropertyChangeListener(listener);
    }

    public DefaultListSelectionModel getRowSelectionModel() {
        return this.rowSelectionModel;
    }

    public DefaultListSelectionModel getColumnSelectionModel() {
        return this.colSelectionModel;
    }

    public void removeProperyChangeListener(PropertyChangeListener listener) {
        this.propChangeSupport.removePropertyChangeListener(listener);
    }

    protected void fireDirtyStateChanged(boolean oldValue, boolean newValue) {
        this.propChangeSupport.firePropertyChange(PROP_DIRTY, oldValue, newValue);
    }

    protected void setDirty(boolean newValue) {
        boolean oldValue = this.dirty;
        this.dirty = newValue;
        if (oldValue != newValue) {
            this.fireDirtyStateChanged(oldValue, newValue);
        }
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        return this.tags.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex >= this.getRowCount()) {
            throw new IndexOutOfBoundsException("unexpected rowIndex: rowIndex=" + rowIndex);
        }
        TagModel tag = this.tags.get(rowIndex);
        switch (columnIndex) {
            case 0: 
            case 1: {
                return tag;
            }
        }
        throw new IndexOutOfBoundsException("unexpected columnIndex: columnIndex=" + columnIndex);
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        TagModel tag = this.get(row);
        if (tag == null) {
            return;
        }
        switch (col) {
            case 0: {
                this.updateTagName(tag, (String)value);
                break;
            }
            case 1: {
                String v = (String)value;
                if (tag.getValueCount() > 1 && !v.equals("")) {
                    this.updateTagValue(tag, v);
                    break;
                }
                if (tag.getValueCount() > 1) break;
                this.updateTagValue(tag, v);
            }
        }
    }

    public void clear() {
        this.tags.clear();
        this.setDirty(true);
        this.fireTableDataChanged();
    }

    public void add(TagModel tag) {
        if (tag == null) {
            throw new IllegalArgumentException("argument 'tag' must not be null");
        }
        this.tags.add(tag);
        this.setDirty(true);
        this.fireTableDataChanged();
    }

    public void prepend(TagModel tag) {
        if (tag == null) {
            throw new IllegalArgumentException("argument 'tag' must not be null");
        }
        this.tags.add(0, tag);
        this.setDirty(true);
        this.fireTableDataChanged();
    }

    public void add(String name, String value) {
        name = name == null ? "" : name;
        value = value == null ? "" : value;
        TagModel tag = this.get(name);
        if (tag == null) {
            tag = new TagModel(name, value);
            this.tags.add(tag);
        } else {
            tag.addValue(value);
        }
        this.setDirty(true);
        this.fireTableDataChanged();
    }

    public TagModel get(String name) {
        name = name == null ? "" : name;
        for (TagModel tag : this.tags) {
            if (!tag.getName().equals(name)) continue;
            return tag;
        }
        return null;
    }

    public TagModel get(int idx) {
        if (idx >= this.tags.size()) {
            return null;
        }
        TagModel tagModel = this.tags.get(idx);
        return tagModel;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return true;
    }

    public void deleteTagNames(int[] tagIndices) {
        if (this.tags == null) {
            return;
        }
        for (int tagIdx : tagIndices) {
            TagModel tag = this.tags.get(tagIdx);
            if (tag == null) continue;
            tag.setName("");
        }
        this.fireTableDataChanged();
        this.setDirty(true);
    }

    public void deleteTagValues(int[] tagIndices) {
        if (this.tags == null) {
            return;
        }
        for (int tagIdx : tagIndices) {
            TagModel tag = this.tags.get(tagIdx);
            if (tag == null) continue;
            tag.setValue("");
        }
        this.fireTableDataChanged();
        this.setDirty(true);
    }

    public void delete(String name) {
        if (name == null) {
            return;
        }
        Iterator<TagModel> it = this.tags.iterator();
        boolean changed = false;
        while (it.hasNext()) {
            TagModel tm = it.next();
            if (!tm.getName().equals(name)) continue;
            changed = true;
            it.remove();
        }
        if (changed) {
            this.fireTableDataChanged();
            this.setDirty(true);
        }
    }

    public void deleteTags(int[] tagIndices) {
        if (this.tags == null) {
            return;
        }
        ArrayList<TagModel> toDelete = new ArrayList<TagModel>();
        for (int tagIdx : tagIndices) {
            TagModel tag = this.tags.get(tagIdx);
            if (tag == null) continue;
            toDelete.add(tag);
        }
        for (TagModel tag : toDelete) {
            this.tags.remove(tag);
        }
        this.fireTableDataChanged();
        this.setDirty(true);
    }

    public void appendNewTag() {
        TagModel tag = new TagModel();
        this.tags.add(tag);
        this.fireTableDataChanged();
        this.setDirty(true);
    }

    public void ensureOneTag() {
        if (this.tags.size() == 0) {
            this.appendNewTag();
        }
    }

    public void initFromPrimitive(Tagged primitive) {
        this.tags.clear();
        for (String key : primitive.keySet()) {
            String value = primitive.get(key);
            this.tags.add(new TagModel(key, value));
        }
        TagModel tag = new TagModel();
        this.sort();
        this.tags.add(tag);
        this.setDirty(false);
    }

    public void initFromTags(Map<String, String> tags) {
        this.tags.clear();
        for (String key : tags.keySet()) {
            String value = tags.get(key);
            this.tags.add(new TagModel(key, value));
        }
        this.sort();
        TagModel tag = new TagModel();
        this.tags.add(tag);
        this.setDirty(false);
    }

    public void initFromTags(TagCollection tags) {
        this.tags.clear();
        if (tags == null) {
            this.setDirty(false);
            return;
        }
        for (String key : tags.getKeys()) {
            String value = tags.getJoinedValues(key);
            this.tags.add(new TagModel(key, value));
        }
        this.sort();
        TagModel tag = new TagModel();
        this.tags.add(tag);
        this.setDirty(false);
    }

    public void applyToPrimitive(Tagged primitive) {
        Map<String, String> tags = primitive.getKeys();
        this.applyToTags(tags);
        primitive.setKeys(tags);
    }

    public void applyToTags(Map<String, String> tags) {
        tags.clear();
        for (TagModel tag : this.tags) {
            if (tag.getValueCount() > 1 || tag.getName().trim().equals("") || tag.getValue().trim().equals("")) continue;
            tags.put(tag.getName().trim(), tag.getValue().trim());
        }
    }

    public Map<String, String> getTags() {
        HashMap<String, String> tags = new HashMap<String, String>();
        this.applyToTags(tags);
        return tags;
    }

    public TagCollection getTagCollection() {
        return TagCollection.from(this.getTags());
    }

    public boolean includesTag(String key) {
        if (key == null) {
            return false;
        }
        for (TagModel tag : this.tags) {
            if (!tag.getName().equals(key)) continue;
            return true;
        }
        return false;
    }

    protected Command createUpdateTagCommand(Collection<OsmPrimitive> primitives, TagModel tag) {
        if (tag.getValueCount() > 1) {
            return null;
        }
        if (tag.getName().trim().equals("")) {
            return null;
        }
        String newkey = tag.getName();
        String newvalue = tag.getValue();
        ChangePropertyCommand command = new ChangePropertyCommand(primitives, newkey, newvalue);
        return command;
    }

    protected Command createDeleteTagsCommand(Collection<OsmPrimitive> primitives) {
        List<String> currentkeys = this.getKeys();
        ArrayList<Command> commands = new ArrayList<Command>();
        for (OsmPrimitive primitive : primitives) {
            for (String oldkey : primitive.keySet()) {
                if (currentkeys.contains(oldkey)) continue;
                ChangePropertyCommand deleteCommand = new ChangePropertyCommand(primitive, oldkey, null);
                commands.add(deleteCommand);
            }
        }
        SequenceCommand command = new SequenceCommand(I18n.trn("Remove old keys from up to {0} object", "Remove old keys from up to {0} objects", primitives.size(), primitives.size()), commands);
        return command;
    }

    public List<String> getKeys() {
        ArrayList<String> keys = new ArrayList<String>();
        for (TagModel tag : this.tags) {
            if (tag.getName().trim().equals("")) continue;
            keys.add(tag.getName());
        }
        return keys;
    }

    protected void sort() {
        Collections.sort(this.tags, new Comparator<TagModel>(){

            @Override
            public int compare(TagModel self, TagModel other) {
                return self.getName().compareTo(other.getName());
            }
        });
    }

    public void updateTagName(TagModel tag, String newName) {
        String oldName = tag.getName();
        tag.setName(newName);
        if (!newName.equals(oldName)) {
            this.setDirty(true);
        }
        SelectionStateMemento memento = new SelectionStateMemento();
        this.fireTableDataChanged();
        memento.apply();
    }

    public void updateTagValue(TagModel tag, String newValue) {
        String oldValue = tag.getValue();
        tag.setValue(newValue);
        if (!newValue.equals(oldValue)) {
            this.setDirty(true);
        }
        SelectionStateMemento memento = new SelectionStateMemento();
        this.fireTableDataChanged();
        memento.apply();
    }

    public boolean isDirty() {
        return this.dirty;
    }

    class SelectionStateMemento {
        private int rowMin;
        private int rowMax;
        private int colMin;
        private int colMax;

        public SelectionStateMemento() {
            this.rowMin = TagEditorModel.this.rowSelectionModel.getMinSelectionIndex();
            this.rowMax = TagEditorModel.this.rowSelectionModel.getMaxSelectionIndex();
            this.colMin = TagEditorModel.this.colSelectionModel.getMinSelectionIndex();
            this.colMax = TagEditorModel.this.colSelectionModel.getMaxSelectionIndex();
        }

        public void apply() {
            TagEditorModel.this.rowSelectionModel.setValueIsAdjusting(true);
            TagEditorModel.this.colSelectionModel.setValueIsAdjusting(true);
            if (this.rowMin >= 0 && this.rowMax >= 0) {
                TagEditorModel.this.rowSelectionModel.setSelectionInterval(this.rowMin, this.rowMax);
            }
            if (this.colMin >= 0 && this.colMax >= 0) {
                TagEditorModel.this.colSelectionModel.setSelectionInterval(this.colMin, this.colMax);
            }
            TagEditorModel.this.rowSelectionModel.setValueIsAdjusting(false);
            TagEditorModel.this.colSelectionModel.setValueIsAdjusting(false);
        }
    }
}

