/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.MessageFormat;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.io.FileExporter;
import org.openstreetmap.josm.io.OsmWriter;
import org.openstreetmap.josm.tools.I18n;

public class OsmExporter
extends FileExporter {
    public OsmExporter() {
        super(new ExtensionFileFilter("osm,xml", "osm", I18n.tr("OSM Server Files") + " (*.osm *.xml)"));
    }

    public OsmExporter(ExtensionFileFilter filter) {
        super(filter);
    }

    public boolean acceptFile(File pathname, Layer layer) {
        if (!(layer instanceof OsmDataLayer)) {
            return false;
        }
        return super.acceptFile(pathname, layer);
    }

    public void exportData(File file, Layer layer) throws IOException {
        if (!(layer instanceof OsmDataLayer)) {
            throw new IllegalArgumentException(MessageFormat.format("Expected instance of OsmDataLayer. Got ''{0}''.", layer.getClass().getName()));
        }
        this.save(file, (OsmDataLayer)layer);
    }

    protected OutputStream getOutputStream(File file) throws FileNotFoundException, IOException {
        return new FileOutputStream(file);
    }

    private void save(File file, OsmDataLayer layer) {
        File tmpFile = null;
        try {
            if (file.exists()) {
                tmpFile = new File(file.getPath() + "~");
                this.copy(file, tmpFile);
            }
            OutputStream out = this.getOutputStream(file);
            OutputStreamWriter writer = new OutputStreamWriter(out, "UTF-8");
            OsmWriter w = new OsmWriter(new PrintWriter(writer), false, layer.data.getVersion());
            w.header();
            w.writeDataSources(layer.data);
            w.writeContent(layer.data);
            w.footer();
            w.close();
            if (!Main.pref.getBoolean("save.keepbackup") && tmpFile != null) {
                tmpFile.delete();
            }
            layer.onPostSaveToFile();
        }
        catch (IOException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>An error occurred while saving.<br>Error is:<br>{0}</html>", e.getMessage()), I18n.tr("Error"), 0);
            try {
                if (tmpFile != null && tmpFile.exists()) {
                    this.copy(tmpFile, file);
                }
            }
            catch (IOException e2) {
                e2.printStackTrace();
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>An error occurred while restoring backup file.<br>Error is:<br>{0}</html>", e2.getMessage()), I18n.tr("Error"), 0);
            }
        }
    }

    private void copy(File src, File dst) throws IOException {
        int len;
        FileOutputStream dstStream;
        FileInputStream srcStream;
        try {
            srcStream = new FileInputStream(src);
            dstStream = new FileOutputStream(dst);
        }
        catch (FileNotFoundException e) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Could not back up file. Exception is: {0}", e.getMessage()), I18n.tr("Error"), 0);
            return;
        }
        byte[] buf = new byte[65536];
        while ((len = srcStream.read(buf)) != -1) {
            dstStream.write(buf, 0, len);
        }
        srcStream.close();
        dstStream.close();
    }
}

