/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Shortcut {
    public static final int SHIFT_DEFAULT = 1;
    private String shortText;
    private String longText;
    private int requestedKey;
    private int requestedGroup;
    private int assignedKey;
    private int assignedModifier;
    private boolean assignedDefault;
    private boolean assignedUser;
    private boolean automatic;
    private boolean reset;
    private static Map<String, Shortcut> shortcuts = new LinkedHashMap<String, Shortcut>();
    private static Map<Integer, Integer> groups = new HashMap<Integer, Integer>();
    public static final int GROUP_NONE = 0;
    public static final int GROUP_HOTKEY = 1;
    public static final int GROUP_MENU = 2;
    public static final int GROUP_EDIT = 3;
    public static final int GROUP_LAYER = 4;
    public static final int GROUP_DIRECT = 5;
    public static final int GROUP_MNEMONIC = 6;
    public static final int GROUP__MAX = 7;
    public static final int GROUP_RESERVED = 1000;
    public static final int GROUPS_DEFAULT = 0;
    public static final int GROUPS_ALT1 = 7;
    public static final int GROUPS_ALT2 = 14;
    private static boolean initdone = false;

    private Shortcut(String shortText, String longText, int requestedKey, int requestedGroup, int assignedKey, int assignedModifier, boolean assignedDefault, boolean assignedUser) {
        this.shortText = shortText;
        this.longText = longText;
        this.requestedKey = requestedKey;
        this.requestedGroup = requestedGroup;
        this.assignedKey = assignedKey;
        this.assignedModifier = assignedModifier;
        this.assignedDefault = assignedDefault;
        this.assignedUser = assignedUser;
        this.automatic = false;
        this.reset = false;
    }

    public String getShortText() {
        return this.shortText;
    }

    public String getLongText() {
        return this.longText;
    }

    private void setLongText(String longText) {
        this.longText = longText;
    }

    private int getRequestedKey() {
        return this.requestedKey;
    }

    public int getRequestedGroup() {
        return this.requestedGroup;
    }

    public int getAssignedKey() {
        return this.assignedKey;
    }

    public int getAssignedModifier() {
        return this.assignedModifier;
    }

    public boolean getAssignedDefault() {
        return this.assignedDefault;
    }

    public boolean getAssignedUser() {
        return this.assignedUser;
    }

    public boolean getAutomatic() {
        return this.automatic;
    }

    public boolean isChangeable() {
        return !this.automatic && !this.shortText.equals("core:none");
    }

    private boolean getReset() {
        return this.reset;
    }

    public void setAutomatic() {
        this.automatic = true;
    }

    public void setAssignedModifier(int assignedModifier) {
        this.assignedModifier = assignedModifier;
    }

    public void setAssignedKey(int assignedKey) {
        this.assignedKey = assignedKey;
    }

    public void setAssignedUser(boolean assignedUser) {
        boolean bl = this.reset = !this.assignedUser && assignedUser;
        if (assignedUser) {
            this.assignedDefault = false;
        }
        this.assignedUser = assignedUser;
    }

    public KeyStroke getKeyStroke() {
        if (this.assignedModifier != -1) {
            return KeyStroke.getKeyStroke(this.assignedKey, this.assignedModifier);
        }
        return null;
    }

    private boolean isSame(int isKey, int isModifier) {
        return isKey == this.assignedKey && isModifier == this.assignedModifier && this.assignedModifier != groups.get(0);
    }

    private Shortcut(String prefString) {
        String[] s = prefString.split(";");
        this.shortText = s[0];
        this.longText = s[1];
        this.requestedKey = Integer.parseInt(s[2]);
        this.requestedGroup = Integer.parseInt(s[3]);
        this.assignedKey = Integer.parseInt(s[4]);
        this.assignedModifier = Integer.parseInt(s[5]);
        this.assignedDefault = Boolean.parseBoolean(s[6]);
        this.assignedUser = Boolean.parseBoolean(s[7]);
    }

    private String asPrefString() {
        return this.shortText + ";" + this.longText + ";" + this.requestedKey + ";" + this.requestedGroup + ";" + this.assignedKey + ";" + this.assignedModifier + ";" + this.assignedDefault + ";" + this.assignedUser;
    }

    private boolean isSame(Shortcut other) {
        return this.assignedKey == other.assignedKey && this.assignedModifier == other.assignedModifier;
    }

    public void setMnemonic(JMenu menu) {
        if (this.requestedGroup == 6 && this.assignedModifier == groups.get(this.requestedGroup + 0) && this.getKeyStroke() != null && KeyEvent.getKeyText(this.assignedKey).length() == 1) {
            menu.setMnemonic(KeyEvent.getKeyText(this.assignedKey).charAt(0));
        }
    }

    public void setMnemonic(AbstractButton button) {
        if (this.requestedGroup == 6 && this.assignedModifier == groups.get(this.requestedGroup + 0) && this.getKeyStroke() != null && KeyEvent.getKeyText(this.assignedKey).length() == 1) {
            button.setMnemonic(KeyEvent.getKeyText(this.assignedKey).charAt(0));
        }
    }

    public String getKeyText() {
        KeyStroke keyStroke = this.getKeyStroke();
        if (keyStroke == null) {
            return "";
        }
        String modifText = KeyEvent.getKeyModifiersText(keyStroke.getModifiers());
        if ("".equals(modifText)) {
            return KeyEvent.getKeyText(keyStroke.getKeyCode());
        }
        return modifText + "+" + KeyEvent.getKeyText(keyStroke.getKeyCode());
    }

    private static Shortcut findShortcut(int requestedKey, int modifier) {
        if (modifier == groups.get(0)) {
            return null;
        }
        for (Shortcut sc : shortcuts.values()) {
            if (!sc.isSame(requestedKey, modifier)) continue;
            return sc;
        }
        return null;
    }

    public static List<Shortcut> listAll() {
        return new ArrayList<Shortcut>(shortcuts.values());
    }

    private static Shortcut findRandomShortcut(String shortText, String longText, int requestedKey, int requestedGroup) {
        int[] mods;
        for (int m : mods = new int[]{groups.get(requestedGroup + 0), groups.get(requestedGroup + 7), groups.get(requestedGroup + 14)}) {
            for (int k = 65; k < 90; ++k) {
                if (Shortcut.findShortcut(k, m) != null) continue;
                return new Shortcut(shortText, longText, requestedKey, requestedGroup, k, m, false, false);
            }
        }
        return new Shortcut(shortText, longText, requestedKey, requestedGroup, requestedKey, groups.get(0), false, false);
    }

    private static void doInit() {
        Shortcut sc;
        int i;
        if (initdone) {
            return;
        }
        initdone = true;
        if (Main.pref.get("shortcut.groups.configured", null) == null) {
            Main.platform.initShortcutGroups();
            Main.pref.put("shortcut.groups.configured", true);
        }
        for (i = 0; i < 35; ++i) {
            groups.put(i, Main.pref.getInteger("shortcut.groups." + i, -1));
        }
        Main.platform.initSystemShortcuts();
        i = 0;
        String p = Main.pref.get("shortcut.shortcut." + i, null);
        while (p != null) {
            sc = new Shortcut(p);
            if (sc.getAssignedUser()) {
                Shortcut.registerShortcut(sc);
            }
            p = Main.pref.get("shortcut.shortcut." + ++i, null);
        }
        i = 0;
        p = Main.pref.get("shortcut.shortcut." + i, null);
        while (p != null) {
            sc = new Shortcut(p);
            if (!sc.getAssignedUser() && sc.getAssignedDefault()) {
                Shortcut.registerShortcut(sc);
            }
            p = Main.pref.get("shortcut.shortcut." + ++i, null);
        }
        i = 0;
        p = Main.pref.get("shortcut.shortcut." + i, null);
        while (p != null) {
            sc = new Shortcut(p);
            if (!sc.getAssignedUser() && !sc.getAssignedDefault()) {
                Shortcut.registerShortcut(sc);
            }
            p = Main.pref.get("shortcut.shortcut." + ++i, null);
        }
    }

    public static boolean savePrefs() {
        boolean changed = false;
        int i = 0;
        for (Shortcut sc : shortcuts.values()) {
            if (sc.getAutomatic() || sc.getReset() || !sc.getAssignedUser()) continue;
            changed |= Main.pref.put("shortcut.shortcut." + i, sc.asPrefString());
            ++i;
        }
        return changed |= Main.pref.put("shortcut.shortcut." + i, "");
    }

    private static void registerShortcut(Shortcut sc) {
        if (sc.getAssignedUser() && Shortcut.findShortcut(sc.getAssignedKey(), sc.getAssignedModifier()) == null) {
            shortcuts.put(sc.getShortText(), sc);
        } else {
            Shortcut.registerShortcut(sc.getShortText(), sc.getLongText(), sc.getRequestedKey(), sc.getRequestedGroup(), sc.getAssignedModifier(), sc);
        }
    }

    public static Shortcut registerSystemShortcut(String shortText, String longText, int key, int modifier) {
        if (shortcuts.containsKey(shortText)) {
            return shortcuts.get(shortText);
        }
        Shortcut potentialShortcut = Shortcut.findShortcut(key, modifier);
        if (potentialShortcut != null) {
            System.err.println("CONFLICT WITH SYSTEM KEY " + shortText);
            return null;
        }
        potentialShortcut = new Shortcut(shortText, longText, key, 1000, key, modifier, true, false);
        shortcuts.put(shortText, potentialShortcut);
        return potentialShortcut;
    }

    public static Shortcut registerShortcut(String shortText, String longText, int requestedKey, int requestedGroup, int modifier) {
        return Shortcut.registerShortcut(shortText, longText, requestedKey, requestedGroup, modifier, null);
    }

    public static Shortcut registerShortcut(String shortText, String longText, int requestedKey, int requestedGroup) {
        return Shortcut.registerShortcut(shortText, longText, requestedKey, requestedGroup, null, null);
    }

    private static Shortcut registerShortcut(String shortText, String longText, int requestedKey, int requestedGroup, Integer modifier, Shortcut originalShortcut) {
        Shortcut.doInit();
        if (shortcuts.containsKey(shortText)) {
            Shortcut sc = shortcuts.get(shortText);
            sc.setLongText(longText);
            return sc;
        }
        Integer defaultModifier = groups.get(requestedGroup + 0);
        if (modifier != null) {
            defaultModifier = modifier == 1 ? Integer.valueOf(defaultModifier | 0x40) : modifier;
        } else if (defaultModifier == null) {
            defaultModifier = groups.get(0);
        }
        Shortcut conflictsWith = null;
        Shortcut potentialShortcut = Shortcut.findShortcut(requestedKey, defaultModifier);
        if (potentialShortcut != null) {
            conflictsWith = potentialShortcut;
            defaultModifier = groups.get(requestedGroup + 7);
            if (defaultModifier == null) {
                defaultModifier = groups.get(0);
            }
            if ((potentialShortcut = Shortcut.findShortcut(requestedKey, defaultModifier)) != null) {
                defaultModifier = groups.get(requestedGroup + 14);
                if (defaultModifier == null) {
                    defaultModifier = groups.get(0);
                }
                potentialShortcut = (potentialShortcut = Shortcut.findShortcut(requestedKey, defaultModifier)) != null ? Shortcut.findRandomShortcut(shortText, longText, requestedKey, requestedGroup) : new Shortcut(shortText, longText, requestedKey, requestedGroup, requestedKey, defaultModifier, false, false);
            } else {
                potentialShortcut = new Shortcut(shortText, longText, requestedKey, requestedGroup, requestedKey, defaultModifier, false, false);
            }
            if (originalShortcut != null && !originalShortcut.isSame(potentialShortcut)) {
                Shortcut.displayWarning(conflictsWith, potentialShortcut, shortText, longText);
            } else if (originalShortcut == null) {
                System.out.println("Silent shortcut conflict: '" + shortText + "' moved by '" + conflictsWith.getShortText() + "' to '" + potentialShortcut.getKeyText() + "'.");
            }
        } else {
            potentialShortcut = new Shortcut(shortText, longText, requestedKey, requestedGroup, requestedKey, defaultModifier, true, false);
        }
        shortcuts.put(shortText, potentialShortcut);
        return potentialShortcut;
    }

    private static void displayWarning(Shortcut conflictsWith, Shortcut potentialShortcut, String shortText, String longText) {
        JOptionPane.showMessageDialog(Main.parent, I18n.tr("Setting the keyboard shortcut ''{0}'' for the action ''{1}'' ({2}) failed\nbecause the shortcut is already taken by the action ''{3}'' ({4}).\n\n", conflictsWith.getKeyText(), longText, shortText, conflictsWith.getLongText(), conflictsWith.getShortText()) + (potentialShortcut.getKeyText().equals("") ? I18n.tr("This action will have no shortcut.\n\n") : I18n.tr("Using the shortcut ''{0}'' instead.\n\n", potentialShortcut.getKeyText())) + I18n.tr("(Hint: You can edit the shortcuts in the preferences.)"), I18n.tr("Error"), 0);
    }

    public static KeyStroke getCopyKeyStroke() {
        Shortcut sc = shortcuts.get("system:copy");
        if (sc == null) {
            return null;
        }
        return sc.getKeyStroke();
    }

    public static KeyStroke getPasteKeyStroke() {
        Shortcut sc = shortcuts.get("system:paste");
        if (sc == null) {
            return null;
        }
        return sc.getKeyStroke();
    }

    public static KeyStroke getCutKeyStroke() {
        Shortcut sc = shortcuts.get("system:cut");
        if (sc == null) {
            return null;
        }
        return sc.getKeyStroke();
    }
}

