/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.openstreetmap.josm.tools.OpenBrowser;

public class UrlLabel
extends JEditorPane
implements HyperlinkListener {
    private String url = "";
    private String description = "";

    public UrlLabel() {
        this.addHyperlinkListener(this);
        this.setEditable(false);
        this.setOpaque(false);
    }

    public UrlLabel(String url) {
        this(url, url);
    }

    public UrlLabel(String url, String description) {
        this();
        this.setUrl(url);
        this.setDescription(description);
        this.refresh();
    }

    protected void refresh() {
        this.setContentType("text/html");
        if (this.url != null) {
            this.setText("<html><a href=\"" + this.url + "\">" + this.description + "</a></html>");
        } else {
            this.setText("<html>" + this.description + "</html>");
        }
        this.setToolTipText(this.url);
    }

    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            OpenBrowser.displayUrl(this.url);
        }
    }

    public void setUrl(String url) {
        this.url = url;
        this.refresh();
    }

    public void setDescription(String description) {
        this.description = description == null ? "" : description;
        this.description = this.description.replace("&", "&amp;").replace(">", "&gt;").replace("<", "&lt;");
        this.refresh();
    }
}

