/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.util.jar.pack;

import com.sun.java.util.jar.pack.ConstantPool;
import com.sun.java.util.jar.pack.Constants;
import com.sun.java.util.jar.pack.Fixups;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class Attribute
implements Comparable,
Constants {
    Layout def;
    byte[] bytes;
    Object fixups;
    private static final byte[] noBytes = new byte[0];
    private static final HashMap canonLists = new HashMap();
    private static final HashMap attributes = new HashMap();
    private static final HashMap standardDefs = new HashMap();
    static final byte EK_INT = 1;
    static final byte EK_BCI = 2;
    static final byte EK_BCO = 3;
    static final byte EK_FLAG = 4;
    static final byte EK_REPL = 5;
    static final byte EK_REF = 6;
    static final byte EK_UN = 7;
    static final byte EK_CASE = 8;
    static final byte EK_CALL = 9;
    static final byte EK_CBLE = 10;
    static final byte EF_SIGN = 1;
    static final byte EF_DELTA = 2;
    static final byte EF_NULL = 4;
    static final byte EF_BACK = 8;
    static final int NO_BAND_INDEX = -1;

    public String name() {
        return this.def.name();
    }

    public Layout layout() {
        return this.def;
    }

    public byte[] bytes() {
        return this.bytes;
    }

    public int size() {
        return this.bytes.length;
    }

    public ConstantPool.Entry getNameRef() {
        return this.def.getNameRef();
    }

    private Attribute(Attribute attribute) {
        this.def = attribute.def;
        this.bytes = attribute.bytes;
        this.fixups = attribute.fixups;
    }

    public Attribute(Layout layout, byte[] byArray, Object object) {
        this.def = layout;
        this.bytes = byArray;
        this.fixups = object;
        Fixups.setBytes(object, byArray);
    }

    public Attribute(Layout layout, byte[] byArray) {
        this(layout, byArray, null);
    }

    public Attribute addContent(byte[] byArray, Object object) {
        assert (this.isCanonical());
        if (byArray.length == 0 && object == null) {
            return this;
        }
        Attribute attribute = new Attribute(this);
        attribute.bytes = byArray;
        attribute.fixups = object;
        Fixups.setBytes(object, byArray);
        return attribute;
    }

    public Attribute addContent(byte[] byArray) {
        return this.addContent(byArray, null);
    }

    public void finishRefs(ConstantPool.Index index) {
        if (this.fixups != null) {
            Fixups.finishRefs(this.fixups, this.bytes, index);
            this.fixups = null;
        }
    }

    public boolean isCanonical() {
        return this == this.def.canon;
    }

    public int compareTo(Object object) {
        Attribute attribute = (Attribute)object;
        return this.def.compareTo(attribute.def);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getCanonList(List list) {
        HashMap hashMap = canonLists;
        synchronized (hashMap) {
            List list2 = (ArrayList)canonLists.get(list);
            if (list2 == null) {
                list2 = new ArrayList(list.size());
                list2.addAll(list);
                list2 = Collections.unmodifiableList(list2);
                canonLists.put(list, list2);
            }
            return list2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Attribute find(int n, String string, String string2) {
        Layout layout = Layout.makeKey(n, string, string2);
        HashMap hashMap = attributes;
        synchronized (hashMap) {
            Attribute attribute = (Attribute)attributes.get(layout);
            if (attribute == null) {
                attribute = new Layout(n, string, string2).canonicalInstance();
                attributes.put(layout, attribute);
            }
            return attribute;
        }
    }

    public static Object keyForLookup(int n, String string) {
        return Layout.makeKey(n, string);
    }

    public static Attribute lookup(Map map, int n, String string) {
        if (map == null) {
            map = standardDefs;
        }
        return (Attribute)map.get(Layout.makeKey(n, string));
    }

    public static Attribute define(Map map, int n, String string, String string2) {
        Attribute attribute = Attribute.find(n, string, string2);
        map.put(Layout.makeKey(n, string), attribute);
        return attribute;
    }

    public static String contextName(int n) {
        switch (n) {
            case 0: {
                return "class";
            }
            case 1: {
                return "field";
            }
            case 2: {
                return "method";
            }
            case 3: {
                return "code";
            }
        }
        return null;
    }

    public static Map getStandardDefs() {
        return new HashMap(standardDefs);
    }

    void visitRefs(Holder holder, int n, final Collection collection) {
        if (n == 0) {
            collection.add(this.getNameRef());
        }
        if (this.bytes.length == 0) {
            return;
        }
        if (!this.def.hasRefs) {
            return;
        }
        if (this.fixups != null) {
            Fixups.visitRefs(this.fixups, collection);
            return;
        }
        this.def.parse(holder, this.bytes, 0, this.bytes.length, new ValueStream(){

            @Override
            public void putInt(int n, int n2) {
            }

            @Override
            public void putRef(int n, ConstantPool.Entry entry) {
                collection.add(entry);
            }

            @Override
            public int encodeBCI(int n) {
                return n;
            }
        });
    }

    public void parse(Holder holder, byte[] byArray, int n, int n2, ValueStream valueStream) {
        this.def.parse(holder, byArray, n, n2, valueStream);
    }

    public Object unparse(ValueStream valueStream, ByteArrayOutputStream byteArrayOutputStream) {
        return this.def.unparse(valueStream, byteArrayOutputStream);
    }

    public String toString() {
        return this.def + "{" + (this.bytes == null ? -1 : this.size()) + "}" + (this.fixups == null ? "" : this.fixups.toString());
    }

    public static String normalizeLayoutString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            int n3;
            int n4;
            char c;
            if ((c = string.charAt(n++)) <= ' ') continue;
            if (c == '#') {
                n4 = string.indexOf(10, n);
                n3 = string.indexOf(13, n);
                if (n4 < 0) {
                    n4 = n2;
                }
                if (n3 < 0) {
                    n3 = n2;
                }
                n = Math.min(n4, n3);
                continue;
            }
            if (c == '\\') {
                stringBuffer.append((int)string.charAt(n++));
                continue;
            }
            if (c == '0' && string.startsWith("0x", n - 1)) {
                char c2;
                n4 = n - 1;
                for (n3 = n4 + 2; n3 < n2 && ((c2 = string.charAt(n3)) >= '0' && c2 <= '9' || c2 >= 'a' && c2 <= 'f'); ++n3) {
                }
                if (n3 > n4) {
                    String string2 = string.substring(n4, n3);
                    stringBuffer.append(Integer.decode(string2));
                    n = n3;
                    continue;
                }
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append(c);
        }
        String string3 = stringBuffer.toString();
        return string3;
    }

    static Layout.Element[] tokenizeLayout(Layout layout, int n, String string) {
        ArrayList arrayList = new ArrayList(string.length());
        Attribute.tokenizeLayout(layout, n, string, arrayList);
        Layout.Element[] elementArray = new Layout.Element[arrayList.size()];
        arrayList.toArray(elementArray);
        return elementArray;
    }

    /*
     * Unable to fully structure code
     */
    static void tokenizeLayout(Layout var0, int var1_1, String var2_2, ArrayList var3_3) {
        var4_4 = false;
        var5_5 = var2_2.length();
        var6_6 = 0;
        block30: while (var6_6 < var5_5) {
            var7_7 = var6_6;
            var9_9 = var0.new Layout.Element();
            block0 : switch (var2_2.charAt(var6_6++)) {
                case 'B': 
                case 'H': 
                case 'I': 
                case 'V': {
                    var10_10 = 1;
                    --var6_6;
                    var6_6 = Attribute.tokenizeUInt(var9_9, var2_2, var6_6);
                    break;
                }
                case 'S': {
                    var10_10 = 1;
                    --var6_6;
                    var6_6 = Attribute.tokenizeSInt(var9_9, var2_2, var6_6);
                    break;
                }
                case 'P': {
                    var10_10 = 2;
                    if (var2_2.charAt(var6_6++) == 'O') {
                        var9_9.flags = (byte)(var9_9.flags | 2);
                        if (!var4_4) {
                            var6_6 = -var6_6;
                            continue block30;
                        }
                        ++var6_6;
                    }
                    --var6_6;
                    var6_6 = Attribute.tokenizeUInt(var9_9, var2_2, var6_6);
                    break;
                }
                case 'O': {
                    var10_10 = 3;
                    var9_9.flags = (byte)(var9_9.flags | 2);
                    if (!var4_4) {
                        var6_6 = -var6_6;
                        continue block30;
                    }
                    var6_6 = Attribute.tokenizeSInt(var9_9, var2_2, var6_6);
                    break;
                }
                case 'F': {
                    var10_10 = 4;
                    var6_6 = Attribute.tokenizeUInt(var9_9, var2_2, var6_6);
                    break;
                }
                case 'N': {
                    var10_10 = 5;
                    var6_6 = Attribute.tokenizeUInt(var9_9, var2_2, var6_6);
                    if (var2_2.charAt(var6_6++) != '[') {
                        var6_6 = -var6_6;
                        continue block30;
                    }
                    var8_8 = var6_6;
                    var6_6 = Attribute.skipBody(var2_2, var8_8);
                    var9_9.body = Attribute.tokenizeLayout(var0, var1_1, var2_2.substring(var8_8, var6_6++));
                    break;
                }
                case 'T': {
                    var10_10 = 7;
                    var6_6 = Attribute.tokenizeSInt(var9_9, var2_2, var6_6);
                    var11_11 = new ArrayList<Layout.Element>();
                    block31: while (true) {
                        if (var2_2.charAt(var6_6++) != '(') {
                            var6_6 = -var6_6;
                            break;
                        }
                        var12_12 = var6_6;
                        var6_6 = var2_2.indexOf(41, var6_6);
                        var13_14 = var2_2.substring(var12_12, var6_6++);
                        var14_16 = var13_14.length();
                        if (var2_2.charAt(var6_6++) != '[') {
                            var6_6 = -var6_6;
                            break;
                        }
                        if (var2_2.charAt(var6_6) == ']') {
                            var8_8 = var6_6;
                        } else {
                            var8_8 = var6_6;
                            var6_6 = Attribute.skipBody(var2_2, var8_8);
                        }
                        var15_17 = Attribute.tokenizeLayout(var0, var1_1, var2_2.substring(var8_8, var6_6++));
                        if (var14_16 == 0) {
                            var16_18 = var0.new Layout.Element();
                            var16_18.body = var15_17;
                            var16_18.kind = (byte)8;
                            var16_18.removeBand();
                            var11_11.add(var16_18);
                            break;
                        }
                        var16_19 = true;
                        var17_20 = 0;
                        while (true) {
                            if ((var18_21 = var13_14.indexOf(44, var17_20)) < 0) {
                                var18_21 = var14_16;
                            }
                            if ((var19_22 = var13_14.substring(var17_20, var18_21)).length() == 0) {
                                var19_22 = "empty";
                            }
                            if ((var22_25 = Attribute.findCaseDash(var19_22, 0)) >= 0) {
                                var20_23 = Attribute.parseIntBefore(var19_22, var22_25);
                                if (var20_23 >= (var21_24 = Attribute.parseIntAfter(var19_22, var22_25))) {
                                    var6_6 = -var6_6;
                                    continue block31;
                                }
                            } else {
                                var20_23 = var21_24 = Integer.parseInt(var19_22);
                            }
                            while (true) {
                                var23_26 = var0.new Layout.Element();
                                var23_26.body = var15_17;
                                var23_26.kind = (byte)8;
                                var23_26.removeBand();
                                if (!var16_19) {
                                    var23_26.flags = (byte)(var23_26.flags | 8);
                                }
                                var16_19 = false;
                                var23_26.value = var20_23;
                                var11_11.add(var23_26);
                                if (var20_23 == var21_24) break;
                                ++var20_23;
                            }
                            if (var18_21 != var14_16) ** break;
                            continue block31;
                            var17_20 = var18_21 + 1;
                        }
                        break;
                    }
                    var9_9.body = new Layout.Element[var11_11.size()];
                    var11_11.toArray(var9_9.body);
                    var9_9.kind = (byte)var10_10;
                    for (var12_12 = 0; var12_12 < var9_9.body.length - 1; ++var12_12) {
                        var13_14 = var9_9.body[var12_12];
                        if (Attribute.matchCase(var9_9, var13_14.value) == var13_14) continue;
                        var6_6 = -var6_6;
                        break block0;
                    }
                    break;
                }
                case '(': {
                    var10_10 = 9;
                    var9_9.removeBand();
                    var6_6 = var2_2.indexOf(41, var6_6);
                    var12_13 = var2_2.substring(var7_7 + 1, var6_6++);
                    var13_15 = Integer.parseInt(var12_13);
                    var14_16 = var1_1 + var13_15;
                    if (!(var13_15 + "").equals(var12_13) || var0.elems == null || var14_16 < 0 || var14_16 >= var0.elems.length) {
                        var6_6 = -var6_6;
                        continue block30;
                    }
                    var15_17 = var0.elems[var14_16];
                    if (!Attribute.$assertionsDisabled && var15_17.kind != 10) {
                        throw new AssertionError();
                    }
                    var9_9.value = var14_16;
                    var9_9.body = new Layout.Element[]{var15_17};
                    if (var13_15 > 0) break;
                    var9_9.flags = (byte)(var9_9.flags | 8);
                    var15_17.flags = (byte)(var15_17.flags | 8);
                    break;
                }
                case 'K': {
                    var10_10 = 6;
                    switch (var2_2.charAt(var6_6++)) {
                        case 'I': {
                            var9_9.refKind = (byte)3;
                            break block0;
                        }
                        case 'J': {
                            var9_9.refKind = (byte)5;
                            break block0;
                        }
                        case 'F': {
                            var9_9.refKind = (byte)4;
                            break block0;
                        }
                        case 'D': {
                            var9_9.refKind = (byte)6;
                            break block0;
                        }
                        case 'S': {
                            var9_9.refKind = (byte)8;
                            break block0;
                        }
                        case 'Q': {
                            var9_9.refKind = (byte)20;
                            break block0;
                        }
                    }
                    var6_6 = -var6_6;
                    continue block30;
                }
                case 'R': {
                    var10_10 = 6;
                    switch (var2_2.charAt(var6_6++)) {
                        case 'C': {
                            var9_9.refKind = (byte)7;
                            break block0;
                        }
                        case 'S': {
                            var9_9.refKind = (byte)13;
                            break block0;
                        }
                        case 'D': {
                            var9_9.refKind = (byte)12;
                            break block0;
                        }
                        case 'F': {
                            var9_9.refKind = (byte)9;
                            break block0;
                        }
                        case 'M': {
                            var9_9.refKind = (byte)10;
                            break block0;
                        }
                        case 'I': {
                            var9_9.refKind = (byte)11;
                            break block0;
                        }
                        case 'U': {
                            var9_9.refKind = 1;
                            break block0;
                        }
                        case 'Q': {
                            var9_9.refKind = (byte)19;
                            break block0;
                        }
                    }
                    var6_6 = -var6_6;
                    continue block30;
                }
                default: {
                    var6_6 = -var6_6;
                    continue block30;
                }
            }
            if (var10_10 == 6) {
                if (var2_2.charAt(var6_6++) == 'N') {
                    var9_9.flags = (byte)(var9_9.flags | 4);
                    ++var6_6;
                }
                --var6_6;
                var6_6 = Attribute.tokenizeUInt(var9_9, var2_2, var6_6);
                var0.hasRefs = true;
            }
            var4_4 = var10_10 == 2;
            var9_9.kind = (byte)var10_10;
            var9_9.layout = var2_2.substring(var7_7, var6_6);
            var3_3.add(var9_9);
        }
    }

    static String[] splitBodies(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i++) != '[') {
                string.charAt(-i);
            }
            int n = i;
            i = Attribute.skipBody(string, n);
            arrayList.add(string.substring(n, i));
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    private static int skipBody(String string, int n) {
        assert (string.charAt(n - 1) == '[');
        if (string.charAt(n) == ']') {
            return -n;
        }
        int n2 = 1;
        while (n2 > 0) {
            switch (string.charAt(n++)) {
                case '[': {
                    ++n2;
                    break;
                }
                case ']': {
                    --n2;
                }
            }
        }
        assert (string.charAt(--n) == ']');
        return n;
    }

    private static int tokenizeUInt(Layout.Element element, String string, int n) {
        switch (string.charAt(n++)) {
            case 'V': {
                element.len = 0;
                break;
            }
            case 'B': {
                element.len = 1;
                break;
            }
            case 'H': {
                element.len = (byte)2;
                break;
            }
            case 'I': {
                element.len = (byte)4;
                break;
            }
            default: {
                return -n;
            }
        }
        return n;
    }

    private static int tokenizeSInt(Layout.Element element, String string, int n) {
        if (string.charAt(n) == 'S') {
            element.flags = (byte)(element.flags | 1);
            ++n;
        }
        return Attribute.tokenizeUInt(element, string, n);
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    static int findCaseDash(String string, int n) {
        if (n <= 0) {
            n = 1;
        }
        int n2 = string.length() - 2;
        int n3;
        while ((n3 = string.indexOf(45, n)) >= 0 && n3 <= n2) {
            if (Attribute.isDigit(string.charAt(n3 - 1))) {
                char c = string.charAt(n3 + 1);
                if (c == '-' && n3 + 2 < string.length()) {
                    c = string.charAt(n3 + 2);
                }
                if (Attribute.isDigit(c)) {
                    return n3;
                }
            }
            n = n3 + 1;
        }
        return -1;
    }

    static int parseIntBefore(String string, int n) {
        int n2;
        int n3;
        for (n3 = n2 = n; n3 > 0 && Attribute.isDigit(string.charAt(n3 - 1)); --n3) {
        }
        if (n3 == n2) {
            return Integer.parseInt("empty");
        }
        if (n3 >= 1 && string.charAt(n3 - 1) == '-') {
            --n3;
        }
        assert (n3 == 0 || !Attribute.isDigit(string.charAt(n3 - 1)));
        return Integer.parseInt(string.substring(n3, n2));
    }

    static int parseIntAfter(String string, int n) {
        int n2 = n + 1;
        int n3 = n2;
        int n4 = string.length();
        if (n3 < n4 && string.charAt(n3) == '-') {
            ++n3;
        }
        while (n3 < n4 && Attribute.isDigit(string.charAt(n3))) {
            ++n3;
        }
        if (n2 == n3) {
            return Integer.parseInt("empty");
        }
        return Integer.parseInt(string.substring(n2, n3));
    }

    static String expandCaseDashNotation(String string) {
        int n = Attribute.findCaseDash(string, 0);
        if (n < 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() * 3);
        int n2 = 0;
        do {
            stringBuffer.append(string.substring(n2, n));
            n2 = n + 1;
            int n3 = Attribute.parseIntBefore(string, n);
            int n4 = Attribute.parseIntAfter(string, n);
            assert (n3 < n4);
            stringBuffer.append(",");
            for (int i = n3 + 1; i < n4; ++i) {
                stringBuffer.append(i);
                stringBuffer.append(",");
            }
        } while ((n = Attribute.findCaseDash(string, n2)) >= 0);
        stringBuffer.append(string.substring(n2));
        return stringBuffer.toString();
    }

    static int parseUsing(Layout.Element[] elementArray, Holder holder, byte[] byArray, int n, int n2, ValueStream valueStream) {
        int n3 = 0;
        int n4 = 0;
        int n5 = n + n2;
        int[] nArray = new int[]{0};
        block10: for (int i = 0; i < elementArray.length; ++i) {
            Layout.Element element = elementArray[i];
            int n6 = element.bandIndex;
            switch (element.kind) {
                case 1: {
                    n = Attribute.parseInt(element, byArray, n, nArray);
                    int n7 = nArray[0];
                    valueStream.putInt(n6, n7);
                    continue block10;
                }
                case 2: {
                    n = Attribute.parseInt(element, byArray, n, nArray);
                    int n8 = nArray[0];
                    int n9 = valueStream.encodeBCI(n8);
                    int n7 = !element.flagTest((byte)2) ? n9 : n9 - n4;
                    n3 = n8;
                    n4 = n9;
                    valueStream.putInt(n6, n7);
                    continue block10;
                }
                case 3: {
                    assert (element.flagTest((byte)2));
                    n = Attribute.parseInt(element, byArray, n, nArray);
                    int n8 = n3 + nArray[0];
                    int n9 = valueStream.encodeBCI(n8);
                    int n7 = n9 - n4;
                    n3 = n8;
                    n4 = n9;
                    valueStream.putInt(n6, n7);
                    continue block10;
                }
                case 4: {
                    n = Attribute.parseInt(element, byArray, n, nArray);
                    int n7 = nArray[0];
                    valueStream.putInt(n6, n7);
                    continue block10;
                }
                case 5: {
                    n = Attribute.parseInt(element, byArray, n, nArray);
                    int n7 = nArray[0];
                    valueStream.putInt(n6, n7);
                    for (int j = 0; j < n7; ++j) {
                        n = Attribute.parseUsing(element.body, holder, byArray, n, n5 - n, valueStream);
                    }
                    continue block10;
                }
                case 7: {
                    n = Attribute.parseInt(element, byArray, n, nArray);
                    int n7 = nArray[0];
                    valueStream.putInt(n6, n7);
                    Layout.Element element2 = Attribute.matchCase(element, n7);
                    n = Attribute.parseUsing(element2.body, holder, byArray, n, n5 - n, valueStream);
                    continue block10;
                }
                case 9: {
                    assert (element.body.length == 1);
                    assert (element.body[0].kind == 10);
                    if (element.flagTest((byte)8)) {
                        valueStream.noteBackCall(element.value);
                    }
                    n = Attribute.parseUsing(element.body[0].body, holder, byArray, n, n5 - n, valueStream);
                    continue block10;
                }
                case 6: {
                    ConstantPool.Entry entry;
                    n = Attribute.parseInt(element, byArray, n, nArray);
                    int n10 = nArray[0];
                    if (n10 == 0) {
                        entry = null;
                    } else {
                        entry = holder.getCPMap()[n10];
                        if (element.refKind == 13 && entry.getTag() == 1) {
                            String string = entry.stringValue();
                            entry = ConstantPool.getSignatureEntry(string);
                        } else if (element.refKind == 20) {
                            assert (entry.getTag() >= 3);
                            assert (entry.getTag() <= 8);
                        } else if (element.refKind != 19) assert (element.refKind == entry.getTag());
                    }
                    valueStream.putRef(n6, entry);
                    continue block10;
                }
                default: {
                    assert (false);
                    continue block10;
                }
            }
        }
        return n;
    }

    static Layout.Element matchCase(Layout.Element element, int n) {
        assert (element.kind == 7);
        int n2 = element.body.length - 1;
        for (int i = 0; i < n2; ++i) {
            Layout.Element element2 = element.body[i];
            assert (element2.kind == 8);
            if (n != element2.value) continue;
            return element2;
        }
        return element.body[n2];
    }

    private static int parseInt(Layout.Element element, byte[] byArray, int n, int[] nArray) {
        int n2;
        int n3 = 0;
        int n4 = n2 = element.len * 8;
        while ((n4 -= 8) >= 0) {
            n3 += (byArray[n++] & 0xFF) << n4;
        }
        if (n2 < 32 && element.flagTest((byte)1)) {
            n4 = 32 - n2;
            n3 = n3 << n4 >> n4;
        }
        nArray[0] = n3;
        return n;
    }

    static void unparseUsing(Layout.Element[] elementArray, Object[] objectArray, ValueStream valueStream, ByteArrayOutputStream byteArrayOutputStream) {
        int n = 0;
        int n2 = 0;
        block10: for (int i = 0; i < elementArray.length; ++i) {
            Layout.Element element = elementArray[i];
            int n3 = element.bandIndex;
            switch (element.kind) {
                case 1: {
                    int n4 = valueStream.getInt(n3);
                    Attribute.unparseInt(element, n4, byteArrayOutputStream);
                    continue block10;
                }
                case 2: {
                    int n4 = valueStream.getInt(n3);
                    int n5 = !element.flagTest((byte)2) ? n4 : n2 + n4;
                    assert (n == valueStream.decodeBCI(n2));
                    int n6 = valueStream.decodeBCI(n5);
                    Attribute.unparseInt(element, n6, byteArrayOutputStream);
                    n = n6;
                    n2 = n5;
                    continue block10;
                }
                case 3: {
                    int n4 = valueStream.getInt(n3);
                    assert (element.flagTest((byte)2));
                    assert (n == valueStream.decodeBCI(n2));
                    int n5 = n2 + n4;
                    int n6 = valueStream.decodeBCI(n5);
                    Attribute.unparseInt(element, n6 - n, byteArrayOutputStream);
                    n = n6;
                    n2 = n5;
                    continue block10;
                }
                case 4: {
                    int n4 = valueStream.getInt(n3);
                    Attribute.unparseInt(element, n4, byteArrayOutputStream);
                    continue block10;
                }
                case 5: {
                    int n4 = valueStream.getInt(n3);
                    Attribute.unparseInt(element, n4, byteArrayOutputStream);
                    for (int j = 0; j < n4; ++j) {
                        Attribute.unparseUsing(element.body, objectArray, valueStream, byteArrayOutputStream);
                    }
                    continue block10;
                }
                case 7: {
                    int n4 = valueStream.getInt(n3);
                    Attribute.unparseInt(element, n4, byteArrayOutputStream);
                    Layout.Element element2 = Attribute.matchCase(element, n4);
                    Attribute.unparseUsing(element2.body, objectArray, valueStream, byteArrayOutputStream);
                    continue block10;
                }
                case 9: {
                    assert (element.body.length == 1);
                    assert (element.body[0].kind == 10);
                    Attribute.unparseUsing(element.body[0].body, objectArray, valueStream, byteArrayOutputStream);
                    continue block10;
                }
                case 6: {
                    int n7;
                    ConstantPool.Entry entry = valueStream.getRef(n3);
                    if (entry != null) {
                        objectArray[0] = Fixups.add(objectArray[0], null, byteArrayOutputStream.size(), 0, entry);
                        n7 = 0;
                    } else {
                        n7 = 0;
                    }
                    Attribute.unparseInt(element, n7, byteArrayOutputStream);
                    continue block10;
                }
                default: {
                    assert (false);
                    continue block10;
                }
            }
        }
    }

    private static void unparseInt(Layout.Element element, int n, ByteArrayOutputStream byteArrayOutputStream) {
        int n2;
        int n3 = element.len * 8;
        if (n3 == 0) {
            return;
        }
        if (n3 < 32) {
            n2 = 32 - n3;
            int n4 = element.flagTest((byte)1) ? n << n2 >> n2 : n << n2 >>> n2;
            if (n4 != n) {
                throw new InternalError("cannot code in " + element.len + " bytes: " + n);
            }
        }
        n2 = n3;
        while ((n2 -= 8) >= 0) {
            byteArrayOutputStream.write((byte)(n >>> n2));
        }
    }

    static {
        String[] stringArray = standardDefs;
        Attribute.define((Map)stringArray, 0, "Signature", "RSH");
        Attribute.define((Map)stringArray, 0, "Synthetic", "");
        Attribute.define((Map)stringArray, 0, "Deprecated", "");
        Attribute.define((Map)stringArray, 0, "SourceFile", "RUH");
        Attribute.define((Map)stringArray, 0, "EnclosingMethod", "RCHRDNH");
        Attribute.define((Map)stringArray, 0, "InnerClasses", "NH[RCHRCNHRUNHFH]");
        Attribute.define((Map)stringArray, 1, "Signature", "RSH");
        Attribute.define((Map)stringArray, 1, "Synthetic", "");
        Attribute.define((Map)stringArray, 1, "Deprecated", "");
        Attribute.define((Map)stringArray, 1, "ConstantValue", "KQH");
        Attribute.define((Map)stringArray, 2, "Signature", "RSH");
        Attribute.define((Map)stringArray, 2, "Synthetic", "");
        Attribute.define((Map)stringArray, 2, "Deprecated", "");
        Attribute.define((Map)stringArray, 2, "Exceptions", "NH[RCH]");
        Attribute.define((Map)stringArray, 3, "StackMapTable", "[NH[(1)]][TB(64-127)[(2)](247)[(1)(2)](248-251)[(1)](252)[(1)(2)](253)[(1)(2)(2)](254)[(1)(2)(2)(2)](255)[(1)NH[(2)]NH[(2)]]()[]][H][TB(7)[RCH](8)[PH]()[]]");
        Attribute.define((Map)stringArray, 3, "LineNumberTable", "NH[PHH]");
        Attribute.define((Map)stringArray, 3, "LocalVariableTable", "NH[PHOHRUHRSHH]");
        Attribute.define((Map)stringArray, 3, "LocalVariableTypeTable", "NH[PHOHRUHRSHH]");
        stringArray = new String[]{Attribute.normalizeLayoutString("\n  # parameter_annotations :=\n  [ NB[(1)] ]     # forward call to annotations"), Attribute.normalizeLayoutString("\n  # annotations :=\n  [ NH[(1)] ]     # forward call to annotation\n  \n  # annotation :=\n  [RSH\n    NH[RUH (1)]   # forward call to value\n    ]"), Attribute.normalizeLayoutString("\n  # value :=\n  [TB # Callable 2 encodes one tagged value.\n    (\\B,\\C,\\I,\\S,\\Z)[KIH]\n    (\\D)[KDH]\n    (\\F)[KFH]\n    (\\J)[KJH]\n    (\\c)[RSH]\n    (\\e)[RSH RUH]\n    (\\s)[RUH]\n    (\\[)[NH[(0)]] # backward self-call to value\n    (\\@)[RSH NH[RUH (0)]] # backward self-call to value\n    ()[] ]")};
        HashMap hashMap = standardDefs;
        String string = stringArray[2];
        String string2 = stringArray[1] + stringArray[2];
        String string3 = stringArray[0] + string2;
        for (int i = 0; i < 4; ++i) {
            if (i == 3) continue;
            Attribute.define(hashMap, i, "RuntimeVisibleAnnotations", string2);
            Attribute.define(hashMap, i, "RuntimeInvisibleAnnotations", string2);
            if (i != 2) continue;
            Attribute.define(hashMap, i, "RuntimeVisibleParameterAnnotations", string3);
            Attribute.define(hashMap, i, "RuntimeInvisibleParameterAnnotations", string3);
            Attribute.define(hashMap, i, "AnnotationDefault", string);
        }
        assert (Attribute.expandCaseDashNotation("1-5").equals("1,2,3,4,5"));
        assert (Attribute.expandCaseDashNotation("-2--1").equals("-2,-1"));
        assert (Attribute.expandCaseDashNotation("-2-1").equals("-2,-1,0,1"));
        assert (Attribute.expandCaseDashNotation("-1-0").equals("-1,0"));
    }

    public static class FormatException
    extends IOException {
        private int ctype;
        private String name;
        String layout;

        public FormatException(String string, int n, String string2, String string3) {
            super(Constants.ATTR_CONTEXT_NAME[n] + "." + string2 + (string == null ? "" : ": " + string));
            this.ctype = n;
            this.name = string2;
            this.layout = string3;
        }

        public FormatException(String string, int n, String string2) {
            this(string, n, string2, null);
        }
    }

    public static class Layout
    implements Comparable {
        int ctype;
        String name;
        boolean hasRefs;
        String layout;
        int bandCount;
        Element[] elems;
        Attribute canon;
        private ConstantPool.Entry nameRef;
        private static final Element[] noElems = new Element[0];

        public int ctype() {
            return this.ctype;
        }

        public String name() {
            return this.name;
        }

        public String layout() {
            return this.layout;
        }

        public Attribute canonicalInstance() {
            return this.canon;
        }

        public ConstantPool.Entry getNameRef() {
            ConstantPool.Entry entry = this.nameRef;
            if (entry == null) {
                this.nameRef = entry = ConstantPool.getUtf8Entry(this.name());
            }
            return entry;
        }

        public boolean isEmpty() {
            return this.layout == "";
        }

        public Layout(int n, String string, String string2) {
            this.ctype = n;
            this.name = string.intern();
            this.layout = string2.intern();
            assert (n < 4);
            boolean bl = string2.startsWith("[");
            try {
                if (!bl) {
                    this.elems = Attribute.tokenizeLayout(this, -1, string2);
                } else {
                    Element element;
                    int n2;
                    String[] stringArray = Attribute.splitBodies(string2);
                    Element[] elementArray = new Element[stringArray.length];
                    this.elems = elementArray;
                    for (n2 = 0; n2 < elementArray.length; ++n2) {
                        element = new Element();
                        element.kind = (byte)10;
                        element.removeBand();
                        element.bandIndex = -1;
                        element.layout = stringArray[n2];
                        elementArray[n2] = element;
                    }
                    for (n2 = 0; n2 < elementArray.length; ++n2) {
                        element = elementArray[n2];
                        element.body = Attribute.tokenizeLayout(this, n2, stringArray[n2]);
                    }
                }
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                throw new RuntimeException("Bad attribute layout: " + string2, stringIndexOutOfBoundsException);
            }
            this.canon = new Attribute(this, noBytes);
        }

        private Layout() {
        }

        static Layout makeKey(int n, String string, String string2) {
            Layout layout = new Layout();
            layout.ctype = n;
            layout.name = string.intern();
            layout.layout = string2.intern();
            assert (n < 4);
            return layout;
        }

        static Layout makeKey(int n, String string) {
            return Layout.makeKey(n, string, "");
        }

        public Attribute addContent(byte[] byArray, Object object) {
            return this.canon.addContent(byArray, object);
        }

        public Attribute addContent(byte[] byArray) {
            return this.canon.addContent(byArray, null);
        }

        public boolean equals(Object object) {
            return object instanceof Layout && this.equals((Layout)object);
        }

        public boolean equals(Layout layout) {
            return this.name == layout.name && this.layout == layout.layout && this.ctype == layout.ctype;
        }

        public int hashCode() {
            return ((17 + this.name.hashCode()) * 37 + this.layout.hashCode()) * 37 + this.ctype;
        }

        public int compareTo(Object object) {
            Layout layout = (Layout)object;
            int n = this.name.compareTo(layout.name);
            if (n != 0) {
                return n;
            }
            n = this.layout.compareTo(layout.layout);
            if (n != 0) {
                return n;
            }
            return this.ctype - layout.ctype;
        }

        public String toString() {
            String string = Attribute.contextName(this.ctype) + "." + this.name + "[" + this.layout + "]";
            assert ((string = this.stringForDebug()) != null);
            return string;
        }

        private String stringForDebug() {
            return Attribute.contextName(this.ctype) + "." + this.name + Arrays.asList(this.elems);
        }

        public boolean hasCallables() {
            return this.elems.length > 0 && this.elems[0].kind == 10;
        }

        public Element[] getCallables() {
            if (this.hasCallables()) {
                return this.elems;
            }
            return noElems;
        }

        public Element[] getEntryPoint() {
            if (this.hasCallables()) {
                return this.elems[0].body;
            }
            return this.elems;
        }

        public void parse(Holder holder, byte[] byArray, int n, int n2, ValueStream valueStream) {
            int n3 = Attribute.parseUsing(this.getEntryPoint(), holder, byArray, n, n2, valueStream);
            if (n3 != n + n2) {
                throw new InternalError("layout parsed " + (n3 - n) + " out of " + n2 + " bytes");
            }
        }

        public Object unparse(ValueStream valueStream, ByteArrayOutputStream byteArrayOutputStream) {
            Object[] objectArray = new Object[]{null};
            Attribute.unparseUsing(this.getEntryPoint(), objectArray, valueStream, byteArrayOutputStream);
            return objectArray[0];
        }

        public String layoutForPackageMajver(int n) {
            if (n <= 150) {
                return Attribute.expandCaseDashNotation(this.layout);
            }
            return this.layout;
        }

        public class Element {
            String layout;
            byte flags;
            byte kind;
            byte len;
            byte refKind;
            int bandIndex;
            int value;
            Element[] body;

            boolean flagTest(byte by) {
                return (this.flags & by) != 0;
            }

            Element() {
                this.bandIndex = Layout.this.bandCount++;
            }

            void removeBand() {
                --Layout.this.bandCount;
                assert (this.bandIndex == Layout.this.bandCount);
                this.bandIndex = -1;
            }

            public boolean hasBand() {
                return this.bandIndex >= 0;
            }

            public String toString() {
                String string = this.layout;
                assert ((string = this.stringForDebug()) != null);
                return string;
            }

            private String stringForDebug() {
                Element[] elementArray = this.body;
                switch (this.kind) {
                    case 9: {
                        elementArray = null;
                        break;
                    }
                    case 8: {
                        if (!this.flagTest((byte)8)) break;
                        elementArray = null;
                    }
                }
                return this.layout + (!this.hasBand() ? "" : "#" + this.bandIndex) + "<" + (this.flags == 0 ? "" : "" + this.flags) + this.kind + this.len + (this.refKind == 0 ? "" : "" + this.refKind) + ">" + (this.value == 0 ? "" : "(" + this.value + ")") + (elementArray == null ? "" : "" + Arrays.asList(elementArray));
            }
        }
    }

    public static abstract class ValueStream {
        public int getInt(int n) {
            throw this.undef();
        }

        public void putInt(int n, int n2) {
            throw this.undef();
        }

        public ConstantPool.Entry getRef(int n) {
            throw this.undef();
        }

        public void putRef(int n, ConstantPool.Entry entry) {
            throw this.undef();
        }

        public int decodeBCI(int n) {
            throw this.undef();
        }

        public int encodeBCI(int n) {
            throw this.undef();
        }

        public void noteBackCall(int n) {
        }

        private RuntimeException undef() {
            return new UnsupportedOperationException("ValueStream method");
        }
    }

    public static abstract class Holder {
        protected int flags;
        protected List attributes;
        static final List noAttributes = Arrays.asList(new Object[0]);

        protected abstract ConstantPool.Entry[] getCPMap();

        public int attributeSize() {
            return this.attributes == null ? 0 : this.attributes.size();
        }

        public void trimToSize() {
            if (this.attributes == null) {
                return;
            }
            if (this.attributes.size() == 0) {
                this.attributes = null;
                return;
            }
            if (this.attributes instanceof ArrayList) {
                ArrayList arrayList = (ArrayList)this.attributes;
                arrayList.trimToSize();
                boolean bl = true;
                for (Attribute attribute : arrayList) {
                    if (!attribute.isCanonical()) {
                        bl = false;
                    }
                    if (attribute.fixups == null) continue;
                    assert (!attribute.isCanonical());
                    attribute.fixups = Fixups.trimToSize(attribute.fixups);
                }
                if (bl) {
                    this.attributes = Attribute.getCanonList(arrayList);
                }
            }
        }

        public void addAttribute(Attribute attribute) {
            if (this.attributes == null) {
                this.attributes = new ArrayList(3);
            } else if (!(this.attributes instanceof ArrayList)) {
                this.attributes = new ArrayList(this.attributes);
            }
            this.attributes.add(attribute);
        }

        public Attribute removeAttribute(Attribute attribute) {
            if (this.attributes == null) {
                return null;
            }
            if (!this.attributes.contains(attribute)) {
                return null;
            }
            if (!(this.attributes instanceof ArrayList)) {
                this.attributes = new ArrayList(this.attributes);
            }
            this.attributes.remove(attribute);
            return attribute;
        }

        public Attribute getAttribute(int n) {
            return (Attribute)this.attributes.get(n);
        }

        protected void visitRefs(int n, Collection collection) {
            if (this.attributes == null) {
                return;
            }
            for (Attribute attribute : this.attributes) {
                attribute.visitRefs(this, n, collection);
            }
        }

        public List getAttributes() {
            if (this.attributes == null) {
                return noAttributes;
            }
            return this.attributes;
        }

        public void setAttributes(List list) {
            this.attributes = list.isEmpty() ? null : list;
        }

        public Attribute getAttribute(String string) {
            if (this.attributes == null) {
                return null;
            }
            for (Attribute attribute : this.attributes) {
                if (!attribute.name().equals(string)) continue;
                return attribute;
            }
            return null;
        }

        public Attribute getAttribute(Layout layout) {
            if (this.attributes == null) {
                return null;
            }
            for (Attribute attribute : this.attributes) {
                if (attribute.layout() != layout) continue;
                return attribute;
            }
            return null;
        }

        public Attribute removeAttribute(String string) {
            return this.removeAttribute(this.getAttribute(string));
        }

        public Attribute removeAttribute(Layout layout) {
            return this.removeAttribute(this.getAttribute(layout));
        }

        public void strip(String string) {
            this.removeAttribute(this.getAttribute(string));
        }
    }
}

